/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.ability.api.CfcQryBudgetPeriodAbilityService;
import com.tydic.cfc.ability.bo.BudgetPeriodDetailBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetPeriodAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetPeriodAbilityRspBO;
import com.tydic.fsc.bo.FscExcelImportBO;
import com.tydic.fsc.budget.ability.api.FscBudgetTemplateExportAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetTemplateExportAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetTemplateExportAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetTemplateExportBO;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.utils.FileUpLoad;
import com.tydic.umc.general.ability.api.UmcQryBudgetDeptPageListAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcQryBudgetDeptPageListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryBudgetDeptPageListAbilityRspBO;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscBudgetTemplateExportAbilityService"})
public class FscBudgetTemplateExportAbilityServiceImpl
implements FscBudgetTemplateExportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetTemplateExportAbilityServiceImpl.class);
    @Autowired
    private FileUpLoad fileUpLoad;
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private CfcQryBudgetPeriodAbilityService cfcQryBudgetPeriodAbilityService;
    @Autowired
    private UmcQryBudgetDeptPageListAbilityService umcQryBudgetDeptPageListAbilityService;

    @PostMapping(value={"budgetTemplateExport"})
    public FscBudgetTemplateExportAbilityRspBO budgetTemplateExport(@RequestBody FscBudgetTemplateExportAbilityReqBO reqBO) {
        FscBudgetTemplateExportAbilityRspBO rspBO = new FscBudgetTemplateExportAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getBudgetYear())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u9884\u7b97\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSbuId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6240\u5c5e\u4e8c\u7ea7\u673a\u6784");
            return rspBO;
        }
        FscExcelImportBO selfRunImportBo = new FscExcelImportBO();
        ArrayList<FscExcelImportBO> selfRunImportBos = new ArrayList<FscExcelImportBO>();
        selfRunImportBo.setSheet("\u9884\u7b97\u5bfc\u5165\u6a21\u677f");
        ArrayList<String> budgetTitle = new ArrayList<String>();
        budgetTitle.add("\u9884\u7b97\u5e74\u5ea6\n<\u81ea\u52a8\u5e26\u51fa\uff0c\u52ff\u6539>");
        budgetTitle.add("\u9884\u7b97\u671f\u95f4\n<\u81ea\u52a8\u5e26\u51fa\uff0c\u52ff\u6539>");
        budgetTitle.add("\u9884\u7b97\u516c\u53f8\n<\u81ea\u52a8\u5e26\u51fa\uff0c\u52ff\u6539>");
        budgetTitle.add("\u9884\u7b97\u90e8\u95e8\n<\u81ea\u52a8\u5e26\u51fa\uff0c\u52ff\u6539>");
        budgetTitle.add("*\u90e8\u95e8\u671f\u95f4\u9884\u7b97\u989d\u5ea6");
        budgetTitle.add("\u9884\u7b97\u90e8\u95e8id\n<\u81ea\u52a8\u5e26\u51fa\uff0c\u52ff\u6539>");
        budgetTitle.add("\u9884\u7b97\u90e8\u95e8\u671f\u95f4id\n<\u81ea\u52a8\u5e26\u51fa\uff0c\u52ff\u6539>");
        selfRunImportBo.setTitle(budgetTitle);
        selfRunImportBos.add(selfRunImportBo);
        CfcQryBudgetPeriodAbilityReqBO cfcQryBudgetPeriodAbilityReqBO = new CfcQryBudgetPeriodAbilityReqBO();
        cfcQryBudgetPeriodAbilityReqBO.setOrgIdWeb(reqBO.getSbuId());
        cfcQryBudgetPeriodAbilityReqBO.setYear(Integer.valueOf(Integer.parseInt(reqBO.getBudgetYear())));
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u5165\u53c2cfcQryBudgetPeriodAbilityReqBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetPeriodAbilityReqBO));
        CfcQryBudgetPeriodAbilityRspBO cfcQryBudgetPeriodAbilityRspBO = this.cfcQryBudgetPeriodAbilityService.qryBudgetPeriod(cfcQryBudgetPeriodAbilityReqBO);
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u53c2cfcQryBudgetPeriodAbilityRspBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetPeriodAbilityRspBO));
        if (!"0000".equals(cfcQryBudgetPeriodAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetPeriodAbilityRspBO.getRespDesc());
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO() == null) {
            throw new FscBusinessException("8888", "\u5f53\u524d\u4e8c\u7ea7\u673a\u6784\u6ca1\u6709\u9884\u7b97\u671f\u95f4\u914d\u7f6e");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum() == null) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u603b\u6570\u4e3a\u7a7a");
        }
        if (!"0000".equals(cfcQryBudgetPeriodAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetPeriodAbilityRspBO.getRespDesc());
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO() == null) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum() == null) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u603b\u6570\u4e3a\u7a7a");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum() == null) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u603b\u6570\u4e3a\u7a7a");
        }
        List budgetPeriodDetailBOList = cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodDetailBOList();
        if (CollectionUtils.isEmpty((Collection)budgetPeriodDetailBOList)) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u6570\u91cf\u4e3a\u7a7a");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum().intValue() != budgetPeriodDetailBOList.size()) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e\u9519\u8bef\uff0c\u671f\u95f4\u603b\u6570\u548c\u914d\u7f6e\u7684\u671f\u95f4\u6570\u91cf\u4e0d\u7b49");
        }
        SimpleDateFormat getYearFormat = new SimpleDateFormat("yyyy");
        for (BudgetPeriodDetailBO each : budgetPeriodDetailBOList) {
            if (each.getPeriodStartDate() == null) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (each.getPeriodEndDate() == null) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (!reqBO.getBudgetYear().equals(getYearFormat.format(each.getPeriodStartDate()))) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u548c\u5e74\u4efd\u4e0d\u5339\u914d");
            }
            if (!reqBO.getBudgetYear().equals(getYearFormat.format(each.getPeriodEndDate()))) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u7ed3\u675f\u65f6\u95f4\u548c\u5e74\u4efd\u4e0d\u5339\u914d");
            }
            if (!StringUtils.isEmpty((Object)each.getPeriodName())) continue;
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u540d\u79f0\u4e3a\u7a7a");
        }
        ArrayList<FscBudgetTemplateExportBO> data = new ArrayList<FscBudgetTemplateExportBO>();
        FscBudgetDetailPO fscBudgetDetailPO = new FscBudgetDetailPO();
        fscBudgetDetailPO.setBudgetYear(reqBO.getBudgetYear());
        fscBudgetDetailPO.setBudgetOrgId(reqBO.getSbuId());
        List detailPOList = this.fscBudgetDetailMapper.getList(fscBudgetDetailPO);
        List<Object> budgetDepartmentIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)detailPOList)) {
            budgetDepartmentIds = detailPOList.stream().map(FscBudgetDetailPO::getBudgetDepartmentId).collect(Collectors.toList());
        }
        UmcQryBudgetDeptPageListAbilityReqBO umcQryBudgetDeptPageListAbilityReqBO = new UmcQryBudgetDeptPageListAbilityReqBO();
        umcQryBudgetDeptPageListAbilityReqBO.setBudgetSbuId(reqBO.getSbuId());
        umcQryBudgetDeptPageListAbilityReqBO.setOrgIdList(budgetDepartmentIds);
        umcQryBudgetDeptPageListAbilityReqBO.setPageNo(Integer.valueOf(1));
        umcQryBudgetDeptPageListAbilityReqBO.setPageSize(Integer.valueOf(5000));
        log.info("\u67e5\u8be2\u4f1a\u5458\u9700\u8981\u521b\u5efa\u9884\u7b97\u7684\u90e8\u95e8\u4fe1\u606f\u5165\u53c2umcQryBudgetDeptPageListAbilityReqBO\uff1a" + JSON.toJSONString((Object)umcQryBudgetDeptPageListAbilityReqBO));
        UmcQryBudgetDeptPageListAbilityRspBO umcQryBudgetDeptPageListAbilityRspBO = this.umcQryBudgetDeptPageListAbilityService.qryBudgetDeptPageList(umcQryBudgetDeptPageListAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u9700\u8981\u521b\u5efa\u9884\u7b97\u7684\u90e8\u95e8\u4fe1\u606f\u51fa\u53c2umcQryBudgetDeptPageListAbilityRspBO\uff1a" + JSON.toJSONString((Object)umcQryBudgetDeptPageListAbilityRspBO));
        if (!"0000".equals(umcQryBudgetDeptPageListAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u9700\u8981\u521b\u5efa\u9884\u7b97\u7684\u90e8\u95e8\u4fe1\u606f\u51fa\u9519\uff1a" + umcQryBudgetDeptPageListAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)umcQryBudgetDeptPageListAbilityRspBO.getRows())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6682\u65e0\u9700\u8981\u521b\u5efa\u9884\u7b97\u7684\u90e8\u95e8");
            return rspBO;
        }
        for (UmcEnterpriseOrgBO each : umcQryBudgetDeptPageListAbilityRspBO.getRows()) {
            for (BudgetPeriodDetailBO space : cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodDetailBOList()) {
                FscBudgetTemplateExportBO temp = new FscBudgetTemplateExportBO();
                temp.setBudgetYear(reqBO.getBudgetYear());
                temp.setBudgetOrgName(umcQryBudgetDeptPageListAbilityRspBO.getSbuName());
                temp.setBudgetDepartmentId(each.getOrgId());
                temp.setBudgetDepartmentName(each.getOrgName());
                temp.setSpaceName(space.getPeriodName());
                temp.setSpaceId(space.getPeriodId());
                data.add(temp);
            }
        }
        String url = this.dealImportTempToXmls(selfRunImportBos, data);
        rspBO.setUrl(url);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public String dealImportTempToXmls(List<FscExcelImportBO> importBOs, List<FscBudgetTemplateExportBO> data) {
        log.info("\u5bfc\u5165\u6570\u636e\uff1a" + JSONObject.toJSONString(importBOs));
        String fileUrl = "";
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFCellStyle headlineStyle = workbook.createCellStyle();
        XSSFFont headFontStyle = workbook.createFont();
        headlineStyle.setFont((Font)headFontStyle);
        XSSFFont commonFontStyle = workbook.createFont();
        XSSFCellStyle titleStyle = workbook.createCellStyle();
        XSSFFont titleFontStyle = workbook.createFont();
        for (int i = 0; i < importBOs.size(); ++i) {
            XSSFSheet sheet = workbook.createSheet(importBOs.get(i).getSheet());
            sheet.setColumnWidth(0, 5000);
            sheet.setColumnWidth(1, 5000);
            sheet.setColumnWidth(2, 5000);
            sheet.setColumnWidth(3, 10000);
            sheet.setColumnWidth(4, 10000);
            sheet.setColumnWidth(5, 6500);
            sheet.setColumnWidth(6, 6500);
            XSSFRow skuDetailsRow = sheet.createRow(0);
            skuDetailsRow.setHeightInPoints(130.0f);
            XSSFCell cell = skuDetailsRow.createCell(0);
            headlineStyle.setWrapText(true);
            headlineStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cell.setCellStyle((CellStyle)headlineStyle);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
            cell.setCellValue("\u6a21\u677f\u4f7f\u7528\u6ce8\u610f\u4e8b\u9879\uff1a\n1\uff09\u6570\u636e\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff0c\u4ee5\u9632\u65e0\u6cd5\u6b63\u786e\u5bfc\u5165\uff1a\n           \uff081\uff09\u9884\u7b97\u5e74\u5ea6\uff0c\u7528\u6237\u70b9\u51fb\u6a21\u677f\u4e0b\u8f7d\u65f6\uff0c\u9009\u62e9\u7684\u9884\u7b97\u5e74\u5ea6\u503c\uff0c\u7cfb\u7edf\u81ea\u52a8\u5e26\u51fa\uff1b\n           \uff082\uff09\u9884\u7b97\u671f\u95f4\uff0c\u7ec4\u7ec7\u673a\u6784\u5728\u6307\u5b9a\u7684\u9884\u7b97\u5e74\u5ea6\u6240\u8bbe\u7f6e\u7684\u9884\u7b97\u671f\u95f4\u4fe1\u606f\uff0c\u7cfb\u7edf\u81ea\u52a8\u5e26\u51fa\uff1b\n           \uff083\uff09\u9884\u7b97\u516c\u53f8\uff0c\u516c\u53f8\u5fc5\u987b\u5df2\u5728\u5546\u57ce\u7cfb\u7edf\u4e2d\u7ef4\u62a4\uff0c\u5e76\u4e14\u516c\u53f8\u540d\u79f0\u9700\u8981\u548c\u8425\u4e1a\u6267\u7167\u4e0a\u7684\u540d\u79f0\u4fdd\u6301\u4e00\u81f4\uff0c\u6ce8\u610f\u4e2d\u82f1\u6587\u7b26\u53f7\uff1b\n           \uff084\uff09\u9884\u7b97\u90e8\u95e8\uff0c\u90e8\u95e8\u5fc5\u987b\u5df2\u5728\u5546\u57ce\u7cfb\u7edf\u4e2d\u7ef4\u62a4\uff0c\u5982\u679c\u662f\u53d8\u66f4\u540d\u79f0\uff0c\u9700\u8981\u5f85\u5546\u57ce\u66f4\u65b0\u540e\uff0c\u518d\u5f55\u5165\u9884\u7b97\u4fe1\u606f\uff1b\n           \uff085\uff09\u90e8\u95e8\u671f\u95f4\u9884\u7b97\u989d\u5ea6\uff1a\u5fc5\u586b\u9879\uff0c\u5f55\u5165\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c\uff0c\u4e0d\u8981\u4f7f\u7528\u79d1\u5b66\u8ba1\u6570\u6cd5\u3001\u4e0d\u542b\u5343\u5206\u53f7\uff0c\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\u3002\n           \uff086\uff09\u9884\u7b97\u90e8\u95e8id\uff0c\u7cfb\u7edf\u81ea\u52a8\u5e26\u51fa\u9884\u7b97\u90e8\u95e8\u5bf9\u5e94\u7684id\u7f16\u7801\uff0c\u8bf7\u4e0d\u8981\u4fee\u6539\u6216\u5220\u9664\uff1b\n           \uff087\uff09\u9884\u7b97\u90e8\u95e8\u671f\u95f4id\uff0c\u7cfb\u7edf\u81ea\u52a8\u5e26\u51fa\u9884\u7b97\u90e8\u95e8\u671f\u95f4\u5bf9\u5e94\u7684id\u7f16\u7801\uff0c\u8bf7\u4e0d\u8981\u4fee\u6539\u6216\u5220\u9664\uff1b");
            skuDetailsRow = sheet.createRow(1);
            for (int j = 0; j < importBOs.get(i).getTitle().size(); ++j) {
                titleStyle = workbook.createCellStyle();
                titleFontStyle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
                titleFontStyle.setBold(true);
                titleStyle.setFont((Font)titleFontStyle);
                titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                titleStyle.setAlignment(HorizontalAlignment.CENTER);
                titleStyle.setWrapText(true);
                titleStyle.setLocked(true);
                titleStyle.setBorderTop(BorderStyle.THIN);
                titleStyle.setBorderBottom(BorderStyle.THIN);
                titleStyle.setBorderLeft(BorderStyle.THIN);
                titleStyle.setBorderRight(BorderStyle.THIN);
                titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                titleStyle.setFillForegroundColor(new XSSFColor(new Color(255, 207, 102)));
                if (j == 4) {
                    titleStyle.setFillForegroundColor(new XSSFColor(new Color(255, 255, 255)));
                    XSSFFont inStyle = workbook.createFont();
                    inStyle.setColor(new XSSFColor(new Color(187, 41, 41)));
                    inStyle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
                    inStyle.setBold(true);
                    titleStyle.setFont((Font)inStyle);
                }
                cell = skuDetailsRow.createCell(j);
                cell.setCellStyle((CellStyle)titleStyle);
                cell.setCellValue((String)importBOs.get(i).getTitle().get(j));
            }
            XSSFDataFormat format = workbook.createDataFormat();
            XSSFCellStyle mathStyle = workbook.createCellStyle();
            commonFontStyle = workbook.createFont();
            commonFontStyle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            mathStyle.setFont((Font)commonFontStyle);
            mathStyle.setLocked(true);
            mathStyle.setBorderTop(BorderStyle.THIN);
            mathStyle.setBorderBottom(BorderStyle.THIN);
            mathStyle.setBorderLeft(BorderStyle.THIN);
            mathStyle.setBorderRight(BorderStyle.THIN);
            mathStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            mathStyle.setAlignment(HorizontalAlignment.CENTER);
            mathStyle.setFillForegroundColor(new XSSFColor(new Color(255, 207, 102)));
            mathStyle.setDataFormat(format.getFormat("@"));
            XSSFCellStyle mathStyle2 = workbook.createCellStyle();
            commonFontStyle = workbook.createFont();
            commonFontStyle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            mathStyle2.setFont((Font)commonFontStyle);
            mathStyle2.setLocked(true);
            mathStyle2.setBorderTop(BorderStyle.THIN);
            mathStyle2.setBorderBottom(BorderStyle.THIN);
            mathStyle2.setBorderLeft(BorderStyle.THIN);
            mathStyle2.setBorderRight(BorderStyle.THIN);
            mathStyle2.setVerticalAlignment(VerticalAlignment.CENTER);
            mathStyle2.setAlignment(HorizontalAlignment.CENTER);
            mathStyle2.setFillForegroundColor(new XSSFColor(new Color(255, 255, 255)));
            mathStyle2.setDataFormat(format.getFormat("@"));
            XSSFCellStyle commonStyle = workbook.createCellStyle();
            commonFontStyle = workbook.createFont();
            commonFontStyle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            commonStyle.setFont((Font)commonFontStyle);
            commonStyle.setLocked(true);
            commonStyle.setBorderTop(BorderStyle.THIN);
            commonStyle.setBorderBottom(BorderStyle.THIN);
            commonStyle.setBorderLeft(BorderStyle.THIN);
            commonStyle.setBorderRight(BorderStyle.THIN);
            commonStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            commonStyle.setAlignment(HorizontalAlignment.CENTER);
            commonStyle.setFillForegroundColor(new XSSFColor(new Color(255, 207, 102)));
            commonStyle.setDataFormat(format.getFormat("@"));
            int rowIndex = 0;
            for (FscBudgetTemplateExportBO datum : data) {
                int cellIndex = 0;
                skuDetailsRow = sheet.createRow(2 + rowIndex++);
                cell = skuDetailsRow.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)commonStyle);
                cell.setCellValue(datum.getBudgetYear());
                cell = skuDetailsRow.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)commonStyle);
                cell.setCellValue(datum.getSpaceName());
                cell = skuDetailsRow.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)commonStyle);
                cell.setCellValue(datum.getBudgetOrgName());
                cell = skuDetailsRow.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)commonStyle);
                cell.setCellValue(datum.getBudgetDepartmentName());
                cell = skuDetailsRow.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)mathStyle);
                cell.setCellValue("");
                cell = skuDetailsRow.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)mathStyle2);
                cell.setCellValue(datum.getBudgetDepartmentId().toString());
                cell = skuDetailsRow.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)mathStyle2);
                cell.setCellValue(datum.getSpaceId().toString());
            }
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outputStream);
            byte[] b = outputStream.toByteArray();
            fileUrl = this.fileUpLoad.upload("\u9884\u7b97\u5bfc\u5165\u6a21\u677f-" + System.currentTimeMillis(), b, ".xlsx");
            outputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u5bfc\u51faExcel\u51fa\u73b0\u4e25\u91cd\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + ex.getMessage());
        }
        return fileUrl;
    }
}

