/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.budget.ability.api.FscQryBudgetDetailPageListAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetDetailBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetDetailPageListAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetDetailPageListAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetDetailPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscQryBudgetDetailPageListAbilityService"})
public class FscQryBudgetDetailPageListAbilityServiceImpl
implements FscQryBudgetDetailPageListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscQryBudgetDetailPageListAbilityServiceImpl.class);
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryBudgetDetailPageList"})
    public FscQryBudgetDetailPageListAbilityRspBO qryBudgetDetailPageList(@RequestBody FscQryBudgetDetailPageListAbilityReqBO reqBO) {
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        FscBudgetDetailPO fscBudgetDetailPo = new FscBudgetDetailPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)fscBudgetDetailPo);
        if (!ObjectUtil.isEmpty((Object)fscBudgetDetailPo.getBudgetOrgId())) {
            fscBudgetDetailPo.setSelectBudgetOrgId(fscBudgetDetailPo.getBudgetOrgId());
        }
        if (!reqBO.getOrgId().equals(1L)) {
            fscBudgetDetailPo.setBudgetOrgId(reqBO.getSecondId());
        }
        fscBudgetDetailPo.setOrderBy("bt.budget_code DESC,bd.update_time DESC");
        log.debug("\u9884\u7b97\u7684\u7ba1\u7406\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscBudgetDetailPo));
        List fscBudgetDetailPOS = this.fscBudgetDetailMapper.getBudgetDetailListPage(fscBudgetDetailPo, page);
        ArrayList<FscBudgetDetailBO> fscBudgetDetailBoList = new ArrayList<FscBudgetDetailBO>();
        if (!ObjectUtil.isEmpty((Object)fscBudgetDetailPOS)) {
            Map mainStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUDGET_MAIN_STATE");
            for (FscBudgetDetailPO item : fscBudgetDetailPOS) {
                FscBudgetDetailBO fscBudgetDetailBO = new FscBudgetDetailBO();
                BeanUtils.copyProperties((Object)item, (Object)fscBudgetDetailBO);
                fscBudgetDetailBO.setStatusStr((String)mainStateMap.get(item.getStatus().toString()));
                try {
                    FscBudgetDetailPO fscChildBudgetDetailPO;
                    if (item.getOriginYearlyTotalBudget() != null) {
                        fscBudgetDetailBO.setOriginYearlyTotalBudget(MoneyUtils.Long2BigDecimal((Long)item.getOriginYearlyTotalBudget()));
                    }
                    if (item.getDepartmentYearlyTotalBudget() != null) {
                        fscBudgetDetailBO.setDepartmentYearlyTotalBudget(MoneyUtils.Long2BigDecimal((Long)item.getDepartmentYearlyTotalBudget()));
                    }
                    if (ObjectUtil.isEmpty((Object)(fscChildBudgetDetailPO = this.fscBudgetDetailMapper.getChildDeptOriginYearlyTotalBudget(item)))) {
                        fscBudgetDetailBO.setChildDeptOriginYearlyTotalBudget(BigDecimal.ZERO);
                    } else {
                        BigDecimal child = new BigDecimal(fscChildBudgetDetailPO.getChildDeptOriginYearlyTotalBudget());
                        fscBudgetDetailBO.setChildDeptOriginYearlyTotalBudget(child.divide(new BigDecimal("10000"), 2, 1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new FscBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                fscBudgetDetailBO.setUnit("\u5143");
                fscBudgetDetailBoList.add(fscBudgetDetailBO);
            }
        }
        FscQryBudgetDetailPageListAbilityRspBO rspBO = new FscQryBudgetDetailPageListAbilityRspBO();
        rspBO.setRows(fscBudgetDetailBoList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void val(FscQryBudgetDetailPageListAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getBudgetId())) {
            throw new FscBusinessException("198888", "\u9884\u7b97\u4e3b\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

