/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.fsc.budget.atom.api.FscObtainBudgetOperationParamsAtomService;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationParamsBO;
import com.tydic.fsc.budget.atom.bo.FscObtainBudgetOperationParamsAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscObtainBudgetOperationParamsAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.po.FscBudgetItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscObtainBudgetOperationParamsAtomServiceImpl
implements FscObtainBudgetOperationParamsAtomService {
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;

    @Override
    public FscObtainBudgetOperationParamsAtomRspBO obtainBudgetOperationParams(FscObtainBudgetOperationParamsAtomReqBO reqBO) {
        FscObtainBudgetOperationParamsAtomRspBO rspBO = new FscObtainBudgetOperationParamsAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<FscBudgetOperationParamsBO> fscBudgetOperationParamsBOS = reqBO.getFscBudgetOperationParamsBOS();
        List budgetDetailIds = fscBudgetOperationParamsBOS.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getBudgetDetailId())).map(FscBudgetOperationParamsBO::getBudgetDetailId).collect(Collectors.toList());
        List budgetItemIds = fscBudgetOperationParamsBOS.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getBudgetItemId())).map(FscBudgetOperationParamsBO::getBudgetItemId).collect(Collectors.toList());
        Map<Long, List<FscBudgetDetailPO>> budgetDepartmentListMap = null;
        if (!ObjectUtil.isEmpty(budgetDetailIds)) {
            FscBudgetDetailPO fscBudgetDetailPO = new FscBudgetDetailPO();
            fscBudgetDetailPO.setBudgetDetailIds(budgetDetailIds);
            List fscBudgetDetailPOList = this.fscBudgetDetailMapper.getListToOperationLog(fscBudgetDetailPO);
            budgetDepartmentListMap = fscBudgetDetailPOList.stream().collect(Collectors.groupingBy(FscBudgetDetailPO::getBudgetDetailId));
        }
        Map<Long, List<FscBudgetItemPO>> budgetSpacecNameListMap = null;
        if (!ObjectUtil.isEmpty(budgetItemIds)) {
            FscBudgetItemPO fscBudgetItemPO = new FscBudgetItemPO();
            fscBudgetItemPO.setBudgetItemIds(budgetItemIds);
            List fscBudgetItemPOList = this.fscBudgetItemMapper.getList(fscBudgetItemPO);
            budgetSpacecNameListMap = fscBudgetItemPOList.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getBudgetItemId));
        }
        ArrayList<FscBudgetOperationAddAtomBO> fscBudgetOperationAddAtomBOS = new ArrayList<FscBudgetOperationAddAtomBO>();
        for (FscBudgetOperationParamsBO operationParams : fscBudgetOperationParamsBOS) {
            FscBudgetOperationAddAtomBO fscBudgetOperationAddAtomBO = new FscBudgetOperationAddAtomBO();
            fscBudgetOperationAddAtomBO.setBussiId(operationParams.getBusId());
            fscBudgetOperationAddAtomBO.setOrgId(budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getBudgetDepartmentId());
            fscBudgetOperationAddAtomBO.setOrgName(budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getOrgPathName());
            try {
                String content;
                BigDecimal oldAmount;
                if (FscConstants.FSC_BUDGET_LOG_OPERATION_TYPE.BUDGET_ADD.equals(operationParams.getOperationType())) {
                    fscBudgetOperationAddAtomBO.setOperationType(1);
                    String content2 = "\u65b0\u589e:\u9884\u7b97\u516c\u53f8\uff1a\u201c" + budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getBudgetDepartmentName() + "\u201c,\u9884\u7b97\u5e74\u5ea6\uff1a\u201d" + budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getBudgetYear() + "\u201c\u5e74";
                    fscBudgetOperationAddAtomBO.setOperationContent(content2);
                }
                if (FscConstants.FSC_BUDGET_LOG_OPERATION_TYPE.BUDGET_ADJUST_ADD.equals(operationParams.getOperationType())) {
                    fscBudgetOperationAddAtomBO.setOperationType(1);
                    oldAmount = MoneyUtils.Long2BigDecimal((Long)budgetSpacecNameListMap.get(operationParams.getBudgetItemId()).get(0).getNowSpaceBudget());
                    content = "\u8c03\u6574:\u9884\u7b97\u516c\u53f8\uff1a\u201c" + budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getBudgetDepartmentName() + "\u201c,\u9884\u7b97\u5e74\u5ea6\uff1a\u201d" + budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getBudgetYear() + "\u201c\u5e74\u201c,\u9884\u7b97\u671f\u95f4\uff1a\u201d" + budgetSpacecNameListMap.get(operationParams.getBudgetItemId()).get(0).getSpaceName() + "\u201c\u201c,\u539f\u9884\u7b97\u989d\u5ea6\uff1a\u201d" + oldAmount + "\u5143\u201c\u201c,\u589e\u52a0\u81f3\uff1a\u201d" + operationParams.getOperationAmount().add(oldAmount) + "\u5143\u201c";
                    fscBudgetOperationAddAtomBO.setOperationContent(content);
                }
                if (FscConstants.FSC_BUDGET_LOG_OPERATION_TYPE.BUDGET_EDITED.equals(operationParams.getOperationType())) {
                    fscBudgetOperationAddAtomBO.setOperationType(2);
                    oldAmount = MoneyUtils.Long2BigDecimal((Long)budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getOriginYearlyTotalBudget());
                    content = "\u4fee\u6539\uff1a\u5e74\u5ea6\u9884\u7b97\u989d\u5ea6\u201c" + oldAmount + "\u5143\u201c,\u6539\u4e3a\uff1a\u201d" + operationParams.getOperationAmount() + "\u5143\u201c";
                    fscBudgetOperationAddAtomBO.setOperationContent(content);
                }
                if (FscConstants.FSC_BUDGET_LOG_OPERATION_TYPE.BUDGET_ADJUST_EDITED.equals(operationParams.getOperationType())) {
                    oldAmount = MoneyUtils.Long2BigDecimal((Long)budgetSpacecNameListMap.get(operationParams.getBudgetItemId()).get(0).getNowSpaceBudget());
                    content = "\u8c03\u6574\uff1a\u9884\u7b97\u516c\u53f8:\u201c" + budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getBudgetDepartmentName() + "\u201c,\u9884\u7b97\u5e74\u5ea6\uff1a\u201d" + budgetDepartmentListMap.get(operationParams.getBudgetDetailId()).get(0).getBudgetYear() + "\u201c\u5e74\u201c,\u9884\u7b97\u671f\u95f4\uff1a\u201d" + budgetSpacecNameListMap.get(operationParams.getBudgetItemId()).get(0).getSpaceName() + "\u201c\u201c,\u539f\u9884\u7b97\u989d\u5ea6\uff1a\u201d" + oldAmount + "\u5143\u201c\u201c,\u51cf\u5c11\u81f3\uff1a\u201d" + oldAmount.subtract(operationParams.getOperationAmount()) + "\u5143\u201c";
                    fscBudgetOperationAddAtomBO.setOperationContent(content);
                    fscBudgetOperationAddAtomBO.setOperationType(2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u7ec4\u88c5\u9519\u8bef");
            }
            fscBudgetOperationAddAtomBOS.add(fscBudgetOperationAddAtomBO);
        }
        rspBO.setFscBudgetOperationAddAtomBOS(fscBudgetOperationAddAtomBOS);
        return rspBO;
    }
}

