/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.atom.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.budget.atom.api.FscSendMessageAtomService;
import com.tydic.fsc.budget.atom.bo.FscSendMessageAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscSendMessageAtomRspBO;
import com.tydic.fsc.budget.atom.bo.SendMessageBO;
import com.tydic.fsc.budget.atom.bo.SendMessageReceiverBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscSendMessageAtomServiceImpl
implements FscSendMessageAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendMessageAtomServiceImpl.class);
    @Value(value="${ADJUST_SEND_MESSAGE_URL}")
    private String ADJUST_SEND_MESSAGE_URL;

    @Override
    public FscSendMessageAtomRspBO sendMessageAtomService(FscSendMessageAtomReqBO reqBO) {
        FscSendMessageAtomRspBO rspBO = new FscSendMessageAtomRspBO();
        for (SendMessageBO sendMessageBO : reqBO.getSendMessageBOList()) {
            log.info("\u53d1\u901a\u77e5\u539f\u5b50\u670d\u52a1\u5165\u53c2{}->" + JSON.toJSONString((Object)sendMessageBO));
            String reqStr = this.initReqStr(sendMessageBO);
            log.info("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u53d1\u9001\u5165\u53c2{}->" + reqStr);
            try {
                String s = HttpUtil.post((String)this.ADJUST_SEND_MESSAGE_URL, (String)reqStr);
                log.info("\u901a\u77e5\u4e2d\u5fc3\u901a\u77e5\u8fd4\u56de\u6d88\u606f{}->" + s);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25,{}", (Object)e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String initReqStr(SendMessageBO sendMessageBO) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("taskCode", (Object)sendMessageBO.getTaskCode());
        JSONObject data = new JSONObject();
        data.put("operType", (Object)sendMessageBO.getOperTypeStr());
        data.put("operNum", (Object)sendMessageBO.getOperNum());
        data.put("budgetYear", (Object)sendMessageBO.getBudgetYear());
        data.put("spaceName", (Object)sendMessageBO.getSpaceName());
        data.put("currentBudget", (Object)sendMessageBO.getCurrentBudget());
        reqJson.put("data", (Object)data.toJSONString());
        reqJson.put("sendId", (Object)sendMessageBO.getSendId());
        reqJson.put("sendName", (Object)sendMessageBO.getSendName());
        JSONArray receivers = new JSONArray();
        for (SendMessageReceiverBO each : sendMessageBO.getReceiverBOList()) {
            JSONObject receiver = new JSONObject();
            receiver.put("receiverId", (Object)each.getReceiverId());
            receiver.put("receiverName", (Object)each.getReceiverName());
            receivers.add((Object)receiver);
        }
        reqJson.put("receivers", (Object)receivers);
        return reqJson.toString();
    }
}

