/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.cfc.ability.api.CfcQryBudgetParamAbilityService;
import com.tydic.cfc.ability.api.CfcQryBudgetPeriodAbilityService;
import com.tydic.cfc.ability.bo.BudgetPeriodDetailBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetParamAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetParamAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetPeriodAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetPeriodAbilityRspBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.fsc.budget.ability.api.FscBudgetTemplateImportAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetTemplateImportAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetTemplateImportAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetTemplateImportBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetTemplateImportFailBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetTimeTaskAbilityReqBO;
import com.tydic.fsc.budget.busi.api.FscBudgetTemplateImportBusiService;
import com.tydic.fsc.budget.busi.bo.FscBudgetTemplateImportBusiReqBO;
import com.tydic.fsc.budget.busi.bo.FscBudgetTemplateImportBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.po.FscBudgetItemPO;
import com.tydic.fsc.po.FscBudgetPO;
import com.tydic.umc.general.ability.api.CrcQryDeptListByOrgIdListAbilityService;
import com.tydic.umc.general.ability.bo.CrcQryDeptListByOrgIdListAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQryDeptListByOrgIdListAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcOrgBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscBudgetTemplateImportAbilityService"})
public class FscBudgetTemplateImportAbilityServiceImpl
implements FscBudgetTemplateImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetTemplateImportAbilityServiceImpl.class);
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscBudgetTemplateImportBusiService fscBudgetTemplateImportBusiService;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private CfcQryBudgetParamAbilityService cfcQryBudgetParamAbilityService;
    @Autowired
    private CfcQryBudgetPeriodAbilityService cfcQryBudgetPeriodAbilityService;
    @Autowired
    private CrcQryDeptListByOrgIdListAbilityService crcQryDeptListByOrgIdListAbilityService;
    @Resource(name="fscBudgetTimeTaskProducer")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${FSC_BUDGET_TIME_TASK_TOPIC:FSC_BUDGET_TIME_TASK_TOPIC}")
    private String FSC_BUDGET_TIME_TASK_TOPIC;

    @PostMapping(value={"budgetTemplateImport"})
    public FscBudgetTemplateImportAbilityRspBO budgetTemplateImport(@RequestBody FscBudgetTemplateImportAbilityReqBO reqBO) {
        FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO;
        FscBudgetTemplateImportAbilityRspBO rspBO = this.judge(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<FscBudgetTemplateImportFailBO> failReasonList = new ArrayList<FscBudgetTemplateImportFailBO>();
        rspBO.setFailReasonList(failReasonList);
        Map<String, List<FscBudgetTemplateImportBO>> departmentMap = reqBO.getBudgetTemplateImport().stream().collect(Collectors.groupingBy(FscBudgetTemplateImportBO::getBudgetDepartmentId));
        CrcQryDeptListByOrgIdListAbilityReqBO crcQryDeptListByOrgIdListAbilityReqBO = new CrcQryDeptListByOrgIdListAbilityReqBO();
        crcQryDeptListByOrgIdListAbilityReqBO.setOrgIdList(departmentMap.keySet().stream().map(Long::parseLong).collect(Collectors.toList()));
        log.info("\u67e5\u8be2\u673a\u6784\u5165\u53c2crcQryDeptListByOrgIdListAbilityReqBO\uff1a" + JSON.toJSONString((Object)crcQryDeptListByOrgIdListAbilityReqBO));
        CrcQryDeptListByOrgIdListAbilityRspBO crcQryDeptListByOrgIdListAbilityRspBO = this.crcQryDeptListByOrgIdListAbilityService.qryDeptListByOrgIdList(crcQryDeptListByOrgIdListAbilityReqBO);
        log.info("\u67e5\u8be2\u673a\u6784\u51fa\u53c2crcQryDeptListByOrgIdListAbilityRspBO\uff1a" + JSON.toJSONString((Object)crcQryDeptListByOrgIdListAbilityRspBO));
        if (!"0000".equals(crcQryDeptListByOrgIdListAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u673a\u6784\u51fa\u9519\uff1a" + crcQryDeptListByOrgIdListAbilityRspBO.getRespDesc());
        }
        if (StringUtils.isEmpty((Object)crcQryDeptListByOrgIdListAbilityRspBO.getSbuId())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u673a\u6784\u65f6\u8fd4\u56de\u7684\u6240\u5c5e\u4e8c\u7ea7\u673a\u6784id\u4e3a\u7a7a");
        }
        Map orgMap = crcQryDeptListByOrgIdListAbilityRspBO.getUmcOrgBOS().stream().collect(Collectors.toMap(UmcOrgBO::getOrgId, Function.identity()));
        CfcQryBudgetParamAbilityReqBO cfcQryBudgetParamAbilityReqBO = new CfcQryBudgetParamAbilityReqBO();
        cfcQryBudgetParamAbilityReqBO.setOrgIdWeb(crcQryDeptListByOrgIdListAbilityRspBO.getSbuId());
        log.info("\u67e5\u8be2\u9884\u7b97\u4f59\u989d\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u5165\u53c2cfcQryBudgetParamAbilityReqBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetParamAbilityReqBO));
        CfcQryBudgetParamAbilityRspBO cfcQryBudgetParamAbilityRspBO = this.cfcQryBudgetParamAbilityService.qryBudgetParam(cfcQryBudgetParamAbilityReqBO);
        log.info("\u67e5\u8be2\u9884\u7b97\u4f59\u989d\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u51fa\u53c2cfcQryBudgetParamAbilityRspBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetParamAbilityRspBO));
        if (!"0000".equals(cfcQryBudgetParamAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u9884\u7b97\u4f59\u989d\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetParamAbilityRspBO.getRespDesc());
        }
        if (!"1".equals(cfcQryBudgetParamAbilityRspBO.getStatus())) {
            throw new FscBusinessException("8888", "\u9884\u7b97\u4f59\u989d\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u6ca1\u6709\u542f\u7528");
        }
        CfcQryBudgetPeriodAbilityReqBO cfcQryBudgetPeriodAbilityReqBO = new CfcQryBudgetPeriodAbilityReqBO();
        cfcQryBudgetPeriodAbilityReqBO.setOrgIdWeb(crcQryDeptListByOrgIdListAbilityRspBO.getSbuId());
        cfcQryBudgetPeriodAbilityReqBO.setYear(Integer.valueOf(Integer.parseInt(((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear())));
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u5165\u53c2cfcQryBudgetPeriodAbilityReqBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetPeriodAbilityReqBO));
        CfcQryBudgetPeriodAbilityRspBO cfcQryBudgetPeriodAbilityRspBO = this.cfcQryBudgetPeriodAbilityService.qryBudgetPeriod(cfcQryBudgetPeriodAbilityReqBO);
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u53c2cfcQryBudgetPeriodAbilityRspBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetPeriodAbilityRspBO));
        if (!"0000".equals(cfcQryBudgetPeriodAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetPeriodAbilityRspBO.getRespDesc());
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO() == null) {
            throw new FscBusinessException("8888", "\u9884\u7b97\u5e74\u5ea6\u201c" + ((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear() + "\u201d\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u9884\u7b97\u5e74\u5ea6\u201c" + ((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear() + "\u201d\u5c1a\u672a\u7ef4\u62a4\u671f\u95f4\u4fe1\u606f");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum() == null) {
            throw new FscBusinessException("8888", "\u9884\u7b97\u5e74\u5ea6\u201c" + ((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear() + "\u201d\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u9884\u7b97\u5e74\u5ea6\u201c" + ((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear() + "\u201d\u6ca1\u7ef4\u62a4\u671f\u95f4");
        }
        if (!"0000".equals(cfcQryBudgetPeriodAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetPeriodAbilityRspBO.getRespDesc());
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO() == null) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u4e3a\u7a7a");
        }
        List budgetPeriodDetailBOList = cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodDetailBOList();
        if (CollectionUtils.isEmpty((Collection)budgetPeriodDetailBOList)) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u6570\u91cf\u4e3a\u7a7a");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum().intValue() != budgetPeriodDetailBOList.size()) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e\u9519\u8bef\uff0c\u671f\u95f4\u603b\u6570\u548c\u914d\u7f6e\u7684\u671f\u95f4\u6570\u91cf\u4e0d\u7b49");
        }
        SimpleDateFormat getYearFormat = new SimpleDateFormat("yyyy");
        for (BudgetPeriodDetailBO each : budgetPeriodDetailBOList) {
            if (each.getPeriodStartDate() == null) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (each.getPeriodEndDate() == null) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (!cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetYear().equals(Integer.parseInt(getYearFormat.format(each.getPeriodStartDate())))) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u548c\u5e74\u4efd\u4e0d\u5339\u914d");
            }
            if (!cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetYear().equals(Integer.parseInt(getYearFormat.format(each.getPeriodEndDate())))) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u7ed3\u675f\u65f6\u95f4\u548c\u5e74\u4efd\u4e0d\u5339\u914d");
            }
            if (!StringUtils.isEmpty((Object)each.getPeriodName())) continue;
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u540d\u79f0\u4e3a\u7a7a");
        }
        Map spaceMap = budgetPeriodDetailBOList.stream().collect(Collectors.toMap(BudgetPeriodDetailBO::getPeriodId, Function.identity()));
        HashSet<String> removeBudgetDepartmentIds = new HashSet<String>();
        for (String budgetDepartmentId : departmentMap.keySet()) {
            Set spaceIds = departmentMap.get(budgetDepartmentId).stream().map(FscBudgetTemplateImportBO::getSpaceId).collect(Collectors.toSet());
            for (FscBudgetTemplateImportBO each : departmentMap.get(budgetDepartmentId)) {
                if (spaceIds.size() != departmentMap.get(budgetDepartmentId).size()) {
                    FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO2 = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO2.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO2.setFailReason("\u9884\u7b97\u90e8\u95e8\u201c" + each.getBudgetDepartmentName() + "\u201c\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u591a\u7b14\u540c\u4e00\u9884\u7b97\u5e74\u5ea6\u7684\u4fe1\u606f");
                    log.error("\u9884\u7b97\u90e8\u95e8\u201c" + each.getBudgetDepartmentName() + "\u201c\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u591a\u7b14\u540c\u4e00\u9884\u7b97\u5e74\u5ea6\u7684\u4fe1\u606f");
                    failReasonList.add(fscBudgetTemplateImportFailBO2);
                    removeBudgetDepartmentIds.add(budgetDepartmentId);
                    continue;
                }
                if (!orgMap.containsKey(Long.parseLong(budgetDepartmentId))) {
                    FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO3 = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO3.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO3.setFailReason("\u9884\u7b97\u90e8\u95e8\u201c" + each.getBudgetDepartmentName() + "\u201c\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u90e8\u95e8id\u4e0d\u5339\u914d");
                    log.error("\u9884\u7b97\u90e8\u95e8\u201c" + each.getBudgetDepartmentName() + "\u201c\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u90e8\u95e8id\u4e0d\u5339\u914d");
                    failReasonList.add(fscBudgetTemplateImportFailBO3);
                    removeBudgetDepartmentIds.add(budgetDepartmentId);
                    continue;
                }
                if (!crcQryDeptListByOrgIdListAbilityRspBO.getSbuOrgName().equals(each.getBudgetOrgName())) {
                    FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO4 = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO4.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO4.setFailReason("\u9884\u7b97\u7ec4\u7ec7\u201c" + each.getBudgetOrgName() + "\u201c\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u7ec4\u7ec7\u540d\u79f0\u4e0d\u5339\u914d");
                    log.error("\u9884\u7b97\u7ec4\u7ec7\u201c" + each.getBudgetOrgName() + "\u201c\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u7ec4\u7ec7\u540d\u79f0\u4e0d\u5339\u914d");
                    failReasonList.add(fscBudgetTemplateImportFailBO4);
                    removeBudgetDepartmentIds.add(budgetDepartmentId);
                    continue;
                }
                if (!((UmcOrgBO)orgMap.get(Long.parseLong(budgetDepartmentId))).getOrgName().equals(each.getBudgetDepartmentName())) {
                    FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO5 = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO5.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO5.setFailReason("\u9884\u7b97\u90e8\u95e8\u201c" + each.getBudgetDepartmentName() + "\u201c\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u90e8\u95e8\u540d\u79f0\u4e0d\u5339\u914d");
                    log.error("\u9884\u7b97\u90e8\u95e8\u201c" + each.getBudgetDepartmentName() + "\u201c\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u90e8\u95e8\u540d\u79f0\u4e0d\u5339\u914d");
                    failReasonList.add(fscBudgetTemplateImportFailBO5);
                    removeBudgetDepartmentIds.add(budgetDepartmentId);
                    continue;
                }
                if (departmentMap.get(budgetDepartmentId).size() != budgetPeriodDetailBOList.size()) {
                    FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO6 = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO6.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO6.setFailReason("\u201c" + each.getBudgetDepartmentName() + "\u201c\u7684\u671f\u95f4\u6570\u91cf\u4e0e\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u671f\u95f4\u6570:\u201c" + cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodDetailBOList().size() + "\u201c\u4e0d\u4e00\u81f4");
                    log.error("\u201c" + each.getBudgetDepartmentName() + "\u201c\u7684\u671f\u95f4\u6570\u91cf\u4e0e\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e\u671f\u95f4\u6570:\u201c" + cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodDetailBOList().size() + "\u201c\u4e0d\u4e00\u81f4");
                    failReasonList.add(fscBudgetTemplateImportFailBO6);
                    removeBudgetDepartmentIds.add(budgetDepartmentId);
                    continue;
                }
                if (!spaceMap.containsKey(Long.parseLong(each.getSpaceId()))) {
                    FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO7 = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO7.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO7.setFailReason("\u201c" + each.getBudgetDepartmentName() + "\u201c\u7684\u9884\u7b97\u671f\u95f4id\u4e0e\u914d\u7f6e\u4e2d\u5fc3\u7684\u4e0d\u5339\u914d");
                    log.error("\u201c" + each.getBudgetDepartmentName() + "\u201c\u7684\u9884\u7b97\u671f\u95f4id\u4e0e\u914d\u7f6e\u4e2d\u5fc3\u7684\u4e0d\u5339\u914d");
                    failReasonList.add(fscBudgetTemplateImportFailBO7);
                    removeBudgetDepartmentIds.add(budgetDepartmentId);
                    continue;
                }
                if (!((BudgetPeriodDetailBO)spaceMap.get(Long.parseLong(each.getSpaceId()))).getPeriodName().equals(each.getSpaceName())) {
                    FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO8 = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO8.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO8.setFailReason("\u201c" + each.getBudgetDepartmentName() + "\u201c\u7684\u9884\u7b97\u671f\u95f4\u540d\u79f0\u4e0e\u914d\u7f6e\u4e2d\u5fc3\u7684\u4e0d\u5339\u914d");
                    log.error("\u201c" + each.getBudgetDepartmentName() + "\u201c\u7684\u9884\u7b97\u671f\u95f4\u540d\u79f0\u4e0e\u914d\u7f6e\u4e2d\u5fc3\u7684\u4e0d\u5339\u914d");
                    failReasonList.add(fscBudgetTemplateImportFailBO8);
                    removeBudgetDepartmentIds.add(budgetDepartmentId);
                    continue;
                }
                double originSpaceBudget = 0.0;
                try {
                    originSpaceBudget = Double.parseDouble(each.getOriginSpaceBudget());
                    if (new BigDecimal(originSpaceBudget).setScale(2, 4).compareTo(new BigDecimal(originSpaceBudget)) != 0) {
                        throw new BusinessException("198888", "\u671f\u95f4\u9884\u7b97\u5f55\u5165\u503c\u8d85\u8fc7\u4e24\u4f4d\u5c0f\u6570");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FscBudgetTemplateImportFailBO fscBudgetTemplateImportFailBO9 = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO9.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO9.setFailReason("\u201c" + each.getBudgetDepartmentName() + "\u201c\u90e8\u95e8\u5bfc\u5165\u9884\u7b97\u671f\u95f4\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u671f\u95f4\u9884\u7b97\u5f55\u5165\u503c\u201c" + each.getOriginSpaceBudget() + "\u201d\u6709\u8bef");
                    log.error("\u201c" + each.getBudgetDepartmentName() + "\u201c\u90e8\u95e8\u5bfc\u5165\u9884\u7b97\u671f\u95f4\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u671f\u95f4\u9884\u7b97\u5f55\u5165\u503c\u201c" + each.getOriginSpaceBudget() + "\u201d\u6709\u8bef");
                    failReasonList.add(fscBudgetTemplateImportFailBO9);
                    removeBudgetDepartmentIds.add(budgetDepartmentId);
                    continue;
                }
                if (!(originSpaceBudget < 0.0)) continue;
                fscBudgetTemplateImportFailBO = new FscBudgetTemplateImportFailBO();
                fscBudgetTemplateImportFailBO.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                fscBudgetTemplateImportFailBO.setFailReason("\u201c" + each.getBudgetDepartmentName() + "\u201c\u90e8\u95e8\u5bfc\u5165\u9884\u7b97\u671f\u95f4\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u671f\u95f4\u9884\u7b97\u5f55\u5165\u503c\u5c0f\u4e8e0");
                log.error("\u201c" + each.getBudgetDepartmentName() + "\u201c\u90e8\u95e8\u5bfc\u5165\u9884\u7b97\u671f\u95f4\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u671f\u95f4\u9884\u7b97\u5f55\u5165\u503c\u5c0f\u4e8e0");
                failReasonList.add(fscBudgetTemplateImportFailBO);
                removeBudgetDepartmentIds.add(budgetDepartmentId);
            }
        }
        for (String each : removeBudgetDepartmentIds) {
            departmentMap.remove(each);
        }
        FscBudgetItemPO qryPO = new FscBudgetItemPO();
        qryPO.setBudgetYear(((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear());
        qryPO.setBudgetDepartmentIds(departmentMap.keySet().stream().map(Long::parseLong).collect(Collectors.toList()));
        List list = this.fscBudgetItemMapper.getList(qryPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map<Long, List<FscBudgetItemPO>> collect = list.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getBudgetDepartmentId));
            for (Long budgetDepartmentId : collect.keySet()) {
                if (!departmentMap.containsKey(budgetDepartmentId.toString())) continue;
                for (FscBudgetTemplateImportBO each : departmentMap.get(budgetDepartmentId.toString())) {
                    fscBudgetTemplateImportFailBO = new FscBudgetTemplateImportFailBO();
                    fscBudgetTemplateImportFailBO.setLineNum(Integer.valueOf(Integer.parseInt(each.getGluttonLineNum())));
                    fscBudgetTemplateImportFailBO.setFailReason("\u201c" + each.getBudgetDepartmentName() + "\u201c\u90e8\u95e8\u5df2\u7ef4\u62a4\u201c" + ((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear() + "\u201d\u5e74\u5ea6\u7684\u9884\u7b97\u4fe1\u606f");
                    log.error("\u201c" + each.getBudgetDepartmentName() + "\u201c\u90e8\u95e8\u5df2\u7ef4\u62a4\u201c" + ((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear() + "\u201d\u5e74\u5ea6\u7684\u9884\u7b97\u4fe1\u606f");
                    failReasonList.add(fscBudgetTemplateImportFailBO);
                }
                departmentMap.remove(budgetDepartmentId.toString());
            }
        }
        ArrayList<FscBudgetDetailPO> budgetDetailInfoList = new ArrayList<FscBudgetDetailPO>();
        ArrayList<FscBudgetItemPO> budgetItemInfoLIst = new ArrayList<FscBudgetItemPO>();
        Long budgetId = this.sequence.nextId();
        Date time = new Date(System.currentTimeMillis());
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        for (String BudgetDepartmentId : departmentMap.keySet()) {
            Long budgetDetailId = this.sequence.nextId();
            List<FscBudgetTemplateImportBO> fscBudgetTemplateImportBOS = departmentMap.get(BudgetDepartmentId);
            BigDecimal originYearlyTotalBudget = new BigDecimal(0);
            for (FscBudgetTemplateImportBO fscBudgetTemplateImportBO : fscBudgetTemplateImportBOS) {
                originYearlyTotalBudget = originYearlyTotalBudget.add(new BigDecimal(fscBudgetTemplateImportBO.getOriginSpaceBudget()));
            }
            int i = 0;
            for (FscBudgetTemplateImportBO each3 : fscBudgetTemplateImportBOS) {
                long spaceId = Long.parseLong(each3.getSpaceId());
                FscBudgetItemPO fscBudgetItemPO = new FscBudgetItemPO();
                fscBudgetItemPO.setBudgetItemId(Long.valueOf(this.sequence.nextId()));
                fscBudgetItemPO.setBudgetDetailId(budgetDetailId);
                if (time.compareTo(((BudgetPeriodDetailBO)spaceMap.get(spaceId)).getPeriodStartDate()) < 0) {
                    fscBudgetItemPO.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.NOT_STARTED);
                } else if (time.compareTo(((BudgetPeriodDetailBO)spaceMap.get(spaceId)).getPeriodEndDate()) > 0) {
                    fscBudgetItemPO.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.OVER);
                } else {
                    fscBudgetItemPO.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.STARTED);
                }
                fscBudgetItemPO.setViewOrder(Integer.valueOf(i++));
                fscBudgetItemPO.setPastBudget(Long.valueOf(0L));
                fscBudgetItemPO.setFixSpaceBudget(Long.valueOf(0L));
                Long originSpaceBudget = null;
                try {
                    originSpaceBudget = MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(each3.getOriginSpaceBudget()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new FscBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                fscBudgetItemPO.setOriginSpaceBudget(originSpaceBudget);
                fscBudgetItemPO.setNowSpaceBudget(originSpaceBudget);
                fscBudgetItemPO.setCurrentBudget(originSpaceBudget);
                fscBudgetItemPO.setUsedBudget(Long.valueOf(0L));
                fscBudgetItemPO.setCreateOperId(reqBO.getUserId());
                fscBudgetItemPO.setCreateOperName(reqBO.getName());
                fscBudgetItemPO.setCreateOperUsername(reqBO.getUserName());
                fscBudgetItemPO.setCreateTime(time);
                fscBudgetItemPO.setUpdateOperId(reqBO.getUserId());
                fscBudgetItemPO.setUpdateOperName(reqBO.getName());
                fscBudgetItemPO.setUpdateOperUsername(reqBO.getUserName());
                fscBudgetItemPO.setUpdateTime(time);
                fscBudgetItemPO.setBudgetId(budgetId);
                fscBudgetItemPO.setStartTime(((BudgetPeriodDetailBO)spaceMap.get(spaceId)).getPeriodStartDate());
                fscBudgetItemPO.setEndTime(((BudgetPeriodDetailBO)spaceMap.get(spaceId)).getPeriodEndDate());
                fscBudgetItemPO.setSpaceName(((BudgetPeriodDetailBO)spaceMap.get(spaceId)).getPeriodName());
                budgetItemInfoLIst.add(fscBudgetItemPO);
            }
            FscBudgetDetailPO fscBudgetDetailPO = new FscBudgetDetailPO();
            fscBudgetDetailPO.setBudgetDetailId(budgetDetailId);
            fscBudgetDetailPO.setBudgetId(budgetId);
            fscBudgetDetailPO.setBudgetDepartmentId(Long.valueOf(Long.parseLong(fscBudgetTemplateImportBOS.get(0).getBudgetDepartmentId())));
            fscBudgetDetailPO.setBudgetDepartmentName(((UmcOrgBO)orgMap.get(fscBudgetDetailPO.getBudgetDepartmentId())).getOrgName());
            try {
                fscBudgetDetailPO.setOriginYearlyTotalBudget(MoneyUtils.BigDecimal2Long((BigDecimal)originYearlyTotalBudget));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FscBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            fscBudgetDetailPO.setOrgPath(((UmcOrgBO)orgMap.get(fscBudgetDetailPO.getBudgetDepartmentId())).getOrgTreePath());
            fscBudgetDetailPO.setOrgPathName(((UmcOrgBO)orgMap.get(fscBudgetDetailPO.getBudgetDepartmentId())).getOrgFullName());
            fscBudgetDetailPO.setStartTime(((BudgetPeriodDetailBO)budgetPeriodDetailBOList.get(0)).getPeriodStartDate());
            fscBudgetDetailPO.setEndTime(((BudgetPeriodDetailBO)budgetPeriodDetailBOList.get(budgetPeriodDetailBOList.size() - 1)).getPeriodEndDate());
            fscBudgetDetailPO.setCreateOperId(reqBO.getUserId());
            fscBudgetDetailPO.setCreateOperName(reqBO.getName());
            fscBudgetDetailPO.setCreateOperUsername(reqBO.getUserName());
            fscBudgetDetailPO.setCreateTime(time);
            fscBudgetDetailPO.setUpdateOperId(reqBO.getUserId());
            fscBudgetDetailPO.setUpdateOperName(reqBO.getName());
            fscBudgetDetailPO.setUpdateOperUsername(reqBO.getUserName());
            fscBudgetDetailPO.setUpdateTime(time);
            budgetDetailInfoList.add(fscBudgetDetailPO);
        }
        if (CollectionUtils.isEmpty(budgetItemInfoLIst)) {
            return rspBO;
        }
        FscBudgetPO budgetInfo = new FscBudgetPO();
        budgetInfo.setBudgetId(budgetId);
        budgetInfo.setBudgetYear(((FscBudgetTemplateImportBO)reqBO.getBudgetTemplateImport().get(0)).getBudgetYear());
        if (Integer.parseInt(budgetInfo.getBudgetYear()) > year) {
            budgetInfo.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.NOT_STARTED);
        } else if (Integer.parseInt(budgetInfo.getBudgetYear()) == year) {
            budgetInfo.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.STARTED);
        } else {
            budgetInfo.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.OVER);
        }
        budgetInfo.setCurrency(Integer.valueOf(1));
        budgetInfo.setBudgetOrgId(crcQryDeptListByOrgIdListAbilityRspBO.getSbuId());
        budgetInfo.setBudgetOrgName(crcQryDeptListByOrgIdListAbilityRspBO.getSbuOrgName());
        budgetInfo.setSpace(cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum());
        budgetInfo.setPeriodDealType(Integer.valueOf(Integer.parseInt(cfcQryBudgetParamAbilityRspBO.getPeriodDealType())));
        budgetInfo.setYearDealType(Integer.valueOf(Integer.parseInt(cfcQryBudgetParamAbilityRspBO.getYearDealType())));
        budgetInfo.setExceedAvailableLimit(Integer.valueOf(Integer.parseInt(cfcQryBudgetParamAbilityRspBO.getExceedAvailableLimit())));
        budgetInfo.setCreateOperId(reqBO.getUserId());
        budgetInfo.setCreateOperName(reqBO.getName());
        budgetInfo.setCreateOperUsername(reqBO.getUserName());
        budgetInfo.setCreateTime(time);
        budgetInfo.setUpdateOperId(reqBO.getUserId());
        budgetInfo.setUpdateOperName(reqBO.getName());
        budgetInfo.setUpdateOperUsername(reqBO.getUserName());
        budgetInfo.setUpdateTime(time);
        if (!CollectionUtils.isEmpty(budgetItemInfoLIst)) {
            FscBudgetTemplateImportBusiReqBO busiReqBO = new FscBudgetTemplateImportBusiReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
            busiReqBO.setBudgetInfo(budgetInfo);
            busiReqBO.setBudgetDetailInfoList(budgetDetailInfoList);
            busiReqBO.setBudgetItemInfoLIst(budgetItemInfoLIst);
            FscBudgetTemplateImportBusiRspBO busiRspBO = null;
            try {
                busiRspBO = this.fscBudgetTemplateImportBusiService.budgetTemplateImport(busiReqBO);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FscBusinessException("8888", "\u5bfc\u5165\u9884\u7b97busi\u5c42\u51fa\u9519\uff1a" + e.getMessage());
            }
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new FscBusinessException("8888", "\u5bfc\u5165\u9884\u7b97busi\u5c42\u62a5\u9519\uff1a" + busiRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(budgetDetailInfoList)) {
                for (FscBudgetDetailPO each : budgetDetailInfoList) {
                    FscBudgetTimeTaskAbilityReqBO fscBudgetTimeTaskAbilityReqBO = new FscBudgetTimeTaskAbilityReqBO();
                    BeanUtils.copyProperties((Object)each, (Object)fscBudgetTimeTaskAbilityReqBO);
                    try {
                        log.info("\u9884\u7b97\u6a21\u677f\u5bfc\u5165\u53d1mq\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscBudgetTimeTaskAbilityReqBO));
                        this.proxyMessageProducer.send(new ProxyMessage(this.FSC_BUDGET_TIME_TASK_TOPIC, "*", JSON.toJSONString((Object)fscBudgetTimeTaskAbilityReqBO)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        log.error("-------------------\u9884\u7b97\u6a21\u677f\u5bfc\u5165\u53d1mq\u5931\u8d25\uff01\uff01\uff01");
                    }
                }
            }
        }
        return rspBO;
    }

    private FscBudgetTemplateImportAbilityRspBO judge(FscBudgetTemplateImportAbilityReqBO reqBO) {
        FscBudgetTemplateImportAbilityRspBO rspBO = new FscBudgetTemplateImportAbilityRspBO();
        if (reqBO.getUserId() == null) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u5165\u53c2userId\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getName())) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u5165\u53c2name\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getBudgetTemplateImport())) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("excel\u7684\u6570\u636e\u884c\u4e3a\u7a7a");
            return rspBO;
        }
        for (FscBudgetTemplateImportBO each : reqBO.getBudgetTemplateImport()) {
            if (StringUtils.isEmpty((Object)each.getGluttonLineNum())) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u5bfc\u5165\u884c\u53f7\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)each.getBudgetYear())) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u7b2c" + each.getGluttonLineNum() + "\u884c\u201d\u9884\u7b97\u5e74\u5ea6\u201c\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)each.getSpaceId())) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u7b2c" + each.getGluttonLineNum() + "\u884c\u201d\u9884\u7b97\u90e8\u95e8\u671f\u95f4id\u201c\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)each.getBudgetDepartmentId())) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u7b2c" + each.getGluttonLineNum() + "\u884c\u201d\u9884\u7b97\u90e8\u95e8id\u201c\u4e3a\u7a7a");
                return rspBO;
            }
            if (!StringUtils.isEmpty((Object)each.getOriginSpaceBudget())) continue;
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u7b2c" + each.getGluttonLineNum() + "\u884c\u201d\u90e8\u95e8\u671f\u95f4\u9884\u7b97\u989d\u5ea6\u201c\u4e3a\u7a7a");
            return rspBO;
        }
        Set budgetYear = reqBO.getBudgetTemplateImport().stream().map(FscBudgetTemplateImportBO::getBudgetYear).collect(Collectors.toSet());
        for (String each : budgetYear) {
            try {
                long l = Long.parseLong(each);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("excel\u7684\u6570\u636e\u884c\u201d\u9884\u7b97\u5e74\u5ea6\u201c\u4e0d\u6b63\u786e");
                return rspBO;
            }
        }
        if (budgetYear.size() > 1) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("excel\u7684\u6570\u636e\u884c\u201d\u9884\u7b97\u5e74\u5ea6\u201c\u4e0d\u4e00\u81f4");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

