/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcQryBudgetPeriodAbilityService;
import com.tydic.cfc.ability.bo.BudgetPeriodDetailBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetPeriodAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetPeriodAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetDetailAndItemAddAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetDetailAndItemAddAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetDetailBO;
import com.tydic.fsc.budget.atom.api.FscBudgetOperationAddAtomService;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomRspBO;
import com.tydic.fsc.budget.busi.api.FscBudgetDetailAndItemAddBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.dao.FscBudgetMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.po.FscBudgetItemPO;
import com.tydic.fsc.po.FscBudgetPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBudgetDetailAndItemAddBusiServiceImpl
implements FscBudgetDetailAndItemAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetDetailAndItemAddBusiServiceImpl.class);
    @Autowired
    private FscBudgetMapper fscBudgetMapper;
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscBudgetOperationAddAtomService fscBudgetOperationAddAtomService;
    @Autowired
    private CfcQryBudgetPeriodAbilityService cfcQryBudgetPeriodAbilityService;
    private final Sequence sequence = Sequence.getInstance();

    @Override
    public FscBudgetDetailAndItemAddAbilityRspBO budgetDetailAndItemAdd(FscBudgetDetailAndItemAddAbilityReqBO reqBO) {
        FscBudgetDetailAndItemAddAbilityRspBO rspBO = new FscBudgetDetailAndItemAddAbilityRspBO();
        ArrayList<FscBudgetDetailBO> detailInfoList = new ArrayList<FscBudgetDetailBO>();
        FscBudgetPO fscBudgetPO = new FscBudgetPO();
        fscBudgetPO.setBudgetId(reqBO.getBudgetId());
        FscBudgetPO budgetInfo = this.fscBudgetMapper.getModelBy(fscBudgetPO);
        if (budgetInfo == null) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u5165\u53c2\u9884\u7b97\u5355\u4e0d\u5b58\u5728");
            return rspBO;
        }
        Date time = new Date(System.currentTimeMillis());
        CfcQryBudgetPeriodAbilityReqBO cfcQryBudgetPeriodAbilityReqBO = new CfcQryBudgetPeriodAbilityReqBO();
        cfcQryBudgetPeriodAbilityReqBO.setOrgIdWeb(budgetInfo.getBudgetOrgId());
        cfcQryBudgetPeriodAbilityReqBO.setYear(Integer.valueOf(Integer.parseInt(budgetInfo.getBudgetYear())));
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u5165\u53c2cfcQryBudgetPeriodAbilityReqBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetPeriodAbilityReqBO));
        CfcQryBudgetPeriodAbilityRspBO cfcQryBudgetPeriodAbilityRspBO = this.cfcQryBudgetPeriodAbilityService.qryBudgetPeriod(cfcQryBudgetPeriodAbilityReqBO);
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u53c2cfcQryBudgetPeriodAbilityRspBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetPeriodAbilityRspBO));
        if (!"0000".equals(cfcQryBudgetPeriodAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetPeriodAbilityRspBO.getRespDesc());
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO() == null) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum() == null) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u603b\u6570\u4e3a\u7a7a");
        }
        if (!cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum().equals(budgetInfo.getSpace())) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u603b\u6570\u88ab\u4fee\u6539\uff0c\u8bf7\u5220\u9664\u5f53\u524d\u9884\u7b97\u5355\uff0c\u7136\u540e\u91cd\u65b0\u65b0\u589e");
        }
        List budgetPeriodDetailBOList = cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodDetailBOList();
        if (CollectionUtils.isEmpty((Collection)budgetPeriodDetailBOList)) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u6570\u91cf\u4e3a\u7a7a");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum().intValue() != budgetPeriodDetailBOList.size()) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e\u9519\u8bef\uff0c\u671f\u95f4\u603b\u6570\u548c\u914d\u7f6e\u7684\u671f\u95f4\u6570\u91cf\u4e0d\u7b49");
        }
        SimpleDateFormat getYearFormat = new SimpleDateFormat("yyyy");
        for (BudgetPeriodDetailBO each : budgetPeriodDetailBOList) {
            if (each.getPeriodStartDate() == null) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (each.getPeriodEndDate() == null) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (!budgetInfo.getBudgetYear().equals(getYearFormat.format(each.getPeriodStartDate()))) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u548c\u5e74\u4efd\u4e0d\u5339\u914d");
            }
            if (!budgetInfo.getBudgetYear().equals(getYearFormat.format(each.getPeriodEndDate()))) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u7ed3\u675f\u65f6\u95f4\u548c\u5e74\u4efd\u4e0d\u5339\u914d");
            }
            if (!StringUtils.isEmpty((Object)each.getPeriodName())) continue;
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u540d\u79f0\u4e3a\u7a7a");
        }
        FscBudgetPO set = new FscBudgetPO();
        set.setUpdateOperId(reqBO.getUserId());
        set.setUpdateOperName(reqBO.getName());
        set.setUpdateOperUsername(reqBO.getUserName());
        set.setUpdateTime(time);
        FscBudgetPO where = new FscBudgetPO();
        where.setBudgetId(budgetInfo.getBudgetId());
        this.fscBudgetMapper.updateBy(set, where);
        ArrayList<FscBudgetDetailPO> detailList = new ArrayList<FscBudgetDetailPO>();
        ArrayList<FscBudgetItemPO> itemList = new ArrayList<FscBudgetItemPO>();
        for (FscBudgetDetailBO each : reqBO.getBudgetDetailList()) {
            FscBudgetDetailPO fscBudgetDetailPO = new FscBudgetDetailPO();
            fscBudgetDetailPO.setBudgetDetailId(Long.valueOf(this.sequence.nextId()));
            fscBudgetDetailPO.setBudgetId(budgetInfo.getBudgetId());
            fscBudgetDetailPO.setBudgetDepartmentId(each.getBudgetDepartmentId());
            fscBudgetDetailPO.setBudgetDepartmentName(each.getBudgetDepartmentName());
            fscBudgetDetailPO.setOriginYearlyTotalBudget(Long.valueOf(0L));
            fscBudgetDetailPO.setOrgPath(each.getOrgPath());
            fscBudgetDetailPO.setOrgPathName(each.getOrgPathName());
            fscBudgetDetailPO.setStartTime(((BudgetPeriodDetailBO)budgetPeriodDetailBOList.get(0)).getPeriodStartDate());
            fscBudgetDetailPO.setEndTime(((BudgetPeriodDetailBO)budgetPeriodDetailBOList.get(budgetPeriodDetailBOList.size() - 1)).getPeriodEndDate());
            fscBudgetDetailPO.setCreateOperId(reqBO.getUserId());
            fscBudgetDetailPO.setCreateOperName(reqBO.getName());
            fscBudgetDetailPO.setCreateOperUsername(reqBO.getUserName());
            fscBudgetDetailPO.setCreateTime(time);
            detailList.add(fscBudgetDetailPO);
            int i = 1;
            boolean mqFlag = false;
            for (BudgetPeriodDetailBO space : budgetPeriodDetailBOList) {
                FscBudgetItemPO fscBudgetItemPO = new FscBudgetItemPO();
                fscBudgetItemPO.setBudgetItemId(Long.valueOf(this.sequence.nextId()));
                fscBudgetItemPO.setBudgetDetailId(fscBudgetDetailPO.getBudgetDetailId());
                fscBudgetItemPO.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.DRAFT);
                fscBudgetItemPO.setViewOrder(Integer.valueOf(i++));
                fscBudgetItemPO.setPastBudget(Long.valueOf(0L));
                fscBudgetItemPO.setFixSpaceBudget(Long.valueOf(0L));
                fscBudgetItemPO.setOriginSpaceBudget(null);
                fscBudgetItemPO.setNowSpaceBudget(null);
                fscBudgetItemPO.setCurrentBudget(null);
                fscBudgetItemPO.setUsedBudget(Long.valueOf(0L));
                fscBudgetItemPO.setCreateOperId(reqBO.getUserId());
                fscBudgetItemPO.setCreateOperName(reqBO.getName());
                fscBudgetItemPO.setCreateOperUsername(reqBO.getUserName());
                fscBudgetItemPO.setCreateTime(time);
                fscBudgetItemPO.setBudgetId(fscBudgetDetailPO.getBudgetId());
                fscBudgetItemPO.setStartTime(space.getPeriodStartDate());
                fscBudgetItemPO.setEndTime(space.getPeriodEndDate());
                fscBudgetItemPO.setSpaceName(space.getPeriodName());
                if (!FscConstants.FSC_BUDGET_MAIN_STATE.DRAFT.equals(budgetInfo.getStatus())) {
                    fscBudgetItemPO.setOriginSpaceBudget(Long.valueOf(0L));
                    fscBudgetItemPO.setNowSpaceBudget(Long.valueOf(0L));
                    fscBudgetItemPO.setCurrentBudget(Long.valueOf(0L));
                    if (time.compareTo(space.getPeriodStartDate()) < 0) {
                        fscBudgetItemPO.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.NOT_STARTED);
                    } else if (time.compareTo(space.getPeriodEndDate()) > 0) {
                        fscBudgetItemPO.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.OVER);
                    } else {
                        fscBudgetItemPO.setSpaceStatus(FscConstants.FSC_BUDGET_MAIN_STATE.STARTED);
                    }
                    mqFlag = true;
                }
                itemList.add(fscBudgetItemPO);
            }
            FscBudgetDetailBO fscBudgetDetailBO = new FscBudgetDetailBO();
            BeanUtils.copyProperties((Object)fscBudgetDetailPO, (Object)fscBudgetDetailBO);
            detailInfoList.add(fscBudgetDetailBO);
        }
        this.fscBudgetDetailMapper.insertBatch(detailList);
        this.fscBudgetItemMapper.insertBatch(itemList);
        if (!FscConstants.FSC_BUDGET_MAIN_STATE.DRAFT.equals(budgetInfo.getStatus())) {
            Map<Long, List<FscBudgetItemPO>> itemMap = itemList.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getBudgetDetailId));
            FscBudgetOperationAddAtomReqBO fscBudgetOperationAddAtomReqBO = new FscBudgetOperationAddAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)((Object)fscBudgetOperationAddAtomReqBO));
            fscBudgetOperationAddAtomReqBO.setLogType(FscConstants.FSC_BUDGET_LOG_TYPE.BUDGET_ORDER);
            ArrayList<FscBudgetOperationAddAtomBO> logList = new ArrayList<FscBudgetOperationAddAtomBO>();
            for (FscBudgetDetailPO each : detailList) {
                FscBudgetOperationAddAtomBO fscBudgetOperationAddAtomBO = new FscBudgetOperationAddAtomBO();
                fscBudgetOperationAddAtomBO.setOperationType(1);
                StringBuilder str = new StringBuilder("\u65b0\u589e\uff1a\u9884\u7b97\u90e8\u95e8\uff1a\u201c");
                str.append(each.getBudgetDepartmentName());
                str.append("\u201d\uff0c\u9884\u7b97\u5e74\u5ea6\uff1a\u201c");
                str.append(budgetInfo.getBudgetYear());
                str.append("\u5e74\u201d\uff1b");
                List<FscBudgetItemPO> items = itemMap.get(each.getBudgetDetailId());
                items.sort(Comparator.comparing(FscBudgetItemPO::getStartTime));
                for (FscBudgetItemPO item : items) {
                    str.append("\u9884\u7b97\u671f\u95f4\u201c");
                    str.append(item.getSpaceName());
                    str.append("\u201c\uff1b");
                }
                fscBudgetOperationAddAtomBO.setOperationContent(str.toString());
                fscBudgetOperationAddAtomBO.setBussiId(each.getBudgetId());
                fscBudgetOperationAddAtomBO.setBussiName(budgetInfo.getBudgetOrgName());
                fscBudgetOperationAddAtomBO.setOrgId(each.getBudgetDepartmentId());
                fscBudgetOperationAddAtomBO.setOrgName(each.getOrgPathName());
                logList.add(fscBudgetOperationAddAtomBO);
            }
            fscBudgetOperationAddAtomReqBO.setList(logList);
            FscBudgetOperationAddAtomRspBO fscBudgetOperationAddAtomRspBO = null;
            try {
                fscBudgetOperationAddAtomRspBO = this.fscBudgetOperationAddAtomService.addBudgetOperation(fscBudgetOperationAddAtomReqBO);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FscBusinessException("198888", "\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
            }
            if (!"0000".equals(fscBudgetOperationAddAtomRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25:" + fscBudgetOperationAddAtomRspBO.getRespDesc());
            }
        }
        rspBO.setDetailInfoList(detailInfoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

