/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcQryBudgetParamAbilityService;
import com.tydic.cfc.ability.api.CfcQryBudgetPeriodAbilityService;
import com.tydic.cfc.ability.bo.BudgetPeriodDetailBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetParamAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetParamAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetPeriodAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryBudgetPeriodAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetMainAddAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetMainAddAbilityRspBO;
import com.tydic.fsc.budget.busi.api.FscBudgetMainAddBusiService;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBudgetMainAddBusiServiceImpl
implements FscBudgetMainAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetMainAddBusiServiceImpl.class);
    @Autowired
    private FscBudgetMapper fscBudgetMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private CfcQryBudgetParamAbilityService cfcQryBudgetParamAbilityService;
    @Autowired
    private CfcQryBudgetPeriodAbilityService cfcQryBudgetPeriodAbilityService;
    private final Sequence sequence = Sequence.getInstance();

    @Override
    public FscBudgetMainAddAbilityRspBO budgetMainAdd(FscBudgetMainAddAbilityReqBO reqBO) {
        FscBudgetMainAddAbilityRspBO rspBO = new FscBudgetMainAddAbilityRspBO();
        Date time = new Date(System.currentTimeMillis());
        CfcQryBudgetParamAbilityReqBO cfcQryBudgetParamAbilityReqBO = new CfcQryBudgetParamAbilityReqBO();
        cfcQryBudgetParamAbilityReqBO.setOrgIdWeb(reqBO.getBudgetOrgId());
        log.info("\u67e5\u8be2\u9884\u7b97\u4f59\u989d\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u5165\u53c2cfcQryBudgetParamAbilityReqBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetParamAbilityReqBO));
        CfcQryBudgetParamAbilityRspBO cfcQryBudgetParamAbilityRspBO = this.cfcQryBudgetParamAbilityService.qryBudgetParam(cfcQryBudgetParamAbilityReqBO);
        log.info("\u67e5\u8be2\u9884\u7b97\u4f59\u989d\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u51fa\u53c2cfcQryBudgetParamAbilityRspBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetParamAbilityRspBO));
        if (!"0000".equals(cfcQryBudgetParamAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u9884\u7b97\u4f59\u989d\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetParamAbilityRspBO.getRespDesc());
        }
        if (!"1".equals(cfcQryBudgetParamAbilityRspBO.getStatus())) {
            throw new FscBusinessException("8888", "\u9884\u7b97\u4f59\u989d\u5904\u7406\u65b9\u5f0f\u914d\u7f6e\u6ca1\u6709\u542f\u7528");
        }
        CfcQryBudgetPeriodAbilityReqBO cfcQryBudgetPeriodAbilityReqBO = new CfcQryBudgetPeriodAbilityReqBO();
        cfcQryBudgetPeriodAbilityReqBO.setOrgIdWeb(reqBO.getBudgetOrgId());
        cfcQryBudgetPeriodAbilityReqBO.setYear(Integer.valueOf(Integer.parseInt(reqBO.getBudgetYear())));
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u5165\u53c2cfcQryBudgetPeriodAbilityReqBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetPeriodAbilityReqBO));
        CfcQryBudgetPeriodAbilityRspBO cfcQryBudgetPeriodAbilityRspBO = this.cfcQryBudgetPeriodAbilityService.qryBudgetPeriod(cfcQryBudgetPeriodAbilityReqBO);
        log.info("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u53c2cfcQryBudgetPeriodAbilityRspBO\uff1a" + JSON.toJSONString((Object)cfcQryBudgetPeriodAbilityRspBO));
        if (!"0000".equals(cfcQryBudgetPeriodAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetPeriodAbilityRspBO.getRespDesc());
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO() == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setErrorMessage("\u9884\u7b97\u7ec4\u7ec7\u201c" + reqBO.getBudgetOrgName() + "\u201d\uff0c\u672a\u5339\u914d\u5230\u201c" + reqBO.getBudgetYear() + "\u201d\u5e74\u5ea6\u7684\u671f\u95f4\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u4fe1\u606f\u540e\uff0c\u518d\u7ef4\u62a4\u9884\u7b97\u4fe1\u606f\u3002");
            return rspBO;
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum() == null) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u603b\u6570\u4e3a\u7a7a");
        }
        if (!"0000".equals(cfcQryBudgetPeriodAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u51fa\u9519\uff1a" + cfcQryBudgetPeriodAbilityRspBO.getRespDesc());
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO() == null) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u914d\u7f6e\u4e3a\u7a7a");
        }
        List budgetPeriodDetailBOList = cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodDetailBOList();
        if (CollectionUtils.isEmpty((Collection)budgetPeriodDetailBOList)) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u6570\u91cf\u4e3a\u7a7a");
        }
        if (cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum().intValue() != budgetPeriodDetailBOList.size()) {
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e\u9519\u8bef\uff0c\u671f\u95f4\u603b\u6570\u548c\u914d\u7f6e\u7684\u671f\u95f4\u6570\u91cf\u4e0d\u7b49");
        }
        SimpleDateFormat getYearFormat = new SimpleDateFormat("yyyy");
        for (BudgetPeriodDetailBO each : budgetPeriodDetailBOList) {
            if (each.getPeriodStartDate() == null) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (each.getPeriodEndDate() == null) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (!cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetYear().equals(Integer.parseInt(getYearFormat.format(each.getPeriodStartDate())))) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u548c\u5e74\u4efd\u4e0d\u5339\u914d");
            }
            if (!cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetYear().equals(Integer.parseInt(getYearFormat.format(each.getPeriodEndDate())))) {
                throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u7ed3\u675f\u65f6\u95f4\u548c\u5e74\u4efd\u4e0d\u5339\u914d");
            }
            if (!StringUtils.isEmpty((Object)each.getPeriodName())) continue;
            throw new FscBusinessException("8888", "\u914d\u7f6e\u4e2d\u5fc3\u9884\u7b97\u671f\u95f4\u540d\u79f0\u4e3a\u7a7a");
        }
        FscBudgetPO insertPO = new FscBudgetPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)insertPO);
        insertPO.setBudgetId(Long.valueOf(this.sequence.nextId()));
        insertPO.setStatus(FscConstants.FSC_BUDGET_MAIN_STATE.DRAFT);
        insertPO.setCurrency(Integer.valueOf(1));
        insertPO.setSpace(cfcQryBudgetPeriodAbilityRspBO.getCfcBudgetPeriodBO().getBudgetPeriodSum());
        insertPO.setPeriodDealType(Integer.valueOf(Integer.parseInt(cfcQryBudgetParamAbilityRspBO.getPeriodDealType())));
        insertPO.setYearDealType(Integer.valueOf(Integer.parseInt(cfcQryBudgetParamAbilityRspBO.getYearDealType())));
        insertPO.setExceedAvailableLimit(Integer.valueOf(Integer.parseInt(cfcQryBudgetParamAbilityRspBO.getExceedAvailableLimit())));
        insertPO.setCreateOperId(reqBO.getUserId());
        insertPO.setCreateOperName(reqBO.getName());
        insertPO.setCreateOperUsername(reqBO.getUserName());
        insertPO.setCreateTime(time);
        insertPO.setBudgetCode(this.getSerial(String.valueOf(FscConstants.FscBudgetOrderNoModel.MAIN), 1));
        this.fscBudgetMapper.insert(insertPO);
        rspBO.setBudgetId(insertPO.getBudgetId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("BUDGET_CODE");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }
}

