/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.budget.ability.api.FscQryBudgetDetailItemPageListAbilityService;
import com.tydic.fsc.budget.ability.bo.FscBudgetItemBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetMainTabsInfoBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetDetailItemPageListAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetDetailItemPageListAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscQryBudgetDetailItemPageListAbilityService"})
public class FscQryBudgetDetailItemPageListAbilityServiceImpl
implements FscQryBudgetDetailItemPageListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscQryBudgetDetailItemPageListAbilityServiceImpl.class);
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryBudgetDetailItemPageList"})
    public FscQryBudgetDetailItemPageListAbilityRspBO qryBudgetDetailItemPageList(@RequestBody FscQryBudgetDetailItemPageListAbilityReqBO reqBO) {
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setPageNo(reqBO.getPageNo().intValue());
        FscBudgetItemPO fscBudgetItemPo = (FscBudgetItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBudgetItemPO.class);
        if (!reqBO.getOrgId().equals(1L)) {
            fscBudgetItemPo.setBudgetOrgId(reqBO.getSecondId());
        }
        fscBudgetItemPo.setOrderBy("bi.create_time desc");
        log.info("\u53ef\u7528\u4f59\u989d\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscBudgetItemPo));
        List fscBudgetItemPOList = this.fscBudgetItemMapper.getBudgetItemListPage(fscBudgetItemPo, page);
        ArrayList<FscBudgetItemBO> fscBudgetItemBOList = new ArrayList<FscBudgetItemBO>();
        if (!ObjectUtil.isEmpty((Object)fscBudgetItemPOList)) {
            Map mainStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUDGET_MAIN_STATE");
            Map spaceStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUDGET_SPACE_STATE");
            for (FscBudgetItemPO item : fscBudgetItemPOList) {
                FscBudgetItemBO fscBudgetItemBO = new FscBudgetItemBO();
                BeanUtils.copyProperties((Object)item, (Object)fscBudgetItemBO);
                fscBudgetItemBO.setStatusStr((String)mainStateMap.get(item.getStatus().toString()));
                fscBudgetItemBO.setSpaceStatusStr((String)spaceStateMap.get(item.getSpaceStatus().toString()));
                try {
                    FscBudgetItemPO fscBudgetItemPO;
                    if (item.getCurrentBudget() != null) {
                        fscBudgetItemBO.setCurrentBudget(MoneyUtils.Long2BigDecimal((Long)item.getCurrentBudget()));
                    }
                    if (item.getUsedBudget() != null) {
                        fscBudgetItemBO.setUsedBudget(MoneyUtils.Long2BigDecimal((Long)item.getUsedBudget()));
                    }
                    if (item.getFixSpaceBudget() != null) {
                        fscBudgetItemBO.setFixSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getFixSpaceBudget()));
                    }
                    if (item.getOriginSpaceBudget() != null) {
                        fscBudgetItemBO.setOriginSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getOriginSpaceBudget()));
                    }
                    if (item.getPastBudget() != null) {
                        fscBudgetItemBO.setPastBudget(MoneyUtils.Long2BigDecimal((Long)item.getPastBudget()));
                    }
                    if (item.getNowSpaceBudget() != null) {
                        fscBudgetItemBO.setNowSpaceBudget(MoneyUtils.Long2BigDecimal((Long)item.getNowSpaceBudget()));
                    }
                    if (ObjectUtil.isEmpty((Object)(fscBudgetItemPO = this.fscBudgetItemMapper.getNowSpaceTotalBudget(item)))) {
                        fscBudgetItemBO.setTotalSpaceBudget(BigDecimal.ZERO);
                    } else {
                        BigDecimal total = new BigDecimal(fscBudgetItemPO.getTotalSpaceBudget());
                        fscBudgetItemBO.setTotalSpaceBudget(total.divide(new BigDecimal("10000"), 2, 1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new FscBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                fscBudgetItemBOList.add(fscBudgetItemBO);
            }
        }
        FscQryBudgetDetailItemPageListAbilityRspBO rspBO = new FscQryBudgetDetailItemPageListAbilityRspBO();
        rspBO.setRows(fscBudgetItemBOList);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrgId())) {
            this.statisticTab(rspBO, reqBO);
        }
        return rspBO;
    }

    private void statisticTab(FscQryBudgetDetailItemPageListAbilityRspBO rspBO, FscQryBudgetDetailItemPageListAbilityReqBO reqBO) {
        Page page = new Page();
        page.setPageSize(-1);
        page.setPageNo(1);
        FscBudgetItemPO fscBudgetItemPo = new FscBudgetItemPO();
        if (!reqBO.getOrgId().equals(1L)) {
            fscBudgetItemPo.setBudgetOrgId(reqBO.getSecondId());
            if (!ObjectUtil.isEmpty((Object)reqBO.getPurOrgIdList())) {
                fscBudgetItemPo.setPurOrgIdList(reqBO.getPurOrgIdList());
            }
            if (!ObjectUtil.isEmpty((Object)reqBO.getPurOrgPathList())) {
                fscBudgetItemPo.setPurOrgPathList(reqBO.getPurOrgPathList());
            }
        }
        fscBudgetItemPo.setSpaceStatusList(Arrays.asList(1, 2, 3));
        fscBudgetItemPo.setOrderBy("bi.create_time desc");
        log.info("\u67e5\u8be2tab\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscBudgetItemPo));
        List fscBudgetItemPOList = this.fscBudgetItemMapper.getBudgetItemListCount(fscBudgetItemPo, page);
        ArrayList<FscBudgetMainTabsInfoBO> fscBudgetMainTabsInfoBOS = new ArrayList<FscBudgetMainTabsInfoBO>();
        FscBudgetMainTabsInfoBO all = new FscBudgetMainTabsInfoBO();
        all.setTabName("\u5168\u90e8");
        all.setCount(Integer.valueOf(0));
        all.setSort(Integer.valueOf(0));
        FscBudgetMainTabsInfoBO starIng = new FscBudgetMainTabsInfoBO();
        starIng.setTabName("\u8fdb\u884c\u4e2d");
        starIng.setCount(Integer.valueOf(0));
        starIng.setSort(Integer.valueOf(1));
        starIng.setCode(FscConstants.FSC_BUDGET_SPACE_STATUS.STAR_ING);
        FscBudgetMainTabsInfoBO notStarted = new FscBudgetMainTabsInfoBO();
        notStarted.setTabName("\u672a\u5f00\u59cb");
        notStarted.setCount(Integer.valueOf(0));
        notStarted.setSort(Integer.valueOf(2));
        notStarted.setCode(FscConstants.FSC_BUDGET_SPACE_STATUS.START_NOT);
        FscBudgetMainTabsInfoBO finish = new FscBudgetMainTabsInfoBO();
        finish.setTabName("\u5df2\u7ed3\u675f");
        finish.setCount(Integer.valueOf(0));
        finish.setSort(Integer.valueOf(3));
        finish.setCode(FscConstants.FSC_BUDGET_SPACE_STATUS.FINISH);
        if (!ObjectUtil.isEmpty((Object)fscBudgetItemPOList)) {
            all.setCount(Integer.valueOf(fscBudgetItemPOList.size()));
            Map<Integer, List<FscBudgetItemPO>> fscBudgetPOListMap = fscBudgetItemPOList.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getSpaceStatus));
            for (Map.Entry<Integer, List<FscBudgetItemPO>> entry : fscBudgetPOListMap.entrySet()) {
                List<FscBudgetItemPO> tempList = entry.getValue();
                log.info("tempList === size:{}", (Object)tempList.size());
                String key = ((Object)entry.getKey()).toString();
                log.info("key === {}", (Object)key);
                switch (key) {
                    case "1": {
                        Integer notStartedCount = tempList.size();
                        notStarted.setCount(notStartedCount);
                    }
                    case "2": {
                        Integer starIngCount = tempList.size();
                        starIng.setCount(starIngCount);
                    }
                    case "3": {
                        Integer finishCount = tempList.size();
                        finish.setCount(finishCount);
                    }
                }
            }
        }
        fscBudgetMainTabsInfoBOS.add(all);
        fscBudgetMainTabsInfoBOS.add(starIng);
        fscBudgetMainTabsInfoBOS.add(notStarted);
        fscBudgetMainTabsInfoBOS.add(finish);
        List sortList = fscBudgetMainTabsInfoBOS.stream().sorted(Comparator.comparing(FscBudgetMainTabsInfoBO::getSort)).collect(Collectors.toList());
        rspBO.setFscBudgetMainTabsInfoBOS(sortList);
    }
}

