/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.budget.ability.api.FscQryBudgetMainInfoAbilityService;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetMainInfoAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscQryBudgetMainInfoAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.dao.FscBudgetMapper;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.po.FscBudgetPO;
import java.math.BigDecimal;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.budget.ability.api.FscQryBudgetMainInfoAbilityService"})
public class FscQryBudgetMainInfoAbilityServiceImpl
implements FscQryBudgetMainInfoAbilityService {
    @Autowired
    private FscBudgetMapper fscBudgetMapper;
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryBudgetMainInfo"})
    public FscQryBudgetMainInfoAbilityRspBO qryBudgetMainInfo(@RequestBody FscQryBudgetMainInfoAbilityReqBO reqBO) {
        FscBudgetPO fscBudgetPO = new FscBudgetPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)fscBudgetPO);
        FscBudgetPO fscBudgetInfo = this.fscBudgetMapper.getModelBy(fscBudgetPO);
        FscQryBudgetMainInfoAbilityRspBO rspBO = (FscQryBudgetMainInfoAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)fscBudgetInfo), FscQryBudgetMainInfoAbilityRspBO.class);
        if (!ObjectUtil.isEmpty((Object)rspBO)) {
            Map mainStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUDGET_MAIN_STATE");
            Map handleTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUDGET_HANDLE_TYPE");
            Map exceedingTheLimitMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_EXCEEDING_THE_LIMIT");
            rspBO.setStatusStr((String)mainStateMap.get(fscBudgetInfo.getStatus().toString()));
            rspBO.setPeriodDealTypeStr((String)handleTypeMap.get(fscBudgetInfo.getPeriodDealType().toString()));
            rspBO.setYearDealTypeStr((String)handleTypeMap.get(fscBudgetInfo.getYearDealType().toString()));
            rspBO.setExceedAvailableLimitStr((String)exceedingTheLimitMap.get(fscBudgetInfo.getExceedAvailableLimit().toString()));
            FscBudgetDetailPO fscBudgetDetailPO = new FscBudgetDetailPO();
            fscBudgetDetailPO.setBudgetId(reqBO.getBudgetId());
            FscBudgetDetailPO fscBudgetDetailPOS = this.fscBudgetDetailMapper.getListCount(fscBudgetDetailPO);
            if (ObjectUtil.isEmpty((Object)fscBudgetDetailPOS)) {
                rspBO.setOriginTotalBudget(BigDecimal.ZERO);
            } else {
                BigDecimal originTotalBudget = new BigDecimal(fscBudgetDetailPOS.getTotalBudget());
                rspBO.setOriginTotalBudget(originTotalBudget.divide(new BigDecimal("10000"), 2, 1));
            }
        }
        return rspBO;
    }
}

