/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.budget.ability.bo.FscBudgetItemBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetNumUpdateAbilityReqBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetNumUpdateAbilityRspBO;
import com.tydic.fsc.budget.ability.bo.FscBudgetNumUpdateBO;
import com.tydic.fsc.budget.atom.api.FscBudgetOperationAddAtomService;
import com.tydic.fsc.budget.atom.api.FscObtainBudgetOperationParamsAtomService;
import com.tydic.fsc.budget.atom.api.FscSendMessageAtomService;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomRspBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationParamsBO;
import com.tydic.fsc.budget.atom.bo.FscObtainBudgetOperationParamsAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscObtainBudgetOperationParamsAtomRspBO;
import com.tydic.fsc.budget.atom.bo.FscSendMessageAtomReqBO;
import com.tydic.fsc.budget.atom.bo.SendMessageBO;
import com.tydic.fsc.budget.atom.bo.SendMessageReceiverBO;
import com.tydic.fsc.budget.busi.api.FscBudgetAdjustBatchSaveBusiService;
import com.tydic.fsc.budget.busi.api.FscbudgetNumUpdateBusiService;
import com.tydic.fsc.budget.busi.bo.FscBudgetAdjustBatchSaveBusiReqBO;
import com.tydic.fsc.budget.busi.bo.FscBudgetAdjustBatchSaveBusiRspBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.dao.FscBudgetUpdateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetItemPO;
import com.tydic.fsc.po.FscBudgetUpdatePO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.CrcBatchQryPurchaseAgentListMapAbilityService;
import com.tydic.umc.general.ability.bo.CrcBatchQryPurchaseAgentListMapAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcBatchQryPurchaseAgentListMapAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemberBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBudgetAdjustBatchSaveBusiServiceImpl
implements FscBudgetAdjustBatchSaveBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetAdjustBatchSaveBusiServiceImpl.class);
    @Autowired
    private FscBudgetUpdateMapper fscBudgetUpdateMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscbudgetNumUpdateBusiService fscbudgetNumUpdateBusiService;
    @Autowired
    private FscBudgetOperationAddAtomService fscBudgetOperationAddAtomService;
    @Autowired
    private FscObtainBudgetOperationParamsAtomService fscObtainBudgetOperationParamsAtomService;
    @Autowired
    private FscSendMessageAtomService fscSendMessageAtomService;
    @Autowired
    private CrcBatchQryPurchaseAgentListMapAbilityService crcBatchQryPurchaseAgentListMapAbilityService;
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;

    @Override
    public FscBudgetAdjustBatchSaveBusiRspBO budgetAdjustBatchSave(FscBudgetAdjustBatchSaveBusiReqBO reqBO) {
        FscBudgetAdjustBatchSaveBusiRspBO rspBO = new FscBudgetAdjustBatchSaveBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<FscBudgetItemBO> fscBudgetItemBOList = reqBO.getBudgeItemList();
        if (!ObjectUtil.isEmpty(fscBudgetItemBOList)) {
            ArrayList<FscBudgetUpdatePO> fscBudgetUpdatePOList = new ArrayList<FscBudgetUpdatePO>(fscBudgetItemBOList.size());
            ArrayList<FscBudgetOperationParamsBO> fscBudgetOperationParamsBOS = new ArrayList<FscBudgetOperationParamsBO>(fscBudgetItemBOList.size());
            ArrayList<FscBudgetNumUpdateBO> fscBudgetNumUpdateBOList = new ArrayList<FscBudgetNumUpdateBO>();
            StringBuilder keySb = new StringBuilder();
            keySb.append(FscConstants.FscBudgetOrderNoModel.ADJUST);
            List<String> orderNos = this.getSerial(keySb.toString(), fscBudgetItemBOList.size());
            int index = 0;
            List budgetItemIds = fscBudgetItemBOList.stream().map(FscBudgetItemBO::getBudgetItemId).collect(Collectors.toList());
            FscBudgetItemPO selectPO = new FscBudgetItemPO();
            selectPO.setBudgetItemIds(budgetItemIds);
            List lastTimeList = this.fscBudgetItemMapper.getList(selectPO);
            Map<Long, List<FscBudgetItemPO>> lastTimeListMap = lastTimeList.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getBudgetItemId));
            Date nowDate = new Date();
            for (FscBudgetItemBO item : fscBudgetItemBOList) {
                Date endTime = lastTimeListMap.get(item.getBudgetItemId()).get(0).getEndTime();
                log.info("\u5f53\u524d\u65f6\u95f4\uff1a{}----\u8c03\u6574\u65f6\u95f4\uff1a{}", (Object)DateUtil.dateToStr((Date)nowDate, (String)"yyyy-MM-dd HH:mm:ss"), (Object)DateUtil.dateToStr((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
                if (nowDate.getTime() > endTime.getTime()) {
                    rspBO.setErrorMessage("\u5f53\u524d\u65f6\u95f4\u4e3a:" + DateUtil.dateToStr((Date)nowDate, (String)"yyyy-MM-dd HH:mm:ss") + ",\u5df2\u8d85\u8fc7\u8c03\u6574\u671f\u95f4\u7684\u622a\u81f3\u65f6\u95f4" + DateUtil.dateToStr((Date)endTime, (String)"yyyy-MM-dd HH:mm:ss") + ",\u4e0d\u5141\u8bb8\u8fdb\u884c\u8c03\u6574\u64cd\u4f5c");
                    if (fscBudgetItemBOList.size() != 1) continue;
                    return rspBO;
                }
                FscBudgetUpdatePO fscBudgetUpdatePO = new FscBudgetUpdatePO();
                FscBudgetOperationParamsBO fscBudgetOperationParamsBO = new FscBudgetOperationParamsBO();
                Long id = Sequence.getInstance().nextId();
                fscBudgetOperationParamsBO.setBudgetDetailId(item.getBudgetDetailId());
                fscBudgetOperationParamsBO.setBudgetItemId(item.getBudgetItemId());
                if (1 == reqBO.getOperType()) {
                    fscBudgetOperationParamsBO.setOperationType(FscConstants.FSC_BUDGET_LOG_OPERATION_TYPE.BUDGET_ADJUST_ADD);
                } else {
                    fscBudgetOperationParamsBO.setOperationType(FscConstants.FSC_BUDGET_LOG_OPERATION_TYPE.BUDGET_ADJUST_EDITED);
                }
                fscBudgetOperationParamsBO.setOperationAmount(reqBO.getOperNum());
                fscBudgetOperationParamsBO.setBusId(id);
                fscBudgetOperationParamsBOS.add(fscBudgetOperationParamsBO);
                BeanUtils.copyProperties((Object)item, (Object)fscBudgetUpdatePO);
                fscBudgetUpdatePO.setOperType(reqBO.getOperType());
                try {
                    fscBudgetUpdatePO.setOperNum(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getOperNum()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ZTBusinessException("\u8c03\u6574\u91d1\u989d\u8f6c\u6362\u9519\u8bef");
                }
                fscBudgetUpdatePO.setAnnexName(reqBO.getAnnexName());
                fscBudgetUpdatePO.setAnnexUrl(reqBO.getAnnexUrl());
                fscBudgetUpdatePO.setUpdateId(id);
                fscBudgetUpdatePO.setUpdateCode(orderNos.get(index));
                fscBudgetUpdatePO.setCreateOperId(reqBO.getUserId());
                fscBudgetUpdatePO.setCreateOperName(reqBO.getName());
                fscBudgetUpdatePO.setCreateOperUsername(reqBO.getUserName());
                fscBudgetUpdatePO.setCreateTime(new Date());
                fscBudgetUpdatePO.setRemark(ObjectUtil.isEmpty((Object)reqBO.getRemark()) ? "" : reqBO.getRemark());
                FscBudgetNumUpdateBO fscBudgetNumUpdateBO = new FscBudgetNumUpdateBO();
                fscBudgetNumUpdateBO.setBudgetItemId(fscBudgetUpdatePO.getBudgetItemId());
                fscBudgetNumUpdateBO.setBudgetDepartmentId(fscBudgetUpdatePO.getBudgetDepartmentId());
                fscBudgetNumUpdateBO.setOperType(fscBudgetUpdatePO.getOperType());
                fscBudgetNumUpdateBO.setOperNum(reqBO.getOperNum());
                fscBudgetNumUpdateBOList.add(fscBudgetNumUpdateBO);
                fscBudgetUpdatePO.setStatus(Integer.valueOf(0));
                fscBudgetUpdatePO.setSysTenantId(reqBO.getSysTenantId());
                fscBudgetUpdatePO.setSysTenantName(reqBO.getSysTenantName());
                fscBudgetUpdatePOList.add(fscBudgetUpdatePO);
                ++index;
            }
            FscObtainBudgetOperationParamsAtomReqBO fscObtainBudgetOperationParamsAtomReqBO = new FscObtainBudgetOperationParamsAtomReqBO();
            fscObtainBudgetOperationParamsAtomReqBO.setFscBudgetOperationParamsBOS(fscBudgetOperationParamsBOS);
            FscObtainBudgetOperationParamsAtomRspBO fscObtainBudgetOperationParamsAtomRspBO = null;
            try {
                fscObtainBudgetOperationParamsAtomRspBO = this.fscObtainBudgetOperationParamsAtomService.obtainBudgetOperationParams(fscObtainBudgetOperationParamsAtomReqBO);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
            }
            if (!"0000".equals(fscObtainBudgetOperationParamsAtomRspBO.getRespCode())) {
                throw new ZTBusinessException("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
            }
            if (ObjectUtil.isEmpty(fscObtainBudgetOperationParamsAtomRspBO.getFscBudgetOperationAddAtomBOS())) {
                throw new ZTBusinessException("\u83b7\u53d6\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
            }
            FscBudgetNumUpdateAbilityReqBO fscBudgetNumUpdateAbilityReqBO = (FscBudgetNumUpdateAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscBudgetNumUpdateAbilityReqBO.class);
            fscBudgetNumUpdateAbilityReqBO.setType(FscConstants.FSC_BUDGET_ADJUST_TYPE.EDITED_ALL);
            fscBudgetNumUpdateAbilityReqBO.setRows(fscBudgetNumUpdateBOList);
            FscBudgetNumUpdateAbilityRspBO fscBudgetNumUpdateAbilityRspBO = this.fscbudgetNumUpdateBusiService.budgetNumUpdate(fscBudgetNumUpdateAbilityReqBO);
            if (!"0000".equals(fscBudgetNumUpdateAbilityRspBO.getRespCode())) {
                log.info("\u66f4\u65b0\u9884\u7b97\u5355\u91d1\u989d\u9519\u8bef:{}", (Object)fscBudgetNumUpdateAbilityRspBO.getRespDesc());
                throw new ZTBusinessException(fscBudgetNumUpdateAbilityRspBO.getRespDesc());
            }
            if (!StringUtils.isEmpty((CharSequence)fscBudgetNumUpdateAbilityRspBO.getErrorMessage())) {
                log.info("\u66f4\u65b0\u9884\u7b97\u5355\u91d1\u989d\u51fa\u9519\uff0c\u5f39\u7a97\u63d0\u793a:{}", (Object)fscBudgetNumUpdateAbilityRspBO.getErrorMessage());
                rspBO.setErrorMessage(fscBudgetNumUpdateAbilityRspBO.getErrorMessage());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            FscBudgetOperationAddAtomReqBO fscBudgetOperationAddAtomReqBO = (FscBudgetOperationAddAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscBudgetOperationAddAtomReqBO.class));
            fscBudgetOperationAddAtomReqBO.setLogType(FscConstants.FSC_BUDGET_LOG_TYPE.BUDGET_ADJUST_ORDER);
            fscBudgetOperationAddAtomReqBO.setList(fscObtainBudgetOperationParamsAtomRspBO.getFscBudgetOperationAddAtomBOS());
            FscBudgetOperationAddAtomRspBO fscBudgetOperationAddAtomRspBO = null;
            try {
                fscBudgetOperationAddAtomRspBO = this.fscBudgetOperationAddAtomService.addBudgetOperation(fscBudgetOperationAddAtomReqBO);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
            }
            if (!"0000".equals(fscBudgetOperationAddAtomRspBO.getRespCode())) {
                throw new ZTBusinessException("\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
            }
            try {
                this.fscBudgetUpdateMapper.insertBatch(fscBudgetUpdatePOList);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u6279\u91cf\u4fdd\u5b58\u9884\u7b97\u8c03\u6574\u5355\u5931\u8d25");
                throw new ZTBusinessException("\u6279\u91cf\u4fdd\u5b58\u9884\u7b97\u8c03\u6574\u5355\u5931\u8d25");
            }
            this.sendMessage(reqBO);
        }
        return rspBO;
    }

    private List<String> getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("BUDGET_ADJUST_CODE");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }

    private void sendMessage(FscBudgetAdjustBatchSaveBusiReqBO reqBO) {
        List orgIds = reqBO.getBudgeItemList().stream().map(FscBudgetItemBO::getBudgetDepartmentId).collect(Collectors.toList());
        CrcBatchQryPurchaseAgentListMapAbilityReqBO crcBatchQryPurchaseAgentListMapAbilityReqBO = new CrcBatchQryPurchaseAgentListMapAbilityReqBO();
        crcBatchQryPurchaseAgentListMapAbilityReqBO.setOrgIdList(orgIds);
        log.info("\u67e5\u8be2\u53d1\u9001\u7ad9\u5185\u4fe1\u4e0b\u5355\u4eba\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)crcBatchQryPurchaseAgentListMapAbilityReqBO));
        CrcBatchQryPurchaseAgentListMapAbilityRspBO crcBatchQryPurchaseAgentListMapAbilityRspBO = this.crcBatchQryPurchaseAgentListMapAbilityService.qryPurchaseAgentListMap(crcBatchQryPurchaseAgentListMapAbilityReqBO);
        log.info("\u67e5\u8be2\u53d1\u9001\u7ad9\u5185\u4fe1\u4e0b\u5355\u4eba\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)crcBatchQryPurchaseAgentListMapAbilityRspBO));
        if (!"0000".equals(crcBatchQryPurchaseAgentListMapAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u7ad9\u5185\u4fe1\u4e0b\u5355\u4eba\u67e5\u8be2\u9519\u8bef");
        }
        if (!ObjectUtil.isEmpty((Object)crcBatchQryPurchaseAgentListMapAbilityRspBO.getMemberListMap())) {
            Map memberInfo = crcBatchQryPurchaseAgentListMapAbilityRspBO.getMemberListMap();
            FscSendMessageAtomReqBO fscSendMessageAtomReqBO = new FscSendMessageAtomReqBO();
            List budgetItemIds = reqBO.getBudgeItemList().stream().map(FscBudgetItemBO::getBudgetItemId).collect(Collectors.toList());
            FscBudgetItemPO selectBo = new FscBudgetItemPO();
            selectBo.setBudgetItemIds(budgetItemIds);
            List fscBudgetItemPOList = this.fscBudgetItemMapper.getBudgetInfoList(selectBo);
            Map<Long, List<FscBudgetItemPO>> fscBudgetItemPOListMap = fscBudgetItemPOList.stream().collect(Collectors.groupingBy(FscBudgetItemPO::getBudgetItemId));
            ArrayList<SendMessageBO> sendMessageBOList = new ArrayList<SendMessageBO>();
            for (FscBudgetItemBO item : reqBO.getBudgeItemList()) {
                SendMessageBO sendMessageBO = new SendMessageBO();
                sendMessageBO.setOperTypeStr(FscConstants.FSC_BUDGET_ADJUST_OPER_TYPE.ADD.equals(reqBO.getOperType()) ? "\u589e\u52a0" : "\u51cf\u5c11");
                sendMessageBO.setOperNum(reqBO.getOperNum());
                sendMessageBO.setBudgetYear(fscBudgetItemPOListMap.get(item.getBudgetItemId()).get(0).getBudgetYear());
                sendMessageBO.setSpaceName(fscBudgetItemPOListMap.get(item.getBudgetItemId()).get(0).getSpaceName());
                sendMessageBO.setTaskCode("fsc_budget_adjust_notice");
                try {
                    sendMessageBO.setCurrentBudget(MoneyUtils.Long2BigDecimal((Long)fscBudgetItemPOListMap.get(item.getBudgetItemId()).get(0).getCurrentBudget()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sendMessageBO.setSendId(reqBO.getUserId().toString());
                sendMessageBO.setSendName(reqBO.getUserName());
                ArrayList<SendMessageReceiverBO> sendMessageReceiverBOList = new ArrayList<SendMessageReceiverBO>();
                if (!ObjectUtil.isEmpty(memberInfo.get(item.getBudgetDepartmentId()))) {
                    List memberInfoList = (List)memberInfo.get(item.getBudgetDepartmentId());
                    for (UmcMemberBO member : memberInfoList) {
                        SendMessageReceiverBO sendMessageReceiverBO = new SendMessageReceiverBO();
                        sendMessageReceiverBO.setReceiverId(member.getMemId().toString());
                        sendMessageReceiverBO.setReceiverName(member.getMemName2());
                        sendMessageReceiverBOList.add(sendMessageReceiverBO);
                    }
                }
                sendMessageBO.setReceiverBOList(sendMessageReceiverBOList);
                sendMessageBOList.add(sendMessageBO);
            }
            fscSendMessageAtomReqBO.setSendMessageBOList(sendMessageBOList);
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscSendMessageAtomReqBO)));
            this.fscSendMessageAtomService.sendMessageAtomService(fscSendMessageAtomReqBO);
        }
    }
}

