/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.budget.busi.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.fsc.budget.atom.api.FscBudgetOperationAddAtomService;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomReqBO;
import com.tydic.fsc.budget.atom.bo.FscBudgetOperationAddAtomRspBO;
import com.tydic.fsc.budget.busi.api.FscBudgetTemplateImportBusiService;
import com.tydic.fsc.budget.busi.bo.FscBudgetTemplateImportBusiReqBO;
import com.tydic.fsc.budget.busi.bo.FscBudgetTemplateImportBusiRspBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBudgetDetailMapper;
import com.tydic.fsc.dao.FscBudgetItemMapper;
import com.tydic.fsc.dao.FscBudgetMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBudgetDetailPO;
import com.tydic.fsc.po.FscBudgetItemPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBudgetTemplateImportBusiServiceImpl
implements FscBudgetTemplateImportBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBudgetTemplateImportBusiServiceImpl.class);
    @Autowired
    private FscBudgetMapper fscBudgetMapper;
    @Autowired
    private FscBudgetDetailMapper fscBudgetDetailMapper;
    @Autowired
    private FscBudgetItemMapper fscBudgetItemMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscBudgetOperationAddAtomService fscBudgetOperationAddAtomService;

    @Override
    public FscBudgetTemplateImportBusiRspBO budgetTemplateImport(FscBudgetTemplateImportBusiReqBO reqBO) {
        FscBudgetTemplateImportBusiRspBO rspBO = new FscBudgetTemplateImportBusiRspBO();
        reqBO.getBudgetInfo().setBudgetCode(this.getSerial(String.valueOf(FscConstants.FscBudgetOrderNoModel.MAIN), 1));
        reqBO.getBudgetInfo().setSysTenantId(reqBO.getSysTenantId());
        reqBO.getBudgetInfo().setSysTenantName(reqBO.getSysTenantName());
        this.fscBudgetMapper.insert(reqBO.getBudgetInfo());
        reqBO.getBudgetDetailInfoList().forEach(each -> {
            each.setSysTenantId(reqBO.getSysTenantId());
            each.setSysTenantName(reqBO.getSysTenantName());
        });
        this.fscBudgetDetailMapper.insertBatch(reqBO.getBudgetDetailInfoList());
        reqBO.getBudgetItemInfoLIst().forEach(each -> {
            each.setSysTenantId(reqBO.getSysTenantId());
            each.setSysTenantName(reqBO.getSysTenantName());
        });
        this.fscBudgetItemMapper.insertBatch(reqBO.getBudgetItemInfoLIst());
        Map<Long, List<FscBudgetItemPO>> itemMap = reqBO.getBudgetItemInfoLIst().stream().collect(Collectors.groupingBy(FscBudgetItemPO::getBudgetDetailId));
        FscBudgetOperationAddAtomReqBO fscBudgetOperationAddAtomReqBO = new FscBudgetOperationAddAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)fscBudgetOperationAddAtomReqBO));
        fscBudgetOperationAddAtomReqBO.setLogType(FscConstants.FSC_BUDGET_LOG_TYPE.BUDGET_ORDER);
        ArrayList<FscBudgetOperationAddAtomBO> logList = new ArrayList<FscBudgetOperationAddAtomBO>();
        for (FscBudgetDetailPO each2 : reqBO.getBudgetDetailInfoList()) {
            FscBudgetOperationAddAtomBO fscBudgetOperationAddAtomBO = new FscBudgetOperationAddAtomBO();
            fscBudgetOperationAddAtomBO.setOperationType(1);
            StringBuilder str = new StringBuilder("\u5bfc\u5165\u65b0\u589e\uff1a\u9884\u7b97\u90e8\u95e8\uff1a\u201c");
            str.append(each2.getBudgetDepartmentName());
            str.append("\u201d\uff0c\u9884\u7b97\u5e74\u5ea6\uff1a\u201c");
            str.append(reqBO.getBudgetInfo().getBudgetYear());
            str.append("\u5e74\u201d\uff1b");
            List<FscBudgetItemPO> items = itemMap.get(each2.getBudgetDetailId());
            items.sort(Comparator.comparing(FscBudgetItemPO::getStartTime));
            for (FscBudgetItemPO item : items) {
                str.append("\u9884\u7b97\u671f\u95f4\u201c");
                str.append(item.getSpaceName());
                str.append("\u201d\uff0c\u90e8\u95e8\u671f\u95f4\u9884\u7b97\u989d\u5ea6\u201c");
                try {
                    str.append(MoneyUtils.Long2BigDecimal((Long)item.getNowSpaceBudget()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new FscBusinessException("198888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
                str.append("\u5143\u201d\uff1b");
            }
            fscBudgetOperationAddAtomBO.setOperationContent(str.toString());
            fscBudgetOperationAddAtomBO.setBussiId(each2.getBudgetId());
            fscBudgetOperationAddAtomBO.setBussiName(reqBO.getBudgetInfo().getBudgetOrgName());
            fscBudgetOperationAddAtomBO.setOrgId(each2.getBudgetDepartmentId());
            fscBudgetOperationAddAtomBO.setOrgName(each2.getOrgPathName());
            logList.add(fscBudgetOperationAddAtomBO);
        }
        fscBudgetOperationAddAtomReqBO.setList(logList);
        FscBudgetOperationAddAtomRspBO fscBudgetOperationAddAtomRspBO = null;
        try {
            fscBudgetOperationAddAtomRspBO = this.fscBudgetOperationAddAtomService.addBudgetOperation(fscBudgetOperationAddAtomReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("198888", "\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25");
        }
        if (!"0000".equals(fscBudgetOperationAddAtomRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u53c2\u6570\u5931\u8d25:" + fscBudgetOperationAddAtomRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("BUDGET_CODE");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }
}

