/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscAccountCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscAccountNoCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAccountAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAccountAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscAccountNoCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAccountNoCreateAtomRspBO;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.po.FscAccountPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscAccountCreateAtomService")
public class FscAccountCreateAtomServiceImpl
implements FscAccountCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountCreateAtomServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountNoCreateAtomService fscAccountNoCreateAtomService;

    @Override
    public FscAccountAtomRspBO createAccount(FscAccountAtomReqBO reqBo) {
        FscAccountAtomRspBO retBo = new FscAccountAtomRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            retBo.setRespCode("194302");
            retBo.setRespDesc("\u521b\u5efa\u8d26\u6237\u539f\u5b50\u670d\u52a1\u9519\u8bef\uff1a" + validateStr);
            return retBo;
        }
        FscAccountPO accountPo = new FscAccountPO();
        accountPo.setOrgId(reqBo.getOrgId());
        FscAccountPO validateRetPo = this.fscAccountMapper.getModelBy(accountPo);
        if (validateRetPo != null) {
            validateRetPo.setAccountName(reqBo.getAccountName());
            validateRetPo.setOrgName(reqBo.getAccountName());
            validateRetPo.setAccountCategory(reqBo.getAccountCategory());
            this.fscAccountMapper.updateById(validateRetPo);
            retBo.setAccountId(validateRetPo.getId().toString());
            retBo.setAccountNo(Long.valueOf(validateRetPo.getAccountNo()));
            return retBo;
        }
        FscAccountNoCreateAtomReqBO atomReqBO = new FscAccountNoCreateAtomReqBO();
        atomReqBO.setAccountCategory(reqBo.getAccountCategory());
        FscAccountNoCreateAtomRspBO atomRetBO = this.fscAccountNoCreateAtomService.createAccountNo(atomReqBO);
        Long accountId = Sequence.getInstance().nextId();
        BeanUtils.copyProperties((Object)reqBo, (Object)accountPo);
        accountPo.setId(accountId);
        accountPo.setAccountNo(atomRetBO.getAccountNo());
        int result = this.fscAccountMapper.insert(accountPo);
        if (result < 1) {
            retBo.setRespCode("194302");
            retBo.setRespDesc("\u521b\u5efa\u8d26\u6237\u539f\u5b50\u670d\u52a1\u9519\u8bef\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        retBo.setAccountId(accountId.toString());
        retBo.setAccountNo(Long.valueOf(atomRetBO.getAccountNo()));
        return retBo;
    }

    private String validateArgs(FscAccountAtomReqBO reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrgId())) {
            return "\u673a\u6784ID[orgId}\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getAccountName())) {
            return "\u8d26\u6237\u540d\u79f0[accountName}\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCreateMethod())) {
            return "\u5f00\u901a\u65b9\u5f0f[createMethod}\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

