/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscLogOrdBusiPO;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.ability.OsworkflowTaskCompleteAbilityService;
import com.tydic.osworkflow.ability.bo.CompleteWithInstanceReqBO;
import com.tydic.osworkflow.ability.bo.CompleteWithInstanceRespBO;
import com.tydic.osworkflow.ability.bo.TaskInfo;
import com.tydic.osworkflow.engine.runtime.TaskCompleteBuilder;
import com.tydic.osworkflow.engine.runtime.TaskService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderStatusFlowAtomServiceImpl
implements FscOrderStatusFlowAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderStatusFlowAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskCompleteBuilder taskCompleteBuilder;
    @Value(value="${workflow.inst.type:WithInstance}")
    private String workflowInstEnable;
    @Autowired
    private OsworkflowTaskCompleteAbilityService osworkflowTaskCompleteAbilityService;

    @Override
    public FscOrderStatusFlowAtomRspBO dealStatusFlow(FscOrderStatusFlowAtomReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        List<FscOrderPO> fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isEmpty(fscOrderPOS)) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b\u5931\u8d25");
        }
        fscOrderPO = fscOrderPOS.get(0);
        if (null == fscOrderPO) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b");
        }
        CompleteWithInstanceReqBO completeWithInstanceReqBO = new CompleteWithInstanceReqBO();
        completeWithInstanceReqBO.setTaskId(fscOrderPO.getTaskId());
        completeWithInstanceReqBO.setVariables(reqBO.getParamMap());
        log.info("\u65b0\u6d41\u7a0b\u6d41\u8f6c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)completeWithInstanceReqBO));
        CompleteWithInstanceRespBO completeWithInstanceRespBO = this.osworkflowTaskCompleteAbilityService.completeWithInstance(completeWithInstanceReqBO);
        log.info("\u65b0\u6d41\u7a0b\u6d41\u8f6c\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)completeWithInstanceRespBO));
        if (!"0000".equals(completeWithInstanceRespBO.getRespCode())) {
            throw new FscBusinessException("194309", "\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + completeWithInstanceRespBO.getRespCode() + "\u3011," + completeWithInstanceRespBO.getRespDesc());
        }
        FscOrderStatusFlowAtomRspBO rspBO = new FscOrderStatusFlowAtomRspBO();
        if (!CollectionUtils.isEmpty((Collection)completeWithInstanceRespBO.getTaskInfoWithInst().getTaskInfoList())) {
            TaskInfo taskInfo = (TaskInfo)completeWithInstanceRespBO.getTaskInfoWithInst().getTaskInfoList().get(0);
            Integer newStatus = Convert.toInt((Object)taskInfo.getStepId());
            String taskId = taskInfo.getTaskId();
            this.updateStatus(reqBO, newStatus, taskId);
            this.writeLog(reqBO, fscOrderPO, newStatus);
            rspBO.setNewStatus(newStatus);
        }
        return new FscOrderStatusFlowAtomRspBO();
    }

    private void val(FscOrderStatusFlowAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u6d41\u8f6c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u6d41\u8f6c\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private Integer string2Integer(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("194309", "\u72b6\u6001\u673a\u539f\u5b50\u670d\u52a1\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void updateStatus(FscOrderStatusFlowAtomReqBO reqBO, Integer newStatus, String taskId) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setOrderState(newStatus);
        if (null != reqBO.getUserId()) {
            fscOrderPo.setUpdateOperId(reqBO.getUserId().toString());
        }
        fscOrderPo.setUpdateOperName(reqBO.getUserName());
        fscOrderPo.setUpdateTime(new Date());
        fscOrderPo.setUpdateTimeEnd(new Date());
        fscOrderPo.setTaskId(taskId);
        this.fscOrderMapper.updateById(fscOrderPo);
    }

    private void writeLog(FscOrderStatusFlowAtomReqBO reqBO, FscOrderPO fscOrderPO, Integer newStatus) {
        FscLogOrdBusiPO fscLogOrdBusiPo = new FscLogOrdBusiPO();
        fscLogOrdBusiPo.setBusiName(reqBO.getBusiName());
        fscLogOrdBusiPo.setBusiType(fscOrderPO.getOrderFlow());
        fscLogOrdBusiPo.setCreateCompanyId(reqBO.getCompanyId());
        fscLogOrdBusiPo.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPo.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPo.setCreateOperName(reqBO.getName());
        fscLogOrdBusiPo.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPo.setCreateOrgName(reqBO.getOrgName());
        fscLogOrdBusiPo.setCreateTime(new Date());
        fscLogOrdBusiPo.setFscOrderId(reqBO.getOrderId());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPo);
        FscOrdStateChgLogPO fscOrdStateChgLogPo = new FscOrdStateChgLogPO();
        fscOrdStateChgLogPo.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrdStateChgLogPo.setOldState(fscOrderPO.getOrderState());
        fscOrdStateChgLogPo.setNewState(newStatus);
        fscOrdStateChgLogPo.setChgTime(new Date());
        if (null != reqBO.getUserId()) {
            fscOrdStateChgLogPo.setOperId(reqBO.getUserId().toString());
        }
        fscOrdStateChgLogPo.setChgDesc(reqBO.getBusiName());
        this.fscOrdStateChgLogMapper.insert(fscOrdStateChgLogPo);
    }
}

