/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderCancelAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscOrderCancelAtomServiceImpl
implements FscOrderCancelAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderCancelAtomServiceImpl.class);
    public static final String BUSI_NAME = "\u4e3b\u5355\u53d6\u6d88";
    public static final String BUSI_CODE = "1099";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;

    @Override
    public FscOrderCancelAtomRspBO dealCancelStatus(FscOrderCancelAtomReqBO reqBO) {
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(reqBO.getOrderState());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        if (reqBO.getOrderFlow().equals(FscConstants.OrderFlow.INVOICE)) {
            paramMap.put("cancelFlag", FscConstants.BillOrderCancelFlag.CANCEL_ORDER);
        } else {
            paramMap.put("auditResult", FscConstants.PayFlowAuditResult.MAIN_CANCEL);
        }
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194308", flowAtomRspBO.getRespDesc());
        }
        return new FscOrderCancelAtomRspBO();
    }
}

