/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.pay;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.sdb.util.SignUtil;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankDownLoadCheckFileService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankDownLoadCheckFileRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBToBPingAnBankDownLoadCheckFileServiceImpl
implements FscBToBPingAnBankDownLoadCheckFileService {
    private static final Logger log = LoggerFactory.getLogger(FscBToBPingAnBankDownLoadCheckFileServiceImpl.class);
    @Value(value="${PING_AN_BANK_DOWNLOAD_CHECK_FILE_URL:https://my-st1.orangebank.com.cn:567/fat7/openapi/file/boapFile/download}")
    private String PING_AN_BANK_DOWNLOAD_CHECK_FILE_URL;
    @Value(value="${MRCH_CODE:4232}")
    private String MRCH_CODE;
    @Value(value="${TXN_CLIENT_NO:680001598756}")
    private String TXN_CLIENT_NO;
    @Value(value="${FUND_SUMMARY_ACCT_NO:15000101293850}")
    private String FUND_SUMMARY_ACCT_NO;
    @Value(value="${LOCAL_FILE_PATH:/download/pingan/}")
    private String LOCAL_FILE_PATH;
    @Value(value="${PING_AN_BANK_APP_ID:18922445-0cd4-4261-8742-37b1e357c291}")
    private String PING_AN_BANK_APP_ID;
    @Value(value="${PING_AN_BANK_PRIVATE_KEY_HEX:67fc43815ddb55e5963c63e08c7cb6a83ea759e393e8f4651e97dedcd70fd0fe}")
    private String PING_AN_BANK_PRIVATE_KEY_HEX;

    @Override
    public FscBToBPingAnBankDownLoadCheckFileRspBO downLoadCheckFile(FscBToBPingAnBankDownLoadCheckFileReqBO reqBO) {
        FscBToBPingAnBankDownLoadCheckFileRspBO rspBO = new FscBToBPingAnBankDownLoadCheckFileRspBO();
        this.val(reqBO);
        String ALG = "DesEde/CBC/PKCS5Padding";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fileNo", (Object)reqBO.getFilePath());
        jsonObject.put("appId", (Object)this.PING_AN_BANK_APP_ID);
        jsonObject.put("container", (Object)"01");
        String reqStr = JSON.toJSONString((Object)jsonObject);
        log.debug("\u83b7\u53d6\u5e73\u5b89\u94f6\u884c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.PING_AN_BANK_DOWNLOAD_CHECK_FILE_URL);
        log.debug("\u83b7\u53d6\u5e73\u5b89\u94f6\u884c\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)reqStr);
        String signature = null;
        try {
            signature = this.getSign(this.PING_AN_BANK_APP_ID, this.PING_AN_BANK_PRIVATE_KEY_HEX, jsonObject.toJSONString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new FscBusinessException("193127", "\u4e0b\u8f7d\u5e73\u5b89\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\uff0c\u9a8c\u7b7e\u5931\u8d25");
        }
        HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)this.PING_AN_BANK_DOWNLOAD_CHECK_FILE_URL).header("appId", this.PING_AN_BANK_APP_ID)).header("fileNo", reqBO.getFilePath())).header("x-pab-signMethod", "SM2")).header("sign", signature)).header("container", "01")).execute();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(this.LOCAL_FILE_PATH + reqBO.getFileName()));
            ((OutputStream)out).write(response.bodyBytes());
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new FscBusinessException("193127", "\u4e0b\u8f7d\u5e73\u5b89\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\uff0c\u751f\u6210\u6587\u4ef6\u5931\u8d25");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FscBusinessException("193127", "\u4e0b\u8f7d\u5e73\u5b89\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\uff0c\u751f\u6210\u6587\u4ef6\u5931\u8d25");
        }
        try {
            byte[] bkey = Base64.decode((byte[])reqBO.getDecryptKey().getBytes());
            SignUtil.decrypt((String)(this.LOCAL_FILE_PATH + reqBO.getFileName()), (String)(this.LOCAL_FILE_PATH + reqBO.getFileName() + ".zip"), (byte[])bkey, (String)ALG, (String)"DesEde", null);
            SignUtil.uncompress((String)(this.LOCAL_FILE_PATH + reqBO.getFileName() + ".zip"), (String)(this.LOCAL_FILE_PATH + reqBO.getFileName() + ".txt"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("193127", "\u4e0b\u8f7d\u5e73\u5b89\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6\u89e3\u5bc6\u89e3\u538b\u5931\u8d25");
        }
        rspBO.setLocalFilePath(this.LOCAL_FILE_PATH + reqBO.getFileName());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String getSign(String appId, String privateKeyHex, String requestBody) throws UnsupportedEncodingException {
        String header = "{\"alg\":\"SM2\",\"typ\":\"JWT\",\"kid\":\"" + appId + "\"}";
        header = Base64.encode((CharSequence)header);
        String data = header + "." + requestBody;
        ECPrivateKeyParameters privateKeyParameters = BCUtil.toSm2Params((String)privateKeyHex);
        SM2 sm2 = new SM2(privateKeyParameters, null);
        byte[] sign = sm2.sign(data.getBytes("utf-8"), null);
        String s = HexUtil.encodeHexStr((byte[])sign);
        String signature = header + ".e30." + Base64.encode((CharSequence)s);
        log.debug("\u5f00\u653e\u94f6\u884csignature\uff1a" + signature);
        return signature;
    }

    private void val(FscBToBPingAnBankDownLoadCheckFileReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u5e73\u5b89\u94f6\u884c\u67e5\u8be2\u9274\u6743\u7ed3\u679c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
    }
}

