/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalJDReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscInvoiceSubmitExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FscInvoiceSubmitExternalServiceImpl
implements FscInvoiceSubmitExternalService {
    private static final Logger log = LoggerFactory.getLogger(FscInvoiceSubmitExternalServiceImpl.class);
    @Autowired
    private Environment environment;
    private static final String JD_SUP_ID = "JD_SUP_ID";
    @Value(value="${esb.invoiceApply.url:http://39.106.83.78:8001/OSN/api/invoiceApply/v1}")
    private String URL;
    @Value(value="${esb.getJDAddressFromAddress.url}")
    private String GET_ADDR_URL;
    private static final String ZORE = "0";

    @Override
    public FscInvoiceSubmitExternalRspBO submitInvoice(FscInvoiceSubmitExternalReqBO reqBO) {
        String reqEsbJson;
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u7535\u5546\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        this.initReqBO(reqBO);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String jdSupId = this.environment.getProperty(JD_SUP_ID);
        if (reqBO.getSupplierId().equals(jdSupId)) {
            FscInvoiceSubmitExternalJDReqBO fscInvoiceSubmitExternalJDReqBO = new FscInvoiceSubmitExternalJDReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)fscInvoiceSubmitExternalJDReqBO);
            fscInvoiceSubmitExternalJDReqBO.setSupplierOrder(String.join((CharSequence)",", reqBO.getExtOrderNos()));
            this.addressChange(fscInvoiceSubmitExternalJDReqBO, hsn);
            reqEsbJson = EsbParamUtil.getEsbReqStr(JSON.toJSONString((Object)fscInvoiceSubmitExternalJDReqBO), hsn, "BUSINESS_PAY");
        } else {
            reqEsbJson = EsbParamUtil.getEsbReqStr(JSON.toJSONString((Object)reqBO), hsn, "BUSINESS_PAY");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u5165\u53c2:{},URL:{}", (Object)reqEsbJson, (Object)this.URL);
        }
        String rspJson = SSLClient.doPost(this.URL, reqEsbJson);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u51fa\u53c2:{}", (Object)rspJson);
        }
        if (StringUtils.isBlank((CharSequence)rspJson)) {
            throw new FscBusinessException("194320", "\u8bf7\u6c42\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        FscInvoiceSubmitExternalRspBO rspBO = (FscInvoiceSubmitExternalRspBO)((Object)JSON.parseObject((String)rspJson, FscInvoiceSubmitExternalRspBO.class));
        if (StringUtils.isNotBlank((CharSequence)rspBO.getResultCode()) && !"0000".equals(rspBO.getResultCode())) {
            throw new FscBusinessException("194320", rspBO.getResultMessage());
        }
        return rspBO;
    }

    private void addressChange(FscInvoiceSubmitExternalJDReqBO fscInvoiceSubmitExternalJDReqBO, String hsn) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address", (Object)fscInvoiceSubmitExternalJDReqBO.getReceiveAddr());
        jsonObject.put("hsn", (Object)hsn);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u4eac\u4e1c\u5730\u5740\u5165\u53c2:{},URL:{}", (Object)jsonObject, (Object)this.GET_ADDR_URL);
        }
        String rspJson = SSLClient.doPost(this.GET_ADDR_URL, JSON.toJSONString((Object)jsonObject));
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u4eac\u4e1c\u5730\u5740\u51fa\u53c2:{}", (Object)rspJson);
        }
        if (StringUtils.isBlank((CharSequence)rspJson)) {
            throw new FscBusinessException("194320", "\u8bf7\u6c42\u4eac\u4e1c\u5730\u5740\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        JSONObject addr = JSON.parseObject((String)rspJson);
        try {
            JSONObject result = addr.getJSONObject("result");
            fscInvoiceSubmitExternalJDReqBO.setProvinceCode(result.getString("provinceId"));
            fscInvoiceSubmitExternalJDReqBO.setCityCode(result.getString("cityId"));
            fscInvoiceSubmitExternalJDReqBO.setAreaCode(result.getString("countyId"));
            fscInvoiceSubmitExternalJDReqBO.setTownCode(result.getString("townId"));
        }
        catch (Exception e) {
            throw new FscBusinessException("194320", "\u8bf7\u6c42\u4eac\u4e1c\u5730\u5740\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)fscInvoiceSubmitExternalJDReqBO.getProvinceCode()) || StringUtils.isEmpty((CharSequence)fscInvoiceSubmitExternalJDReqBO.getCityCode()) || StringUtils.isEmpty((CharSequence)fscInvoiceSubmitExternalJDReqBO.getAreaCode())) {
            throw new FscBusinessException("194320", "\u8bf7\u6c42\u4eac\u4e1c\u5730\u5740\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
    }

    private void initReqBO(FscInvoiceSubmitExternalReqBO reqBO) {
        String jdSupId = this.environment.getProperty(JD_SUP_ID);
        if (reqBO.getSupplierId().equals(jdSupId)) {
            reqBO.setEnterpriseBankAccount(reqBO.getAccount());
            reqBO.setEnterpriseBankName(reqBO.getBank());
            reqBO.setEnterpriseRegAddress(reqBO.getAddress());
            reqBO.setEnterpriseRegPhone(reqBO.getPhone());
            reqBO.setInvoiceOrg("10");
        }
        if (null == reqBO.getTotalBatch()) {
            reqBO.setTotalBatch(FscConstants.BASIC_INVOICE_BATCH_NUM);
        }
        if (null == reqBO.getBizInvoiceContent()) {
            reqBO.setBizInvoiceContent(FscConstants.BASIC_INVOICE_CONTENT);
        }
        if (null == reqBO.getInvoiceOrg()) {
            reqBO.setInvoiceOrg("6");
        }
        if (null == reqBO.getInvoiceNum()) {
            reqBO.setInvoiceNum(reqBO.getExtOrderNos().size());
        }
        if (null == reqBO.getTotalBatchInvoiceAmount()) {
            reqBO.setTotalBatchInvoiceAmount(reqBO.getTotalCharge());
        }
        if (null == reqBO.getBillDate()) {
            reqBO.setBillDate(DateUtils.dateToStr((Date)new Date()));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTownCode())) {
            reqBO.setTownCode(ZORE);
        }
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            reqBO.setInvoiceType(FscConstants.FscElecInvoiceType.ELEC.toString());
        } else {
            reqBO.setInvoiceType(FscConstants.FscElecInvoiceType.SPECIAL.toString());
        }
    }
}

