/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DottedLineSeparator;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscBillOrderCreatePdfBusiService;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.bo.FscBillCreateOrderPdfReqBO;
import com.tydic.fsc.busibase.busi.bo.FscBillReCreateFscOrderPdfReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscApprovalRelationMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscApprovalRelationPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uac.exception.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBillOrderCreatePdfBusiServiceImpl
implements FscBillOrderCreatePdfBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreatePdfBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscApprovalRelationMapper fscApprovalRelationMapper;

    @Override
    public FscAttachmentPO createFscOrderPdf(FscBillCreateOrderPdfReqBO reqBO) {
        FscOrderPO fscOrderPo = reqBO.getFscOrderPo();
        FscOrderInvoicePO fscOrderInvoicePo = reqBO.getFscOrderInvoicePo();
        Map<Long, FscOrderInfoBO> fscOrderInfoBoMap = reqBO.getFscOrderInfoBoMap();
        SplitOrderBO splitOrderBO = reqBO.getSplitOrderBO();
        List<FscInvoicePO> fscInvoicePOS = reqBO.getFscInvoicePOS();
        List<FscInvoiceItemPO> fscInvoiceItemPOS = reqBO.getFscInvoiceItemPOS();
        log.info("FscOrderPO\u5165\u53c2:{}", (Object)fscOrderPo);
        log.info("FscOrderInvoicePO\u5165\u53c2:{}", (Object)fscOrderInvoicePo);
        log.info("FscOrderInfoBoMap\u5165\u53c2:{}", fscOrderInfoBoMap);
        log.info("SplitOrderBO\u5165\u53c2:{}", (Object)splitOrderBO);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Font titleFont = this.getFont("titleFont");
        Font contentFont = this.getFont("contentFont");
        Document document = new Document(PageSize.A4.rotate(), 75.0f, 75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        Paragraph paragraph = new Paragraph("\u7ed3\u7b97\u5355\uff1a" + fscOrderPo.getOrderNo(), titleFont);
        paragraph.setAlignment(1);
        paragraph.setLeading(30.0f);
        try {
            document.add((Element)paragraph);
        }
        catch (DocumentException e) {
            log.info("\u7ed3\u7b97\u5355\u6dfb\u52a0\u9519\u8bef");
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u6dfb\u52a0\u9519\u8bef");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PdfPTable lineOne = new PdfPTable(3);
        lineOne.addCell(this.createCell("\u4f9b\u5e94\u5546\u540d\u79f0\uff1a" + fscOrderPo.getSupplierName(), contentFont, 0, false));
        lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u53d1\u8d77\u4eba\uff1a" + fscOrderPo.getCreateOperName(), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u53d1\u8d77\u65f6\u95f4\uff1a" + sdf.format(fscOrderPo.getCreateTime()), contentFont, 2, false));
        lineOne.addCell(this.createCell("\u8ba2\u5355\u6570\u91cf\uff1a" + fscOrderPo.getOrderNum(), contentFont, 0, false));
        lineOne.addCell(this.createCell("\u7ed3\u7b97\u603b\u91d1\u989d\uff1a" + fscOrderPo.getTotalCharge().setScale(2), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u5e01\u522b\uff1a\u4eba\u6c11\u5e01", contentFont, 2, false));
        lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u7c7b\u578b\uff1a" + fscOrderPo.getFscBusiTypeName(), contentFont, 0, false));
        Map<String, String> orderStateMap = 0 == fscOrderPo.getOrderFlow() ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE") : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE");
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderApprovalId())) {
            lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u72b6\u6001\uff1a" + orderStateMap.get(fscOrderPo.getOrderState() + ""), contentFont, 1, false));
            lineOne.addCell(this.createCell("", contentFont, 2, false));
        } else {
            orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_APPROVAL_STATE");
            lineOne.addCell(this.createCell("\u7ed3\u7b97\u5ba1\u6279\u5355\u53f7\uff1a" + reqBO.getFscOrderApprovalNo(), contentFont, 1, false));
            lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u72b6\u6001\uff1a" + orderStateMap.get(reqBO.getFscOrderState() + ""), contentFont, 2, false));
        }
        try {
            document.add((Element)lineOne);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph invoiceTitle = new Paragraph("\u5f00\u7968\u4fe1\u606f", titleFont);
        invoiceTitle.setAlignment(0);
        invoiceTitle.setLeading(30.0f);
        try {
            document.add((Element)invoiceTitle);
        }
        catch (DocumentException e) {
            log.info("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        Paragraph p2 = new Paragraph();
        p2.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
        try {
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
        }
        Map<String, String> invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
        Map<String, String> invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
        String invoiceStr = invoiceTypeMap.get(fscOrderInvoicePo.getInvoiceType()) + "(" + invoiceCategoryMap.get(String.valueOf(fscOrderInvoicePo.getInvoiceCategory())) + ")";
        log.info("\u53d1\u7968\u7c7b\u578b\u8f6c\u4e49\u53c2\u6570:{}", invoiceTypeMap);
        log.info("\u53d1\u7968\u7c7b\u522b\u8f6c\u4e49\u53c2\u6570:{}", invoiceCategoryMap);
        log.info("\u516c\u53f8\u540d\u79f0:{}", (Object)fscOrderInvoicePo.getBuyName());
        PdfPTable table = new PdfPTable(1);
        table.addCell(this.createCell("\u53d1\u7968\u7c7b\u578b\uff1a" + invoiceStr, contentFont, 0, false));
        table.addCell(this.createCell("\u516c\u53f8\u540d\u79f0\uff1a" + fscOrderInvoicePo.getBuyName(), contentFont, 0, false));
        table.addCell(this.createCell("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a" + fscOrderInvoicePo.getTaxNo(), contentFont, 0, false));
        table.addCell(this.createCell("\u5730\u5740\uff1a" + fscOrderInvoicePo.getAddress(), contentFont, 0, false));
        table.addCell(this.createCell("\u7535\u8bdd\uff1a" + fscOrderInvoicePo.getPhone(), contentFont, 0, false));
        table.addCell(this.createCell("\u5f00\u6237\u94f6\u884c\uff1a" + fscOrderInvoicePo.getBank(), contentFont, 0, false));
        table.addCell(this.createCell("\u5f00\u6237\u8d26\u6237\uff1a" + fscOrderInvoicePo.getAccount(), contentFont, 0, false));
        table.addCell(this.createCell("\u5907\u6ce8\uff1a" + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getMemo()) ? "" : fscOrderInvoicePo.getMemo()), contentFont, 0, false));
        try {
            document.add((Element)table);
        }
        catch (DocumentException e) {
            log.info("pdf\u53d1\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u53d1\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph invoiceReceive = new Paragraph("\u53d1\u7968\u63a5\u6536\u4fe1\u606f", titleFont);
        invoiceReceive.setAlignment(0);
        invoiceReceive.setLeading(30.0f);
        try {
            document.add((Element)invoiceReceive);
        }
        catch (DocumentException e) {
            log.info("pdf\u6536\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u6536\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        try {
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
        }
        String invoiceAddr = (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getProvince()) ? "" : fscOrderInvoicePo.getProvince()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getCity()) ? "" : fscOrderInvoicePo.getCity()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getArea()) ? "" : fscOrderInvoicePo.getArea()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getTown()) ? "" : fscOrderInvoicePo.getTown()) + fscOrderInvoicePo.getReceiveAddr();
        PdfPTable invoiceReceiveTable = new PdfPTable(4);
        invoiceReceiveTable.addCell(this.createCell("\u6536\u7968\u4eba\uff1a" + fscOrderInvoicePo.getReceiveName(), contentFont, 0, false));
        invoiceReceiveTable.addCell(this.createCell("\u6536\u7968\u5730\u5740\uff1a" + invoiceAddr, contentFont, 0, false));
        invoiceReceiveTable.addCell(this.createCell("\u8054\u7cfb\u7535\u8bdd\uff1a" + fscOrderInvoicePo.getReceivePhone(), contentFont, 0, false));
        invoiceReceiveTable.addCell(this.createCell("\u7535\u7968\u63a5\u6536\u90ae\u7bb1\uff1a" + fscOrderInvoicePo.getReceiveEmail(), contentFont, 0, false));
        try {
            document.add((Element)invoiceReceiveTable);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            log.info("pdf\u6536\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u6536\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph orderItemParagraph = new Paragraph("\u7ed3\u7b97\u5355\u660e\u7ec6", titleFont);
        orderItemParagraph.setAlignment(0);
        orderItemParagraph.setLeading(30.0f);
        try {
            document.add((Element)orderItemParagraph);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u5355\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u5355\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
        }
        try {
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable nullTable = new PdfPTable(1);
        nullTable.addCell(this.createCell("", contentFont, 0, false));
        try {
            document.add((Element)nullTable);
        }
        catch (DocumentException e) {
            log.info("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable itemTable = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
        itemTable.setTotalWidth(700.0f);
        itemTable.setLockedWidth(true);
        itemTable.setHorizontalAlignment(1);
        itemTable.getDefaultCell().setBorder(1);
        itemTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u8ba2\u5355\u7f16\u53f7", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u5916\u90e8\u7535\u5546\u5355\u53f7", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u4e0b\u5355\u65f6\u95f4", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u786e\u8ba4\u6536\u8d27\u65f6\u95f4", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u4f9b\u5e94\u5546", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u8ba2\u5355\u91d1\u989d", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u4e0b\u5355\u4eba/\u4e0b\u5355\u4eba\u8d26\u53f7", contentFont, 0, true));
        int itemCount = 1;
        if (!ObjectUtil.isEmpty((Object)splitOrderBO.getRelOrderList())) {
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.get(relOrderBO.getAcceptOrderId());
                itemTable.addCell(this.createCell(itemCount > 9 ? String.valueOf(itemCount) : "0" + itemCount, contentFont, false));
                itemTable.addCell(this.createCell(fscOrderInfoBO.getOrderNo(), contentFont, false));
                itemTable.addCell(this.createCell(fscOrderInfoBO.getSaleOrderNoExt(), contentFont, false));
                itemTable.addCell(this.createCell(sdf.format(fscOrderInfoBO.getOrderCreateTime()), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderInfoBO.getAcceptTime()) ? "" : sdf.format(fscOrderInfoBO.getAcceptTime()), contentFont, false));
                itemTable.addCell(this.createCell(fscOrderInfoBO.getSupplierName(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderInfoBO.getInspTotalSaleMoney()) ? "" : fscOrderInfoBO.getInspTotalSaleMoney().setScale(2).toString(), contentFont, false));
                itemTable.addCell(this.createCell(fscOrderInfoBO.getOrderCreateOperName() + "/" + fscOrderInfoBO.getOrderCreateLoginName(), contentFont, false));
                ++itemCount;
                if (ObjectUtil.isEmpty((Object)fscOrderInfoBO)) continue;
                List fscOrderItemBOS = fscOrderInfoBO.getFscOrderItemBOS();
                PdfPCell goodsNum = new PdfPCell(new Phrase("\u5546\u54c1\u5e8f\u53f7", contentFont));
                goodsNum.setHorizontalAlignment(2);
                goodsNum.setVerticalAlignment(5);
                itemTable.addCell(goodsNum);
                itemTable.addCell(this.createCell("\u5546\u54c1\u540d\u79f0", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u4e00\u7ea7\u76ee\u5f55", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u89c4\u683c", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u578b\u53f7", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5355\u4f4d", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u6570\u91cf", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5355\u4ef7\uff08\u5143\uff09", contentFont, 0, true));
                int goodsCount = 1;
                for (FscOrderItemBO fscOrderItemBO : fscOrderItemBOS) {
                    itemTable.addCell(this.createCell("(" + goodsCount + ")", contentFont, true));
                    itemTable.addCell(this.createCell(fscOrderItemBO.getSkuName(), contentFont, false));
                    itemTable.addCell(this.createCell(fscOrderItemBO.getL1CatalogName(), contentFont, false));
                    itemTable.addCell(this.createCell(fscOrderItemBO.getSpec(), contentFont, false));
                    itemTable.addCell(this.createCell(fscOrderItemBO.getModel(), contentFont, false));
                    itemTable.addCell(this.createCell(fscOrderItemBO.getUnit(), contentFont, false));
                    itemTable.addCell(this.createCell(String.valueOf(fscOrderItemBO.getNum()), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemBO.getSalePrice()) ? "" : fscOrderItemBO.getSalePrice().toString(), contentFont, false));
                    ++goodsCount;
                }
            }
        }
        try {
            document.add((Element)itemTable);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
        }
        Map<Object, Object> fscOrderItemBOSMap = new HashMap();
        if (!ObjectUtil.isEmpty(fscInvoiceItemPOS)) {
            fscOrderItemBOSMap = fscInvoiceItemPOS.stream().collect(Collectors.groupingBy(item -> item.getInvoiceId()));
        }
        if (!ObjectUtil.isEmpty(fscInvoicePOS)) {
            Paragraph orderInvoiceItemParagraph = new Paragraph("\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6", titleFont);
            orderInvoiceItemParagraph.setAlignment(0);
            orderInvoiceItemParagraph.setLeading(30.0f);
            try {
                document.add((Element)orderInvoiceItemParagraph);
            }
            catch (DocumentException e) {
                log.info("pdf\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
            }
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable emptyTable = new PdfPTable(1);
            emptyTable.addCell(this.createCell("", contentFont, 0, false));
            try {
                document.add((Element)emptyTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
            }
            DecimalFormat df = new DecimalFormat("#0.00");
            PdfPTable invTable = new PdfPTable(new float[]{10.0f, 20.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            invTable.setTotalWidth(700.0f);
            invTable.setLockedWidth(true);
            invTable.setHorizontalAlignment(1);
            invTable.getDefaultCell().setBorder(1);
            invTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
            invTable.addCell(this.createCell("\u6536\u7968\u65b9", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u53f7\u7801", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u4ee3\u7801", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u7c7b\u578b", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u7c7b\u522b", contentFont, 0, true));
            invTable.addCell(this.createCell("\u5f00\u7968\u65e5\u671f", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u603b\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
            invTable.addCell(this.createCell("\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
            invTable.addCell(this.createCell("\u7a0e\u989d\uff08\u5143\uff09", contentFont, 0, true));
            int invCount = 1;
            for (FscInvoicePO fscInvoicePO : fscInvoicePOS) {
                invTable.addCell(this.createCell(invCount > 9 ? String.valueOf(invCount) : "0" + invCount, contentFont, false));
                invTable.addCell(this.createCell(fscInvoicePO.getBuyName(), contentFont, false));
                invTable.addCell(this.createCell(fscInvoicePO.getInvoiceNo(), contentFont, false));
                invTable.addCell(this.createCell(fscInvoicePO.getInvoiceCode(), contentFont, false));
                invTable.addCell(this.createCell(invoiceTypeMap.get(fscInvoicePO.getInvoiceType()), contentFont, false));
                invTable.addCell(this.createCell(invoiceCategoryMap.get(String.valueOf(fscInvoicePO.getInvoiceCategory())), contentFont, false));
                invTable.addCell(this.createCell(fscInvoicePO.getBillDate(), contentFont, false));
                invTable.addCell(this.createCell(fscInvoicePO.getAmt().setScale(2).toString(), contentFont, false));
                invTable.addCell(this.createCell(fscInvoicePO.getUntaxAmt().setScale(2).toString(), contentFont, false));
                BigDecimal taxAmt = fscInvoicePO.getAmt().subtract(fscInvoicePO.getUntaxAmt());
                invTable.addCell(this.createCell(taxAmt.setScale(2).toString(), contentFont, false));
                ++invCount;
                List fscInvoicePOList = (List)fscOrderItemBOSMap.get(fscInvoicePO.getInvoiceId());
                if (ObjectUtil.isEmpty((Object)fscInvoicePOList)) continue;
                PdfPCell invItemNum = new PdfPCell(new Phrase("\u5546\u54c1\u5e8f\u53f7", contentFont));
                invItemNum.setHorizontalAlignment(2);
                invItemNum.setVerticalAlignment(5);
                invTable.addCell(invItemNum);
                invTable.addCell(this.createCell("\u5546\u54c1\u540d\u79f0", contentFont, 0, true));
                invTable.addCell(this.createCell("\u89c4\u683c", contentFont, 0, true));
                invTable.addCell(this.createCell("\u578b\u53f7", contentFont, 0, true));
                invTable.addCell(this.createCell("\u5355\u4f4d", contentFont, 0, true));
                invTable.addCell(this.createCell("\u6570\u91cf", contentFont, 0, true));
                invTable.addCell(this.createCell("\u5355\u4ef7\uff08\u5143\uff09", contentFont, 0, true));
                invTable.addCell(this.createCell("\u53d1\u7968\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
                invTable.addCell(this.createCell("\u7a0e\u7387", contentFont, 0, true));
                invTable.addCell(this.createCell("\u7a0e\u989d\uff08\u5143\uff09", contentFont, 0, true));
                int invItemCount = 1;
                for (FscInvoiceItemPO fscInvoiceItemPO : fscInvoicePOList) {
                    invTable.addCell(this.createCell("(" + invItemCount + ")", contentFont, true));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getSkuName(), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getSpec(), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getModel(), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getUnit(), contentFont, false));
                    invTable.addCell(this.createCell(String.valueOf(fscInvoiceItemPO.getNum().setScale(2)), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getPrice().setScale(2).toString(), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getUntaxAmt().setScale(2).toString(), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getTax().multiply(new BigDecimal("100")).setScale(2).toString() + "%", contentFont, false));
                    BigDecimal itemTaxAmt = fscInvoiceItemPO.getAmt().subtract(fscInvoiceItemPO.getUntaxAmt());
                    invTable.addCell(this.createCell(itemTaxAmt.setScale(2).toString(), contentFont, false));
                    ++invItemCount;
                }
            }
            try {
                document.add((Element)invTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u7ed3\u7b97\u53d1\u7968\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7ed3\u7b97\u53d1\u7968\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
            }
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
            innerFileUrl = this.accessUrl + path;
            fileUrl = this.ossFileUrl + path;
        } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        log.info("innerFileUrl:{}", (Object)innerFileUrl);
        log.info("fileUrl:{}", (Object)fileUrl);
        fscAttachmentPO.setObjId(fscOrderPo.getFscOrderId());
        fscAttachmentPO.setFscOrderId(fscOrderPo.getFscOrderId());
        fscAttachmentPO.setObjType(0);
        fscAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
        fscAttachmentPO.setAttachmentName(fileName);
        fscAttachmentPO.setAttachmentUrl(fileUrl);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER_PDF);
        log.info("\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", (Object)fscAttachmentPO);
        return fscAttachmentPO;
    }

    private Font getFont(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCell(String title, Font font, boolean isFirst) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isFirst) {
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
        }
        return cell;
    }

    @Override
    public List<FscAttachmentPO> recreateFscOrderPdf(FscBillReCreateFscOrderPdfReqBO reqBO) {
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        if (!ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            fscOrderIds.add(reqBO.getFscOrderId());
        } else {
            Object fscShouldPayPOS;
            FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
            if (!ObjectUtil.isEmpty((Object)reqBO.getShouldPayId())) {
                fscShouldPayPo.setShouldPayId(reqBO.getShouldPayId());
            }
            if (!ObjectUtil.isEmpty(reqBO.getShouldPayIds())) {
                fscShouldPayPo.setShouldPayIds(reqBO.getShouldPayIds());
            }
            if (!ObjectUtil.isEmpty((Object)(fscShouldPayPOS = this.fscShouldPayMapper.getList(fscShouldPayPo)))) {
                fscShouldPayPOS.forEach(item -> fscOrderIds.add(item.getObjectId()));
            }
        }
        ArrayList<FscAttachmentPO> fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
        if (!ObjectUtil.isEmpty(fscOrderIds)) {
            for (Long fscOrderId : fscOrderIds) {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPO);
                if (ObjectUtil.isEmpty((Object)fscOrder)) {
                    log.info("\u7ed3\u7b97\u5355id:{},\u4e0d\u5b58\u5728", (Object)fscOrderId);
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355");
                }
                FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
                fscOrderInvoicePo.setFscOrderId(fscOrderId);
                FscOrderInvoicePO fscOrderInvoice = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
                if (ObjectUtil.isEmpty((Object)fscOrderInvoice)) {
                    log.info("\u7ed3\u7b97\u5355id:{},\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)fscOrderId);
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u53d1\u7968");
                }
                FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
                fscOrderItemPo.setFscOrderId(fscOrderId);
                List<FscOrderItemPO> fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPo);
                ArrayList inspectionVoucherIdList = new ArrayList();
                if (ObjectUtil.isEmpty(fscOrderItemPOList)) {
                    log.info("\u7ed3\u7b97\u5355id:{},\u9a8c\u6536\u5355id\u4e0d\u5b58\u5728", (Object)fscOrderId);
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u9a8c\u6536\u5355id");
                }
                fscOrderItemPOList.forEach(item -> inspectionVoucherIdList.add(item.getAcceptOrderId()));
                FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
                fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderId.toString());
                log.info("\u8ba2\u5355\u67e5\u8be2\u5165\u53c2:{}", (Object)fscAcceptOrderListQueryAtomReqBO);
                FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
                log.info("\u8ba2\u5355\u67e5\u8be2\u7ed3\u679c:{}", (Object)fscAcceptOrderListQueryAtomRspBO);
                HashSet inspectionVoucherIdSet = new HashSet(inspectionVoucherIdList);
                if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdSet.size()) {
                    throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
                }
                SplitOrderBO splitOrderBO = new SplitOrderBO();
                ArrayList<RelOrderBO> relOrderList = new ArrayList<RelOrderBO>();
                for (Long id : inspectionVoucherIdList) {
                    RelOrderBO relOrderBO = new RelOrderBO();
                    relOrderBO.setAcceptOrderId(id);
                    relOrderList.add(relOrderBO);
                }
                splitOrderBO.setRelOrderList(relOrderList);
                FscBillCreateOrderPdfReqBO fscBillCreateOrderPdfReqBO = new FscBillCreateOrderPdfReqBO();
                FscApprovalRelationPO fscApprovalRelationPo = new FscApprovalRelationPO();
                fscApprovalRelationPo.setFscOrderId(fscOrderId);
                List<FscApprovalRelationPO> fscApprovalRelationPOS = this.fscApprovalRelationMapper.getList(fscApprovalRelationPo);
                if (!ObjectUtil.isEmpty(fscApprovalRelationPOS)) {
                    FscOrderPO fscApprovalPO = new FscOrderPO();
                    fscApprovalPO.setFscOrderId(fscApprovalRelationPOS.get(0).getFscApprovalOrderId());
                    FscOrderPO approvalPO = this.fscOrderMapper.getModelBy(fscApprovalPO);
                    fscBillCreateOrderPdfReqBO.setFscOrderApprovalId(approvalPO.getFscOrderId());
                    fscBillCreateOrderPdfReqBO.setFscOrderApprovalNo(approvalPO.getOrderNo());
                    fscBillCreateOrderPdfReqBO.setFscOrderState(approvalPO.getOrderState());
                }
                FscInvoicePO fscInvoicePo = new FscInvoicePO();
                fscInvoicePo.setFscOrderId(fscOrderId);
                List<FscInvoicePO> fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePo);
                ArrayList<Long> inoviceIds = new ArrayList<Long>();
                if (!ObjectUtil.isEmpty(fscInvoicePOS)) {
                    fscBillCreateOrderPdfReqBO.setFscInvoicePOS(fscInvoicePOS);
                    fscInvoicePOS.forEach(item -> inoviceIds.add(item.getInvoiceId()));
                    FscInvoiceItemPO fscInvoiceItemPo = new FscInvoiceItemPO();
                    fscInvoiceItemPo.setInvoiceIds(inoviceIds);
                    List<FscInvoiceItemPO> fscInvoiceItemPOS = this.fscInvoiceItemMapper.getList(fscInvoiceItemPo);
                    if (!ObjectUtil.isEmpty(fscInvoiceItemPOS)) {
                        fscBillCreateOrderPdfReqBO.setFscInvoiceItemPOS(fscInvoiceItemPOS);
                    }
                }
                fscBillCreateOrderPdfReqBO.setFscOrderPo(fscOrder);
                fscBillCreateOrderPdfReqBO.setFscOrderInvoicePo(fscOrderInvoice);
                fscBillCreateOrderPdfReqBO.setFscOrderInfoBoMap(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap());
                fscBillCreateOrderPdfReqBO.setSplitOrderBO(splitOrderBO);
                FscAttachmentPO fscAttachmentPO = this.createFscOrderPdf(fscBillCreateOrderPdfReqBO);
                fscAttachmentPOS.add(fscAttachmentPO);
            }
        }
        try {
            log.info("\u7ed3\u7b97\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", fscAttachmentPOS);
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4fdd\u5b58\u7ed3\u7b97\u5355\u9644\u4ef6\u5931\u8d25");
            throw new ZTBusinessException("\u4fdd\u5b58\u7ed3\u7b97\u5355\u9644\u4ef6\u5931\u8d25");
        }
        return fscAttachmentPOS;
    }
}

