/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.busibase.atom.api.FscCreditDeductAtomService;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscCreditDeductAtomServiceImpl
implements FscCreditDeductAtomService {
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    private static final Integer IS_CREDIT = 1;

    @Override
    public FscCreditDeductAtomRspBO dealAccountDeduct(FscCreditDeductAtomReqBO reqBO) {
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(reqBO.getSupId());
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setSysTenantId(reqBO.getSysTenantId());
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (null == fscMerchantPo) {
            throw new FscBusinessException("194304", "\u67e5\u8be2\u5546\u6237\u4e3a\u7a7a");
        }
        FscMerchantPO merchant = new FscMerchantPO();
        merchant.setParentId(fscMerchantPo.getMerchantId());
        merchant.setPayObjId(reqBO.getCreditOrgId());
        merchant.setSysTenantId(reqBO.getSysTenantId());
        merchant = this.fscMerchantMapper.getModelBy(merchant);
        if (null != merchant) {
            BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
        }
        FscCreditBalancePO fscCreditBalancePo = new FscCreditBalancePO();
        fscCreditBalancePo.setMerchantId(fscMerchantPo.getMerchantId());
        fscCreditBalancePo.setSysTenantId(reqBO.getSysTenantId());
        FscCreditBalancePO fscCreditBalance = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePo);
        BigDecimal totalAmt = reqBO.getFscCreditDeductAtomBOS().stream().map(FscCreditDeductAtomBO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (null == fscCreditBalance) {
            fscCreditBalancePo.setAvailableAmount(fscMerchantPo.getPayCreditAmount().subtract(totalAmt));
            fscCreditBalancePo.setCreditAmount(fscMerchantPo.getPayCreditAmount());
            fscCreditBalancePo.setUsedAmount(totalAmt);
            fscCreditBalancePo.setUpdateTime(new Date());
            fscCreditBalancePo.setSysTenantId(reqBO.getSysTenantId());
            fscCreditBalancePo.setSysTenantName(reqBO.getSysTenantName());
            this.fscCreditBalanceMapper.insert(fscCreditBalancePo);
        } else {
            int i = this.fscCreditBalanceMapper.updateAmtById(fscMerchantPo.getMerchantId(), totalAmt, reqBO.getSysTenantId());
            if (i != 1) {
                BigDecimal availableAmount = fscCreditBalance.getAvailableAmount();
                BigDecimal creditAmount = fscCreditBalance.getCreditAmount();
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new FscBusinessException("194304", "\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                }
                if (totalAmt.compareTo(BigDecimal.ZERO) > 0 && availableAmount.compareTo(totalAmt) < 0) {
                    throw new FscBusinessException("194304", "\u53ef\u7528\u91d1\u989d\u5c0f\u4e8e\u6263\u51cf\u91d1\u989d");
                }
                if (totalAmt.compareTo(BigDecimal.ZERO) < 0 && availableAmount.add(totalAmt.abs()).compareTo(creditAmount) > 0) {
                    throw new FscBusinessException("194304", "\u6263\u51cf\u91d1\u989d\u52a0\u4e0a\u53ef\u7528\u91d1\u989d\u5927\u4e8e\u6388\u4fe1\u989d\u5ea6");
                }
            }
        }
        this.writeLog(fscMerchantPo, fscCreditBalance, reqBO);
        return new FscCreditDeductAtomRspBO();
    }

    private void writeLog(FscMerchantPO fscMerchant, FscCreditBalancePO fscCreditBalance, FscCreditDeductAtomReqBO reqBO) {
        Date now = new Date();
        ArrayList<FscPayLogPO> fscPayLogPos = new ArrayList<FscPayLogPO>();
        reqBO.getFscCreditDeductAtomBOS().forEach(fscCreditDeductAtomBO -> {
            FscPayLogPO fscPayLogPo = new FscPayLogPO();
            long nextId = Sequence.getInstance().nextId();
            fscPayLogPo.setId(nextId);
            fscPayLogPo.setAccountId(fscMerchant.getAccountId());
            fscPayLogPo.setOrgId(reqBO.getCreditOrgId());
            fscPayLogPo.setUserName(fscMerchant.getOrgName());
            fscPayLogPo.setBusiTime(now);
            fscPayLogPo.setPayeeId(reqBO.getSupId());
            fscPayLogPo.setBusiOrderType(fscCreditDeductAtomBO.getOrderType());
            fscPayLogPo.setBusiAmount(fscCreditDeductAtomBO.getAmount());
            if (fscCreditDeductAtomBO.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_PAY);
            } else {
                fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
            }
            if (null != reqBO.getBusiCategory()) {
                fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
            }
            fscPayLogPo.setBusiOrderNo(fscCreditDeductAtomBO.getOrderNo());
            fscPayLogPo.setBusiOrderId(fscCreditDeductAtomBO.getOrderId());
            if (null == fscCreditBalance) {
                BigDecimal totalAmt = reqBO.getFscCreditDeductAtomBOS().stream().map(FscCreditDeductAtomBO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                fscPayLogPo.setBusiBeforeAmount(fscMerchant.getPayCreditAmount());
                fscPayLogPo.setBusiAfterAmount(fscMerchant.getPayCreditAmount().subtract(totalAmt));
            } else {
                fscPayLogPo.setBusiBeforeAmount(fscCreditBalance.getAvailableAmount());
                fscPayLogPo.setBusiAfterAmount(fscCreditBalance.getAvailableAmount().subtract(fscCreditDeductAtomBO.getAmount()));
            }
            fscPayLogPo.setIsCredit(IS_CREDIT);
            fscPayLogPo.setCreateTime(now);
            if (null != reqBO.getUserName()) {
                fscPayLogPo.setCreateOperId(reqBO.getUserName());
            }
            fscPayLogPo.setSysTenantId(reqBO.getSysTenantId());
            fscPayLogPo.setSysTenantName(reqBO.getSysTenantName());
            fscPayLogPos.add(fscPayLogPo);
        });
        this.fscPayLogMapper.insertBatch(fscPayLogPos);
    }
}

