/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.fsc.busibase.busi.api.FscBillOrderCreatePdfToEmailBusiService;
import com.tydic.fsc.busibase.busi.bo.FscBillOrderCreatePdfToEmailBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscBillOrderCreatePdfToEmailBusiRspBO;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBillOrderCreatePdfToEmailBusiServiceImpl
implements FscBillOrderCreatePdfToEmailBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreatePdfToEmailBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${pdf.reuploadCount}")
    private Integer reuploadCount;

    @Override
    public FscBillOrderCreatePdfToEmailBusiRspBO orderCreatePdfToEmail(FscBillOrderCreatePdfToEmailBusiReqBO reqBO) {
        FscBillOrderCreatePdfToEmailBusiRspBO rspBO = new FscBillOrderCreatePdfToEmailBusiRspBO();
        List<Long> fscOrderIds = reqBO.getFscOrderIds();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIds);
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscOrderPO> fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderIdList(fscOrderIds);
        fscOrderInvoicePO.setSysTenantId(reqBO.getSysTenantId());
        List<FscOrderInvoicePO> fscOrderInvoicePOS = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO);
        Map<Long, FscOrderInvoicePO> fscOrderInvoicePOSMap = fscOrderInvoicePOS.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, o -> o));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), 75.0f, 75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        Font contentFont = this.getFont("contentFont");
        PdfPTable orderInfoTable = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
        orderInfoTable.setTotalWidth(700.0f);
        orderInfoTable.setLockedWidth(true);
        orderInfoTable.setHorizontalAlignment(1);
        orderInfoTable.getDefaultCell().setBorder(1);
        orderInfoTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
        orderInfoTable.addCell(this.createCell("\u91c7\u8d2d\u7ed3\u7b97\u5355\u53f7", contentFont, 0, true));
        orderInfoTable.addCell(this.createCell("\u6536\u7968\u65b9", contentFont, 0, true));
        orderInfoTable.addCell(this.createCell("\u91c7\u8d2d\u7ed3\u7b97\u5355\u7533\u8bf7\u4eba", contentFont, 0, true));
        orderInfoTable.addCell(this.createCell("\u4f9b\u5e94\u5546", contentFont, 0, true));
        orderInfoTable.addCell(this.createCell("\u91c7\u8d2d\u7ed3\u7b97\u5355\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
        orderInfoTable.addCell(this.createCell("\u53d1\u7968\u603b\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
        orderInfoTable.addCell(this.createCell("\u7533\u8bf7\u65f6\u95f4", contentFont, 0, true));
        int sort = 1;
        for (FscOrderPO item : fscOrderPOList) {
            orderInfoTable.addCell(this.createCell(sort > 9 ? String.valueOf(sort) : "0" + sort, contentFont, false));
            orderInfoTable.addCell(this.createCell(item.getOrderNo(), contentFont, false));
            FscOrderInvoicePO fscOrderInvoicePO1 = fscOrderInvoicePOSMap.get(item.getFscOrderId());
            orderInfoTable.addCell(this.createCell(fscOrderInvoicePO1.getBuyName(), contentFont, false));
            orderInfoTable.addCell(this.createCell(item.getCreateOperName(), contentFont, false));
            orderInfoTable.addCell(this.createCell(item.getSupplierName(), contentFont, false));
            orderInfoTable.addCell(this.createCell(item.getTotalCharge().setScale(2).toString(), contentFont, false));
            orderInfoTable.addCell(this.createCell(item.getTotalCharge().setScale(2).toString(), contentFont, false));
            orderInfoTable.addCell(this.createCell(DateUtil.dateToStr((Date)item.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), contentFont, false));
            ++sort;
        }
        try {
            document.add((Element)orderInfoTable);
        }
        catch (DocumentException e) {
            throw new ZTBusinessException("pdf\u65b0\u589e\u9519\u8bef");
        }
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        for (int count = 0; count < this.reuploadCount; ++count) {
            if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            if (fileUrl.indexOf("null") == -1) break;
        }
        rspBO.setUrl(fileUrl);
        return rspBO;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCell(String title, Font font, boolean isFirst) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isFirst) {
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
        }
        return cell;
    }

    private Font getFont(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }
}

