/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.external.api.bo.FscBillCheckOrderAccountReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillCheckOrderAccountRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillCheckOrderAccountService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FscBillCheckOrderAccountServiceImpl
implements FscBillCheckOrderAccountService {
    private static final Logger log = LoggerFactory.getLogger(FscBillCheckOrderAccountServiceImpl.class);
    @Autowired
    private Environment prop;
    @Value(value="${FSC_BILL_CHECK_ECOM_URL:}")
    private String FSC_BILL_CHECK_ECOM_URL;
    @Value(value="${FSC_BILL_CHECK_ECOM_URL_JD:}")
    private String FSC_BILL_CHECK_ECOM_URL_JD;
    @Value(value="${JD_SUP_ID:100055}")
    private Long JD_SUP_ID;

    @Override
    public FscBillCheckOrderAccountRspBO checkOrderAccount(FscBillCheckOrderAccountReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5916\u90e8\u7535\u5546\u5bf9\u8d26\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        String reqBoStr = this.initReq(reqBO);
        String url = this.FSC_BILL_CHECK_ECOM_URL;
        if (this.JD_SUP_ID.equals(reqBO.getSupplierId())) {
            url = this.FSC_BILL_CHECK_ECOM_URL_JD;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u5730\u5740:{}", (Object)url);
            log.debug("\u8c03\u7528\u5916\u90e8\u7535\u5546\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u8bf7\u6c42\u62a5\u6587:{}", (Object)reqBoStr);
        }
        String rspJson = SSLClient.doPost(url, reqBoStr);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5916\u90e8\u7535\u5546\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u54cd\u5e94\u62a5\u6587:{}", (Object)rspJson);
        }
        if (StringUtils.isBlank((CharSequence)rspJson)) {
            throw new FscBusinessException("194315", "\u8c03\u7528\u5916\u90e8\u7535\u5546\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u8fd4\u56de\u7a7a");
        }
        FscBillCheckOrderAccountRspBO rspBO = (FscBillCheckOrderAccountRspBO)((Object)JSON.parseObject((String)rspJson, FscBillCheckOrderAccountRspBO.class));
        if (null == rspBO.getResult()) {
            return rspBO;
        }
        if (StringUtils.isNotBlank((CharSequence)rspBO.getResultCode()) && (this.JD_SUP_ID.equals(reqBO.getSupplierId()) ? !"9000".equals(rspBO.getResultCode()) : !"0000".equals(rspBO.getResultCode()))) {
            throw new FscBusinessException("194315", rspBO.getResultMessage());
        }
        return rspBO;
    }

    private String initReq(FscBillCheckOrderAccountReqBO reqBO) {
        String hsn = this.JD_SUP_ID.equals(reqBO.getSupplierId()) ? this.prop.getProperty("SUPPLIER_ID_JDJC_" + reqBO.getSupplierId()) : this.prop.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        return EsbParamUtil.getEsbReqStr(JSON.toJSONString((Object)reqBO), hsn, "BUSINESS_PAY");
    }
}

