/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.tydic.fsc.bo.FscBigDecimalConvertBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class FscBigDecimalConvertAspect {
    private static final Logger log = LoggerFactory.getLogger(FscBigDecimalConvertAspect.class);
    private static final String SEPARATOR = "|";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String BEFORE_IN_PARAM = "BEFORE_IN_PARAM";
    private static final String AFTER_IN_PARAM = "AFTER_IN_PARAM";
    private static final String BEFORE_OUT_PARAM = "BEFORE_OUT_PARAM";
    private static final String AFTER_OUT_PARAM = "AFTER_OUT_PARAM";
    private static final Integer BEFORE_SCALE = 1;
    private static final Integer AFTER_SCALE = 2;
    private static final Integer MODE = 3;
    private static final String ROUND_DOWN = "2";
    private static final String ROUND_HALF_UP = "1";
    private static final String DEFAULT = "8";
    private static Map<Integer, String> configMap;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    ValueFilter beforeFilter = new ValueFilter(){

        public Object process(Object obj, String s, Object v) {
            if (v != null && v.getClass().equals(BigDecimal.class)) {
                BigDecimal origin = (BigDecimal)v;
                v = FscBigDecimalConvertAspect.this.convertScale(origin, FscBigDecimalConvertAspect.this.string2Integer((String)configMap.get(BEFORE_SCALE)), (String)configMap.get(MODE));
            }
            return v;
        }
    };
    ValueFilter afterFilter = new ValueFilter(){

        public Object process(Object obj, String s, Object v) {
            if (v != null && v.getClass().equals(BigDecimal.class)) {
                BigDecimal origin = (BigDecimal)v;
                v = FscBigDecimalConvertAspect.this.convertScale(origin, FscBigDecimalConvertAspect.this.string2Integer((String)configMap.get(AFTER_SCALE)), (String)configMap.get(MODE));
            }
            return v;
        }
    };

    @Pointcut(value="@annotation(com.tydic.fsc.utils.BigDecimalConvert)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) {
        Object obj = null;
        Object[] args = null;
        try {
            args = this.before(pjp);
            obj = pjp.proceed(args);
            return obj;
        }
        catch (FscBusinessException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @AfterReturning(value="pointCut()", returning="obj")
    public Object setValue(JoinPoint point, Object obj) throws Throwable {
        return this.afterReturn(point, obj);
    }

    private Object[] before(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        if (args != null && args.length > 0 && args.length == 1) {
            Object o1;
            String serFee = "";
            Long sysTenantId = null;
            if (null != args[0]) {
                FscBigDecimalConvertBO fscBigDecimalConvertBO = (FscBigDecimalConvertBO)JSON.parseObject((String)JSON.toJSONString((Object)args[0]), FscBigDecimalConvertBO.class);
                if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscBigDecimalConvertBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscBigDecimalConvertBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscBigDecimalConvertBO.getOrderFlow())) {
                    serFee = "ser_fee";
                }
                if (!CollectionUtils.isEmpty((Collection)fscBigDecimalConvertBO.getOrderFlows()) && (fscBigDecimalConvertBO.getOrderFlows().contains(FscConstants.OrderFlow.MONTH_SERVICE_FEE) || fscBigDecimalConvertBO.getOrderFlows().contains(FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE) || fscBigDecimalConvertBO.getOrderFlows().contains(FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE))) {
                    serFee = "ser_fee";
                }
                sysTenantId = fscBigDecimalConvertBO.getSysTenantId();
            }
            this.getConfig(serFee, sysTenantId);
            BigDecimalConvert annotation = signature.getMethod().getAnnotation(BigDecimalConvert.class);
            int value = annotation.value();
            if (0 != value) {
                configMap.put(AFTER_SCALE, StrUtil.toString((Object)value));
            }
            String[] infos = new String[3];
            infos[0] = this.getClassAndMethodName((JoinPoint)pjp);
            Class<?> aClass = args[0].getClass();
            infos[1] = AFTER_IN_PARAM;
            infos[2] = JSON.toJSONString((Object)args[0], (SerializeFilter)this.beforeFilter, (SerializerFeature[])new SerializerFeature[0]);
            args[0] = o1 = JSON.parseObject((String)infos[2], aClass);
            log.info(this.getLogInfoByStrings(infos));
        }
        return args;
    }

    private Object afterReturn(JoinPoint jp, Object obj) {
        String[] infos = new String[]{this.getClassAndMethodName(jp), AFTER_OUT_PARAM, JSON.toJSONString((Object)obj, (SerializeFilter)this.afterFilter, (SerializerFeature[])new SerializerFeature[0])};
        Object o = JSON.parseObject((String)infos[2], obj.getClass());
        BeanUtils.copyProperties((Object)o, (Object)obj);
        log.info(this.getLogInfoByStrings(infos));
        return o;
    }

    private void getConfig(String value, Long sysTenantId) {
        FscCfcUniteParamQryListDetailExternalReqBO reqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        reqBO.setRelId(value);
        reqBO.setParamCode("settle_money_digit");
        reqBO.setSysTenantId(sysTenantId);
        FscCfcUniteParamQryListDetailExternalRspBO rspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new FscBusinessException("198888", rspBO.getRespDesc());
        }
        configMap = new HashMap<Integer, String>(4);
        if (new BigDecimal(rspBO.getBackDight()).compareTo(new BigDecimal(DEFAULT)) >= 0) {
            configMap.put(BEFORE_SCALE, DEFAULT);
        } else {
            configMap.put(BEFORE_SCALE, rspBO.getBackDight());
        }
        configMap.put(AFTER_SCALE, rspBO.getFrontDight());
        configMap.put(MODE, rspBO.getCalOverDueMethod());
    }

    private BigDecimal convertScale(Object obj, Integer scale, String mode) {
        if (null == obj) {
            obj = "0";
        }
        int bigMode = 4;
        BigDecimal decimal = new BigDecimal(obj.toString());
        if (ROUND_HALF_UP.equals(mode)) {
            bigMode = 4;
        } else if (ROUND_DOWN.equals(mode)) {
            bigMode = 1;
        }
        return decimal.setScale((int)scale, bigMode);
    }

    private String getClassAndMethodName(JoinPoint pjp) {
        Object target = pjp.getTarget();
        String className = target.getClass().getName();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        String methodName = signature.getMethod().getName();
        return className + CLASS_METHOD_SEPARATOR + methodName;
    }

    private String getLogInfoByStrings(String[] infos) {
        StringBuilder str = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            str.append(info).append(SEPARATOR);
        }
        if (str.length() > 1) {
            str.setLength(str.length() - 1);
        }
        return str.toString();
    }

    private Integer string2Integer(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("198888", "\u6570\u636e\u8f6c\u6362\u9519\u8bef");
        }
    }
}

