/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.atom.api.FscBankCheckItemSyncEsAtomService;
import com.tydic.fsc.busibase.atom.bo.FscBankCheckItemSyncEsAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscBankCheckItemSyncEsAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBankCheckItemSyncEsAtomServiceImpl
implements FscBankCheckItemSyncEsAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscBankCheckItemSyncEsAtomServiceImpl.class);
    @Resource(name="fscSyncBankCheckItemMqServiceProvider")
    private ProxyMessageProducer fscSyncBankItemMqServiceProvider;
    @Value(value="${es.FSC_SYNC_BANK_ITEM_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_SYNC_BANK_ITEM_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    private void writeFailLog(FscBankCheckItemSyncEsAtomReqBO reqBO, Long objId, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(objId);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_BANK_CHECK_ITEM_SYNC_ES);
        fscOrderFailLogUpdateBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderFailLogUpdateBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    @Override
    public FscBankCheckItemSyncEsAtomRspBO bankCheckItemSyncEs(FscBankCheckItemSyncEsAtomReqBO reqBO) {
        if (null != reqBO.getBankCheckId()) {
            reqBO.getBankCheckIdList().add(reqBO.getBankCheckId());
        }
        if (ObjectUtil.isNotEmpty(reqBO.getBankCheckIdList())) {
            reqBO.getBankCheckIdList().forEach(bo -> {
                FscBankCheckItemSyncEsAtomReqBO fscSyncReqBO = new FscBankCheckItemSyncEsAtomReqBO();
                fscSyncReqBO.setBankCheckId((Long)bo);
                fscSyncReqBO.setSysTenantId(reqBO.getSysTenantId());
                ProxyMessage mes = new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)((Object)fscSyncReqBO)));
                ProxySendResult proxySendResult = this.fscSyncBankItemMqServiceProvider.send(mes);
                if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                    this.writeFailLog(reqBO, (Long)bo, JSONObject.toJSONString((Object)proxySendResult));
                }
            });
        }
        return new FscBankCheckItemSyncEsAtomRspBO();
    }
}

