/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.fsc.bo.FscMerchantPayeeBO;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeAtomQryListService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeQryListAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeQryListAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeQryOrgIdAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.util.FscRspUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscMerchantPayeeQryListServiceImpl
implements FscMerchantPayeeAtomQryListService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantPayeeQryListServiceImpl.class);
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Value(value="${enabled.pingAn.account}")
    private Boolean switchPingAnAccount;
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;
    @Value(value="${opertionWithdrawalOrgId}")
    private Long opertionWithdrawalOrgId;

    @Override
    public FscMerchantPayeeQryListAtomRspBO queryList(FscMerchantPayeeQryListAtomReqBO reqBO) {
        FscMerchantPayeeQryListAtomRspBO retBo = (FscMerchantPayeeQryListAtomRspBO)FscRspUtil.getSuccessRspBo(FscMerchantPayeeQryListAtomRspBO.class);
        ArrayList<FscMerchantPayeeBO> rows = new ArrayList<FscMerchantPayeeBO>();
        retBo.setRows(rows);
        FscMerchantPayeePO reqPo = new FscMerchantPayeePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)reqPo);
        List<FscMerchantPayeePO> payeeList = this.fscMerchantPayeeMapper.getList(reqPo);
        if (CollectionUtils.isEmpty(payeeList)) {
            return retBo;
        }
        for (FscMerchantPayeePO payeePO : payeeList) {
            FscMerchantPayeeBO payeeBO = new FscMerchantPayeeBO();
            BeanUtils.copyProperties((Object)payeePO, (Object)payeeBO);
            rows.add(payeeBO);
        }
        return retBo;
    }

    @Override
    public FscMerchantPayeeQryOrgIdAtomRspBO getModelByOrgId(FscMerchantPayeeQryListAtomReqBO reqBO) {
        FscMerchantPayeeQryOrgIdAtomRspBO retBo = (FscMerchantPayeeQryOrgIdAtomRspBO)FscRspUtil.getSuccessRspBo(FscMerchantPayeeQryOrgIdAtomRspBO.class);
        if (this.opertionWithdrawalOrgId.equals(reqBO.getOrgId())) {
            CfcUniteParamQryListPageAbilityReqBO cfcUniteParamQryListPageAbilityReqBO1 = new CfcUniteParamQryListPageAbilityReqBO();
            cfcUniteParamQryListPageAbilityReqBO1.setId(FscConstants.TRADE_MODEL.SALE_ORDER_FEE);
            CfcUniteParamQryListPageAbilityRspBO cfcUniteParamQryListPageAbilityRspBO1 = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO1);
            log.info("\u83b7\u53d6\u8fd0\u8425\u63d0\u73b0\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cfcUniteParamQryListPageAbilityRspBO1.getRows()));
            FscAccountPO fscAccountPO = new FscAccountPO();
            fscAccountPO.setOrgId(this.opertionWithdrawalOrgId);
            fscAccountPO.setRecvSubLedgerAcctNo(((JSONObject)cfcUniteParamQryListPageAbilityRspBO1.getRows().get(0)).get((Object)"payeeAccountNo").toString());
            fscAccountPO.setStatus(1);
            List<FscAccountPO> accountPOList = this.fscAccountMapper.getList(fscAccountPO);
            retBo.setPayeeAccountName(accountPOList.get(0).getOrgName());
            retBo.setPayeeBankAccount(accountPOList.get(0).getRecvSubLedgerAcctNo());
            retBo.setPayeeBankName(((JSONObject)cfcUniteParamQryListPageAbilityRspBO1.getRows().get(0)).get((Object)"payeeBankName").toString());
        } else {
            FscMerchantPayeePO fscMerchantPayeePo = new FscMerchantPayeePO();
            fscMerchantPayeePo.setOrgId(reqBO.getOrgId());
            if (this.switchPingAnAccount.booleanValue()) {
                fscMerchantPayeePo.setAccountNoTypeList(Arrays.asList("2", "3"));
            } else {
                fscMerchantPayeePo.setAccountNoTypeList(Arrays.asList("1"));
            }
            FscMerchantPayeePO fscMerchantPayeePoQry = this.fscMerchantPayeeMapper.getModelByOrgId(fscMerchantPayeePo);
            if (null != fscMerchantPayeePoQry) {
                retBo.setPayeeAccountName(fscMerchantPayeePoQry.getPayeeAccountName());
                retBo.setPayeeBankAccount(fscMerchantPayeePoQry.getPayeeBankAccount());
                retBo.setPayeeBankName(fscMerchantPayeePoQry.getPayeeBankName());
            }
        }
        return retBo;
    }
}

