/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jd.open.api.sdk.internal.JSON.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocAcceptOrderCommodityInfoExtBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscStockItemMapper;
import com.tydic.fsc.dao.FscStockMapper;
import com.tydic.fsc.dao.FscStockRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderMapPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscStockItemPO;
import com.tydic.fsc.po.FscStockPO;
import com.tydic.fsc.po.FscStockRelationPO;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscStockOperAtomServiceImpl
implements FscStockOperAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscStockOperAtomServiceImpl.class);
    @Autowired
    private FscStockMapper fscStockMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscStockItemMapper fscStockItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderMapMapper fscOrderMapMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscStockRelationMapper fscStockRelationMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;

    @Override
    public FscStockOperAtomRspBO dealStockOper(FscStockOperAtomReqBO reqBO) {
        List<Long> acceptOrderIds;
        this.val(reqBO);
        FscStockOperAtomRspBO fscStockOperAtomRspBO = new FscStockOperAtomRspBO();
        fscStockOperAtomRspBO.setRespCode("0000");
        fscStockOperAtomRspBO.setRespDesc("\u6210\u529f");
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderRelationPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscOrderRelationPO> fscOrderRelationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        FscOrderPO fscOrderSupPO = new FscOrderPO();
        fscOrderSupPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderSupPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderSupPO = this.fscOrderMapper.getModelBy(fscOrderSupPO);
        for (FscOrderRelationPO item : fscOrderRelationPOList) {
            if (ObjectUtil.isEmpty((Object)item.getSupplierId())) {
                item.setSupplierId(fscOrderSupPO.getSupplierId());
            }
            if (!ObjectUtil.isEmpty((Object)item.getSupplierName())) continue;
            item.setSupplierName(fscOrderSupPO.getSupplierName());
        }
        Map<Long, List<FscOrderRelationPO>> orderRelationMap = fscOrderRelationPOList.stream().collect(Collectors.groupingBy(FscOrderRelationPO::getSupplierId));
        if (!ObjectUtil.isEmpty((Object)reqBO.getStockStatus())) {
            if (fscOrderSupPO.getInvStatus() == 0 || fscOrderSupPO.getInvStatus() == 3) {
                reqBO.setStockStatus(0);
            } else {
                reqBO.setStockStatus(1);
            }
        }
        if (FscConstants.FscStockOperType.INBOUND.equals(reqBO.getOperType())) {
            if (ObjectUtil.isEmpty(orderRelationMap)) {
                acceptOrderIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
                reqBO.setAcceptOrderIds(acceptOrderIds);
                this.dealInbound(reqBO);
            } else {
                orderRelationMap.forEach((k, v) -> {
                    List<Long> acceptOrderIds = v.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
                    reqBO.setSupplierId(((FscOrderRelationPO)v.get(0)).getSupplierId());
                    reqBO.setSupplierName(((FscOrderRelationPO)v.get(0)).getSupplierName());
                    reqBO.setAcceptOrderIds(acceptOrderIds);
                    this.dealInbound(reqBO);
                });
            }
        } else if (FscConstants.FscStockOperType.OUTBOUND.equals(reqBO.getOperType())) {
            if (ObjectUtil.isEmpty(orderRelationMap)) {
                acceptOrderIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
                reqBO.setAcceptOrderIds(acceptOrderIds);
                this.dealOutBound(reqBO);
            } else {
                orderRelationMap.forEach((k, v) -> {
                    List<Long> acceptOrderIds = v.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
                    reqBO.setSupplierId(((FscOrderRelationPO)v.get(0)).getSupplierId());
                    reqBO.setSupplierName(((FscOrderRelationPO)v.get(0)).getSupplierName());
                    reqBO.setAcceptOrderIds(acceptOrderIds);
                    this.dealOutBound(reqBO);
                });
            }
        }
        return fscStockOperAtomRspBO;
    }

    private void dealOutBound(FscStockOperAtomReqBO reqBO) {
        List<FscOrderItemPO> fscOrderItemPOList;
        List<FscUocInspectionDetailsListBO> inspList = this.getInspectionList(reqBO.getAcceptOrderIds());
        Long fscStockId = this.createFscStock(reqBO, inspList);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemPO.setSysTenantId(reqBO.getSysTenantId());
        if (!ObjectUtil.isEmpty(reqBO.getAcceptOrderIds())) {
            fscOrderItemPO.setAcceptOrderIds(reqBO.getAcceptOrderIds());
        }
        if (CollectionUtils.isEmpty(fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO))) {
            return;
        }
        ArrayList<FscStockItemPO> fscStockItemPO1List = new ArrayList<FscStockItemPO>();
        for (FscOrderItemPO orderItemPO : fscOrderItemPOList) {
            FscStockItemPO fscStockItemPO2 = new FscStockItemPO();
            fscStockItemPO2.setAcceptOrderId(orderItemPO.getAcceptOrderId());
            fscStockItemPO2.setOrderItemId(orderItemPO.getOrderItemId());
            fscStockItemPO2.setOrderId(orderItemPO.getOrderId());
            fscStockItemPO1List.add(fscStockItemPO2);
        }
        if (CollectionUtils.isEmpty(fscStockItemPO1List = this.fscStockItemMapper.getListByCondition(fscStockItemPO1List, reqBO.getOperType(), reqBO.getSysTenantId()))) {
            throw new FscBusinessException("194312", "\u6ca1\u6709\u67e5\u8be2\u5230\u5e93\u5b58\u8be6\u60c5\u7684\u4fe1\u606f");
        }
        FscStockPO fscStockPO = new FscStockPO();
        fscStockPO.setStockItemIds(fscStockItemPO1List.stream().map(FscStockItemPO::getId).collect(Collectors.toList()));
        fscStockPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscStockPO> fscStockPOList = this.fscStockMapper.getListByStockItemId(fscStockPO);
        List<Object> fscStockItemPOList = new ArrayList();
        log.info("\u91c7\u8d2d\u7ed3\u7b97\u5355\u751f\u6210\u7684\u51fa\u5e93\u5355:{}", (Object)JSON.toString(fscStockPOList));
        if (!ObjectUtil.isEmpty(fscStockPOList)) {
            List fscStockTempList = fscStockPOList.stream().filter(item -> !item.getFscOrderId().equals(reqBO.getFscOrderId())).collect(Collectors.toList());
            List stockItemIds = fscStockTempList.stream().map(FscStockPO::getStockItemId).collect(Collectors.toList());
            fscStockItemPOList = fscStockItemPO1List.stream().filter(item -> !stockItemIds.contains(item.getId())).collect(Collectors.toList());
        } else {
            fscStockItemPOList = fscStockItemPO1List;
        }
        log.info("\u6392\u9664\u540e----\u91c7\u8d2d\u7ed3\u7b97\u5355\u751f\u6210\u7684\u51fa\u5e93\u5355:{}", (Object)JSON.toString(fscStockItemPOList));
        Map<String, FscStockItemPO> FscStockItemPOMap = fscStockItemPOList.stream().collect(Collectors.toMap(fscStockItemPO -> "" + fscStockItemPO.getOrderItemId() + fscStockItemPO.getAcceptOrderId(), fscStockItemPO -> fscStockItemPO, (k, v) -> k));
        Map<Long, List<FscUocInspectionDetailsListBO>> acceptListMap = inspList.stream().collect(Collectors.groupingBy(o -> o.getAcceptOrderId()));
        for (FscOrderItemPO invoiceItemPO : fscOrderItemPOList) {
            int i;
            FscUocInspectionDetailsListBO fscUocInspectionDetailsListBO;
            Map<String, List<FscUocAcceptOrderCommodityInfoExtBO>> goodsInfoMap;
            FscStockItemPO fscStockItemPO3 = FscStockItemPOMap.get("" + invoiceItemPO.getOrderItemId() + invoiceItemPO.getAcceptOrderId());
            if (fscStockItemPO3 == null) continue;
            fscStockItemPO3.setOutNum(fscStockItemPO3.getOutNum().add(invoiceItemPO.getNum()));
            fscStockItemPO3.setNum(fscStockItemPO3.getNum().subtract(invoiceItemPO.getNum()));
            fscStockItemPO3.setUpdateTime(new Date());
            fscStockItemPO3.setSysTenantId(reqBO.getSysTenantId());
            if (!ObjectUtil.isEmpty(acceptListMap.get(invoiceItemPO.getAcceptOrderId())) && !ObjectUtil.isEmpty((goodsInfoMap = (fscUocInspectionDetailsListBO = acceptListMap.get(invoiceItemPO.getAcceptOrderId()).get(0)).getAcceptOrderCommodityInfo().stream().collect(Collectors.groupingBy(o -> o.getSkuId() + "-" + o.getInspCount().setScale(2, 1)))).get(invoiceItemPO.getSkuId().toString() + "-" + invoiceItemPO.getNum().setScale(2, 1)))) {
                FscUocAcceptOrderCommodityInfoExtBO fscUocAcceptOrderCommodityInfoExtBO = goodsInfoMap.get(invoiceItemPO.getSkuId().toString() + "-" + invoiceItemPO.getNum().setScale(2, 1)).get(0);
                BigDecimal tax = new BigDecimal(fscUocAcceptOrderCommodityInfoExtBO.getTax()).divide(new BigDecimal("100"), 2, 1);
                fscStockItemPO3.setPrice(fscUocAcceptOrderCommodityInfoExtBO.getPurchasePrice());
                fscStockItemPO3.setSalePrice(fscUocAcceptOrderCommodityInfoExtBO.getSalePrice());
                fscStockItemPO3.setAmt(fscUocAcceptOrderCommodityInfoExtBO.getInspPurchaseMoney());
                BigDecimal taxNum = new BigDecimal("1").add(tax);
                fscStockItemPO3.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscStockItemPO3.getAmt(), (BigDecimal)tax));
                fscStockItemPO3.setUntaxAmt(fscStockItemPO3.getAmt().subtract(fscStockItemPO3.getTaxAmt()).setScale(2, RoundingMode.HALF_UP));
                fscStockItemPO3.setSaleAmt(fscUocAcceptOrderCommodityInfoExtBO.getInspSaleMoney());
                fscStockItemPO3.setSaleTaxAmt(fscStockItemPO3.getSaleAmt().divide(taxNum, 2, 1).multiply(tax).setScale(2, RoundingMode.HALF_UP));
                fscStockItemPO3.setSaleUntaxAmt(fscStockItemPO3.getSaleAmt().subtract(fscStockItemPO3.getSaleTaxAmt()).setScale(2, RoundingMode.HALF_UP));
            }
            if ((i = this.fscStockItemMapper.updateById(fscStockItemPO3)) >= 1) continue;
            throw new FscBusinessException("194312", "\u51fa\u5e93\u66f4\u65b0\u8868\u5931\u8d25");
        }
        List<Long> fscStockItemIdList = fscStockItemPOList.stream().map(FscStockItemPO::getId).collect(Collectors.toList());
        this.createStockRelation(fscStockItemIdList, fscStockId, reqBO.getSysTenantId(), reqBO.getSysTenantName());
    }

    private void dealInbound(FscStockOperAtomReqBO reqBO) {
        List<FscOrderItemPO> fscOrderItemList;
        log.info("dealInbound\u5165\u53c2:{}", (Object)JSON.toString((Object)((Object)reqBO)));
        List<FscUocInspectionDetailsListBO> inspList = this.getInspectionList(reqBO.getAcceptOrderIds());
        Long fscStockId = this.createFscStock(reqBO, inspList);
        FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
        fscInvoiceItemPO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoiceItemPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscInvoiceItemPO> fscInvoiceItemList = this.fscInvoiceItemMapper.getList(fscInvoiceItemPO);
        ArrayList<FscStockItemPO> fscStockItemList = new ArrayList<FscStockItemPO>(fscInvoiceItemList.size());
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderItemPO.setSysTenantId(reqBO.getSysTenantId());
        if (!ObjectUtil.isEmpty(reqBO.getAcceptOrderIds())) {
            fscOrderItemPO.setAcceptOrderIds(reqBO.getAcceptOrderIds());
        }
        if (CollectionUtils.isEmpty(fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO))) {
            throw new FscBusinessException("194312", "\u6ca1\u6709\u67e5\u8be2\u5230\u4e3b\u5355\u660e\u7ec6\u4fe1\u606f");
        }
        Map<String, FscOrderItemPO> collect = fscOrderItemList.stream().collect(Collectors.toMap(fscOrderItem -> "" + fscOrderItem.getOrderItemId() + fscOrderItem.getAcceptOrderId(), fscOrderItem -> fscOrderItem));
        ArrayList<Long> fscStockItemIdList = new ArrayList<Long>(fscOrderItemList.size());
        Map<Long, List<FscUocInspectionDetailsListBO>> acceptListMap = inspList.stream().collect(Collectors.groupingBy(o -> o.getAcceptOrderId()));
        for (FscOrderItemPO item : fscOrderItemList) {
            FscUocInspectionDetailsListBO fscUocInspectionDetailsListBO;
            Map<String, List<FscUocAcceptOrderCommodityInfoExtBO>> goodsInfoMap;
            FscStockItemPO fscStockItemPO = new FscStockItemPO();
            BeanUtils.copyProperties((Object)item, (Object)fscStockItemPO);
            FscOrderItemPO fscOrderItemPO1 = collect.get("" + fscStockItemPO.getOrderItemId() + fscStockItemPO.getAcceptOrderId());
            if (fscOrderItemPO1 != null) {
                if (!StringUtils.isBlank((CharSequence)fscOrderItemPO1.getSkuIdExt())) {
                    fscStockItemPO.setSkuIdExt(fscOrderItemPO1.getSkuIdExt());
                }
                fscStockItemPO.setSkuNo(fscOrderItemPO1.getSkuNo());
                fscStockItemPO.setTaxRate(fscOrderItemPO1.getTaxRate());
                fscStockItemPO.setL1CatalogName(fscOrderItemPO1.getL1CatalogName());
            }
            long fscStockItemId = Sequence.getInstance().nextId();
            fscStockItemPO.setId(fscStockItemId);
            fscStockItemPO.setInNum(fscStockItemPO.getNum());
            fscStockItemPO.setNum(fscStockItemPO.getNum());
            fscStockItemPO.setOutNum(BigDecimal.ZERO);
            fscStockItemPO.setStockAmt(fscStockItemPO.getAmt());
            fscStockItemPO.setCreateTime(new Date());
            fscStockItemList.add(fscStockItemPO);
            if (!ObjectUtil.isEmpty(acceptListMap.get(item.getAcceptOrderId())) && !ObjectUtil.isEmpty((goodsInfoMap = (fscUocInspectionDetailsListBO = acceptListMap.get(item.getAcceptOrderId()).get(0)).getAcceptOrderCommodityInfo().stream().collect(Collectors.groupingBy(o -> o.getSkuId() + "-" + o.getInspCount().setScale(2, 1)))).get(item.getSkuId().toString() + "-" + item.getNum().setScale(2, 1)))) {
                FscUocAcceptOrderCommodityInfoExtBO fscUocAcceptOrderCommodityInfoExtBO = goodsInfoMap.get(item.getSkuId().toString() + "-" + item.getNum().setScale(2, 1)).get(0);
                BigDecimal tax = new BigDecimal(fscUocAcceptOrderCommodityInfoExtBO.getTax()).divide(new BigDecimal("100"), 2, 1);
                fscStockItemPO.setPrice(fscUocAcceptOrderCommodityInfoExtBO.getPurchasePrice());
                fscStockItemPO.setSalePrice(fscUocAcceptOrderCommodityInfoExtBO.getSalePrice());
                fscStockItemPO.setAmt(fscUocAcceptOrderCommodityInfoExtBO.getInspPurchaseMoney());
                BigDecimal taxNum = new BigDecimal("1").add(tax);
                fscStockItemPO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscStockItemPO.getAmt(), (BigDecimal)tax));
                fscStockItemPO.setUntaxAmt(fscStockItemPO.getAmt().subtract(fscStockItemPO.getTaxAmt()).setScale(2, RoundingMode.HALF_UP));
                fscStockItemPO.setSaleAmt(fscUocAcceptOrderCommodityInfoExtBO.getInspSaleMoney());
                fscStockItemPO.setSaleTaxAmt(fscStockItemPO.getSaleAmt().divide(taxNum, 2, 1).multiply(tax).setScale(2, RoundingMode.HALF_UP));
                fscStockItemPO.setSaleUntaxAmt(fscStockItemPO.getSaleAmt().subtract(fscStockItemPO.getSaleTaxAmt()).setScale(2, RoundingMode.HALF_UP));
            }
            fscStockItemIdList.add(fscStockItemId);
        }
        this.fscStockItemMapper.insertBatch(fscStockItemList);
        this.createStockRelation(fscStockItemIdList, fscStockId, reqBO.getSysTenantId(), reqBO.getSysTenantName());
    }

    private void createStockRelation(List<Long> fscStockItemIdList, Long fscStockId, Long sysTenantId, String sysTenantName) {
        log.info("\u521b\u5efa\u51fa\u5165\u5e93\u5355\u5173\u8054\u5173\u7cfb\u53c2\u6570:{}-----stockId:{}", (Object)JSON.toString(fscStockItemIdList), (Object)fscStockId);
        ArrayList<FscStockRelationPO> fscStockRelationPOList = new ArrayList<FscStockRelationPO>();
        for (Long fscStockItemId : fscStockItemIdList) {
            FscStockRelationPO fscStockRelationPO = new FscStockRelationPO();
            fscStockRelationPO.setId(Sequence.getInstance().nextId());
            fscStockRelationPO.setStockId(fscStockId);
            fscStockRelationPO.setStockItemId(fscStockItemId);
            fscStockRelationPO.setSysTenantId(sysTenantId);
            this.fscStockRelationMapper.getModelBy(fscStockRelationPO);
            fscStockRelationPO.setSysTenantName(sysTenantName);
            fscStockRelationPOList.add(fscStockRelationPO);
        }
        this.fscStockRelationMapper.insertBatch(fscStockRelationPOList);
    }

    private Long createFscStock(FscStockOperAtomReqBO reqBO, List<FscUocInspectionDetailsListBO> inspList) {
        BigDecimal totalPurAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (FscUocInspectionDetailsListBO item : inspList) {
            List<FscUocAcceptOrderCommodityInfoExtBO> goodsList = item.getAcceptOrderCommodityInfo();
            for (FscUocAcceptOrderCommodityInfoExtBO goods : goodsList) {
                totalPurAmount = totalPurAmount.add(goods.getInspPurchaseMoney());
                BigDecimal tax = new BigDecimal(goods.getTax()).divide(new BigDecimal("100"), 2, 1);
                BigDecimal tempTaxAmount = TaxUtils.calTaxAmt((BigDecimal)goods.getInspPurchaseMoney(), (BigDecimal)tax);
                taxAmount = taxAmount.add(tempTaxAmount);
            }
        }
        BigDecimal unTaxTotalPurAmount = totalPurAmount.subtract(taxAmount);
        FscStockPO fscStockPO = new FscStockPO();
        long fscStockId = Sequence.getInstance().nextId();
        fscStockPO.setId(fscStockId);
        fscStockPO.setFscOrderId(reqBO.getFscOrderId());
        fscStockPO.setSyncState(reqBO.getSyncState());
        fscStockPO.setStockFlag(reqBO.getOperType());
        fscStockPO.setCreateTime(new Date());
        String inStockNo = this.createStockNo(reqBO);
        fscStockPO.setStockNo(inStockNo);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoicePO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (fscOrderPO == null) {
            throw new FscBusinessException("194312", "\u6ca1\u6709\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f");
        }
        FscOrderMapPO fscOrderMapPo = new FscOrderMapPO();
        fscOrderMapPo.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrderMapPo.setSysTenantId(reqBO.getSysTenantId());
        List<FscOrderMapPO> fscOrderMapPOList = this.fscOrderMapMapper.getList(fscOrderMapPo);
        if (ObjectUtil.isNotEmpty(fscOrderMapPOList)) {
            fscOrderMapPOList.forEach(bo -> {
                if ("fscOrderProOperId".equals(bo.getFieldCode()) && ObjectUtil.isNotEmpty((Object)bo.getFieldValue())) {
                    fscStockPO.setCreateOperId(Long.parseLong(bo.getFieldValue()));
                } else if ("fscOrderProOperName".equals(bo.getFieldCode()) && ObjectUtil.isNotEmpty((Object)bo.getFieldValue())) {
                    fscStockPO.setCreateOperName(bo.getFieldValue());
                }
            });
        }
        fscStockPO.setOrderNo(fscOrderPO.getOrderNo());
        if (ObjectUtil.isEmpty(reqBO.getAcceptOrderIds())) {
            fscStockPO.setSupplierId(fscOrderPO.getSupplierId());
            fscStockPO.setSupplierName(fscOrderPO.getSupplierName());
            fscStockPO.setTotalAmt(totalPurAmount);
            fscStockPO.setTaxAmt(taxAmount);
            fscStockPO.setUntaxAmt(unTaxTotalPurAmount);
        } else {
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderItemPO.setAcceptOrderIds(reqBO.getAcceptOrderIds());
            fscStockPO.setSupplierId(reqBO.getSupplierId());
            fscStockPO.setSupplierName(reqBO.getSupplierName());
            fscStockPO.setTotalAmt(totalPurAmount);
            fscStockPO.setTaxAmt(taxAmount);
            fscStockPO.setUntaxAmt(unTaxTotalPurAmount);
        }
        fscStockPO.setPurchaserId(fscOrderPO.getPurchaserId());
        fscStockPO.setPurchaserName(fscOrderPO.getPurchaserName());
        fscStockPO.setStockStatus(reqBO.getStockStatus());
        fscStockPO.setSysTenantId(reqBO.getSysTenantId());
        fscStockPO.setSysTenantName(reqBO.getSysTenantName());
        int insert = this.fscStockMapper.insert(fscStockPO);
        if (insert < 1) {
            throw new FscBusinessException("194312", "\u5165\u5e93\u8868\u65b0\u589e\u5931\u8d25");
        }
        return fscStockId;
    }

    private String createStockNo(FscStockOperAtomReqBO reqBO) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        if (FscConstants.FscStockOperType.INBOUND.equals(reqBO.getOperType())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("IN_STOCK_ORDER_NO");
        } else if (FscConstants.FscStockOperType.OUTBOUND.equals(reqBO.getOperType())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("OUT_STOCK_ORDER_NO");
        }
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setSysTenantId(reqBO.getSysTenantId());
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }

    private void val(FscStockOperAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5e93\u5b58\u51fa\u5165\u5e93\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5e93\u5b58\u51fa\u5165\u5e93\u539f\u5b50\u670d\u52a1\u5931\u8d25,[fscOrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new FscBusinessException("191000", "\u5e93\u5b58\u51fa\u5165\u5e93\u539f\u5b50\u670d\u52a1\u5931\u8d25,[operType]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (FscConstants.FscStockOperType.INBOUND.equals(reqBO.getOperType())) {
            FscStockPO fscStockPO = new FscStockPO();
            fscStockPO.setFscOrderId(reqBO.getFscOrderId());
            fscStockPO.setStockFlag(reqBO.getOperType());
            fscStockPO.setStockStatus(reqBO.getStockStatus());
            fscStockPO.setSysTenantId(reqBO.getSysTenantId());
            List<FscStockPO> fscStockPOList = this.fscStockMapper.getList(fscStockPO);
            if (ObjectUtil.isNotEmpty(fscStockPOList)) {
                throw new FscBusinessException("194312", "\u4e0d\u80fd\u91cd\u590d\u5165\u5e93");
            }
        } else {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && ("2".equals(String.valueOf(fscOrderPO.getOrderSource())) || "3".equals(String.valueOf(fscOrderPO.getOrderSource()))) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                FscStockPO fscStockPO = new FscStockPO();
                fscStockPO.setFscOrderId(reqBO.getFscOrderId());
                fscStockPO.setStockFlag(reqBO.getOperType());
                fscStockPO.setStockStatus(reqBO.getStockStatus());
                fscStockPO.setSysTenantId(reqBO.getSysTenantId());
                List<FscStockPO> fscStockPOList = this.fscStockMapper.getList(fscStockPO);
                if (ObjectUtil.isNotEmpty(fscStockPOList)) {
                    throw new FscBusinessException("194312", "\u4e0d\u80fd\u91cd\u590d\u5165\u5e93");
                }
            }
        }
    }

    private List<FscUocInspectionDetailsListBO> getInspectionList(List<Long> acceptIds) {
        FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = new FscUocInspectionDetailsListPageQueryReqBO();
        fscUocInspectionDetailsListPageQueryReqBO.setPageSize(1000);
        fscUocInspectionDetailsListPageQueryReqBO.setInspOrderIdList(new ArrayList<Long>(acceptIds));
        fscUocInspectionDetailsListPageQueryReqBO.setCanSettleChng(true);
        log.info("\u521b\u5efa\u51fa\u5165\u5e93\u5355-\u83b7\u53d6\u9a8c\u6536\u5355\u5165\u53c2:{}", (Object)JSON.toString((Object)((Object)fscUocInspectionDetailsListPageQueryReqBO)));
        FscUocInspectionDetailsListPageQueryRspBO fscUocInspectionDetailsListPageQueryRspBO = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
        if (!"0000".equals(fscUocInspectionDetailsListPageQueryRspBO.getRespCode())) {
            log.info("\u521b\u5efa\u51fa\u5165\u5e93\u5355-\u83b7\u53d6\u9a8c\u6536\u5355\u5931\u8d25");
            throw new FscBusinessException("198888", "\u83b7\u53d6\u9a8c\u6536\u5355\u9519\u8bef");
        }
        if (ObjectUtil.isEmpty((Object)fscUocInspectionDetailsListPageQueryRspBO.getRows())) {
            log.info("\u521b\u5efa\u51fa\u5165\u5e93\u5355-\u83b7\u53d6\u9a8c\u6536\u5355\u6570\u636e\u4e3a\u7a7a");
            throw new FscBusinessException("198888", "\u83b7\u53d6\u9a8c\u6536\u5355\u6570\u636e\u4e3a\u7a7a");
        }
        return fscUocInspectionDetailsListPageQueryRspBO.getRows();
    }
}

