/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DottedLineSeparator;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.cfc.ability.api.CfcQryFinancialTypeListAbilityService;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.commodity.common.ability.api.UccbBatchQryCatalogRelListAbilityService;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderExtInspQryExtBO;
import com.tydic.fsc.busibase.busi.api.FscBillAdjustOrderCreatePdfBusiService;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscEacQueryOperationRecordsListService;
import com.tydic.fsc.busibase.busi.bo.FscBillCreateAdjustOrderPdfReqBO;
import com.tydic.fsc.busibase.busi.bo.FscEacOperationRecordsInfoBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderExtInspListQryExtService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscApprovalRelationMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscGoodsDeductionAdjustMapper;
import com.tydic.fsc.dao.FscGoodsDeductionRecordItemMapper;
import com.tydic.fsc.dao.FscGoodsDeductionRecordMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscGoodsDeductionAdjustPO;
import com.tydic.fsc.po.FscGoodsDeductionRecordItemPO;
import com.tydic.fsc.po.FscGoodsDeductionRecordPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBillAdjustOrderCreatePdfBusiServiceImpl
implements FscBillAdjustOrderCreatePdfBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillAdjustOrderCreatePdfBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${pdf.reuploadCount}")
    private Integer reuploadCount;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscApprovalRelationMapper fscApprovalRelationMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderListQueryAtomService fscOrderListQueryAtomService;
    @Autowired
    private FscEacQueryOperationRecordsListService fscEacQueryOperationRecordsListService;
    @Autowired
    private CfcQryFinancialTypeListAbilityService cfcQryFinancialTypeListAbilityService;
    @Autowired
    private UccbBatchQryCatalogRelListAbilityService uccbBatchQryCatalogRelListAbilityService;
    @Autowired
    private FscGoodsDeductionAdjustMapper fscGoodsDeductionAdjustMapper;
    @Autowired
    private FscGoodsDeductionRecordMapper fscGoodsDeductionRecordMapper;
    @Autowired
    private FscGoodsDeductionRecordItemMapper fscGoodsDeductionRecordItemMapper;
    @Autowired
    private FscUocOrderExtInspListQryExtService fscUocOrderExtInspListQryExtService;

    @Override
    public FscAttachmentPO createFscAdjustOrderPdf(FscBillCreateAdjustOrderPdfReqBO reqBO) {
        Integer sourceType = reqBO.getSourceType();
        FscOrderInvoicePO fscOrderInvoicePo = reqBO.getFscOrderInvoicePo();
        if (null == fscOrderInvoicePo) {
            fscOrderInvoicePo = new FscOrderInvoicePO();
        }
        List<FscOrderRelationPO> fscOrderRelationPOList = reqBO.getFscOrderRelationPOS();
        List<FscOrderItemPO> fscOrderItemPOList = reqBO.getFscOrderItemPOS();
        List<FscInvoicePO> fscInvoicePOS = reqBO.getFscInvoicePOS();
        List<FscInvoiceItemPO> fscInvoiceItemPOS = reqBO.getFscInvoiceItemPOS();
        Map<String, List<FscEacOperationRecordsInfoBO>> orderApprovalInfoMap = reqBO.getOrderApprovalInfoMap();
        List<FscUocOrderExtInspQryExtBO> fscInspOrderInfoBOList = reqBO.getFscInspOrderInfoBOList();
        log.info("FscOrderInvoicePO\u5165\u53c2:{}", (Object)fscOrderInvoicePo);
        log.info("FscOrderRelationPOList\u5165\u53c2:{}", fscOrderRelationPOList);
        log.info("FscOrderItemPOList\u5165\u53c2:{}", fscOrderItemPOList);
        log.info("FscInvoicePO\u5165\u53c2:{}", fscInvoicePOS);
        log.info("FscInvoiceItemPO\u5165\u53c2:{}", fscInvoiceItemPOS);
        log.info("orderApprovalInfoMap\u5165\u53c2:{}", orderApprovalInfoMap);
        log.info("fscInspOrderInfoBOList\u5165\u53c2:{}", fscInspOrderInfoBOList);
        Map<String, String> invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE", reqBO.getSysTenantId());
        Map<String, String> invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY", reqBO.getSysTenantId());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FscGoodsDeductionAdjustPO fscGoodsDeductionAdjustPo = new FscGoodsDeductionAdjustPO();
        fscGoodsDeductionAdjustPo.setFscAdjustId(reqBO.getFscAdjustId());
        fscGoodsDeductionAdjustPo.setSysTenantId(reqBO.getSysTenantId());
        fscGoodsDeductionAdjustPo = this.fscGoodsDeductionAdjustMapper.getModelBy(fscGoodsDeductionAdjustPo);
        FscGoodsDeductionRecordPO fscGoodsDeductionRecordPo = new FscGoodsDeductionRecordPO();
        fscGoodsDeductionRecordPo.setManualAdjustmentId(reqBO.getFscAdjustId());
        fscGoodsDeductionRecordPo.setSysTenantId(reqBO.getSysTenantId());
        List<FscGoodsDeductionRecordPO> goodsDeductionRecordPOList = this.fscGoodsDeductionRecordMapper.getList(fscGoodsDeductionRecordPo);
        List<Object> recordItemPOList = new ArrayList();
        Map<Object, Object> recordItemMap = new HashMap();
        if (ObjectUtil.isNotEmpty(goodsDeductionRecordPOList)) {
            FscGoodsDeductionRecordItemPO fscGoodsDeductionRecordItemPo = new FscGoodsDeductionRecordItemPO();
            fscGoodsDeductionRecordItemPo.setAdjustSummaryIdList(goodsDeductionRecordPOList.stream().map(FscGoodsDeductionRecordPO::getAdjustSummaryId).collect(Collectors.toList()));
            fscGoodsDeductionRecordItemPo.setSysTenantId(reqBO.getSysTenantId());
            recordItemPOList = this.fscGoodsDeductionRecordItemMapper.getList(fscGoodsDeductionRecordItemPo);
            if (ObjectUtil.isNotEmpty(recordItemPOList)) {
                recordItemMap = recordItemPOList.stream().collect(Collectors.groupingBy(FscGoodsDeductionRecordItemPO::getAdjustSummaryId));
            }
        }
        Font titleFont = this.getFont("titleFont");
        Font contentFont = this.getFont("contentFont");
        Document document = new Document(PageSize.A4.rotate(), 75.0f, 75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        String orderPdfTitle = "\u7ed3\u7b97\u8c03\u6574\u5355";
        Paragraph paragraph = new Paragraph(orderPdfTitle + fscGoodsDeductionAdjustPo.getFscAdjustNo(), titleFont);
        paragraph.setAlignment(1);
        paragraph.setLeading(30.0f);
        try {
            document.add((Element)paragraph);
        }
        catch (DocumentException e) {
            log.info("\u7ed3\u7b97\u5355\u6dfb\u52a0\u9519\u8bef");
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u6dfb\u52a0\u9519\u8bef");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PdfPTable lineOne = new PdfPTable(3);
        lineOne.setTotalWidth(700.0f);
        lineOne.setLockedWidth(true);
        lineOne = new PdfPTable(4);
        Map<String, String> orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_GOODS_RECORD_ADJUST_STATE", reqBO.getSysTenantId());
        lineOne.addCell(this.createCell("\u7ed3\u7b97\u8c03\u6574\u5355\u53f7\uff1a" + fscGoodsDeductionAdjustPo.getFscAdjustNo(), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u4f9b\u5e94\u5546\uff1a" + fscGoodsDeductionAdjustPo.getSupplierName(), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u91c7\u8d2d\u5355\u4f4d\uff1a" + fscGoodsDeductionAdjustPo.getPurchaseName(), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u8c03\u6574\u5355\u72b6\u6001\uff1a" + orderStateMap.get(fscGoodsDeductionAdjustPo.getStatus() + ""), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u8c03\u6574\u5355\u91d1\u989d\uff08\u5143\uff09\uff1a" + fscGoodsDeductionAdjustPo.getFscAdjustAmount().setScale(2), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u5e01\u522b\uff1a\u4eba\u6c11\u5e01", contentFont, 1, false));
        lineOne.addCell(this.createCell("\u8c03\u6574\u5355\u751f\u6210\u65f6\u95f4\uff1a" + sdf.format(fscGoodsDeductionAdjustPo.getCreateDate()), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u7ecf\u529e\u4eba\uff1a" + fscGoodsDeductionAdjustPo.getCreateOperUserName(), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u5f00\u7968\u7c7b\u578b\uff1a\u7ea2\u5b57\u53d1\u7968", contentFont, 1, false));
        lineOne.addCell(this.createCell("\u8c03\u6574\u6c47\u603b\u7b14\u6570\uff1a" + (ObjectUtil.isEmpty(goodsDeductionRecordPOList) ? "0" : Integer.valueOf(goodsDeductionRecordPOList.size())) + "\u7b14", contentFont, 1, false));
        lineOne.addCell(this.createCell("\u53d1\u7968\u7b7e\u6536\u65f6\u95f4\uff1a" + (null != fscGoodsDeductionAdjustPo.getSignDate() ? sdf.format(fscGoodsDeductionAdjustPo.getSignDate()) : ""), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u53d1\u7968\u7b7e\u6536\u4eba\uff1a" + (ObjectUtil.isEmpty((Object)fscGoodsDeductionAdjustPo.getInvoiceSignUserName()) ? "" : fscGoodsDeductionAdjustPo.getInvoiceSignUserName()), contentFont, 1, false));
        try {
            document.add((Element)lineOne);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph p2 = new Paragraph();
        p2.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
        reqBO.setIsShowCatalogName(true);
        if (reqBO.getIsShowCatalogName().booleanValue()) {
            Paragraph l1CatalogNameTitle = null;
            l1CatalogNameTitle = new Paragraph("\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603b", titleFont);
            l1CatalogNameTitle.setAlignment(0);
            l1CatalogNameTitle.setLeading(30.0f);
            try {
                document.add((Element)l1CatalogNameTitle);
            }
            catch (DocumentException e) {
                log.info("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
            }
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            }
            Map<Object, Object> fscOrderL1CatalogNameMap = new HashMap();
            fscOrderL1CatalogNameMap = recordItemPOList.stream().collect(Collectors.groupingBy(item -> item.getL1CatalogName() + "-" + item.getTaxRate()));
            float[] tableFlloat = null;
            tableFlloat = new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f};
            PdfPTable catalogNameTable = new PdfPTable(tableFlloat);
            catalogNameTable.setTotalWidth(700.0f);
            catalogNameTable.setLockedWidth(true);
            catalogNameTable.setHorizontalAlignment(1);
            catalogNameTable.getDefaultCell().setBorder(1);
            catalogNameTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u4e00\u7ea7\u7c7b\u76ee", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u7a0e\u7387\uff08%\uff09", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u7a0e\u91d1\uff08\u5143\uff09", contentFont, 0, true));
            AtomicInteger catalogNameSort = new AtomicInteger(1);
            BigDecimal[] allPrice = new BigDecimal[]{new BigDecimal(0)};
            BigDecimal[] allUntaxAmt = new BigDecimal[]{new BigDecimal(0)};
            BigDecimal[] allTaxAmt = new BigDecimal[]{new BigDecimal(0)};
            fscOrderL1CatalogNameMap.forEach((k, v) -> {
                BigDecimal amtTemp = v.stream().map(FscGoodsDeductionRecordItemPO::getCancelAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                allPrice[0] = allPrice[0].add(amtTemp);
                BigDecimal untaxAmtTemp = amtTemp.divide(BigDecimal.ONE.add(((FscGoodsDeductionRecordItemPO)v.get(0)).getTaxRate()), 2, 4);
                allUntaxAmt[0] = allUntaxAmt[0].add(untaxAmtTemp);
                BigDecimal taxAmt = amtTemp.subtract(untaxAmtTemp);
                allTaxAmt[0] = allTaxAmt[0].add(taxAmt);
                catalogNameTable.addCell(this.createCell("(" + catalogNameSort.get() + ")", contentFont, true));
                catalogNameTable.addCell(this.createCell(((FscGoodsDeductionRecordItemPO)v.get(0)).getL1CatalogName(), contentFont, false));
                Double tempTax = Double.valueOf(((FscGoodsDeductionRecordItemPO)v.get(0)).getTaxRate().toString());
                if (tempTax > 1.0) {
                    catalogNameTable.addCell(this.createCell(((FscGoodsDeductionRecordItemPO)v.get(0)).getTaxRate().setScale(0).toString() + "%", contentFont, false));
                } else {
                    catalogNameTable.addCell(this.createCell(((FscGoodsDeductionRecordItemPO)v.get(0)).getTaxRate().multiply(new BigDecimal("100")).setScale(0).toString() + "%", contentFont, false));
                }
                catalogNameTable.addCell(this.createCell(amtTemp.setScale(2, 4).toString(), contentFont, false));
                catalogNameTable.addCell(this.createCell(untaxAmtTemp.setScale(2, 4).toString(), contentFont, false));
                catalogNameTable.addCell(this.createCell(taxAmt.setScale(2, 4).toString(), contentFont, false));
                catalogNameSort.getAndIncrement();
            });
            catalogNameTable.addCell(this.createCell("\u5408\u8ba1", contentFont, true));
            catalogNameTable.addCell(this.createCell("", contentFont, false));
            catalogNameTable.addCell(this.createCell("", contentFont, false));
            catalogNameTable.addCell(this.createCell(allPrice[0].setScale(2, 4).toString(), contentFont, false));
            catalogNameTable.addCell(this.createCell(allUntaxAmt[0].setScale(2, 4).toString(), contentFont, false));
            catalogNameTable.addCell(this.createCell(allTaxAmt[0].setScale(2, 4).toString(), contentFont, false));
            try {
                document.add((Element)catalogNameTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            }
        }
        String orderItemTitleStr = "\u8c03\u6574\u660e\u7ec6\u4fe1\u606f";
        Paragraph orderItemParagraph = new Paragraph(orderItemTitleStr, titleFont);
        orderItemParagraph.setAlignment(0);
        orderItemParagraph.setLeading(30.0f);
        try {
            document.add((Element)orderItemParagraph);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u5355\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u5355\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
        }
        try {
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable nullTable = new PdfPTable(1);
        nullTable.addCell(this.createCell("", contentFont, 0, false));
        try {
            document.add((Element)nullTable);
        }
        catch (DocumentException e) {
            log.info("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable itemTable = null;
        itemTable = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
        itemTable.setTotalWidth(700.0f);
        itemTable.setLockedWidth(true);
        itemTable.setHorizontalAlignment(1);
        itemTable.getDefaultCell().setBorder(1);
        itemTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u8c03\u6574\u6c47\u603b\u7f16\u53f7", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u4fee\u6539\u5e74\u4efd", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u4fee\u6539\u6708\u4efd", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u5355\u54c1\u7f16\u53f7", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u5355\u54c1\u540d\u79f0", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u5355\u54c1\u542b\u7a0e\u4ef7\u683c", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u7a0e\u7387", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u6c47\u603b\u6570\u91cf", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u6c47\u603b\u91d1\u989d", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u8c03\u6574\u6c47\u603b\u751f\u6210\u65f6\u95f4", contentFont, 0, true));
        itemTable.addCell(this.createCell("\u64cd\u4f5c\u4eba", contentFont, 0, true));
        itemTable.addCell(this.createCell("", contentFont, 0, true));
        itemTable.addCell(this.createCell("", contentFont, 0, true));
        int itemCount = 1;
        if (!ObjectUtil.isEmpty(goodsDeductionRecordPOList)) {
            for (FscGoodsDeductionRecordPO fscGoodsDeductionRecordPO : goodsDeductionRecordPOList) {
                itemTable.addCell(this.createCell(itemCount > 9 ? String.valueOf(itemCount) : "0" + itemCount, contentFont, false));
                itemTable.addCell(this.createCell(fscGoodsDeductionRecordPO.getAdjustSummaryNo(), contentFont, false));
                itemTable.addCell(this.createCell(fscGoodsDeductionRecordPO.getEditYear() + "\u5e74", contentFont, false));
                itemTable.addCell(this.createCell((fscGoodsDeductionRecordPO.getEditMonth().toString().length() == 1 ? "0" : "") + fscGoodsDeductionRecordPO.getEditMonth() + "\u6708", contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscGoodsDeductionRecordPO.getSkuCode()) ? "" : fscGoodsDeductionRecordPO.getSkuCode(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscGoodsDeductionRecordPO.getSkuName()) ? "" : fscGoodsDeductionRecordPO.getSkuName(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscGoodsDeductionRecordPO.getPrice()) ? "" : fscGoodsDeductionRecordPO.getPrice().setScale(2).toString(), contentFont, false));
                if (fscGoodsDeductionRecordPO.getTaxRate().compareTo(BigDecimal.ONE) > 0) {
                    itemTable.addCell(this.createCell(fscGoodsDeductionRecordPO.getTaxRate().setScale(0) + "%", contentFont, false));
                } else {
                    itemTable.addCell(this.createCell(fscGoodsDeductionRecordPO.getTaxRate().multiply(new BigDecimal("100")).setScale(0).toString() + "%", contentFont, false));
                }
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscGoodsDeductionRecordPO.getSummaryNum()) ? "" : fscGoodsDeductionRecordPO.getSummaryNum().setScale(0).toString(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscGoodsDeductionRecordPO.getSummaryAmount()) ? "" : fscGoodsDeductionRecordPO.getSummaryAmount().setScale(2).toString(), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscGoodsDeductionRecordPO.getCreateDate()) ? "" : sdf.format(fscGoodsDeductionRecordPO.getCreateDate()), contentFont, false));
                itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscGoodsDeductionRecordPO.getCreateOperUserName()) ? "" : fscGoodsDeductionRecordPO.getCreateOperUserName(), contentFont, false));
                itemTable.addCell(this.createCell("", contentFont, 0, true));
                itemTable.addCell(this.createCell("", contentFont, 0, true));
                ++itemCount;
                List recordItemPOList1 = (List)recordItemMap.get(fscGoodsDeductionRecordPO.getAdjustSummaryId());
                if (ObjectUtil.isEmpty((Object)recordItemPOList1)) continue;
                itemTable.addCell(this.createCell("", contentFont, 0, true));
                PdfPCell goodsNum = new PdfPCell(new Phrase("\u660e\u7ec6\u5e8f\u53f7", contentFont));
                goodsNum.setHorizontalAlignment(2);
                goodsNum.setVerticalAlignment(5);
                itemTable.addCell(goodsNum);
                itemTable.addCell(this.createCell("\u53d6\u6d88\u5355\u636e", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u8c03\u6574\u5df2\u91c7\u8d2d\u7ed3\u7b97\u9a8c\u6536\u5355\u53f7", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5355\u54c1\u7f16\u53f7", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5355\u54c1\u540d\u79f0", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u4e00\u7ea7\u7c7b\u76ee", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u91c7\u8d2d\u4fa7\u9a8c\u6536\u5355\u8d39\u7528\u7c7b\u578b", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5355\u54c1\u542b\u7a0e\u4ef7\u683c", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u7a0e\u7387", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u53d6\u6d88\u6570\u91cf", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u53d6\u6d88\u91d1\u989d", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u53d6\u6d88\u539f\u56e0\u8bf4\u660e", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u53d6\u6d88\u65f6\u95f4", contentFont, 0, true));
                int goodsCount = 1;
                for (FscGoodsDeductionRecordItemPO fscOrderItemPO : recordItemPOList1) {
                    itemTable.addCell(this.createCell("", contentFont, 0, true));
                    itemTable.addCell(this.createCell("(" + goodsCount + ")", contentFont, true));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getCancelOrderNo()) ? "" : fscOrderItemPO.getCancelOrderNo(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getCancelAcceptNo()) ? "" : fscOrderItemPO.getCancelAcceptNo(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getSkuCode()) ? "" : fscOrderItemPO.getSkuCode(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getSkuName()) ? "" : fscOrderItemPO.getSkuName(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getL1CatalogName()) ? "" : fscOrderItemPO.getL1CatalogName(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getCostTypeName()) ? "" : fscOrderItemPO.getCostTypeName(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getPrice()) ? "" : fscOrderItemPO.getPrice().setScale(2).toString(), contentFont, false));
                    if (fscOrderItemPO.getTaxRate().compareTo(BigDecimal.ONE) > 0) {
                        itemTable.addCell(this.createCell(fscOrderItemPO.getTaxRate().setScale(0) + "%", contentFont, false));
                    } else {
                        itemTable.addCell(this.createCell(fscOrderItemPO.getTaxRate().multiply(new BigDecimal("100")).setScale(0).toString() + "%", contentFont, false));
                    }
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getCancelNum()) ? "" : fscOrderItemPO.getCancelNum().setScale(0).toString(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getCancelAmount()) ? "" : fscOrderItemPO.getCancelAmount().setScale(2).toString(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getRemak()) ? "" : fscOrderItemPO.getRemak(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getCancelTime()) ? "" : sdf.format(fscOrderItemPO.getCancelTime()), contentFont, false));
                    ++goodsCount;
                }
            }
        }
        try {
            document.add((Element)itemTable);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
        }
        Map<Object, Object> fscOrderItemBOSMap = new HashMap();
        if (!ObjectUtil.isEmpty(fscInvoiceItemPOS)) {
            fscOrderItemBOSMap = fscInvoiceItemPOS.stream().collect(Collectors.groupingBy(item -> item.getInvoiceId()));
        }
        if (!(ObjectUtil.isEmpty(fscInvoicePOS) || ObjectUtil.isEmpty((Object)fscInvoicePOS.get(0).getInvoiceCode()) && ObjectUtil.isEmpty((Object)fscInvoicePOS.get(0).getInvoiceNo()))) {
            String orderInvoiceTitleStr = "\u8c03\u6574\u5355\u53d1\u7968\u660e\u7ec6";
            Paragraph orderInvoiceItemParagraph = new Paragraph(orderInvoiceTitleStr, titleFont);
            orderInvoiceItemParagraph.setAlignment(0);
            orderInvoiceItemParagraph.setLeading(30.0f);
            try {
                document.add((Element)orderInvoiceItemParagraph);
            }
            catch (DocumentException e) {
                log.info("pdf\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
            }
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable emptyTable = new PdfPTable(1);
            emptyTable.addCell(this.createCell("", contentFont, 0, false));
            try {
                document.add((Element)emptyTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
            }
            DecimalFormat df = new DecimalFormat("#0.00");
            PdfPTable invTable = new PdfPTable(new float[]{10.0f, 20.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            invTable.setTotalWidth(700.0f);
            invTable.setLockedWidth(true);
            invTable.setHorizontalAlignment(1);
            invTable.getDefaultCell().setBorder(1);
            invTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
            invTable.addCell(this.createCell("\u6536\u7968\u65b9", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u53f7\u7801", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u4ee3\u7801", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u7c7b\u578b", contentFont, 0, true));
            invTable.addCell(this.createCell("\u5f00\u7968\u65e5\u671f", contentFont, 0, true));
            invTable.addCell(this.createCell("\u53d1\u7968\u603b\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
            invTable.addCell(this.createCell("\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
            invTable.addCell(this.createCell("\u7a0e\u989d\uff08\u5143\uff09", contentFont, 0, true));
            invTable.addCell(this.createCell("", contentFont, 0, true));
            int invCount = 1;
            for (FscInvoicePO fscInvoicePO : fscInvoicePOS) {
                invTable.addCell(this.createCell(invCount > 9 ? String.valueOf(invCount) : "0" + invCount, contentFont, false));
                invTable.addCell(this.createCell(fscGoodsDeductionAdjustPo.getPurchaseName(), contentFont, false));
                invTable.addCell(this.createCell(fscInvoicePO.getInvoiceNo(), contentFont, false));
                invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoicePO.getInvoiceCode()) ? "" : fscInvoicePO.getInvoiceCode(), contentFont, false));
                invTable.addCell(this.createCell(invoiceTypeMap.get(fscInvoicePO.getInvoiceType()), contentFont, false));
                invTable.addCell(this.createCell(fscInvoicePO.getBillDate(), contentFont, false));
                invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoicePO.getAmt()) ? "" : fscInvoicePO.getAmt().setScale(2, 4).toString(), contentFont, false));
                invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoicePO.getUntaxAmt()) ? "" : fscInvoicePO.getUntaxAmt().setScale(2, 4).toString(), contentFont, false));
                BigDecimal taxAmt = ObjectUtil.isEmpty((Object)fscInvoicePO.getUntaxAmt()) || ObjectUtil.isEmpty((Object)fscInvoicePO.getAmt()) ? BigDecimal.ZERO : fscInvoicePO.getAmt().subtract(fscInvoicePO.getUntaxAmt());
                invTable.addCell(this.createCell(taxAmt.setScale(2, 4).toString(), contentFont, false));
                invTable.addCell(this.createCell("", contentFont, false));
                ++invCount;
                List fscInvoicePOList = (List)fscOrderItemBOSMap.get(fscInvoicePO.getInvoiceId());
                if (ObjectUtil.isEmpty((Object)fscInvoicePOList)) continue;
                PdfPCell invItemNum = new PdfPCell(new Phrase("\u5546\u54c1\u5e8f\u53f7", contentFont));
                invItemNum.setHorizontalAlignment(2);
                invItemNum.setVerticalAlignment(5);
                invTable.addCell(invItemNum);
                invTable.addCell(this.createCell("\u5546\u54c1\u540d\u79f0", contentFont, 0, true));
                invTable.addCell(this.createCell("\u89c4\u683c", contentFont, 0, true));
                invTable.addCell(this.createCell("\u578b\u53f7", contentFont, 0, true));
                invTable.addCell(this.createCell("\u5355\u4f4d", contentFont, 0, true));
                invTable.addCell(this.createCell("\u6570\u91cf", contentFont, 0, true));
                invTable.addCell(this.createCell("\u5355\u4ef7\uff08\u5143\uff09", contentFont, 0, true));
                invTable.addCell(this.createCell("\u53d1\u7968\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
                invTable.addCell(this.createCell("\u7a0e\u7387", contentFont, 0, true));
                invTable.addCell(this.createCell("\u7a0e\u989d\uff08\u5143\uff09", contentFont, 0, true));
                int invItemCount = 1;
                for (FscInvoiceItemPO fscInvoiceItemPO : fscInvoicePOList) {
                    invTable.addCell(this.createCell("(" + invItemCount + ")", contentFont, true));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getSkuName(), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getSpec(), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getModel(), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoiceItemPO.getUnit(), contentFont, false));
                    invTable.addCell(this.createCell(String.valueOf(fscInvoiceItemPO.getNum().setScale(2)), contentFont, false));
                    invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getPrice()) ? "" : fscInvoiceItemPO.getPrice().setScale(2, 4).toString(), contentFont, false));
                    invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getAmt()) ? "" : fscInvoiceItemPO.getAmt().setScale(2, 4).toString(), contentFont, false));
                    Double tempTax = ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getTax()) ? 0.0 : Double.valueOf(fscInvoiceItemPO.getTax().toString());
                    if (tempTax > 1.0) {
                        invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getTax()) ? "" : fscInvoiceItemPO.getTax().setScale(2).toString() + "%", contentFont, false));
                    } else {
                        invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getTax()) ? "" : fscInvoiceItemPO.getTax().multiply(new BigDecimal("100")).setScale(2).toString() + "%", contentFont, false));
                    }
                    BigDecimal itemTaxAmt = ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getAmt()) || ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getUntaxAmt()) ? BigDecimal.ZERO : fscInvoiceItemPO.getAmt().subtract(fscInvoiceItemPO.getUntaxAmt());
                    invTable.addCell(this.createCell(itemTaxAmt.setScale(2, 4).toString(), contentFont, false));
                    ++invItemCount;
                }
            }
            try {
                document.add((Element)invTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u7ed3\u7b97\u53d1\u7968\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7ed3\u7b97\u53d1\u7968\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
            }
        }
        Paragraph invoiceTitle = new Paragraph("\u5f00\u7968\u4fe1\u606f", titleFont);
        invoiceTitle.setAlignment(0);
        invoiceTitle.setLeading(30.0f);
        try {
            document.add((Element)invoiceTitle);
        }
        catch (DocumentException e) {
            log.info("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        try {
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
        }
        String invoiceStr = invoiceTypeMap.get(fscOrderInvoicePo.getInvoiceType());
        log.info("\u53d1\u7968\u7c7b\u578b\u8f6c\u4e49\u53c2\u6570:{}", invoiceTypeMap);
        log.info("\u53d1\u7968\u7c7b\u522b\u8f6c\u4e49\u53c2\u6570:{}", invoiceCategoryMap);
        log.info("\u516c\u53f8\u540d\u79f0:{}", (Object)fscOrderInvoicePo.getBuyName());
        PdfPTable table = new PdfPTable(1);
        table.addCell(this.createCell("\u53d1\u7968\u7c7b\u578b\uff1a" + (ObjectUtil.isNotEmpty((Object)invoiceStr) ? invoiceStr : ""), contentFont, 0, false));
        table.addCell(this.createCell("\u516c\u53f8\u540d\u79f0\uff1a" + (ObjectUtil.isNotEmpty((Object)fscOrderInvoicePo.getBuyName()) ? fscOrderInvoicePo.getBuyName() : ""), contentFont, 0, false));
        table.addCell(this.createCell("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a" + (ObjectUtil.isNotEmpty((Object)fscOrderInvoicePo.getTaxNo()) ? fscOrderInvoicePo.getTaxNo() : ""), contentFont, 0, false));
        table.addCell(this.createCell("\u5730\u5740\uff1a" + (ObjectUtil.isNotEmpty((Object)fscOrderInvoicePo.getAddress()) ? fscOrderInvoicePo.getAddress() : ""), contentFont, 0, false));
        table.addCell(this.createCell("\u7535\u8bdd\uff1a" + (ObjectUtil.isNotEmpty((Object)fscOrderInvoicePo.getPhone()) ? fscOrderInvoicePo.getPhone() : ""), contentFont, 0, false));
        table.addCell(this.createCell("\u5f00\u6237\u94f6\u884c\uff1a" + (ObjectUtil.isNotEmpty((Object)fscOrderInvoicePo.getBank()) ? fscOrderInvoicePo.getBank() : ""), contentFont, 0, false));
        table.addCell(this.createCell("\u5f00\u6237\u8d26\u6237\uff1a" + (ObjectUtil.isNotEmpty((Object)fscOrderInvoicePo.getAccount()) ? fscOrderInvoicePo.getAccount() : ""), contentFont, 0, false));
        List<String> marks = Arrays.asList("1,1,2", "2,1,3");
        table.addCell(this.createCell("\u5907\u6ce8\uff1a" + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getMemo()) ? "" : fscOrderInvoicePo.getMemo()), contentFont, 0, false));
        try {
            document.add((Element)table);
        }
        catch (DocumentException e) {
            log.info("pdf\u53d1\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u53d1\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph invoiceReceive = new Paragraph("\u53d1\u7968\u63a5\u6536\u4fe1\u606f", titleFont);
        invoiceReceive.setAlignment(0);
        invoiceReceive.setLeading(30.0f);
        try {
            document.add((Element)invoiceReceive);
        }
        catch (DocumentException e) {
            log.info("pdf\u6536\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u6536\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        try {
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
        }
        String invoiceAddr = (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getProvince()) ? "" : fscOrderInvoicePo.getProvince()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getCity()) ? "" : fscOrderInvoicePo.getCity()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getArea()) ? "" : fscOrderInvoicePo.getArea()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getTown()) ? "" : fscOrderInvoicePo.getTown()) + fscOrderInvoicePo.getReceiveAddr();
        PdfPTable invoiceReceiveTable = new PdfPTable(4);
        invoiceReceiveTable.addCell(this.createCell("\u6536\u7968\u4eba\uff1a" + (ObjectUtil.isNotEmpty((Object)fscOrderInvoicePo.getReceiveName()) ? fscOrderInvoicePo.getReceiveName() : ""), contentFont, 0, false));
        invoiceReceiveTable.addCell(this.createCell("\u6536\u7968\u5730\u5740\uff1a" + (ObjectUtil.isNotEmpty((Object)invoiceAddr) ? invoiceAddr : ""), contentFont, 0, false));
        invoiceReceiveTable.addCell(this.createCell("\u8054\u7cfb\u7535\u8bdd\uff1a" + (ObjectUtil.isNotEmpty((Object)fscOrderInvoicePo.getReceivePhone()) ? fscOrderInvoicePo.getReceivePhone() : ""), contentFont, 0, false));
        invoiceReceiveTable.addCell(this.createCell("\u7535\u7968\u63a5\u6536\u90ae\u7bb1\uff1a" + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getReceiveEmail()) ? "" : fscOrderInvoicePo.getReceiveEmail()), contentFont, 0, false));
        try {
            document.add((Element)invoiceReceiveTable);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            log.info("pdf\u6536\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u6536\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        for (int count = 0; count < this.reuploadCount; ++count) {
            if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            if (fileUrl.indexOf("null") == -1) break;
        }
        log.info("innerFileUrl:{}", innerFileUrl);
        log.info("fileUrl:{}", fileUrl);
        fscAttachmentPO.setObjId(fscGoodsDeductionAdjustPo.getFscAdjustId());
        fscAttachmentPO.setFscOrderId(fscGoodsDeductionAdjustPo.getFscAdjustId());
        fscAttachmentPO.setObjType(0);
        fscAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
        if (FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.DOWN_AGM_ORDER.equals(sourceType)) {
            fileName = "\u9500\u552e\u7ed3\u7b97\u5355.pdf";
        } else if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
            fileName = "\u91c7\u8d2d\u7ed3\u7b97\u5355.pdf";
        }
        fscAttachmentPO.setAttachmentName(fileName);
        fscAttachmentPO.setAttachmentUrl(fileUrl);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER_PDF);
        log.info("\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", (Object)fscAttachmentPO);
        return fscAttachmentPO;
    }

    private Font getFont(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCell(String title, Font font, boolean isFirst) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isFirst) {
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
        }
        return cell;
    }

    @Override
    public List<FscAttachmentPO> recreateFscOrderPdf(FscBillCreateAdjustOrderPdfReqBO reqBO) {
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        if (!ObjectUtil.isEmpty((Object)reqBO.getFscAdjustId())) {
            fscOrderIds.add(reqBO.getFscAdjustId());
        }
        ArrayList<FscAttachmentPO> fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
        if (!ObjectUtil.isEmpty(fscOrderIds)) {
            for (Long fscOrderId : fscOrderIds) {
                FscBillCreateAdjustOrderPdfReqBO fscBillCreateOrderPdfReqBO = new FscBillCreateAdjustOrderPdfReqBO();
                FscAttachmentPO fscAttachmentOnePO = new FscAttachmentPO();
                fscAttachmentOnePO.setFscOrderId(fscOrderId);
                fscAttachmentOnePO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER_PDF);
                fscAttachmentOnePO.setSysTenantId(reqBO.getSysTenantId());
                List<FscAttachmentPO> attachmentMapperList = this.fscAttachmentMapper.getList(fscAttachmentOnePO);
                if (!ObjectUtil.isEmpty(attachmentMapperList)) {
                    FscAttachmentPO fscAttachmentDelPO = new FscAttachmentPO();
                    List<Long> attachmentIdList = attachmentMapperList.stream().map(FscAttachmentPO::getAttachmentId).collect(Collectors.toList());
                    fscAttachmentDelPO.setAttachmentIds(attachmentIdList);
                    fscAttachmentDelPO.setSysTenantId(reqBO.getSysTenantId());
                    this.fscAttachmentMapper.deleteBy(fscAttachmentDelPO);
                }
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
                fscOrderInvoicePo.setFscOrderId(fscOrderId);
                fscOrderInvoicePo.setSysTenantId(reqBO.getSysTenantId());
                FscOrderInvoicePO fscOrderInvoice = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
                FscInvoicePO fscInvoicePo = new FscInvoicePO();
                fscInvoicePo.setFscOrderId(fscOrderId);
                fscInvoicePo.setSysTenantId(reqBO.getSysTenantId());
                List<FscInvoicePO> fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePo);
                ArrayList<Long> inoviceIds = new ArrayList<Long>();
                if (!ObjectUtil.isEmpty(fscInvoicePOS)) {
                    fscBillCreateOrderPdfReqBO.setFscInvoicePOS(fscInvoicePOS);
                    fscInvoicePOS.forEach(item -> inoviceIds.add(item.getInvoiceId()));
                    FscInvoiceItemPO fscInvoiceItemPo = new FscInvoiceItemPO();
                    fscInvoiceItemPo.setInvoiceIds(inoviceIds);
                    fscInvoiceItemPo.setSysTenantId(reqBO.getSysTenantId());
                    List<FscInvoiceItemPO> fscInvoiceItemPOS = this.fscInvoiceItemMapper.getList(fscInvoiceItemPo);
                    if (!ObjectUtil.isEmpty(fscInvoiceItemPOS)) {
                        fscBillCreateOrderPdfReqBO.setFscInvoiceItemPOS(fscInvoiceItemPOS);
                    }
                }
                fscBillCreateOrderPdfReqBO.setFscAdjustId(reqBO.getFscAdjustId());
                fscBillCreateOrderPdfReqBO.setFscOrderInvoicePo(fscOrderInvoice);
                fscBillCreateOrderPdfReqBO.setIsShowMark(reqBO.getIsShowMark());
                fscBillCreateOrderPdfReqBO.setSourceType(ObjectUtil.isEmpty((Object)reqBO.getSourceType()) ? 0 : reqBO.getSourceType());
                fscBillCreateOrderPdfReqBO.setIsShowCatalogName(true);
                fscBillCreateOrderPdfReqBO.setIsActivity(ObjectUtil.isEmpty((Object)reqBO.getIsActivity()) ? "" : reqBO.getIsActivity());
                FscAttachmentPO fscAttachmentPO = this.createFscAdjustOrderPdf(fscBillCreateOrderPdfReqBO);
                fscAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
                fscAttachmentPO.setSysTenantName(reqBO.getSysTenantName());
                fscAttachmentPOS.add(fscAttachmentPO);
            }
        }
        try {
            log.info("\u7ed3\u7b97\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", fscAttachmentPOS);
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4fdd\u5b58\u7ed3\u7b97\u5355\u9644\u4ef6\u5931\u8d25");
            throw new ZTBusinessException("\u4fdd\u5b58\u7ed3\u7b97\u5355\u9644\u4ef6\u5931\u8d25");
        }
        return fscAttachmentPOS;
    }
}

