/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DottedLineSeparator;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.cfc.ability.api.CrcQryPaymentBehalfAbilityService;
import com.tydic.cfc.ability.bo.CfcPaymentBehalfBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfAbilityRspBO;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.commodity.common.ability.api.UccbBatchQryCatalogRelListAbilityService;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccbBatchQryCatalogRelListBO;
import com.tydic.fsc.busibase.atom.api.FscOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderListBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscBillPayOrderCreatePdfBusiService;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscEacQueryOperationRecordsListService;
import com.tydic.fsc.busibase.busi.bo.FscBillPayOrderCreatePdfBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscBillPayOrderCreatePdfBusiRspBO;
import com.tydic.fsc.busibase.busi.bo.FscBillPayOrderCreatePdfInfoBO;
import com.tydic.fsc.busibase.busi.bo.FscBillPayOrderCreatePdfPayeeInfoBO;
import com.tydic.fsc.busibase.busi.bo.FscEacOperationRecordsInfoBO;
import com.tydic.fsc.busibase.busi.bo.FscEacQueryOperationRecordsListReqBO;
import com.tydic.fsc.busibase.busi.bo.FscEacQueryOperationRecordsListRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscApprovalRelationMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscApprovalRelationPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.general.ability.api.CrcQrySupplierBankListAbilityService;
import com.tydic.umc.general.ability.api.DictionaryAbilityService;
import com.tydic.umc.general.ability.api.UmcQrySupplierPayAccountListPageAbilityService;
import com.tydic.umc.general.ability.bo.CrcQrySupplierBankListAbilityReqBO;
import com.tydic.umc.general.ability.bo.CrcQrySupplierBankListAbilityRspBO;
import com.tydic.umc.general.ability.bo.DicDictionaryBO;
import com.tydic.umc.general.ability.bo.QueryDictionaryAbilityReqBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import oshi.util.StringUtil;

@Service
public class FscBillPayOrderCreatePdfBusiServiceImpl
implements FscBillPayOrderCreatePdfBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayOrderCreatePdfBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscApprovalRelationMapper fscApprovalRelationMapper;
    @Autowired
    private FscOrderListQueryAtomService fscOrderListQueryAtomService;
    @Autowired
    private FscEacQueryOperationRecordsListService fscEacQueryOperationRecordsListService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private CrcQryPaymentBehalfAbilityService crcQryPaymentBehalfAbilityService;
    @Autowired
    private CrcQrySupplierBankListAbilityService crcQrySupplierBankListAbilityService;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${enabled.pingAn.account:true}")
    private Boolean enabledPingAnAccount;
    @Value(value="${HK.sysTenantId:1104853665419067393}")
    private Long hkSysTenantId;
    @Autowired
    private DictionaryAbilityService umcDictionaryAbilityService;
    @Autowired
    private UccbBatchQryCatalogRelListAbilityService uccbBatchQryCatalogRelListAbilityService;
    @Autowired
    private UmcQrySupplierPayAccountListPageAbilityService umcQrySupplierPayAccountListPageAbilityService;

    @Override
    public FscBillPayOrderCreatePdfBusiRspBO createPayOrderPdf(FscBillPayOrderCreatePdfBusiReqBO reqBO) {
        this.val(reqBO);
        FscAttachmentPO selectAttachmentPO = new FscAttachmentPO();
        selectAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER_PDF);
        selectAttachmentPO.setFscOrderId(reqBO.getPayOrderId());
        selectAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscAttachmentPO> fscAttachmentPOList = this.fscAttachmentMapper.getList(selectAttachmentPO);
        if (!ObjectUtil.isEmpty(fscAttachmentPOList)) {
            FscAttachmentPO deleteAttachment = new FscAttachmentPO();
            deleteAttachment.setAttachmentIds(fscAttachmentPOList.stream().map(FscAttachmentPO::getAttachmentId).collect(Collectors.toList()));
            deleteAttachment.setSysTenantId(reqBO.getSysTenantId());
            this.fscAttachmentMapper.deleteBy(deleteAttachment);
        }
        this.createPdfParams(reqBO);
        log.info("\u521b\u5efapdf\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        FscBillPayOrderCreatePdfBusiRspBO fscBillPayOrderCreatePdfBusiRspBO = new FscBillPayOrderCreatePdfBusiRspBO();
        Font titleFont = this.getFont("titleFont");
        Font contentFont = this.getFont("contentFont");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), 75.0f, 75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        PdfPTable headTable = new PdfPTable(8);
        headTable.addCell(this.createCell("\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7:" + reqBO.getPayOrderNo(), titleFont, 4, false));
        PdfPCell payerAmountCell = this.createCell("\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d:" + reqBO.getPayTotalAmount().setScale(2).toString() + "(\u5143)", titleFont, 4, false);
        payerAmountCell.setHorizontalAlignment(2);
        headTable.addCell(payerAmountCell);
        headTable.addCell(this.createCell("\u6700\u665a\u4ed8\u6b3e\u65f6\u95f4:" + (ObjectUtil.isEmpty((Object)reqBO.getLastPayDate()) ? "\u2014\u2014" : DateUtil.dateToStrLong((Date)reqBO.getLastPayDate())), contentFont, 2, false));
        headTable.addCell(this.createCell("\u6240\u5c5e\u79df\u6237:" + reqBO.getSysTenantName(), contentFont, 2, false));
        headTable.addCell(this.createCell("\u4ed8\u6b3e\u65b9\u5f0f:" + reqBO.getPayType(), contentFont, 2, false));
        headTable.addCell(this.createCell("\u8d27\u5e01:" + reqBO.getCurrencyStr(), contentFont, 2, false));
        headTable.addCell(this.createCell("\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001:" + reqBO.getPayOrderState(), contentFont, 2, false));
        headTable.addCell(this.createCell("\u62a5\u8d26\u5355\u53f7:" + (ObjectUtil.isEmpty((Object)reqBO.getReimburseNo()) ? "\u2014\u2014" : reqBO.getReimburseNo()), contentFont, 2, false));
        headTable.addCell(this.createCell("\u62a5\u8d26\u65e5\u671f:" + (ObjectUtil.isEmpty((Object)reqBO.getSyncDate()) ? "\u2014\u2014" : DateUtil.dateToStr((Date)reqBO.getSyncDate(), (String)"yyyy-MM-dd HH:mm:ss")), contentFont, 2, false));
        headTable.addCell(this.createCell("\u64cd\u4f5c\u4eba:" + (ObjectUtil.isEmpty((Object)reqBO.getCreateOperName()) ? "\u2014\u2014" : reqBO.getCreateOperName()), contentFont, 2, false));
        headTable.addCell(this.createCell("\u8d39\u7528\u7c7b\u578b:" + (ObjectUtil.isEmpty((Object)reqBO.getFscBusiTypeName()) ? "\u2014\u2014" : reqBO.getFscBusiTypeName()), contentFont, 2, false));
        headTable.addCell(this.createCell("", contentFont, 2, false));
        headTable.addCell(this.createCell("", contentFont, 2, false));
        headTable.addCell(this.createCell("", contentFont, 2, false));
        headTable.addCell(this.createCellTop("\u4ed8\u6b3e\u5355\u4f4d:" + reqBO.getPayerName(), contentFont, 3, false));
        headTable.addCell(this.createCellTop("\u4ed8\u6b3e\u94f6\u884c\u53ca\u8d26\u6237:", contentFont, 1, false));
        headTable.addCell(this.createCellTop(ObjectUtil.isEmpty((Object)reqBO.getPayerAccount()) ? "" : reqBO.getPayerAccount(), contentFont, 4, false));
        if (!ObjectUtil.isEmpty(reqBO.getBehalfPayerInfoMap())) {
            Map<String, List<Map<String, String>>> behalfPayerInfoMap = reqBO.getBehalfPayerInfoMap();
            for (Map.Entry<String, List<Map<String, String>>> entry : behalfPayerInfoMap.entrySet()) {
                headTable.addCell(this.createCellTop("\u4ed8\u6b3e\u5355\u4f4d:" + entry.getKey() + "(\u4ee3)", contentFont, 3, false));
                List<Map<String, String>> tempList = entry.getValue();
                Object behalfPayerName = "";
                for (int i = 0; i < tempList.size(); ++i) {
                    Map<String, String> it = tempList.get(i);
                    for (Map.Entry<String, String> name : it.entrySet()) {
                        if (i == 0) {
                            behalfPayerName = (ObjectUtil.isEmpty((Object)name.getKey()) ? "\u2014\u2014" : name.getKey()) + "\uff1a" + (ObjectUtil.isEmpty((Object)name.getValue()) ? "\u2014\u2014" : name.getValue()) + "\n";
                            continue;
                        }
                        behalfPayerName = (String)behalfPayerName + "                                   " + (ObjectUtil.isEmpty((Object)name.getKey()) ? "\u2014\u2014" : name.getKey()) + "\uff1a" + (ObjectUtil.isEmpty((Object)name.getValue()) ? "\u2014\u2014" : name.getValue()) + "\n";
                    }
                }
                headTable.addCell(this.createCellTop("\u4ed8\u6b3e\u94f6\u884c\u53ca\u8d26\u6237:", contentFont, 1, false));
                headTable.addCell(this.createCellTop((String)behalfPayerName, contentFont, 4, false));
            }
        }
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph p2 = new Paragraph();
        p2.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
        Paragraph payeeInfoTitle = new Paragraph("\u6536\u6b3e\u4fe1\u606f", titleFont);
        payeeInfoTitle.setAlignment(0);
        payeeInfoTitle.setLeading(30.0f);
        try {
            document.add((Element)payeeInfoTitle);
        }
        catch (DocumentException e) {
            log.info("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
        }
        try {
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable payeeInfoTable = new PdfPTable(6);
        payeeInfoTable.addCell(this.createCell("\u6536\u6b3e\u5355\u4f4d:" + reqBO.getPayeeName() + "(" + (ObjectUtil.isEmpty((Object)reqBO.getShorName()) ? "-" : reqBO.getShorName()) + ")", titleFont, 6, false));
        if (ObjectUtil.isNotEmpty(reqBO.getPayeeInfoListBO())) {
            List sortList = reqBO.getPayeeInfoListBO().stream().sorted(Comparator.nullsFirst(Comparator.comparing(FscBillPayOrderCreatePdfPayeeInfoBO::getIsDefalt, Comparator.nullsFirst(Comparator.naturalOrder())).reversed())).collect(Collectors.toList());
            for (FscBillPayOrderCreatePdfPayeeInfoBO payeeInfoBO : sortList) {
                String accountStr = ObjectUtil.isEmpty((Object)payeeInfoBO.getPayeeBankName()) ? "\u2014\u2014" : (payeeInfoBO.getIsDefalt().equals(1) ? payeeInfoBO.getPayeeBankName() + ":" + payeeInfoBO.getPayeeAccount() + "(\u9ed8\u8ba4)" : payeeInfoBO.getPayeeBankName() + ":" + payeeInfoBO.getPayeeAccount());
                payeeInfoTable.addCell(this.createCell("\u8d26\u53f7\u7c7b\u578b:" + (ObjectUtil.isEmpty((Object)payeeInfoBO.getPayAccountTypeStr()) ? "\u2014\u2014" : payeeInfoBO.getPayAccountTypeStr()), contentFont, 2, false));
                payeeInfoTable.addCell(this.createCell("\u6536\u6b3e\u94f6\u884c\u53ca\u8d26\u6237:" + accountStr, contentFont, 4, false));
            }
        } else {
            payeeInfoTable.addCell(this.createCell("\u8d26\u53f7\u7c7b\u578b:\u2014\u2014", contentFont, 2, false));
            payeeInfoTable.addCell(this.createCell("\u6536\u6b3e\u94f6\u884c\u53ca\u8d26\u6237:\u2014\u2014", contentFont, 4, false));
        }
        try {
            document.add((Element)payeeInfoTable);
        }
        catch (DocumentException e) {
            log.info("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable shouldPayInfoTable = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
        shouldPayInfoTable.setTotalWidth(700.0f);
        shouldPayInfoTable.setLockedWidth(true);
        shouldPayInfoTable.setHorizontalAlignment(1);
        shouldPayInfoTable.getDefaultCell().setBorder(1);
        shouldPayInfoTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
        shouldPayInfoTable.addCell(this.createCell("\u7ed3\u7b97\u5355\u53f7", contentFont, 0, true));
        shouldPayInfoTable.addCell(this.createCell("\u8d39\u7528\u7c7b\u578b", contentFont, 0, true));
        shouldPayInfoTable.addCell(this.createCell("\u7ed3\u7b97\u5355\u91d1\u989d(\u5143)", contentFont, 0, true));
        shouldPayInfoTable.addCell(this.createCell("\u5df2\u4ed8\u91d1\u989d(\u5143)", contentFont, 0, true));
        shouldPayInfoTable.addCell(this.createCell("\u5e94\u4ed8\u751f\u6210\u65f6\u95f4", contentFont, 0, true));
        int sort = 1;
        for (FscOrderPO fscOrderPO : reqBO.getShouldPayOrderInfo()) {
            shouldPayInfoTable.addCell(this.createCell(sort > 9 ? String.valueOf(sort) : "0" + sort, contentFont, false));
            shouldPayInfoTable.addCell(this.createCell(fscOrderPO.getOrderNo(), contentFont, false));
            shouldPayInfoTable.addCell(this.createCell(fscOrderPO.getFscBusiTypeName(), contentFont, false));
            shouldPayInfoTable.addCell(this.createCell(fscOrderPO.getTotalCharge().setScale(2).toString(), contentFont, false));
            shouldPayInfoTable.addCell(this.createCell(fscOrderPO.getPaidAmount().setScale(2).toString(), contentFont, false));
            shouldPayInfoTable.addCell(this.createCell(DateUtil.dateToStr((Date)fscOrderPO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), contentFont, false));
        }
        try {
            document.add((Element)shouldPayInfoTable);
        }
        catch (DocumentException e) {
            log.info("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
        }
        for (FscBillPayOrderCreatePdfInfoBO fscBillPayOrderCreatePdfInfoBO : reqBO.getFscBillPayOrderCreatePdfInfoBOList()) {
            Object xcCategoryStr;
            Map<String, String> orderStateMap;
            Integer sourceType = fscBillPayOrderCreatePdfInfoBO.getSourceType();
            FscOrderPO fscOrderPo = fscBillPayOrderCreatePdfInfoBO.getFscOrderPo();
            FscOrderInvoicePO fscOrderInvoicePo = fscBillPayOrderCreatePdfInfoBO.getFscOrderInvoicePo();
            List<FscOrderRelationPO> fscOrderRelationPOList = fscBillPayOrderCreatePdfInfoBO.getFscOrderRelationPOS();
            List<FscOrderItemPO> fscOrderItemPOList = fscBillPayOrderCreatePdfInfoBO.getFscOrderItemPOS();
            List<FscInvoicePO> fscInvoicePOS = fscBillPayOrderCreatePdfInfoBO.getFscInvoicePOS();
            List<FscInvoiceItemPO> fscInvoiceItemPOS = fscBillPayOrderCreatePdfInfoBO.getFscInvoiceItemPOS();
            Map<String, List<FscEacOperationRecordsInfoBO>> orderApprovalInfoMap = fscBillPayOrderCreatePdfInfoBO.getOrderApprovalInfoMap();
            log.info("FscOrderPO\u5165\u53c2:{}", (Object)fscOrderPo);
            log.info("FscOrderInvoicePO\u5165\u53c2:{}", (Object)fscOrderInvoicePo);
            log.info("FscOrderRelationPOList\u5165\u53c2:{}", fscOrderRelationPOList);
            log.info("FscOrderItemPOList\u5165\u53c2:{}", fscOrderItemPOList);
            log.info("FscInvoicePO\u5165\u53c2:{}", fscInvoicePOS);
            log.info("FscInvoiceItemPO\u5165\u53c2:{}", fscInvoiceItemPOS);
            log.info("orderApprovalInfoMap\u5165\u53c2:{}", orderApprovalInfoMap);
            Map<String, String> invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE", reqBO.getSysTenantId());
            Map<String, String> invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY", reqBO.getSysTenantId());
            String orderPdfTitle = "\u7ed3\u7b97\u5355";
            if (FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType)) {
                orderPdfTitle = "\u7ed3\u7b97\u5ba1\u6279\u5355\uff1a";
            } else if (FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.DOWN_AGM_ORDER.equals(sourceType)) {
                orderPdfTitle = "\u9500\u552e\u7ed3\u7b97\u5355:";
            } else if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                orderPdfTitle = "\u91c7\u8d2d\u7ed3\u7b97\u5355:";
            }
            Paragraph paragraph = new Paragraph(orderPdfTitle + fscOrderPo.getOrderNo(), titleFont);
            paragraph.setAlignment(1);
            paragraph.setLeading(30.0f);
            try {
                document.add((Element)paragraph);
            }
            catch (DocumentException e) {
                log.info("\u7ed3\u7b97\u5355\u6dfb\u52a0\u9519\u8bef");
                throw new ZTBusinessException("\u7ed3\u7b97\u5355\u6dfb\u52a0\u9519\u8bef");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            PdfPTable lineOne = new PdfPTable(3);
            if (FscConstants.FSC_ORDER_PDF_TYPE.MATCH_AGM_ORDER.equals(sourceType)) {
                lineOne = new PdfPTable(4);
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u53f7\uff1a" + fscOrderPo.getOrderNo(), contentFont, 0, false));
                lineOne.addCell(this.createCell("\u91c7\u8d2d\u5355\u4f4d\uff1a" + fscOrderPo.getSupplierName(), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u8ba2\u5355\u6570\u91cf\uff1a" + fscOrderPo.getOrderNum() + "\u7b14", contentFont, 1, false));
                orderStateMap = 0 == fscOrderPo.getOrderFlow() ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE", reqBO.getSysTenantId()) : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE", reqBO.getSysTenantId());
                if (FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType)) {
                    orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_APPROVAL_STATE", reqBO.getSysTenantId());
                }
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u72b6\u6001\uff1a" + orderStateMap.get(fscOrderPo.getOrderState() + ""), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5ba1\u6279\u5355\uff1a" + fscBillPayOrderCreatePdfInfoBO.getFscOrderApprovalNo(), contentFont, 0, false));
                lineOne.addCell(this.createCell("\u91c7\u8d2d\u5355\u4f4d\uff1a" + fscOrderPo.getPurchaserName(), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u53d1\u8d77\u65f6\u95f4\uff1a" + sdf.format(fscOrderPo.getCreateTime()), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u53d1\u8d77\u4eba\uff1a" + fscOrderPo.getCreateOperName(), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u8d39\u7528\u7c7b\u578b\uff1a" + fscOrderPo.getFscBusiTypeName(), contentFont, 0, false));
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u603b\u91d1\u989d(\u5143)\uff1a" + fscOrderPo.getTotalCharge().setScale(2), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u5e01\u522b\uff1a\u4eba\u6c11\u5e01", contentFont, 2, false));
            } else if (FscConstants.FSC_ORDER_PDF_TYPE.MATCH_ELC_ORDER.equals(sourceType)) {
                lineOne = new PdfPTable(4);
                lineOne.addCell(this.createCell("\u4f9b\u5e94\u5546\u540d\u79f0\uff1a" + fscOrderPo.getSupplierName(), contentFont, 0, false));
                lineOne.addCell(this.createCell("\u91c7\u8d2d\u5355\u4f4d\uff1a" + fscOrderPo.getPurchaserName(), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u8ba2\u5355\u6570\u91cf\uff1a" + fscOrderPo.getOrderNum() + "\u7b14", contentFont, 1, false));
                orderStateMap = 0 == fscOrderPo.getOrderFlow() ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE", reqBO.getSysTenantId()) : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE", reqBO.getSysTenantId());
                if (FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType)) {
                    orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_APPROVAL_STATE", reqBO.getSysTenantId());
                }
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u72b6\u6001\uff1a" + orderStateMap.get(fscOrderPo.getOrderState() + ""), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5ba1\u6279\u5355\uff1a" + fscBillPayOrderCreatePdfInfoBO.getFscOrderApprovalNo(), contentFont, 0, false));
                lineOne.addCell(this.createCell("\u5e01\u522b\uff1a\u4eba\u6c11\u5e01", contentFont, 1, false));
                lineOne.addCell(this.createCell("\u53d1\u8d77\u65f6\u95f4\uff1a" + sdf.format(fscOrderPo.getCreateTime()), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u53d1\u8d77\u4eba\uff1a" + fscOrderPo.getCreateOperName(), contentFont, 1, false));
                lineOne.addCell(this.createCell("\u8d39\u7528\u7c7b\u578b\uff1a" + fscOrderPo.getFscBusiTypeName(), contentFont, 0, false));
                lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u603b\u91d1\u989d(\u5143)\uff1a" + fscOrderPo.getTotalCharge().setScale(2), contentFont, 1, false));
                lineOne.addCell(this.createCell("", contentFont, 1, false));
                lineOne.addCell(this.createCell("", contentFont, 1, false));
            } else {
                lineOne = new PdfPTable(3);
                if (FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u4f9b\u5e94\u5546\u540d\u79f0\uff1a" + fscOrderPo.getSupplierName(), contentFont, 0, false));
                } else {
                    lineOne.addCell(this.createCell("\u91c7\u8d2d\u5355\u4f4d\uff1a" + fscOrderPo.getPurchaserName(), contentFont, 0, false));
                }
                if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u91c7\u8d2d\u7ed3\u7b97\u5355\u53d1\u8d77\u4eba\uff1a" + fscOrderPo.getCreateOperName(), contentFont, 1, false));
                } else if (FscConstants.FSC_ORDER_PDF_TYPE.DOWN_AGM_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u9500\u552e\u7ed3\u7b97\u5355\u53d1\u8d77\u4eba\uff1a" + fscOrderPo.getCreateOperName(), contentFont, 1, false));
                } else {
                    lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u53d1\u8d77\u4eba\uff1a" + fscOrderPo.getCreateOperName(), contentFont, 1, false));
                }
                orderStateMap = 0 == fscOrderPo.getOrderFlow() ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE", reqBO.getSysTenantId()) : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE", reqBO.getSysTenantId());
                if (FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType)) {
                    orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_APPROVAL_STATE", reqBO.getSysTenantId());
                }
                if (FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u91c7\u8d2d\u7ed3\u7b97\u5355\u72b6\u6001\uff1a" + orderStateMap.get(fscOrderPo.getOrderState() + ""), contentFont, 2, false));
                } else if (FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u7ed3\u7b97\u5ba1\u6279\u5355\u72b6\u6001\uff1a" + orderStateMap.get(fscOrderPo.getOrderState() + ""), contentFont, 2, false));
                } else if (FscConstants.FSC_ORDER_PDF_TYPE.DOWN_AGM_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u9500\u552e\u7ed3\u7b97\u5355\u72b6\u6001\uff1a" + orderStateMap.get(fscOrderPo.getOrderState() + ""), contentFont, 2, false));
                } else {
                    lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u72b6\u6001\uff1a" + orderStateMap.get(fscOrderPo.getOrderState() + ""), contentFont, 2, false));
                }
                lineOne.addCell(this.createCell("\u8ba2\u5355\u6570\u91cf\uff1a" + fscOrderPo.getOrderNum() + "\u7b14", contentFont, 0, false));
                if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u91c7\u8d2d\u7ed3\u7b97\u5355\u603b\u91d1\u989d(\u5143)\uff1a" + fscOrderPo.getTotalCharge().setScale(2), contentFont, 1, false));
                } else if (FscConstants.FSC_ORDER_PDF_TYPE.DOWN_AGM_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u9500\u552e\u7ed3\u7b97\u5355\u603b\u91d1\u989d(\u5143)\uff1a" + fscOrderPo.getTotalCharge().setScale(2), contentFont, 1, false));
                } else {
                    lineOne.addCell(this.createCell("\u7ed3\u7b97\u5355\u603b\u91d1\u989d(\u5143)\uff1a" + fscOrderPo.getTotalCharge().setScale(2), contentFont, 1, false));
                }
                lineOne.addCell(this.createCell("\u5e01\u522b\uff1a\u4eba\u6c11\u5e01", contentFont, 2, false));
                lineOne.addCell(this.createCell("\u8d39\u7528\u7c7b\u578b\uff1a" + fscOrderPo.getFscBusiTypeName(), contentFont, 0, false));
                log.info("\u7ed3\u7b97\u5355\u72b6\u6001map:{}", orderStateMap);
                log.info("OrderFlow:{}", (Object)fscOrderPo.getOrderFlow());
                log.info("OrderState:{}", (Object)fscOrderPo.getOrderState());
                if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u7ed3\u7b97\u5ba1\u6279\u5355\uff1a" + (ObjectUtil.isEmpty((Object)fscBillPayOrderCreatePdfInfoBO.getFscOrderApprovalNo()) ? "" : fscBillPayOrderCreatePdfInfoBO.getFscOrderApprovalNo()), contentFont, 1, false));
                    lineOne.addCell(this.createCell("\u53d1\u8d77\u65f6\u95f4\uff1a" + sdf.format(fscOrderPo.getCreateTime()), contentFont, 1, false));
                } else if (FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u53d1\u8d77\u65f6\u95f4\uff1a" + sdf.format(fscOrderPo.getCreateTime()), contentFont, 1, false));
                    lineOne.addCell(this.createCell("", contentFont, 2, false));
                } else if (FscConstants.FSC_ORDER_PDF_TYPE.DOWN_AGM_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER.equals(sourceType)) {
                    lineOne.addCell(this.createCell("\u7ed3\u7b97\u5ba1\u6279\u5355\uff1a" + fscBillPayOrderCreatePdfInfoBO.getFscOrderApprovalNo(), contentFont, 1, false));
                    lineOne.addCell(this.createCell("\u53d1\u8d77\u65f6\u95f4\uff1a" + sdf.format(fscOrderPo.getCreateTime()), contentFont, 2, false));
                    lineOne.addCell(this.createCell("", contentFont, 3, false));
                } else {
                    lineOne.addCell(this.createCell("\u53d1\u8d77\u65f6\u95f4\uff1a" + sdf.format(fscOrderPo.getCreateTime()), contentFont, 1, false));
                    lineOne.addCell(this.createCell("", contentFont, 2, false));
                }
            }
            try {
                document.add((Element)lineOne);
            }
            catch (DocumentException e) {
                log.info("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            }
            fscBillPayOrderCreatePdfInfoBO.setIsShowCatalogName(true);
            if (fscBillPayOrderCreatePdfInfoBO.getIsShowCatalogName().booleanValue()) {
                Paragraph l1CatalogNameTitle = null;
                l1CatalogNameTitle = fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.BILLED_INVOICE) ? new Paragraph("\u4e1a\u52a1\u5c0f\u7c7b\u6c47\u603b", titleFont) : (fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.SIGNED_INVOICE) ? new Paragraph("\u4e1a\u52a1\u5c0f\u7c7b\u6c47\u603b", titleFont) : new Paragraph("\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603b", titleFont));
                l1CatalogNameTitle.setAlignment(0);
                l1CatalogNameTitle.setLeading(30.0f);
                try {
                    document.add((Element)l1CatalogNameTitle);
                }
                catch (DocumentException e) {
                    log.info("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
                }
                try {
                    document.add((Element)p2);
                }
                catch (DocumentException e) {
                    log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                }
                List catalogNameList = fscOrderItemPOList.stream().map(FscOrderItemPO::getL1CatalogName).collect(Collectors.toList());
                UccbBatchQryCatalogRelListAbilityReqBO relListAbilityReqBO = new UccbBatchQryCatalogRelListAbilityReqBO();
                relListAbilityReqBO.setCatalogNames(catalogNameList);
                log.info("\u63a8\u9001\u7a0e\u63a7-\u67e5\u8be2\u4e1a\u52a1\u5c0f\u7c7b\u5165\u53c2:{}", (Object)relListAbilityReqBO);
                UccbBatchQryCatalogRelListAbilityRspBO rspBO = this.uccbBatchQryCatalogRelListAbilityService.batchQryCatalogRelList(relListAbilityReqBO);
                log.info("\u63a8\u9001\u7a0e\u63a7-\u67e5\u8be2\u4e1a\u52a1\u5c0f\u7c7b\u51fa\u53c2:{}", (Object)rspBO);
                if (!ObjectUtil.isEmpty((Object)rspBO.getRows())) {
                    Map<String, List<UccbBatchQryCatalogRelListBO>> uccbBatchQryCatalogRelListBOList = rspBO.getRows().stream().collect(Collectors.groupingBy(UccbBatchQryCatalogRelListBO::getCatalogName));
                    fscOrderItemPOList.forEach(item -> {
                        if (!ObjectUtil.isEmpty(uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName()))) {
                            item.setCatalogIn(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName())).get(0)).getCatalogIn());
                            item.setCatalogOut(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName())).get(0)).getCatalogOut());
                            item.setSalesReceiptsStatement(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName())).get(0)).getSalesReceiptsStatement());
                            item.setBussiCatalogName(((UccbBatchQryCatalogRelListBO)((List)uccbBatchQryCatalogRelListBOList.get(item.getL1CatalogName())).get(0)).getBussiCatalogName());
                        }
                    });
                }
                Map<Object, Object> fscOrderL1CatalogNameMap = new HashMap();
                if (fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.BILLED_INVOICE)) {
                    fscOrderL1CatalogNameMap = fscOrderItemPOList.stream().collect(Collectors.groupingBy(item -> item.getSalesReceiptsStatement()));
                } else if (fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.SIGNED_INVOICE)) {
                    fscOrderL1CatalogNameMap = fscOrderItemPOList.stream().collect(Collectors.groupingBy(item -> item.getSalesReceiptsStatement()));
                } else {
                    fscOrderItemPOList.forEach(item -> {
                        if (ObjectUtil.isEmpty((Object)item.getL1CatalogName())) {
                            item.setL1CatalogName("");
                        }
                    });
                    fscOrderL1CatalogNameMap = fscOrderItemPOList.stream().collect(Collectors.groupingBy(item -> item.getL1CatalogName()));
                }
                float[] tableFlloat = null;
                tableFlloat = fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.BILLED_INVOICE) ? new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f} : (this.hkSysTenantId.equals(reqBO.getSysTenantId()) ? new float[]{10.0f, 10.0f, 10.0f} : new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
                PdfPTable catalogNameTable = new PdfPTable(tableFlloat);
                catalogNameTable.setTotalWidth(700.0f);
                catalogNameTable.setLockedWidth(true);
                catalogNameTable.setHorizontalAlignment(1);
                catalogNameTable.getDefaultCell().setBorder(1);
                catalogNameTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
                if (fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.BILLED_INVOICE)) {
                    catalogNameTable.addCell(this.createCell("\u4e1a\u52a1\u5c0f\u7c7b", contentFont, 0, true));
                    catalogNameTable.addCell(this.createCell("\u9500\u552e\u6536\u5165\u7ed3\u7b97\u5355", contentFont, 0, true));
                } else if (fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.SIGNED_INVOICE)) {
                    catalogNameTable.addCell(this.createCell("\u4e1a\u52a1\u5c0f\u7c7b", contentFont, 0, true));
                } else {
                    catalogNameTable.addCell(this.createCell("\u4e00\u7ea7\u7c7b\u76ee", contentFont, 0, true));
                }
                if (this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                    catalogNameTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
                } else {
                    catalogNameTable.addCell(this.createCell("\u7a0e\u7387\uff08%\uff09", contentFont, 0, true));
                    catalogNameTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
                    catalogNameTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
                    catalogNameTable.addCell(this.createCell("\u7a0e\u91d1\uff08\u5143\uff09", contentFont, 0, true));
                }
                AtomicInteger catalogNameSort = new AtomicInteger(1);
                BigDecimal allPrice = fscOrderItemPOList.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal allUntaxAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal allTaxAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                fscOrderL1CatalogNameMap.forEach((k, v) -> {
                    BigDecimal amtTemp = v.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal untaxAmtTemp = v.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal taxAmt = v.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    catalogNameTable.addCell(this.createCell("(" + catalogNameSort.get() + ")", contentFont, true));
                    if (fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.BILLED_INVOICE)) {
                        catalogNameTable.addCell(this.createCell(((FscOrderItemPO)v.get(0)).getBussiCatalogName(), contentFont, false));
                        catalogNameTable.addCell(this.createCell((String)k, contentFont, false));
                    } else if (fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.SIGNED_INVOICE)) {
                        catalogNameTable.addCell(this.createCell(((FscOrderItemPO)v.get(0)).getBussiCatalogName(), contentFont, false));
                    } else {
                        catalogNameTable.addCell(this.createCell((String)k, contentFont, false));
                    }
                    if (this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                        catalogNameTable.addCell(this.createCell(amtTemp.setScale(2, 4).toString(), contentFont, false));
                    } else {
                        Double tempTax = Double.valueOf(((FscOrderItemPO)v.get(0)).getTaxRate().toString());
                        if (tempTax > 1.0) {
                            catalogNameTable.addCell(this.createCell(((FscOrderItemPO)v.get(0)).getTaxRate().setScale(0).toString() + "%", contentFont, false));
                        } else {
                            catalogNameTable.addCell(this.createCell(((FscOrderItemPO)v.get(0)).getTaxRate().multiply(new BigDecimal("100")).setScale(0).toString() + "%", contentFont, false));
                        }
                        catalogNameTable.addCell(this.createCell(amtTemp.setScale(2, 4).toString(), contentFont, false));
                        catalogNameTable.addCell(this.createCell(untaxAmtTemp.setScale(2, 4).toString(), contentFont, false));
                        catalogNameTable.addCell(this.createCell(taxAmt.setScale(2, 4).toString(), contentFont, false));
                    }
                    catalogNameSort.getAndIncrement();
                });
                catalogNameTable.addCell(this.createCell("\u5408\u8ba1", contentFont, true));
                if (fscBillPayOrderCreatePdfInfoBO.getSourceType().equals(FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER) && fscOrderPo.getOrderState().equals(FscConstants.FscServiceOrderState.BILLED_INVOICE)) {
                    catalogNameTable.addCell(this.createCell("", contentFont, false));
                }
                if (this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                    catalogNameTable.addCell(this.createCell(allPrice.setScale(2, 4).toString(), contentFont, false));
                } else {
                    catalogNameTable.addCell(this.createCell("", contentFont, false));
                    catalogNameTable.addCell(this.createCell("", contentFont, false));
                    catalogNameTable.addCell(this.createCell(allPrice.setScale(2, 4).toString(), contentFont, false));
                    catalogNameTable.addCell(this.createCell(allUntaxAmt.setScale(2, 4).toString(), contentFont, false));
                    catalogNameTable.addCell(this.createCell(allTaxAmt.setScale(2, 4).toString(), contentFont, false));
                }
                try {
                    document.add((Element)catalogNameTable);
                }
                catch (DocumentException e) {
                    log.info("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                }
            }
            String orderItemTitleStr = "\u7ed3\u7b97\u5355\u8ba2\u5355\u660e\u7ec6";
            if (FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType)) {
                orderItemTitleStr = "\u7ed3\u7b97\u5ba1\u6279\u5355\u8ba2\u5355\u660e\u7ec6";
            } else if (FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.DOWN_AGM_ORDER.equals(sourceType)) {
                orderItemTitleStr = "\u9500\u552e\u7ed3\u7b97\u5355\u8ba2\u5355\u660e\u7ec6";
            } else if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                orderItemTitleStr = "\u91c7\u8d2d\u7ed3\u7b97\u5355\u8ba2\u5355\u660e\u7ec6";
            }
            Paragraph orderItemParagraph = new Paragraph(orderItemTitleStr, titleFont);
            orderItemParagraph.setAlignment(0);
            orderItemParagraph.setLeading(30.0f);
            try {
                document.add((Element)orderItemParagraph);
            }
            catch (DocumentException e) {
                log.info("pdf\u7ed3\u7b97\u5355\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7ed3\u7b97\u5355\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
            }
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable nullTable = new PdfPTable(1);
            nullTable.addCell(this.createCell("", contentFont, 0, false));
            try {
                document.add((Element)nullTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable itemTable = null;
            itemTable = FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType) ? new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f}) : new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            itemTable.setTotalWidth(700.0f);
            itemTable.setLockedWidth(true);
            itemTable.setHorizontalAlignment(1);
            itemTable.getDefaultCell().setBorder(1);
            itemTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
            if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.MATCH_ELC_ORDER.equals(sourceType)) {
                itemTable.addCell(this.createCell("\u8ba2\u5355\u7f16\u53f7", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u5916\u90e8\u7535\u5546\u53f7", contentFont, 0, true));
            } else {
                itemTable.addCell(this.createCell("\u9a8c\u6536\u5355\u7f16\u53f7", contentFont, 0, true));
                itemTable.addCell(this.createCell("\u8ba2\u5355\u7f16\u53f7", contentFont, 0, true));
            }
            itemTable.addCell(this.createCell("\u4e0b\u5355\u65f6\u95f4", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u786e\u8ba4\u6536\u8d27\u65f6\u95f4", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u4f9b\u5e94\u5546", contentFont, 0, true));
            itemTable.addCell(this.createCell("\u8ba2\u5355\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
            if (FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                itemTable.addCell(this.createCell("\u91c7\u8d2d\u5355\u4f4d", contentFont, 0, true));
            }
            itemTable.addCell(this.createCell("\u4e0b\u5355\u4eba/\u4e0b\u5355\u4eba\u8d26\u53f7", contentFont, 0, true));
            itemTable.addCell(this.createCell("", contentFont, 0, true));
            itemTable.addCell(this.createCell("", contentFont, 0, true));
            itemTable.addCell(this.createCell("", contentFont, 0, true));
            int itemCount = 1;
            Map<Long, List<FscOrderItemPO>> fscOrderInfoBOMap = fscOrderItemPOList.stream().collect(Collectors.groupingBy(item -> item.getAcceptOrderId()));
            if (!ObjectUtil.isEmpty(fscOrderRelationPOList)) {
                for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOList) {
                    itemTable.addCell(this.createCell(itemCount > 9 ? String.valueOf(itemCount) : "0" + itemCount, contentFont, false));
                    if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.MATCH_ELC_ORDER.equals(sourceType)) {
                        itemTable.addCell(this.createCell(fscOrderRelationPO.getOrderNo(), contentFont, false));
                        itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderRelationPO.getExtOrderNo()) ? "" : fscOrderRelationPO.getExtOrderNo(), contentFont, false));
                    } else {
                        itemTable.addCell(this.createCell(fscOrderRelationPO.getAcceptOrderNo(), contentFont, false));
                        itemTable.addCell(this.createCell(fscOrderRelationPO.getOrderNo(), contentFont, false));
                    }
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderRelationPO.getOrderCreateTime()) ? "" : sdf.format(fscOrderRelationPO.getOrderCreateTime()), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderRelationPO.getAcceptCreateTime()) ? "" : sdf.format(fscOrderRelationPO.getAcceptCreateTime()), contentFont, false));
                    itemTable.addCell(this.createCell(fscOrderPo.getSupplierName(), contentFont, false));
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderRelationPO.getOrderTotalCharge()) ? "" : fscOrderRelationPO.getOrderTotalCharge().setScale(2).toString(), contentFont, false));
                    if (FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                        itemTable.addCell(this.createCell(fscOrderPo.getPurchaserName(), contentFont, false));
                    }
                    itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderRelationPO.getOrderCreateOperName()) ? "" : fscOrderRelationPO.getOrderCreateOperName(), contentFont, false));
                    itemTable.addCell(this.createCell("", contentFont, false));
                    itemTable.addCell(this.createCell("", contentFont, 0, true));
                    itemTable.addCell(this.createCell("", contentFont, 0, true));
                    ++itemCount;
                    List<FscOrderItemPO> fscOrderItemBOS = fscOrderInfoBOMap.get(fscOrderRelationPO.getAcceptOrderId());
                    if (ObjectUtil.isEmpty(fscOrderItemBOS)) continue;
                    PdfPCell goodsNum = new PdfPCell(new Phrase("\u5546\u54c1\u5e8f\u53f7", contentFont));
                    goodsNum.setHorizontalAlignment(2);
                    goodsNum.setVerticalAlignment(5);
                    itemTable.addCell(goodsNum);
                    itemTable.addCell(this.createCell("\u5546\u54c1\u540d\u79f0", contentFont, 0, true));
                    itemTable.addCell(this.createCell("\u4e00\u7ea7\u7c7b\u76ee", contentFont, 0, true));
                    itemTable.addCell(this.createCell("\u89c4\u683c", contentFont, 0, true));
                    itemTable.addCell(this.createCell("\u578b\u53f7", contentFont, 0, true));
                    itemTable.addCell(this.createCell("\u5355\u4f4d", contentFont, 0, true));
                    itemTable.addCell(this.createCell("\u6570\u91cf", contentFont, 0, true));
                    itemTable.addCell(this.createCell("\u5355\u4ef7\uff08\u5143\uff09", contentFont, 0, true));
                    if (FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                        itemTable.addCell(this.createCell("", contentFont, 0, true));
                    }
                    itemTable.addCell(this.createCell("\u5907\u6ce8", contentFont, 0, true));
                    itemTable.addCell(this.createCell("\u7ba1\u63a7\u54c1\u7c7b", contentFont, 0, true));
                    itemTable.addCell(this.createCell("\u4fe1\u521b\u5546\u54c1", contentFont, 0, true));
                    int goodsCount = 1;
                    for (FscOrderItemPO fscOrderItemPO : fscOrderItemBOS) {
                        itemTable.addCell(this.createCell("(" + goodsCount + ")", contentFont, true));
                        itemTable.addCell(this.createCell(fscOrderItemPO.getSkuName(), contentFont, false));
                        itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getL1CatalogName()) ? "" : fscOrderItemPO.getL1CatalogName(), contentFont, false));
                        itemTable.addCell(this.createCell(fscOrderItemPO.getSpec(), contentFont, false));
                        itemTable.addCell(this.createCell(fscOrderItemPO.getModel(), contentFont, false));
                        itemTable.addCell(this.createCell(fscOrderItemPO.getUnit(), contentFont, false));
                        itemTable.addCell(this.createCell(String.valueOf(fscOrderItemPO.getNum().setScale(2)), contentFont, false));
                        itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getPrice()) ? "" : fscOrderItemPO.getPrice().setScale(2).toString(), contentFont, false));
                        ++goodsCount;
                        if (FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                            itemTable.addCell(this.createCell("", contentFont, false));
                        }
                        itemTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderItemPO.getMemo()) ? "" : fscOrderItemPO.getMemo(), contentFont, false));
                        Object object = ObjectUtil.isEmpty((Object)fscOrderItemPO.getXcCategory()) ? "" : (xcCategoryStr = "0".equals(fscOrderItemPO.getXcCategory()) ? "\u5426" : "\u662f");
                        String xcSkuStr = ObjectUtil.isEmpty((Object)fscOrderItemPO.getXcSku()) ? "" : ("\u5426".equals(xcCategoryStr) ? "-" : ("0".equals(fscOrderItemPO.getXcSku()) ? "\u5426" : "\u662f"));
                        itemTable.addCell(this.createCell((String)xcCategoryStr, contentFont, false));
                        itemTable.addCell(this.createCell(xcSkuStr, contentFont, false));
                    }
                }
            }
            try {
                document.add((Element)itemTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u7ed3\u7b97\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u7ed3\u7b97\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
            }
            Map<Object, Object> fscOrderItemBOSMap = new HashMap();
            if (!ObjectUtil.isEmpty(fscInvoiceItemPOS)) {
                fscOrderItemBOSMap = fscInvoiceItemPOS.stream().collect(Collectors.groupingBy(item -> item.getInvoiceId()));
            }
            if (!ObjectUtil.isEmpty(fscInvoicePOS) && !ObjectUtil.isEmpty((Object)fscInvoicePOS.get(0).getInvoiceNo())) {
                String orderInvoiceTitleStr = "\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6";
                if (FscConstants.FSC_ORDER_PDF_TYPE.AGM_APPROVAL.equals(sourceType)) {
                    orderInvoiceTitleStr = "\u7ed3\u7b97\u5ba1\u6279\u5355\u53d1\u7968\u660e\u7ec6";
                } else if (FscConstants.FSC_ORDER_PDF_TYPE.DOWN_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.DOWN_AGM_ORDER.equals(sourceType)) {
                    orderInvoiceTitleStr = "\u9500\u552e\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6";
                } else if (FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER.equals(sourceType) || FscConstants.FSC_ORDER_PDF_TYPE.UP_AGM_ORDER.equals(sourceType)) {
                    orderInvoiceTitleStr = "\u91c7\u8d2d\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6";
                }
                Paragraph orderInvoiceItemParagraph = new Paragraph(orderInvoiceTitleStr, titleFont);
                orderInvoiceItemParagraph.setAlignment(0);
                orderInvoiceItemParagraph.setLeading(30.0f);
                try {
                    document.add((Element)orderInvoiceItemParagraph);
                }
                catch (DocumentException e) {
                    log.info("pdf\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u7ed3\u7b97\u5355\u53d1\u7968\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
                }
                try {
                    document.add((Element)p2);
                }
                catch (DocumentException e) {
                    log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                }
                PdfPTable emptyTable = new PdfPTable(1);
                emptyTable.addCell(this.createCell("", contentFont, 0, false));
                try {
                    document.add((Element)emptyTable);
                }
                catch (DocumentException e) {
                    log.info("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u7a7a\u8868\u683c\u65b0\u589e\u9519\u8bef");
                }
                DecimalFormat df = new DecimalFormat("#0.00");
                PdfPTable invTable = new PdfPTable(new float[]{10.0f, 20.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
                if (this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                    invTable = new PdfPTable(new float[]{10.0f, 20.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
                }
                invTable.setTotalWidth(700.0f);
                invTable.setLockedWidth(true);
                invTable.setHorizontalAlignment(1);
                invTable.getDefaultCell().setBorder(1);
                invTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
                invTable.addCell(this.createCell("\u6536\u7968\u65b9", contentFont, 0, true));
                invTable.addCell(this.createCell("\u53d1\u7968\u53f7\u7801", contentFont, 0, true));
                if (!this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                    invTable.addCell(this.createCell("\u53d1\u7968\u4ee3\u7801", contentFont, 0, true));
                    invTable.addCell(this.createCell("\u53d1\u7968\u7c7b\u578b", contentFont, 0, true));
                }
                invTable.addCell(this.createCell("\u53d1\u7968\u7c7b\u522b", contentFont, 0, true));
                invTable.addCell(this.createCell("\u5f00\u7968\u65e5\u671f", contentFont, 0, true));
                invTable.addCell(this.createCell("\u53d1\u7968\u603b\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
                if (this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                    invTable.addCell(this.createCell("", contentFont, 0, true));
                    invTable.addCell(this.createCell("", contentFont, 0, true));
                } else {
                    invTable.addCell(this.createCell("\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
                    invTable.addCell(this.createCell("\u7a0e\u989d\uff08\u5143\uff09", contentFont, 0, true));
                }
                int invCount = 1;
                xcCategoryStr = fscInvoicePOS.iterator();
                while (xcCategoryStr.hasNext()) {
                    FscInvoicePO fscInvoicePO = xcCategoryStr.next();
                    invTable.addCell(this.createCell(invCount > 9 ? String.valueOf(invCount) : "0" + invCount, contentFont, false));
                    if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPo.getReceiveType())) {
                        invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderPo.getPurchaserName()) ? "" : fscOrderPo.getPurchaserName(), contentFont, false));
                    }
                    if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPo.getReceiveType())) {
                        invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderPo.getProOrgName()) ? "" : fscOrderPo.getProOrgName(), contentFont, false));
                    }
                    if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(fscOrderPo.getReceiveType())) {
                        invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscOrderPo.getProOrgName()) ? "" : fscOrderPo.getProOrgName(), contentFont, false));
                    }
                    invTable.addCell(this.createCell(fscInvoicePO.getInvoiceNo(), contentFont, false));
                    if (!this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                        invTable.addCell(this.createCell(fscInvoicePO.getInvoiceCode(), contentFont, false));
                        invTable.addCell(this.createCell(invoiceTypeMap.get(fscInvoicePO.getInvoiceType()), contentFont, false));
                    }
                    invTable.addCell(this.createCell(invoiceCategoryMap.get(String.valueOf(fscInvoicePO.getInvoiceCategory())), contentFont, false));
                    invTable.addCell(this.createCell(fscInvoicePO.getBillDate(), contentFont, false));
                    invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoicePO.getAmt()) ? "" : fscInvoicePO.getAmt().setScale(2, 4).toString(), contentFont, false));
                    if (this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                        invTable.addCell(this.createCell("", contentFont, true));
                        invTable.addCell(this.createCell("", contentFont, true));
                    } else {
                        invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoicePO.getUntaxAmt()) ? "" : fscInvoicePO.getUntaxAmt().setScale(2, 4).toString(), contentFont, false));
                        BigDecimal taxAmt = ObjectUtil.isEmpty((Object)fscInvoicePO.getUntaxAmt()) || ObjectUtil.isEmpty((Object)fscInvoicePO.getAmt()) ? BigDecimal.ZERO : fscInvoicePO.getAmt().subtract(fscInvoicePO.getUntaxAmt());
                        invTable.addCell(this.createCell(taxAmt.setScale(2, 4).toString(), contentFont, false));
                    }
                    ++invCount;
                    List fscInvoicePOList = (List)fscOrderItemBOSMap.get(fscInvoicePO.getInvoiceId());
                    if (ObjectUtil.isEmpty((Object)fscInvoicePOList)) continue;
                    PdfPCell invItemNum = new PdfPCell(new Phrase("\u5546\u54c1\u5e8f\u53f7", contentFont));
                    invItemNum.setHorizontalAlignment(2);
                    invItemNum.setVerticalAlignment(5);
                    invTable.addCell(invItemNum);
                    invTable.addCell(this.createCell("\u5546\u54c1\u540d\u79f0", contentFont, 0, true));
                    invTable.addCell(this.createCell("\u89c4\u683c", contentFont, 0, true));
                    invTable.addCell(this.createCell("\u578b\u53f7", contentFont, 0, true));
                    invTable.addCell(this.createCell("\u5355\u4f4d", contentFont, 0, true));
                    invTable.addCell(this.createCell("\u6570\u91cf", contentFont, 0, true));
                    invTable.addCell(this.createCell("\u5355\u4ef7\uff08\u5143\uff09", contentFont, 0, true));
                    invTable.addCell(this.createCell("\u53d1\u7968\u91d1\u989d\uff08\u5143\uff09", contentFont, 0, true));
                    if (!this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                        invTable.addCell(this.createCell("\u7a0e\u7387", contentFont, 0, true));
                        invTable.addCell(this.createCell("\u7a0e\u989d\uff08\u5143\uff09", contentFont, 0, true));
                    }
                    int invItemCount = 1;
                    for (FscInvoiceItemPO fscInvoiceItemPO : fscInvoicePOList) {
                        invTable.addCell(this.createCell("(" + invItemCount + ")", contentFont, true));
                        invTable.addCell(this.createCell(fscInvoiceItemPO.getSkuName(), contentFont, false));
                        invTable.addCell(this.createCell(fscInvoiceItemPO.getSpec(), contentFont, false));
                        invTable.addCell(this.createCell(fscInvoiceItemPO.getModel(), contentFont, false));
                        invTable.addCell(this.createCell(fscInvoiceItemPO.getUnit(), contentFont, false));
                        invTable.addCell(this.createCell(String.valueOf(fscInvoiceItemPO.getNum().setScale(2)), contentFont, false));
                        invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getPrice()) ? "" : fscInvoiceItemPO.getPrice().setScale(2, 4).toString(), contentFont, false));
                        invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getAmt()) ? "" : fscInvoiceItemPO.getAmt().setScale(2, 4).toString(), contentFont, false));
                        if (!this.hkSysTenantId.equals(reqBO.getSysTenantId())) {
                            Double tempTax = ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getTax()) ? 0.0 : Double.valueOf(fscInvoiceItemPO.getTax().toString());
                            if (tempTax > 1.0) {
                                invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getTax()) ? "" : fscInvoiceItemPO.getTax().setScale(2).toString() + "%", contentFont, false));
                            } else {
                                invTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getTax()) ? "" : fscInvoiceItemPO.getTax().multiply(new BigDecimal("100")).setScale(2).toString() + "%", contentFont, false));
                            }
                            BigDecimal itemTaxAmt = ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getAmt()) || ObjectUtil.isEmpty((Object)fscInvoiceItemPO.getUntaxAmt()) ? BigDecimal.ZERO : fscInvoiceItemPO.getAmt().subtract(fscInvoiceItemPO.getUntaxAmt());
                            invTable.addCell(this.createCell(itemTaxAmt.setScale(2, 4).toString(), contentFont, false));
                        }
                        ++invItemCount;
                    }
                }
                try {
                    document.add((Element)invTable);
                }
                catch (DocumentException e) {
                    log.info("pdf\u7ed3\u7b97\u53d1\u7968\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u7ed3\u7b97\u53d1\u7968\u660e\u7ec6\u65b0\u589e\u9519\u8bef");
                }
            }
            if (!ObjectUtil.isEmpty(orderApprovalInfoMap)) {
                Paragraph orderApprovalTitle = new Paragraph("\u5ba1\u6279\u4fe1\u606f", titleFont);
                orderApprovalTitle.setAlignment(0);
                orderApprovalTitle.setLeading(30.0f);
                try {
                    document.add((Element)orderApprovalTitle);
                }
                catch (DocumentException e) {
                    log.info("pdf\u5ba1\u6279\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u5ba1\u6279\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                }
                try {
                    document.add((Element)p2);
                }
                catch (DocumentException e) {
                    log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                }
                orderApprovalInfoMap.forEach((key, val) -> {
                    if (!ObjectUtil.isEmpty((Object)key)) {
                        PdfPTable orderTable = new PdfPTable(1);
                        orderTable.addCell(this.createCell("\u91c7\u8d2d\u8ba2\u5355\uff1a" + key, contentFont, 0, false));
                        try {
                            document.add((Element)orderTable);
                        }
                        catch (DocumentException e) {
                            log.info("pdf\u91c7\u8d2d\u8ba2\u5355\u65b0\u589e\u9519\u8bef");
                            throw new ZTBusinessException("pdf\u7ed3\u7b97\u91c7\u8d2d\u8ba2\u5355\u65b0\u589e\u9519\u8bef");
                        }
                    }
                    PdfPTable orderApprovalTable = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
                    orderApprovalTable.setTotalWidth(700.0f);
                    orderApprovalTable.setLockedWidth(true);
                    orderApprovalTable.setHorizontalAlignment(1);
                    orderApprovalTable.getDefaultCell().setBorder(1);
                    orderApprovalTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
                    orderApprovalTable.addCell(this.createCell("\u59d3\u540d", contentFont, 0, true));
                    orderApprovalTable.addCell(this.createCell("\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784", contentFont, 0, true));
                    orderApprovalTable.addCell(this.createCell("\u4e1a\u52a1\u884c\u4e3a", contentFont, 0, true));
                    orderApprovalTable.addCell(this.createCell("\u610f\u89c1", contentFont, 0, true));
                    orderApprovalTable.addCell(this.createCell("\u64cd\u4f5c\u65f6\u95f4", contentFont, 0, true));
                    orderApprovalTable.addCell(this.createCell("\u5386\u65f6", contentFont, 0, true));
                    List tempApprovalInfo = val;
                    int approvalSort = 1;
                    for (FscEacOperationRecordsInfoBO fscEacOperationRecordsInfoBO : tempApprovalInfo) {
                        orderApprovalTable.addCell(this.createCell(String.valueOf(approvalSort), contentFont, true));
                        orderApprovalTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscEacOperationRecordsInfoBO.getUserName()) ? "" : fscEacOperationRecordsInfoBO.getUserName(), contentFont, false));
                        orderApprovalTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscEacOperationRecordsInfoBO.getOrgName()) ? "" : fscEacOperationRecordsInfoBO.getOrgName(), contentFont, false));
                        orderApprovalTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscEacOperationRecordsInfoBO.getActionStr()) ? "" : fscEacOperationRecordsInfoBO.getActionStr(), contentFont, false));
                        orderApprovalTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscEacOperationRecordsInfoBO.getResult()) ? "" : fscEacOperationRecordsInfoBO.getResult(), contentFont, false));
                        orderApprovalTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscEacOperationRecordsInfoBO.getCreateTime()) ? "" : sdf.format(fscEacOperationRecordsInfoBO.getCreateTime()), contentFont, false));
                        orderApprovalTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscEacOperationRecordsInfoBO.getAllTimeDesc()) ? "" : fscEacOperationRecordsInfoBO.getAllTimeDesc(), contentFont, false));
                        ++approvalSort;
                    }
                    try {
                        document.add((Element)orderApprovalTable);
                    }
                    catch (DocumentException e) {
                        log.info("pdf\u7ed3\u7b97\u8ba2\u5355\u5ba1\u6279\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
                        throw new ZTBusinessException("pdf\u7ed3\u7b97\u8ba2\u5355\u5ba1\u6279\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
                    }
                });
            }
            Paragraph invoiceTitle = new Paragraph("\u5f00\u7968\u4fe1\u606f", titleFont);
            invoiceTitle.setAlignment(0);
            invoiceTitle.setLeading(30.0f);
            try {
                document.add((Element)invoiceTitle);
            }
            catch (DocumentException e) {
                log.info("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            }
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            }
            String invoiceStr = invoiceTypeMap.get(fscOrderInvoicePo.getInvoiceType());
            PdfPTable table = new PdfPTable(1);
            table.addCell(this.createCell("\u53d1\u7968\u7c7b\u578b\uff1a" + invoiceStr, contentFont, 0, false));
            table.addCell(this.createCell("\u516c\u53f8\u540d\u79f0\uff1a" + fscOrderInvoicePo.getBuyName(), contentFont, 0, false));
            table.addCell(this.createCell("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a" + fscOrderInvoicePo.getTaxNo(), contentFont, 0, false));
            table.addCell(this.createCell("\u5730\u5740\uff1a" + fscOrderInvoicePo.getAddress(), contentFont, 0, false));
            table.addCell(this.createCell("\u7535\u8bdd\uff1a" + fscOrderInvoicePo.getPhone(), contentFont, 0, false));
            table.addCell(this.createCell("\u5f00\u6237\u94f6\u884c\uff1a" + fscOrderInvoicePo.getBank(), contentFont, 0, false));
            table.addCell(this.createCell("\u5f00\u6237\u8d26\u6237\uff1a" + fscOrderInvoicePo.getAccount(), contentFont, 0, false));
            List<String> marks = Arrays.asList("1,1,2", "2,1,3");
            String type = fscOrderPo.getMakeType() + "," + fscOrderPo.getReceiveType() + "," + fscOrderPo.getOrderSource();
            if (marks.contains(type)) {
                table.addCell(this.createCell("\u5907\u6ce8\uff1a" + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getMemo()) ? "" : fscOrderInvoicePo.getMemo()), contentFont, 0, false));
            } else if (fscBillPayOrderCreatePdfInfoBO.getIsShowMark().booleanValue()) {
                table.addCell(this.createCell("\u5907\u6ce8\uff1a" + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getMemo()) ? "" : fscOrderInvoicePo.getMemo()), contentFont, 0, false));
            }
            try {
                document.add((Element)table);
            }
            catch (DocumentException e) {
                log.info("pdf\u53d1\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u53d1\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            }
            Paragraph invoiceReceive = new Paragraph("\u53d1\u7968\u63a5\u6536\u4fe1\u606f", titleFont);
            invoiceReceive.setAlignment(0);
            invoiceReceive.setLeading(30.0f);
            try {
                document.add((Element)invoiceReceive);
            }
            catch (DocumentException e) {
                log.info("pdf\u6536\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u6536\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            }
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            }
            String invoiceAddr = (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getProvince()) ? "" : fscOrderInvoicePo.getProvince()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getCity()) ? "" : fscOrderInvoicePo.getCity()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getArea()) ? "" : fscOrderInvoicePo.getArea()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePo.getTown()) ? "" : fscOrderInvoicePo.getTown()) + fscOrderInvoicePo.getReceiveAddr();
            PdfPTable invoiceReceiveTable = new PdfPTable(4);
            invoiceReceiveTable.addCell(this.createCell("\u6536\u7968\u4eba\uff1a" + fscOrderInvoicePo.getReceiveName(), contentFont, 0, false));
            invoiceReceiveTable.addCell(this.createCell("\u6536\u7968\u5730\u5740\uff1a" + invoiceAddr, contentFont, 0, false));
            invoiceReceiveTable.addCell(this.createCell("\u8054\u7cfb\u7535\u8bdd\uff1a" + fscOrderInvoicePo.getReceivePhone(), contentFont, 0, false));
            invoiceReceiveTable.addCell(this.createCell("\u7535\u7968\u63a5\u6536\u90ae\u7bb1\uff1a" + fscOrderInvoicePo.getReceiveEmail(), contentFont, 0, false));
            try {
                document.add((Element)invoiceReceiveTable);
            }
            catch (DocumentException e) {
                e.printStackTrace();
                log.info("pdf\u6536\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u6536\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            }
        }
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
            innerFileUrl = this.accessUrl + path;
            fileUrl = this.ossFileUrl + path;
        } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        log.info("innerFileUrl:{}", (Object)innerFileUrl);
        log.info("fileUrl:{}", (Object)fileUrl);
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(reqBO.getPayOrderId());
        fscAttachmentPO.setFscOrderId(reqBO.getPayOrderId());
        fscAttachmentPO.setObjType(0);
        fscAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
        fscAttachmentPO.setAttachmentName(fileName);
        fscAttachmentPO.setAttachmentUrl(fileUrl);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER_PDF);
        fscAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
        fscAttachmentPO.setSysTenantName(reqBO.getSysTenantName());
        log.info("\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", (Object)fscAttachmentPO);
        this.fscAttachmentMapper.insert(fscAttachmentPO);
        fscBillPayOrderCreatePdfBusiRspBO.setUrl(fileUrl);
        return fscBillPayOrderCreatePdfBusiRspBO;
    }

    private void val(FscBillPayOrderCreatePdfBusiReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getPayOrderId())) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void createPdfParams(FscBillPayOrderCreatePdfBusiReqBO reqBO) {
        FscOrderPO payOrderInfo = new FscOrderPO();
        payOrderInfo.setFscOrderId(reqBO.getPayOrderId());
        payOrderInfo.setSysTenantId(reqBO.getSysTenantId());
        payOrderInfo = this.fscOrderMapper.getModelBy(payOrderInfo);
        if (ObjectUtil.isEmpty((Object)payOrderInfo)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u4ed8\u6b3e\u5355");
        }
        log.info("\u4ed8\u6b3e\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)payOrderInfo));
        reqBO.setPayOrderNo(payOrderInfo.getOrderNo());
        reqBO.setPayTotalAmount(payOrderInfo.getTotalCharge());
        reqBO.setPayerName(payOrderInfo.getPayerName());
        reqBO.setLastPayDate(payOrderInfo.getLastPayDate());
        Map<String, String> currencyDic = this.getUmcDic("UMC_CURRENCY_CODE", reqBO.getSysTenantId());
        reqBO.setCurrencyStr(currencyDic.get(ObjectUtil.isEmpty((Object)payOrderInfo.getCurrency()) ? "0" : String.valueOf(payOrderInfo.getCurrency())));
        FscAccountPO fscPayerAccountPO = new FscAccountPO();
        fscPayerAccountPO.setOrgId(payOrderInfo.getPayerId());
        fscPayerAccountPO.setStatus(1);
        fscPayerAccountPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscAccountPO> fscPayerAccountPOList = this.fscAccountMapper.getList(fscPayerAccountPO);
        log.info("\u83b7\u53d6\u4ed8\u6b3e\u8d26\u6237:{}", (Object)JSON.toJSONString(fscPayerAccountPOList));
        if (!ObjectUtil.isEmpty(fscPayerAccountPOList)) {
            Set accountList = fscPayerAccountPOList.stream().map(bo -> bo.getDepositBankName() + "\uff1a" + bo.getAccountNo() + "\n").collect(Collectors.toSet());
            log.info("accountList:{}", (Object)JSON.toJSONString(accountList));
            reqBO.setPayerAccount(StringUtil.join((String)"", new ArrayList(accountList)));
        }
        Map<String, String> checkStatus = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BANK_CHECK_STATUS", reqBO.getSysTenantId());
        if (FscConstants.FscPayOrderState.TO_PAY.equals(payOrderInfo.getOrderState())) {
            reqBO.setPayOrderState("\u5f85\u4ed8\u6b3e");
        } else if (FscConstants.FscPayOrderState.PAIED.equals(payOrderInfo.getOrderState())) {
            reqBO.setPayOrderState("\u5df2\u4ed8\u6b3e");
        }
        reqBO.setPayType("\u8d26\u671f\u652f\u4ed8");
        reqBO.setReimburseNo(payOrderInfo.getReimburseNo());
        reqBO.setSyncDate(payOrderInfo.getSyncTime());
        reqBO.setPayeeName(payOrderInfo.getPayeeName());
        reqBO.setShorName(payOrderInfo.getShorName());
        CrcQrySupplierBankListAbilityReqBO umcBankQryReqBO = new CrcQrySupplierBankListAbilityReqBO();
        umcBankQryReqBO.setSysTenantId(payOrderInfo.getSysTenantId());
        umcBankQryReqBO.setSupplierId(payOrderInfo.getPayeeId());
        CrcQrySupplierBankListAbilityRspBO umcBankBO = this.crcQrySupplierBankListAbilityService.qryBankList(umcBankQryReqBO);
        ArrayList<FscBillPayOrderCreatePdfPayeeInfoBO> payeeInfoListBO = new ArrayList<FscBillPayOrderCreatePdfPayeeInfoBO>();
        if (ObjectUtil.isNotEmpty((Object)umcBankBO.getBankAccountList())) {
            umcBankBO.getBankAccountList().forEach(bo -> {
                FscBillPayOrderCreatePdfPayeeInfoBO payeeInfoBO = new FscBillPayOrderCreatePdfPayeeInfoBO();
                payeeInfoBO.setPayeeBankName(bo.getAccountBankName());
                payeeInfoBO.setPayAccountTypeStr("1".equals(bo.getPayAccountType()) ? "\u76d1\u7ba1\u8d26\u6237" : "\u975e\u76d1\u7ba1\u8d26\u6237");
                payeeInfoBO.setPayeeAccount(bo.getPayAccount());
                payeeInfoBO.setIsDefalt(ObjectUtil.isEmpty((Object)bo.getExtColumn3()) ? 0 : Integer.parseInt(bo.getExtColumn3()));
                payeeInfoListBO.add(payeeInfoBO);
            });
            reqBO.setPayeeInfoListBO(payeeInfoListBO);
        }
        reqBO.setCreateOperName(payOrderInfo.getCreateOperName());
        reqBO.setFscBusiTypeName(payOrderInfo.getFscBusiTypeName());
        List<FscOrderPO> jsdList = this.fscOrderMapper.getJSDbyFKDid(reqBO.getPayOrderId(), reqBO.getSysTenantId());
        List<Long> fscOrderIds = jsdList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        List<FscOrderPO> fscOrderPOList = this.fscOrderMapper.getShouldPayOrder(fscOrderIds, reqBO.getSysTenantId());
        reqBO.setShouldPayOrderInfo(fscOrderPOList);
        List<FscBillPayOrderCreatePdfInfoBO> fscBillPayOrderCreatePdfInfoBOList = this.createFscOrderInfo(fscOrderIds, "0", reqBO.getSysTenantId());
        reqBO.setFscBillPayOrderCreatePdfInfoBOList(fscBillPayOrderCreatePdfInfoBOList);
        CrcQryPaymentBehalfAbilityReqBO crcQryPaymentBehalfAbilityReqBO = new CrcQryPaymentBehalfAbilityReqBO();
        crcQryPaymentBehalfAbilityReqBO.setCorporationId(payOrderInfo.getPayerId());
        crcQryPaymentBehalfAbilityReqBO.setOrgIdWeb(payOrderInfo.getSecondOrgId());
        log.info("\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfAbilityReqBO));
        CrcQryPaymentBehalfAbilityRspBO crcQryPaymentBehalfAbilityRspBO = this.crcQryPaymentBehalfAbilityService.qryPaymentBehalf(crcQryPaymentBehalfAbilityReqBO);
        log.info("\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfAbilityRspBO));
        if (!"0000".equals(crcQryPaymentBehalfAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("193203", "\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u9519\u8bef");
        }
        HashMap<String, List<Map<String, String>>> behalfPayerInfoMap = new HashMap<String, List<Map<String, String>>>();
        if (!ObjectUtil.isEmpty((Object)crcQryPaymentBehalfAbilityRspBO.getCfcPaymentBehalfBOS())) {
            for (CfcPaymentBehalfBO cfcPaymentBehalfBO : crcQryPaymentBehalfAbilityRspBO.getCfcPaymentBehalfBOS()) {
                ArrayList accountInfoMap = new ArrayList();
                FscAccountPO fscAccountPO = new FscAccountPO();
                fscAccountPO.setOrgId(cfcPaymentBehalfBO.getPaymentId());
                fscAccountPO.setSysTenantId(reqBO.getSysTenantId());
                List<FscAccountPO> accountPOList = this.fscAccountMapper.getList(fscAccountPO);
                if (!ObjectUtil.isEmpty(accountPOList)) {
                    for (FscAccountPO account : accountPOList) {
                        HashMap<String, String> accountMap = new HashMap<String, String>();
                        accountMap.put(account.getDepositBankName(), account.getAccountNo());
                        accountInfoMap.add(accountMap);
                    }
                }
                behalfPayerInfoMap.put(cfcPaymentBehalfBO.getPaymentName(), accountInfoMap);
            }
        }
        reqBO.setBehalfPayerInfoMap(behalfPayerInfoMap);
    }

    private List<FscBillPayOrderCreatePdfInfoBO> createFscOrderInfo(List<Long> fscOrderIds, String isProfess, Long sysTenantId) {
        ArrayList<FscBillPayOrderCreatePdfInfoBO> fscBillPayOrderCreatePdfInfoBOList = new ArrayList<FscBillPayOrderCreatePdfInfoBO>();
        if (!ObjectUtil.isEmpty(fscOrderIds)) {
            for (Long fscOrderId : fscOrderIds) {
                String isprofess;
                FscBillPayOrderCreatePdfInfoBO fscBillPayOrderCreatePdfInfoBO = new FscBillPayOrderCreatePdfInfoBO();
                FscAttachmentPO fscAttachmentOnePO = new FscAttachmentPO();
                fscAttachmentOnePO.setFscOrderId(fscOrderId);
                fscAttachmentOnePO.setAttachmentType(FscConstants.AttachmentType.FSC_ORDER_PDF);
                fscAttachmentOnePO.setSysTenantId(sysTenantId);
                List<FscAttachmentPO> attachmentMapperList = this.fscAttachmentMapper.getList(fscAttachmentOnePO);
                if (!ObjectUtil.isEmpty(attachmentMapperList)) {
                    FscAttachmentPO fscAttachmentDelPO = new FscAttachmentPO();
                    List<Long> attachmentIdList = attachmentMapperList.stream().map(FscAttachmentPO::getAttachmentId).collect(Collectors.toList());
                    fscAttachmentDelPO.setAttachmentIds(attachmentIdList);
                    fscAttachmentDelPO.setSysTenantId(sysTenantId);
                    this.fscAttachmentMapper.deleteBy(fscAttachmentDelPO);
                }
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                fscOrderPO.setSysTenantId(sysTenantId);
                FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPO);
                if (ObjectUtil.isEmpty((Object)fscOrder)) {
                    log.info("\u7ed3\u7b97\u5355id:{},\u4e0d\u5b58\u5728", (Object)fscOrderId);
                    throw new FscBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355");
                }
                FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
                fscOrderInvoicePo.setFscOrderId(fscOrderId);
                fscOrderInvoicePo.setSysTenantId(sysTenantId);
                FscOrderInvoicePO fscOrderInvoice = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
                if (ObjectUtil.isEmpty((Object)fscOrderInvoice)) {
                    log.info("\u7ed3\u7b97\u5355id:{},\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)fscOrderId);
                    throw new FscBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u53d1\u7968");
                }
                FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
                fscOrderRelationPO.setFscOrderId(fscOrderId);
                fscOrderRelationPO.setSysTenantId(sysTenantId);
                List<FscOrderRelationPO> fscOrderRelationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
                if (ObjectUtil.isEmpty(fscOrderRelationPOList)) {
                    log.info("\u7ed3\u7b97\u5355id:{},\u8ba2\u5355\u5173\u8054\u5173\u7cfb\u4e0d\u5b58\u5728", (Object)fscOrderId);
                    throw new FscBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u5173\u7cfb");
                }
                fscBillPayOrderCreatePdfInfoBO.setFscOrderRelationPOS(fscOrderRelationPOList);
                FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
                fscOrderItemPo.setFscOrderId(fscOrderId);
                fscOrderItemPo.setSysTenantId(sysTenantId);
                List<FscOrderItemPO> fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPo);
                if (ObjectUtil.isEmpty(fscOrderItemPOList)) {
                    log.info("\u7ed3\u7b97\u5355id:{},\u8ba2\u5355\u660e\u7ec6\u4e0d\u5b58\u5728", (Object)fscOrderId);
                    throw new FscBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u660e\u7ec6");
                }
                fscBillPayOrderCreatePdfInfoBO.setFscOrderItemPOS(fscOrderItemPOList);
                FscApprovalRelationPO fscApprovalRelationPo = new FscApprovalRelationPO();
                fscApprovalRelationPo.setFscOrderId(fscOrderId);
                fscApprovalRelationPo.setSysTenantId(sysTenantId);
                List<FscApprovalRelationPO> fscApprovalRelationPOS = this.fscApprovalRelationMapper.getList(fscApprovalRelationPo);
                if (!ObjectUtil.isEmpty(fscApprovalRelationPOS)) {
                    FscOrderPO fscApprovalPO = new FscOrderPO();
                    fscApprovalPO.setFscOrderId(fscApprovalRelationPOS.get(0).getFscApprovalOrderId());
                    fscApprovalPO.setSysTenantId(sysTenantId);
                    FscOrderPO approvalPO = this.fscOrderMapper.getModelBy(fscApprovalPO);
                    fscBillPayOrderCreatePdfInfoBO.setFscOrderApprovalId(approvalPO.getFscOrderId());
                    fscBillPayOrderCreatePdfInfoBO.setFscOrderApprovalNo(approvalPO.getOrderNo());
                    fscBillPayOrderCreatePdfInfoBO.setFscOrderState(approvalPO.getOrderState());
                }
                HashMap<String, List<FscEacOperationRecordsInfoBO>> orderApprovalInfoMap = new HashMap<String, List<FscEacOperationRecordsInfoBO>>();
                String string = isprofess = ObjectUtil.isEmpty((Object)isProfess) ? "1" : isProfess;
                if ("1".equals(isprofess)) {
                    for (FscOrderRelationPO orderRelationPO : fscOrderRelationPOList) {
                        FscOrderListQueryAtomReqBO fscOrderListQueryAtomReqBO = new FscOrderListQueryAtomReqBO();
                        fscOrderListQueryAtomReqBO.setSaleOrderNo(orderRelationPO.getOrderNo());
                        fscOrderListQueryAtomReqBO.setSysTenantId(sysTenantId);
                        log.info("\u83b7\u53d6\u8ba2\u5355\u5ba1\u6279id\u5165\u53c2\uff1a{}", (Object)fscOrderListQueryAtomReqBO);
                        FscOrderListQueryAtomRspBO fscOrderListQueryAtomRspBO = this.fscOrderListQueryAtomService.query(fscOrderListQueryAtomReqBO);
                        log.info("\u83b7\u53d6\u8ba2\u5355\u5ba1\u6279id\u51fa\u53c2\uff1a{}", (Object)fscOrderListQueryAtomRspBO);
                        if (ObjectUtil.isEmpty(fscOrderListQueryAtomRspBO.getRows())) continue;
                        for (FscOrderListBO fscOrderListBO : fscOrderListQueryAtomRspBO.getRows()) {
                            FscEacQueryOperationRecordsListReqBO fscEacQueryOperationRecordsListReqBO = new FscEacQueryOperationRecordsListReqBO();
                            fscEacQueryOperationRecordsListReqBO.setProcInstId(fscOrderListBO.getAuditProcId());
                            fscEacQueryOperationRecordsListReqBO.setSysTenantId(sysTenantId);
                            log.info("\u67e5\u8be2\u5ba1\u6279\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)fscEacQueryOperationRecordsListReqBO);
                            FscEacQueryOperationRecordsListRspBO fscEacQueryOperationRecordsListRspBO = this.fscEacQueryOperationRecordsListService.queryOperationRecordsList(fscEacQueryOperationRecordsListReqBO);
                            log.info("\u67e5\u8be2\u5ba1\u6279\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)fscEacQueryOperationRecordsListRspBO);
                            if (ObjectUtil.isEmpty(fscEacQueryOperationRecordsListRspBO.getRows())) continue;
                            orderApprovalInfoMap.put(orderRelationPO.getOrderNo(), fscEacQueryOperationRecordsListRspBO.getRows());
                        }
                    }
                } else if (!ObjectUtil.isEmpty((Object)fscBillPayOrderCreatePdfInfoBO.getFscOrderApprovalId())) {
                    FscEacQueryOperationRecordsListReqBO fscEacQueryOperationRecordsListReqBO = new FscEacQueryOperationRecordsListReqBO();
                    fscEacQueryOperationRecordsListReqBO.setBusinessId(fscBillPayOrderCreatePdfInfoBO.getFscOrderApprovalId().toString());
                    fscEacQueryOperationRecordsListReqBO.setSysTenantId(sysTenantId);
                    log.info("\u67e5\u8be2\u5ba1\u6279\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)fscEacQueryOperationRecordsListReqBO);
                    FscEacQueryOperationRecordsListRspBO fscEacQueryOperationRecordsListRspBO = this.fscEacQueryOperationRecordsListService.queryOperationRecordsList(fscEacQueryOperationRecordsListReqBO);
                    log.info("\u67e5\u8be2\u5ba1\u6279\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)fscEacQueryOperationRecordsListRspBO);
                    if (!ObjectUtil.isEmpty(fscEacQueryOperationRecordsListRspBO.getRows())) {
                        orderApprovalInfoMap.put("", fscEacQueryOperationRecordsListRspBO.getRows());
                    }
                }
                fscBillPayOrderCreatePdfInfoBO.setOrderApprovalInfoMap(orderApprovalInfoMap);
                FscInvoicePO fscInvoicePo = new FscInvoicePO();
                fscInvoicePo.setFscOrderId(fscOrderId);
                fscInvoicePo.setSysTenantId(sysTenantId);
                List<FscInvoicePO> fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePo);
                ArrayList<Long> inoviceIds = new ArrayList<Long>();
                if (!ObjectUtil.isEmpty(fscInvoicePOS)) {
                    fscBillPayOrderCreatePdfInfoBO.setFscInvoicePOS(fscInvoicePOS);
                    fscInvoicePOS.forEach(item -> inoviceIds.add(item.getInvoiceId()));
                    FscInvoiceItemPO fscInvoiceItemPo = new FscInvoiceItemPO();
                    fscInvoiceItemPo.setInvoiceIds(inoviceIds);
                    fscInvoiceItemPo.setSysTenantId(sysTenantId);
                    List<FscInvoiceItemPO> fscInvoiceItemPOS = this.fscInvoiceItemMapper.getList(fscInvoiceItemPo);
                    if (!ObjectUtil.isEmpty(fscInvoiceItemPOS)) {
                        fscBillPayOrderCreatePdfInfoBO.setFscInvoiceItemPOS(fscInvoiceItemPOS);
                    }
                }
                fscBillPayOrderCreatePdfInfoBO.setFscOrderPo(fscOrder);
                fscBillPayOrderCreatePdfInfoBO.setFscOrderInvoicePo(fscOrderInvoice);
                fscBillPayOrderCreatePdfInfoBO.setIsShowMark(true);
                fscBillPayOrderCreatePdfInfoBO.setSourceType(FscConstants.FSC_ORDER_PDF_TYPE.UP_ELC_ORDER);
                fscBillPayOrderCreatePdfInfoBO.setIsShowCatalogName(true);
                fscBillPayOrderCreatePdfInfoBOList.add(fscBillPayOrderCreatePdfInfoBO);
            }
        }
        return fscBillPayOrderCreatePdfInfoBOList;
    }

    private Font getFont(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCell(String title, Font font, boolean isFirst) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isFirst) {
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
        }
        return cell;
    }

    public PdfPCell createCellTop(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(4);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    private Map<String, String> getUmcDic(String pCode, Long sysTenantId) {
        Map<String, String> umcDicMap = new HashMap<String, String>();
        QueryDictionaryAbilityReqBO reqBO = new QueryDictionaryAbilityReqBO();
        reqBO.setPcode(pCode);
        reqBO.setSysTenantId(sysTenantId);
        UmcRspListBO qryRspBO = this.umcDictionaryAbilityService.queryBypCodeBackPo(reqBO);
        if ("0000".equals(qryRspBO.getRespCode()) && null != qryRspBO && !CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            umcDicMap = qryRspBO.getRows().stream().collect(Collectors.toMap(DicDictionaryBO::getCode, DicDictionaryBO::getTitle));
        }
        return umcDicMap;
    }
}

