/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.bo.FscDictionaryBusiReqBO;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.po.FscDicDictionaryPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscDictionaryBusiServiceImpl
implements FscDictionaryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDictionaryBusiServiceImpl.class);
    private static final String SYS_CODE_DEFAULT = "FSC";
    private static final Integer DIC_ORDER_ID = 1;
    @Autowired
    private FscDicDictionaryMapper dicDictionaryMapper;

    @Override
    public List<FscDicDictionaryBO> queryBypCodeBackPo(String pCode, Long sysTenantId) {
        return this.queryBypCodeBackPo(null, pCode, sysTenantId);
    }

    @Override
    public List<FscDicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode, Long sysTenantId) {
        ArrayList<FscDicDictionaryBO> dicDictionaryBOS = new ArrayList<FscDicDictionaryBO>();
        List<FscDicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(this.getDicDictionaryPO(sysCode, pCode, sysTenantId));
        if (dicDictionaryPOS != null) {
            for (FscDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                FscDicDictionaryBO dicDictionaryBO = new FscDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    @Override
    public FscRspPageBaseBO<FscDicDictionaryBO> queryBypCodeBackPoPage(FscDictionaryBusiReqBO dictionaryBusiReqBO) {
        FscDicDictionaryPO dicDictionary = new FscDicDictionaryPO();
        ArrayList<FscDicDictionaryBO> rows = new ArrayList<FscDicDictionaryBO>();
        dicDictionary.setSysCode(dictionaryBusiReqBO.getSysCode());
        dicDictionary.setPCode(dictionaryBusiReqBO.getPcode());
        dicDictionary.setTitle(dictionaryBusiReqBO.getTitle());
        dicDictionary.setSysTenantId(dictionaryBusiReqBO.getSysTenantId());
        Page page = new Page(dictionaryBusiReqBO.getPageNo().intValue(), dictionaryBusiReqBO.getPageSize().intValue());
        FscRspPageBaseBO dicDictionaryBOS = new FscRspPageBaseBO();
        List<FscDicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListPageByCondition(dicDictionary, page);
        if (dicDictionaryPOS != null) {
            for (FscDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                FscDicDictionaryBO dicDictionaryBO = new FscDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                rows.add(dicDictionaryBO);
            }
        }
        dicDictionaryBOS.setRespDesc("\u67e5\u8be2\u6210\u529f");
        dicDictionaryBOS.setRows(rows);
        dicDictionaryBOS.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        dicDictionaryBOS.setTotal(Integer.valueOf(page.getTotalPages()));
        dicDictionaryBOS.setPageNo(Integer.valueOf(page.getPageNo()));
        return dicDictionaryBOS;
    }

    @Override
    public List<FscDicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode, String title, Long sysTenantId) {
        FscDicDictionaryPO dicDictionary = new FscDicDictionaryPO();
        dicDictionary.setSysCode(sysCode);
        dicDictionary.setPCode(pCode);
        dicDictionary.setTitle(title);
        dicDictionary.setSysTenantId(sysTenantId);
        if (StringUtils.isEmpty((Object)dicDictionary.getOrderBy())) {
            dicDictionary.setOrderBy("ORDER_ID");
        }
        ArrayList<FscDicDictionaryBO> dicDictionaryBOS = new ArrayList<FscDicDictionaryBO>();
        List<FscDicDictionaryPO> dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(dicDictionary);
        if (!CollectionUtils.isEmpty(dicDictionaryPOS)) {
            for (FscDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                FscDicDictionaryBO dicDictionaryBO = new FscDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    @Override
    public Map<String, String> queryBypCodeBackMap(String pCode, Long sysTenantId) {
        return this.queryBypCodeBackMap(null, pCode, sysTenantId);
    }

    @Override
    public Map<String, String> queryBypCodeBackMap(String sysCode, String pCode, Long sysTenantId) {
        List<FscDicDictionaryPO> listPo = this.dicDictionaryMapper.getListByCondition(this.getDicDictionaryPO(sysCode, pCode, sysTenantId));
        if (listPo == null || listPo.size() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (FscDicDictionaryPO po : listPo) {
            map.put(po.getCode(), po.getTitle());
        }
        return map;
    }

    @Override
    public FscDicDictionaryBO getDictionaryByBO(FscDicDictionaryBO dicDictionaryBO) {
        FscDicDictionaryBO dictionaryBO = new FscDicDictionaryBO();
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        BeanUtils.copyProperties((Object)dicDictionaryBO, (Object)dicDictionaryModel);
        FscDicDictionaryPO dicDictionaryPO = this.dicDictionaryMapper.getModelByCondition(dicDictionaryModel);
        if (null != dicDictionaryPO) {
            BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dictionaryBO);
        }
        return dictionaryBO;
    }

    public FscDicDictionaryPO getDicDictionaryPO(String sysCode, String pCode, Long sysTenantId) {
        FscDicDictionaryPO queryDictionaryPO = new FscDicDictionaryPO();
        queryDictionaryPO.setPCode(pCode);
        if (StringUtils.isEmpty((Object)sysCode)) {
            sysCode = SYS_CODE_DEFAULT;
        }
        queryDictionaryPO.setSysCode(sysCode);
        queryDictionaryPO.setSysTenantId(sysTenantId);
        return queryDictionaryPO;
    }

    @Override
    public int updateDicDictionary(FscDicDictionaryReqBO dicDictionaryBO) {
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        dicDictionaryModel.setSysTenantId(dicDictionaryBO.getSysTenantId());
        return this.dicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    @Override
    public int addDicDictionary(FscDicDictionaryReqBO dicDictionaryBO) {
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(DIC_ORDER_ID);
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        dicDictionaryModel.setSysTenantId(dicDictionaryBO.getSysTenantId());
        dicDictionaryModel.setSysTenantName(dicDictionaryBO.getSysTenantName());
        return this.dicDictionaryMapper.insert(dicDictionaryModel);
    }

    @Override
    public int deleteDicDictionary(FscDicDictionaryReqBO dicDictionaryBO) {
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        dicDictionaryModel.setSysTenantId(dicDictionaryBO.getSysTenantId());
        return this.dicDictionaryMapper.deleteByCondition(dicDictionaryModel);
    }

    @Override
    public int checkDicBy(String code, String pCode, Long sysTenantId) {
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        dicDictionaryModel.setPCode(pCode);
        dicDictionaryModel.setCode(code);
        dicDictionaryModel.setSysTenantId(sysTenantId);
        return this.dicDictionaryMapper.getCheckBy(dicDictionaryModel);
    }
}

