/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DottedLineSeparator;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.bo.FscComPayOrderListBO;
import com.tydic.fsc.bo.FscPayEvidenceBO;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.api.FscPayBillOrderCreatePdfBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.busibase.busi.bo.FscPayBillOrderCreatePdfBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderShouldPayItemPO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPayBillOrderCreatePdfBusiServiceImpl
implements FscPayBillOrderCreatePdfBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillOrderCreatePdfBusiServiceImpl.class);
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @Override
    public FscAttachmentPO createPayBillOrderPdf(FscPayBillOrderCreatePdfBusiReqBO reqBO) {
        FscComOrderListPageQueryBusiReqBO fscComOrderListPageQueryBusiReqBO = new FscComOrderListPageQueryBusiReqBO();
        fscComOrderListPageQueryBusiReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComOrderListPageQueryBusiReqBO.setPageNo(1);
        fscComOrderListPageQueryBusiReqBO.setPageSize(10);
        fscComOrderListPageQueryBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscComOrderListPageQueryBusiRspBO fscComOrderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(fscComOrderListPageQueryBusiReqBO);
        if (ObjectUtil.isEmpty((Object)((Object)fscComOrderListPageQueryBusiRspBO))) {
            log.info("\u6536\u6b3e\u5355id:{}\u4e0d\u5b58\u5728", (Object)reqBO.getFscOrderId());
        }
        FscComOrderListBO fscComOrderListBO = (FscComOrderListBO)fscComOrderListPageQueryBusiRspBO.getRows().get(0);
        Font titleFont = this.getFont("titleFont");
        Font contentFont = this.getFont("contentFont");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), 75.0f, 75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        Paragraph paragraph = new Paragraph("\u6536\u6b3e\u901a\u77e5\u5355:" + fscComOrderListBO.getFscOrderNo(), titleFont);
        paragraph.setAlignment(1);
        paragraph.setLeading(30.0f);
        try {
            document.add((Element)paragraph);
        }
        catch (DocumentException e) {
            log.info("\u6536\u6b3e\u901a\u77e5\u5355\u6807\u9898\u6dfb\u52a0\u9519\u8bef");
            throw new ZTBusinessException("\u6536\u6b3e\u901a\u77e5\u5355\u6807\u9898\u6dfb\u52a0\u9519\u8bef");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PdfPTable lineOne = new PdfPTable(4);
        lineOne.addCell(this.createCell("\u6536\u6b3e\u5355\u4f4d\uff1a" + fscComOrderListBO.getPayeeName(), contentFont, 0, false));
        lineOne.addCell(this.createCell("\u6536\u6b3e\u94f6\u884c\uff1a" + fscComOrderListBO.getPayeeBankName(), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u6536\u6b3e\u8d26\u6237\uff1a" + fscComOrderListBO.getPayeeBankAccount(), contentFont, 2, false));
        lineOne.addCell(this.createCell("\u6536\u6b3e\u65f6\u95f4\uff1a", contentFont, 3, false));
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setOrgId(fscComOrderListBO.getPurchaserId());
        fscAccountPO.setStatus(1);
        fscAccountPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscAccountPO> fscAccountPOS = this.fscAccountMapper.getList(fscAccountPO);
        lineOne.addCell(this.createCell("\u4ed8\u6b3e\u5355\u4f4d\uff1a" + fscComOrderListBO.getPayerName(), contentFont, 0, false));
        lineOne.addCell(this.createCell("\u4ed8\u6b3e\u94f6\u884c\uff1a" + fscAccountPOS.get(0).getAccountName(), contentFont, 1, false));
        lineOne.addCell(this.createCell("\u4ed8\u6b3e\u8d26\u6237\uff1a" + fscAccountPOS.get(0).getAccountNo(), contentFont, 2, false));
        lineOne.addCell(this.createCell("\u4ed8\u6b3e\u65f6\u95f4\uff1a" + sdf.format(fscComOrderListBO.getPayTime()), contentFont, 3, false));
        lineOne.addCell(this.createCell("\u5e94\u4ed8\u91d1\u989d\uff1a" + fscComOrderListBO.getTotalCharge().setScale(2, RoundingMode.HALF_UP), contentFont, 0, false));
        lineOne.addCell(this.createCell("\u5e01\u522b\uff1a\u4eba\u6c11\u5e01", contentFont, 1, false));
        lineOne.addCell(this.createCell("\u64cd\u4f5c\u4eba\uff1a" + fscComOrderListBO.getCreateOperName(), contentFont, 2, false));
        lineOne.addCell(this.createCell("", contentFont, 3, false));
        try {
            document.add((Element)lineOne);
        }
        catch (DocumentException e) {
            log.info("\u6536\u6b3e\u901a\u77e5\u5355\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("\u6536\u6b3e\u901a\u77e5\u5355\u65b0\u589e\u9519\u8bef");
        }
        Paragraph payVoucher = new Paragraph("\u4ed8\u6b3e\u51ed\u8bc1:" + fscComOrderListBO.getBuyName(), titleFont);
        payVoucher.setAlignment(0);
        payVoucher.setLeading(20.0f);
        try {
            document.add((Element)payVoucher);
        }
        catch (DocumentException e) {
            log.info("\u6536\u6b3e\u901a\u77e5\u5355\u4ed8\u6b3e\u51ed\u8bc1\u6dfb\u52a0\u9519\u8bef");
            throw new ZTBusinessException("\u6536\u6b3e\u901a\u77e5\u5355\u4ed8\u6b3e\u51ed\u8bc1\u6dfb\u52a0\u9519\u8bef");
        }
        Paragraph payeeVoucher = new Paragraph("\u5165\u8d26\u51ed\u8bc1:" + (ObjectUtil.isEmpty((Object)fscComOrderListBO.getPayEvidenceInfo()) ? "" : ((FscPayEvidenceBO)fscComOrderListBO.getPayEvidenceInfo().get(0)).getPayEvidenceName()), titleFont);
        payeeVoucher.setAlignment(0);
        payeeVoucher.setLeading(20.0f);
        try {
            document.add((Element)payeeVoucher);
        }
        catch (DocumentException e) {
            log.info("\u6536\u6b3e\u901a\u77e5\u5355\u4ed8\u6b3e\u51ed\u8bc1\u6dfb\u52a0\u9519\u8bef");
            throw new ZTBusinessException("\u6536\u6b3e\u901a\u77e5\u5355\u4ed8\u6b3e\u51ed\u8bc1\u6dfb\u52a0\u9519\u8bef");
        }
        Page page = new Page(1, 10);
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPayItemPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscOrderShouldPayItemPO> fscOrderShouldPayItemPOList = this.fscOrderPayItemMapper.getListForDealPaySuccessPage(fscOrderPayItemPO, (Page<FscOrderPayItemPO>)page);
        if (ObjectUtil.isEmpty(fscOrderShouldPayItemPOList)) {
            log.info("\u4ed8\u6b3e\u5355:{}\u9500\u552e\u5355\u4e0d\u5b58\u5728", (Object)reqBO.getFscOrderId());
        }
        List<Long> fscOrderIds = fscOrderShouldPayItemPOList.stream().map(FscComPayOrderListBO::getFscOrderId).collect(Collectors.toList());
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderIdList(fscOrderIds);
        fscOrderItemPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscOrderItemPO> fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        Paragraph p2 = new Paragraph();
        p2.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
        if (!ObjectUtil.isEmpty(fscOrderItemPOList)) {
            Paragraph l1CatalogNameTitle = new Paragraph("\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603b", titleFont);
            l1CatalogNameTitle.setAlignment(0);
            l1CatalogNameTitle.setLeading(30.0f);
            try {
                document.add((Element)l1CatalogNameTitle);
            }
            catch (DocumentException e) {
                log.info("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u4e00\u7ea7\u7c7b\u76ee\u6c47\u603btitle\u65b0\u589e\u9519\u8bef");
            }
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u70b9\u7ebf\u65b0\u589e\u9519\u8bef");
            }
            Map<String, List<FscOrderItemPO>> fscOrderL1CatalogNameMap = fscOrderItemPOList.stream().collect(Collectors.groupingBy(item -> item.getL1CatalogName()));
            PdfPTable catalogNameTable = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            catalogNameTable.setTotalWidth(700.0f);
            catalogNameTable.setLockedWidth(true);
            catalogNameTable.setHorizontalAlignment(1);
            catalogNameTable.getDefaultCell().setBorder(1);
            catalogNameTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u4e00\u7ea7\u7c7b\u76ee", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u7a0e\u7387\uff08%\uff09", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u603b\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09\uff08\u5143\uff09", contentFont, 0, true));
            catalogNameTable.addCell(this.createCell("\u7a0e\u91d1\uff08\u5143\uff09", contentFont, 0, true));
            AtomicInteger catalogNameSort = new AtomicInteger(1);
            BigDecimal allPrice = fscOrderItemPOList.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal allUntaxAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal allTaxAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            fscOrderL1CatalogNameMap.forEach((k, v) -> {
                BigDecimal amtTemp = v.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal untaxAmtTemp = v.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal taxAmt = v.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                catalogNameTable.addCell(this.createCell("(" + catalogNameSort.get() + ")", contentFont, true));
                catalogNameTable.addCell(this.createCell((String)k, contentFont, false));
                Double tempTax = Double.valueOf(((FscOrderItemPO)v.get(0)).getTaxRate().toString());
                if (tempTax > 1.0) {
                    catalogNameTable.addCell(this.createCell(((FscOrderItemPO)v.get(0)).getTaxRate().setScale(0).toString() + "%", contentFont, false));
                } else {
                    catalogNameTable.addCell(this.createCell(((FscOrderItemPO)v.get(0)).getTaxRate().multiply(new BigDecimal("100")).setScale(0).toString() + "%", contentFont, false));
                }
                catalogNameTable.addCell(this.createCell(amtTemp.setScale(2, 4).toString(), contentFont, false));
                catalogNameTable.addCell(this.createCell(untaxAmtTemp.setScale(2, 4).toString(), contentFont, false));
                catalogNameTable.addCell(this.createCell(taxAmt.setScale(2, 4).toString(), contentFont, false));
                catalogNameSort.getAndIncrement();
            });
            catalogNameTable.addCell(this.createCell("\u5408\u8ba1", contentFont, true));
            catalogNameTable.addCell(this.createCell("", contentFont, false));
            catalogNameTable.addCell(this.createCell("", contentFont, false));
            catalogNameTable.addCell(this.createCell(allPrice.setScale(2, 4).toString(), contentFont, false));
            catalogNameTable.addCell(this.createCell(allUntaxAmt.setScale(2, 4).toString(), contentFont, false));
            catalogNameTable.addCell(this.createCell(allTaxAmt.setScale(2, 4).toString(), contentFont, false));
            try {
                document.add((Element)catalogNameTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            }
            Paragraph saleOrderTitle = new Paragraph("\u9500\u552e\u7ed3\u7b97\u5355", titleFont);
            saleOrderTitle.setAlignment(0);
            saleOrderTitle.setLeading(30.0f);
            try {
                document.add((Element)saleOrderTitle);
            }
            catch (DocumentException e) {
                log.info("pdf\u9500\u552e\u7ed3\u7b97\u5355title\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u9500\u552e\u7ed3\u7b97\u5355title\u65b0\u589e\u9519\u8bef");
            }
            try {
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable saleOrderTable = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            saleOrderTable.setTotalWidth(700.0f);
            saleOrderTable.setLockedWidth(true);
            saleOrderTable.setHorizontalAlignment(1);
            saleOrderTable.getDefaultCell().setBorder(1);
            saleOrderTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
            saleOrderTable.addCell(this.createCell("\u9500\u552e\u7ed3\u7b97\u5355\u53f7", contentFont, 0, true));
            saleOrderTable.addCell(this.createCell("\u5e94\u4ed8\u91d1\u989d(\u5143)", contentFont, 0, true));
            saleOrderTable.addCell(this.createCell("\u5df2\u4ed8\u91d1\u989d(\u5143)", contentFont, 0, true));
            saleOrderTable.addCell(this.createCell("\u5e94\u4ed8\u751f\u6210\u65f6\u95f4", contentFont, 0, true));
            saleOrderTable.addCell(this.createCell("\u6700\u665a\u4ed8\u6b3e\u65f6\u95f4", contentFont, 0, true));
            Integer saleIndex = 0;
            for (FscComPayOrderListBO fscComPayOrderListBO : fscOrderShouldPayItemPOList) {
                catalogNameTable.addCell(this.createCell(saleIndex.toString(), contentFont, false));
                catalogNameTable.addCell(this.createCell(fscComPayOrderListBO.getFscOrderNo(), contentFont, false));
                catalogNameTable.addCell(this.createCell(ObjectUtil.isEmpty((Object)fscComPayOrderListBO.getActualAmount()) ? "" : fscComPayOrderListBO.getActualAmount().setScale(2, RoundingMode.HALF_UP).toString(), contentFont, false));
                catalogNameTable.addCell(this.createCell("", contentFont, false));
                catalogNameTable.addCell(this.createCell(sdf.format(fscComPayOrderListBO.getCreateTime()), contentFont, false));
                catalogNameTable.addCell(this.createCell(sdf.format(fscComPayOrderListBO.getLastPayDate()), contentFont, false));
                Integer n = saleIndex;
                Integer n2 = saleIndex = Integer.valueOf(saleIndex + 1);
            }
            try {
                document.add((Element)catalogNameTable);
            }
            catch (DocumentException e) {
                log.info("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u5f00\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            }
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
            innerFileUrl = this.accessUrl + path;
            fileUrl = this.ossFileUrl + path;
        } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        log.info("innerFileUrl:{}", (Object)innerFileUrl);
        log.info("fileUrl:{}", (Object)fileUrl);
        fscAttachmentPO.setObjId(reqBO.getFscOrderId());
        fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
        fscAttachmentPO.setObjType(0);
        fscAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
        fscAttachmentPO.setAttachmentName(fileName);
        fscAttachmentPO.setAttachmentUrl(fileUrl);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_PAY_ORDER_PDF);
        log.info("\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", (Object)fscAttachmentPO);
        return fscAttachmentPO;
    }

    private Font getFont(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCell(String title, Font font, boolean isFirst) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isFirst) {
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
        }
        return cell;
    }
}

