/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.draw.DottedLineSeparator;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscServiceFeeCreatePdfBusiService;
import com.tydic.fsc.busibase.busi.bo.FscServiceFeeCreatePdfBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscServiceFeeCreatePdfBusiRspBO;
import com.tydic.fsc.busibase.busi.bo.FscServicePayAdjustRecodeBusiBaseBO;
import com.tydic.fsc.busibase.external.api.bo.FscServiceFeeItemPdfBO;
import com.tydic.fsc.busibase.external.api.bo.FscServiceFeePdfQryListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocFeeServiceInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocFeeServicePdfInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocFeeServicePdfInspectionDetailsListPageQueryService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderAdjustProcessMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderServiceFeeMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderAdjustProcessPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderServiceFeePO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.general.ability.api.DictionaryAbilityService;
import com.tydic.umc.general.ability.bo.DicDictionaryBO;
import com.tydic.umc.general.ability.bo.QueryDictionaryAbilityReqBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscServiceFeeCreatePdfBusiServiceImpl
implements FscServiceFeeCreatePdfBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscServiceFeeCreatePdfBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscUocFeeServicePdfInspectionDetailsListPageQueryService fscUocFeeServicePdfInspectionDetailsListPageQueryService;
    @Autowired
    private FscOrderAdjustProcessMapper fscOrderAdjustProcessMapper;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderServiceFeeMapper fscOrderServiceFeeMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private DictionaryAbilityService umcDictionaryAbilityService;

    @Override
    public FscServiceFeeCreatePdfBusiRspBO createServiceFeePdf(FscServiceFeeCreatePdfBusiReqBO reqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            throw new ZTBusinessException("\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u5b58\u5728");
        }
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrderRelationPO.setSysTenantId(reqBO.getSysTenantId());
        List<FscOrderRelationPO> fscOrderRelationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        FscOrderServiceFeePO fscOrderServiceFeePo = new FscOrderServiceFeePO();
        fscOrderServiceFeePo.setFscOrderId(reqBO.getFscOrderId());
        FscOrderServiceFeePO fscOrderServiceFeePo1 = this.fscOrderServiceFeeMapper.getModelBy(fscOrderServiceFeePo);
        CfcUniteParamQryListPageAbilityReqBO cfcUniteParamQryListPageAbilityReqBO1 = new CfcUniteParamQryListPageAbilityReqBO();
        cfcUniteParamQryListPageAbilityReqBO1.setId(FscConstants.TRADE_MODEL.SERVICE_FEE);
        CfcUniteParamQryListPageAbilityRspBO cfcUniteParamQryListPageAbilityRspBO1 = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO1);
        log.info("\u83b7\u53d6\u8fd0\u8425\u63d0\u73b0\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)cfcUniteParamQryListPageAbilityRspBO1.getRows()));
        if (ObjectUtil.isEmpty((Object)cfcUniteParamQryListPageAbilityRspBO1.getRows())) {
            log.info("YY009\u672a\u914d\u7f6e");
        }
        FscServicePayAdjustRecodeBusiBaseBO proAdjustInfo = new FscServicePayAdjustRecodeBusiBaseBO();
        FscServicePayAdjustRecodeBusiBaseBO supplierAdjustInfo = new FscServicePayAdjustRecodeBusiBaseBO();
        this.getServiceFeeAdjustInfo(reqBO, proAdjustInfo, supplierAdjustInfo);
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(reqBO.getFscOrderId());
        List<FscOrderItemPO> fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPo);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Font titleFont = this.getFont("titleFont");
        Font contentFont = this.getFont("contentFont");
        Document document = new Document(PageSize.A4.rotate(), 75.0f, 75.0f, 15.0f, 40.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        Paragraph paragraph = new Paragraph("\u9500\u552e\u6536\u5165\u7ed3\u7b97\u5355(\u7535\u5546\u64ae\u5408)\uff1a" + fscOrderPO.getOrderNo(), titleFont);
        paragraph.setAlignment(1);
        paragraph.setLeading(30.0f);
        try {
            document.add((Element)paragraph);
        }
        catch (DocumentException e) {
            log.info("\u6807\u9898\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("\u6807\u9898\u65b0\u589e\u9519\u8bef");
        }
        Map<String, String> orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE", reqBO.getSysTenantId());
        Map<String, String> currencyDic = this.getUmcDic("UMC_CURRENCY_CODE", reqBO.getSysTenantId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PdfPTable lineOne = new PdfPTable(6);
        lineOne.setTotalWidth(700.0f);
        lineOne.setLockedWidth(true);
        lineOne.setHorizontalAlignment(0);
        lineOne.addCell(this.createCellRight("\u7ed3\u7b97\u5355\u53d1\u8d77\u5355\u4f4d\uff1a", contentFont, 1, false));
        lineOne.addCell(this.createCell("" + fscOrderPO.getProOrgName(), contentFont, 1, false));
        lineOne.addCell(this.createCellRight("\u7ed3\u7b97\u5355\u5355\u636e\u7c7b\u578b\uff1a", contentFont, 1, false));
        lineOne.addCell(this.createCell("\u6708\u5ea6\u6210\u4ea4\u670d\u52a1", contentFont, 1, false));
        lineOne.addCell(this.createCellRight("\u4f9b\u5e94\u5546\u540d\u79f0\uff1a", contentFont, 1, false));
        lineOne.addCell(this.createCell("" + fscOrderPO.getSupplierName(), contentFont, 1, false));
        lineOne.addCell(this.createCellRight("\u7ed3\u7b97\u5355\u5355\u636e\u72b6\u6001\uff1a", contentFont, 1, false));
        lineOne.addCell(this.createCell("" + orderStateMap.get(fscOrderPO.getOrderState() + ""), contentFont, 1, false));
        lineOne.addCell(this.createCellRight("\u8ba2\u5355\u6570\u91cf\uff1a", contentFont, 1, false));
        lineOne.addCell(this.createCell("" + fscOrderPO.getOrderNum() + "\u7b14", contentFont, 1, false));
        lineOne.addCell(this.createCellRight("\u5b9e\u9645\u91d1\u989d(\u5143)\uff1a", contentFont, 1, false));
        lineOne.addCell(this.createCell("" + fscOrderPO.getActualAmount().setScale(2, 4).toString(), contentFont, 1, false));
        lineOne.addCell(this.createCellRight("\u53d1\u8d77\u65f6\u95f4\uff1a", contentFont, 1, false));
        lineOne.addCell(this.createCell("" + sdf.format(fscOrderPO.getCreateTime()), contentFont, 1, false));
        lineOne.addCell(this.createCellRight("\u7ed3\u7b97\u5355\u53d1\u8d77\u4eba\uff1a", contentFont, 1, false));
        lineOne.addCell(this.createCell("" + fscOrderPO.getCreateOperName(), contentFont, 1, false));
        lineOne.addCell(this.createCell("", contentFont, 2, false));
        try {
            document.add((Element)lineOne);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph p1 = new Paragraph();
        p1.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
        Paragraph preferentialTitle1 = new Paragraph("\u7ed3\u7b97\u8d27\u5e01\u4fe1\u606f", titleFont);
        preferentialTitle1.setAlignment(0);
        preferentialTitle1.setLeading(30.0f);
        try {
            document.add((Element)preferentialTitle1);
            document.add((Element)p1);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u8d27\u5e01\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u8d27\u5e01\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable preferential1 = new PdfPTable(6);
        preferential1.setTotalWidth(700.0f);
        preferential1.setLockedWidth(true);
        preferential1.setHorizontalAlignment(0);
        preferential1.addCell(this.createCellRight("\u7ed3\u7b97\u8d27\u5e01\uff1a", contentFont, 1, false));
        String fscCurrencyStr = ObjectUtil.isEmpty((Object)currencyDic.get(String.valueOf(fscOrderPO.getCurrency()))) ? "\u4eba\u6c11\u5e01" : currencyDic.get(String.valueOf(fscOrderPO.getCurrency()));
        preferential1.addCell(this.createCell("" + fscCurrencyStr, contentFont, 1, false));
        preferential1.addCell(this.createCellRight("\u539f\u8d27\u5e01\uff1a", contentFont, 1, false));
        String orderCurrencyStr = ObjectUtil.isEmpty((Object)currencyDic.get(String.valueOf(fscOrderServiceFeePo1.getOrderCurrency()))) ? "\u4eba\u6c11\u5e01" : currencyDic.get(String.valueOf(fscOrderServiceFeePo1.getOrderCurrency()));
        preferential1.addCell(this.createCell("" + orderCurrencyStr, contentFont, 1, false));
        if (fscOrderPO.getCurrency().compareTo(fscOrderServiceFeePo1.getOrderCurrency()) != 0) {
            preferential1.addCell(this.createCellRight("\u6c47\u7387\uff1a", contentFont, 1, false));
            preferential1.addCell(this.createCell("100" + orderCurrencyStr + " = " + fscOrderServiceFeePo1.getExchangeRate().multiply(new BigDecimal(100)) + fscCurrencyStr, contentFont, 1, false));
            preferential1.addCell(this.createCellRight("\u6c47\u7387\u66f4\u65b0\u65f6\u95f4\uff1a", contentFont, 1, false));
            preferential1.addCell(this.createCell("" + sdf.format(fscOrderServiceFeePo1.getExchangeRateUpdateTime()), contentFont, 1, false));
        }
        try {
            document.add((Element)preferential1);
        }
        catch (DocumentException e) {
            log.info("pdf\u7ed3\u7b97\u8d27\u5e01\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u7ed3\u7b97\u8d27\u5e01\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph p2 = new Paragraph();
        p2.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
        Paragraph preferentialTitle = new Paragraph("\u4f18\u60e0\u4fe1\u606f", titleFont);
        preferentialTitle.setAlignment(0);
        preferentialTitle.setLeading(30.0f);
        try {
            document.add((Element)preferentialTitle);
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u4f18\u60e0\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u4f18\u60e0\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable preferentialOne = new PdfPTable(6);
        preferentialOne.setTotalWidth(700.0f);
        preferentialOne.setLockedWidth(true);
        preferentialOne.setHorizontalAlignment(0);
        preferentialOne.addCell(this.createCellRight("\u7ed3\u7b97\u5355\u91d1\u989d(\u5143)\uff1a", contentFont, 1, false));
        preferentialOne.addCell(this.createCell("" + fscOrderPO.getTotalCharge().setScale(2, 4), contentFont, 1, false));
        preferentialOne.addCell(this.createCellRight("\u51cf\u514d\u91d1\u989d(\u5143)\uff1a", contentFont, 1, false));
        String perferentialAmount = fscOrderPO.getTotalCharge().subtract(null != fscOrderPO.getCreditAmount() ? fscOrderPO.getCreditAmount() : BigDecimal.ZERO).setScale(2, 4).toString();
        preferentialOne.addCell(this.createCell("" + (null != fscOrderPO.getCreditAmount() ? fscOrderPO.getCreditAmount().setScale(2, 4) : BigDecimal.ZERO), contentFont, 1, false));
        preferentialOne.addCell(this.createCellRight("\u4f18\u60e0\u540e\u7ed3\u7b97\u91d1\u989d(\u5143)\uff1a", contentFont, 1, false));
        preferentialOne.addCell(this.createCell("" + perferentialAmount, contentFont, 1, false));
        preferentialOne.addCell(this.createCellRight("\u4f18\u60e0\u64cd\u4f5c\u4eba\uff1a", contentFont, 1, false));
        preferentialOne.addCell(this.createCell("" + (ObjectUtil.isEmpty((Object)fscOrderPO.getCreateOperName()) ? "" : fscOrderPO.getCreateOperName()), contentFont, 1, false));
        preferentialOne.addCell(this.createCellRight("\u4f18\u60e0\u64cd\u4f5c\u65f6\u95f4\uff1a", contentFont, 1, false));
        preferentialOne.addCell(this.createCell("" + sdf.format(fscOrderPO.getCreateTime()), contentFont, 1, false));
        preferentialOne.addCell(this.createCell("", contentFont, 2, false));
        try {
            document.add((Element)preferentialOne);
        }
        catch (DocumentException e) {
            log.info("pdf\u4f18\u60e0\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u4f18\u60e0\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph p20 = new Paragraph();
        p20.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
        Paragraph preferentialTitle20 = new Paragraph("\u4f9b\u5e94\u5546\u6838\u5b9e\u7ed3\u679c\u53cd\u9988", titleFont);
        preferentialTitle20.setAlignment(0);
        preferentialTitle20.setLeading(30.0f);
        try {
            document.add((Element)preferentialTitle20);
            document.add((Element)p20);
        }
        catch (DocumentException e) {
            log.info("pdf\u4f9b\u5e94\u5546\u6838\u5b9e\u7ed3\u679c\u53cd\u9988title\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u4f9b\u5e94\u5546\u6838\u5b9e\u7ed3\u679c\u53cd\u9988title\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable preferentialOne20 = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
        preferentialOne20.setTotalWidth(700.0f);
        preferentialOne20.setLockedWidth(true);
        preferentialOne20.setHorizontalAlignment(0);
        preferentialOne20.addCell(this.createCellRight("\u6838\u5b9e\u7ed3\u679c\uff1a", contentFont, 1, false));
        preferentialOne20.addCell(this.createCell("" + (ObjectUtil.isNotEmpty((Object)supplierAdjustInfo.getAdjustResult()) ? ("pass".equals(supplierAdjustInfo.getAdjustResult()) ? "\u6838\u5bf9\u65e0\u8bef" : "\u670d\u52a1\u8d39\u5b58\u5728\u5dee\u5f02") : "-"), contentFont, 1, false));
        preferentialOne20.addCell(this.createCellRight("\u53cd\u9988\u4eba\uff1a", contentFont, 1, false));
        preferentialOne20.addCell(this.createCell("" + (ObjectUtil.isNotEmpty((Object)supplierAdjustInfo.getCreateOperName()) ? supplierAdjustInfo.getCreateOperName() : "-"), contentFont, 1, false));
        preferentialOne20.addCell(this.createCellRight("\u53cd\u9988\u65f6\u95f4\uff1a", contentFont, 1, false));
        preferentialOne20.addCell(this.createCell("" + (ObjectUtil.isNotEmpty((Object)supplierAdjustInfo.getCreateTime()) ? DateUtil.dateToStrLong((Date)supplierAdjustInfo.getCreateTime()) : "-"), contentFont, 1, false));
        if ("nopass".equals(supplierAdjustInfo.getAdjustResult())) {
            preferentialOne20.addCell(this.createCellRight("\u8c03\u6574\u65b9\u5411\uff1a", contentFont, 1, false));
            preferentialOne20.addCell(this.createCell("" + (BigDecimal.ZERO.compareTo(fscOrderPO.getAdjustAmount()) < 0 ? "\u8c03\u589e" : "\u8c03\u51cf"), contentFont, 1, false));
            preferentialOne20.addCell(this.createCellRight("\u7533\u8bf7\u8c03\u6574\u91d1\u989d\uff08\u5143\uff09\uff1a", contentFont, 1, false));
            preferentialOne20.addCell(this.createCell("" + (null != fscOrderPO.getAdjustAmount() ? fscOrderPO.getAdjustAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO).abs(), contentFont, 1, false));
            preferentialOne20.addCell(this.createCellRight("\u8c03\u6574\u540e\u7ed3\u7b97\u91d1\u989d\uff08\u5143\uff09\uff1a", contentFont, 1, false));
            preferentialOne20.addCell(this.createCell("" + fscOrderPO.getActualAmount().setScale(2, 4).toString(), contentFont, 1, false));
            preferentialOne20.addCell(this.createCellRight("\u7533\u8bf7\u8bf4\u660e\uff1a", contentFont, 1, false));
            preferentialOne20.addCell(this.createCellGray("" + supplierAdjustInfo.getAdjustRemark(), contentFont, 5, true, 1));
            preferentialOne20.addCell(this.createCellRight("\u9644\u4ef6\uff1a", contentFont, 1, false));
            preferentialOne20.addCell(this.createCell("" + (ObjectUtil.isNotEmpty(supplierAdjustInfo.getAttachmentBOList()) ? supplierAdjustInfo.getAttachmentBOList().stream().map(AttachmentBO::getAttachmentName).collect(Collectors.joining("      ")) : "-"), contentFont, 5, false));
        }
        try {
            document.add((Element)preferentialOne20);
        }
        catch (DocumentException e) {
            log.info("pdf\u4f18\u60e0\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u4f18\u60e0\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        if (null != proAdjustInfo && ObjectUtil.isNotEmpty((Object)proAdjustInfo.getAdjustResult())) {
            Paragraph p21 = new Paragraph();
            p21.add((Element)new Chunk((DrawInterface)new DottedLineSeparator()));
            Paragraph preferentialTitle21 = new Paragraph("\u8fd0\u8425\u65b9\u5ba1\u6838\u7ed3\u679c", titleFont);
            preferentialTitle21.setAlignment(0);
            preferentialTitle21.setLeading(30.0f);
            try {
                document.add((Element)preferentialTitle21);
                document.add((Element)p21);
            }
            catch (DocumentException e) {
                log.info("pdf\u8fd0\u8425\u65b9\u5ba1\u6838\u7ed3\u679ctitle\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u8fd0\u8425\u65b9\u5ba1\u6838\u7ed3\u679ctitle\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable preferentialOne21 = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            preferentialOne21.setTotalWidth(700.0f);
            preferentialOne21.setLockedWidth(true);
            preferentialOne21.setHorizontalAlignment(0);
            preferentialOne21.addCell(this.createCellRight("\u5ba1\u6838\u7ed3\u679c\uff1a", contentFont, 1, false));
            preferentialOne21.addCell(this.createCell("" + (ObjectUtil.isNotEmpty((Object)proAdjustInfo.getAdjustResult()) ? ("pass".equals(proAdjustInfo.getAdjustResult()) ? "\u901a\u8fc7" : "\u4e0d\u901a\u8fc7") : "-"), contentFont, 1, false));
            preferentialOne21.addCell(this.createCellRight("\u5ba1\u6838\u4eba\uff1a", contentFont, 1, false));
            preferentialOne21.addCell(this.createCell("" + (ObjectUtil.isNotEmpty((Object)proAdjustInfo.getCreateOperName()) ? proAdjustInfo.getCreateOperName() : "-"), contentFont, 1, false));
            preferentialOne21.addCell(this.createCellRight("\u5ba1\u6838\u65f6\u95f4\uff1a", contentFont, 1, false));
            preferentialOne21.addCell(this.createCell("" + (ObjectUtil.isNotEmpty((Object)proAdjustInfo.getCreateTime()) ? DateUtil.dateToStrLong((Date)proAdjustInfo.getCreateTime()) : "-"), contentFont, 1, false));
            if ("nopass".equals(proAdjustInfo.getAdjustResult())) {
                preferentialOne21.addCell(this.createCellRight("\u5ba1\u6838\u8bf4\u660e\uff1a", contentFont, 1, false));
                preferentialOne21.addCell(this.createCellGray("" + proAdjustInfo.getAdjustRemark(), contentFont, 5, true, 1));
                preferentialOne21.addCell(this.createCellRight("\u9644\u4ef6\uff1a", contentFont, 1, false));
                preferentialOne21.addCell(this.createCell("" + (ObjectUtil.isNotEmpty(proAdjustInfo.getAttachmentBOList()) ? proAdjustInfo.getAttachmentBOList().stream().map(AttachmentBO::getAttachmentName).collect(Collectors.joining("      ")) : "-"), contentFont, 5, false));
            }
            try {
                document.add((Element)preferentialOne21);
            }
            catch (DocumentException e) {
                log.info("pdf\u4f18\u60e0\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u4f18\u60e0\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            }
        }
        Paragraph invoiceTitle = new Paragraph("\u53d1\u7968\u4fe1\u606f", titleFont);
        invoiceTitle.setAlignment(0);
        invoiceTitle.setLeading(30.0f);
        try {
            document.add((Element)invoiceTitle);
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u53d1\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u53d1\u7968\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable invoiceOne = new PdfPTable(3);
        Map<String, String> invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE", reqBO.getSysTenantId());
        Map<String, String> invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY", reqBO.getSysTenantId());
        invoiceOne.addCell(this.createCell("\u53d1\u7968\u62ac\u5934\uff1a" + fscOrderInvoicePO.getBuyName(), contentFont, 1, false));
        invoiceOne.addCell(this.createCell("\u53d1\u7968\u7c7b\u578b\uff1a" + (ObjectUtil.isEmpty((Object)invoiceTypeMap.get(fscOrderInvoicePO.getInvoiceType())) ? "" : invoiceTypeMap.get(fscOrderInvoicePO.getInvoiceType())), contentFont, 1, false));
        invoiceOne.addCell(this.createCell("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a" + fscOrderInvoicePO.getTaxNo(), contentFont, 1, false));
        invoiceOne.addCell(this.createCell("\u5f00\u6237\u94f6\u884c\uff1a" + fscOrderInvoicePO.getBank(), contentFont, 1, false));
        invoiceOne.addCell(this.createCell("\u5f00\u6237\u884c\u8d26\u6237\uff1a" + fscOrderInvoicePO.getAccount(), contentFont, 1, false));
        invoiceOne.addCell(this.createCell("\u5730\u5740\uff1a" + fscOrderInvoicePO.getAddress(), contentFont, 1, false));
        invoiceOne.addCell(this.createCell("\u56fa\u5b9a\u7535\u8bdd\uff1a" + fscOrderInvoicePO.getPhone(), contentFont, 1, false));
        invoiceOne.addCell(this.createCell("\u5907\u6ce8\uff1a" + (ObjectUtil.isEmpty((Object)fscOrderInvoicePO.getMemo()) ? "\u2014\u2014" : fscOrderInvoicePO.getMemo()), contentFont, 1, false));
        invoiceOne.addCell(this.createCell("", contentFont, 1, false));
        invoiceTitle.setLeading(30.0f);
        try {
            document.add((Element)invoiceOne);
        }
        catch (DocumentException e) {
            log.info("pdf\u53d1\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u53d1\u7968\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph invoiceReceiveTitle = new Paragraph("\u53d1\u7968\u63a5\u6536\u4fe1\u606f", titleFont);
        invoiceReceiveTitle.setAlignment(0);
        invoiceReceiveTitle.setLeading(30.0f);
        try {
            document.add((Element)invoiceReceiveTitle);
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u53d1\u7968\u63a5\u6536\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u53d1\u7968\u63a5\u6536\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable invoiceReceiveOne = new PdfPTable(3);
        invoiceReceiveOne.addCell(this.createCell("\u6536\u7968\u4eba\uff1a" + (ObjectUtil.isEmpty((Object)fscOrderInvoicePO.getReceiveName()) ? "" : fscOrderInvoicePO.getReceiveName()), contentFont, 1, false));
        String invoiceAddr = (ObjectUtil.isEmpty((Object)fscOrderInvoicePO.getProvince()) ? "" : fscOrderInvoicePO.getProvince()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePO.getCity()) ? "" : fscOrderInvoicePO.getCity()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePO.getArea()) ? "" : fscOrderInvoicePO.getArea()) + (ObjectUtil.isEmpty((Object)fscOrderInvoicePO.getTown()) ? "" : fscOrderInvoicePO.getTown()) + fscOrderInvoicePO.getReceiveAddr();
        invoiceReceiveOne.addCell(this.createCell("\u6536\u7968\u5730\u5740\uff1a" + invoiceAddr, contentFont, 1, false));
        invoiceReceiveOne.addCell(this.createCell("\u8054\u7cfb\u7535\u8bdd\uff1a" + fscOrderInvoicePO.getReceivePhone(), contentFont, 1, false));
        invoiceReceiveOne.addCell(this.createCell("\u7535\u7968\u63a5\u6536\u90ae\u7bb1\uff1a" + fscOrderInvoicePO.getReceiveEmail(), contentFont, 1, false));
        try {
            document.add((Element)invoiceReceiveOne);
        }
        catch (DocumentException e) {
            log.info("pdf\u53d1\u7968\u63a5\u6536\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u53d1\u7968\u63a5\u6536\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        Paragraph payeeInfoTitle = new Paragraph("\u4ed8\u6b3e\u4fe1\u606f", titleFont);
        payeeInfoTitle.setAlignment(0);
        payeeInfoTitle.setLeading(30.0f);
        try {
            document.add((Element)payeeInfoTitle);
            document.add((Element)p2);
        }
        catch (DocumentException e) {
            log.info("pdf\u6536\u6b3e\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u6536\u6b3e\u4fe1\u606ftitle\u65b0\u589e\u9519\u8bef");
        }
        PdfPTable payeeInfoOne = new PdfPTable(3);
        payeeInfoOne.addCell(this.createCell("\u6536\u6b3e\u94f6\u884c\u6237\u540d\uff1a" + ((JSONObject)cfcUniteParamQryListPageAbilityRspBO1.getRows().get(0)).get((Object)"payeeAccountName"), contentFont, 1, false));
        payeeInfoOne.addCell(this.createCell("\u6536\u6b3e\u94f6\u884c\u8d26\u53f7\uff1a" + ((JSONObject)cfcUniteParamQryListPageAbilityRspBO1.getRows().get(0)).get((Object)"payeeAccountNo"), contentFont, 1, false));
        payeeInfoOne.addCell(this.createCell("\u6536\u6b3e\u94f6\u884c\uff1a" + ((JSONObject)cfcUniteParamQryListPageAbilityRspBO1.getRows().get(0)).get((Object)"payeeBankName"), contentFont, 1, false));
        try {
            document.add((Element)payeeInfoOne);
        }
        catch (DocumentException e) {
            log.info("pdf\u6536\u6b3e\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
            throw new ZTBusinessException("pdf\u6536\u6b3e\u4fe1\u606f\u65b0\u589e\u9519\u8bef");
        }
        if (!ObjectUtil.isEmpty(fscOrderRelationPOList)) {
            Paragraph serviceFeeItemTitle = new Paragraph("\u6210\u4ea4\u670d\u52a1\u8d39\u660e\u7ec6", titleFont);
            serviceFeeItemTitle.setAlignment(0);
            serviceFeeItemTitle.setLeading(30.0f);
            try {
                document.add((Element)serviceFeeItemTitle);
                document.add((Element)p2);
            }
            catch (DocumentException e) {
                log.info("pdf\u6210\u4ea4\u670d\u52a1\u8d39\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
                throw new ZTBusinessException("pdf\u6210\u4ea4\u670d\u52a1\u8d39\u660e\u7ec6title\u65b0\u589e\u9519\u8bef");
            }
            PdfPTable serviceFeeItemTable = new PdfPTable(new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f});
            serviceFeeItemTable.setTotalWidth(700.0f);
            serviceFeeItemTable.setLockedWidth(true);
            serviceFeeItemTable.setHorizontalAlignment(1);
            serviceFeeItemTable.getDefaultCell().setBorder(1);
            serviceFeeItemTable.addCell(this.createCell("\u5e8f\u53f7", contentFont, 0, true));
            serviceFeeItemTable.addCell(this.createCell("\u670d\u52a1\u540d\u79f0", contentFont, 0, true));
            serviceFeeItemTable.addCell(this.createCell("\u6210\u4ea4\u91d1\u989d", contentFont, 0, true));
            serviceFeeItemTable.addCell(this.createCell("\u8d39\u7387", contentFont, 0, true));
            serviceFeeItemTable.addCell(this.createCell("\u6210\u4ea4\u670d\u52a1\u8d39", contentFont, 0, true));
            serviceFeeItemTable.addCell(this.createCell("\u7a0e\u7387", contentFont, 0, true));
            serviceFeeItemTable.addCell(this.createCell("\u7a0e\u989d", contentFont, 0, true));
            serviceFeeItemTable.addCell(this.createCell("\u4e0d\u542b\u7a0e\u91d1\u989d", contentFont, 0, true));
            serviceFeeItemTable.addCell(this.createCell("\u5907\u6ce8", contentFont, 0, true));
            int sort = 1;
            if (fscOrderItemPOList.stream().filter(bo -> null == bo.getServiceFeeRate() || null == bo.getServiceFeeRate()).count() > 0L || fscOrderItemPOList.stream().filter(bo -> null == bo.getInspPurchaseMoney()).count() > 0L) {
                ArrayList<FscServiceFeeItemPdfBO> fscInspectionItemListBOList = new ArrayList<FscServiceFeeItemPdfBO>();
                List acceptIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
                FscUocFeeServiceInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = (FscUocFeeServiceInspectionDetailsListPageQueryReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscUocFeeServiceInspectionDetailsListPageQueryReqBO.class));
                int groupSize = 2000;
                List grouped = LongStream.range(0L, (int)Math.ceil(Double.valueOf(acceptIds.size()) / Double.valueOf(groupSize))).mapToObj(i -> acceptIds.subList((int)i * groupSize, Math.min(((int)i + 1) * groupSize, acceptIds.size()))).collect(Collectors.toList());
                for (List acceptIdList : grouped) {
                    fscUocInspectionDetailsListPageQueryReqBO.setInspOrderIdList(acceptIdList);
                    fscUocInspectionDetailsListPageQueryReqBO.setPageNo(1);
                    fscUocInspectionDetailsListPageQueryReqBO.setPageSize(groupSize);
                    fscUocInspectionDetailsListPageQueryReqBO.setPayServiceCode("953317067065413636");
                    FscUocFeeServicePdfInspectionDetailsListPageQueryRspBO fscUocInspectionDetailsListPageQueryRspBO = this.fscUocFeeServicePdfInspectionDetailsListPageQueryService.getPdfInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
                    log.info("\u6210\u4ea4\u670d\u52a1\u8d39pdf\u6253\u5370\u9a8c\u6536\u5355\u67e5\u8be2\u51fa\u53c2:{}", (Object)fscUocInspectionDetailsListPageQueryRspBO.getRows().size());
                    List fscUocInspectionDetailsListBOList = fscUocInspectionDetailsListPageQueryRspBO.getRows();
                    for (Object fscInspectionDetailsListBO : fscUocInspectionDetailsListBOList) {
                        fscInspectionItemListBOList.addAll(((FscServiceFeePdfQryListBO)fscInspectionDetailsListBO).getOrderItem());
                    }
                }
                log.info("\u6210\u4ea4\u670d\u52a1\u8d39pdf\u6253\u5370\u9a8c\u6536\u5355\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString(fscInspectionItemListBOList));
                Map<String, List<FscServiceFeeItemPdfBO>> inspectionItemListMap = fscInspectionItemListBOList.stream().collect(Collectors.groupingBy(o -> o.getServiceFeeRate()));
                BigDecimal totalCharge = BigDecimal.ZERO;
                BigDecimal totalSerPriceMoney = BigDecimal.ZERO;
                BigDecimal totalTaxAmount = BigDecimal.ZERO;
                BigDecimal totalUnTaxAmount = BigDecimal.ZERO;
                for (Map.Entry<String, List<FscServiceFeeItemPdfBO>> entry : inspectionItemListMap.entrySet()) {
                    List<FscServiceFeeItemPdfBO> tempList = entry.getValue();
                    String taxStr = "6";
                    BigDecimal tax = new BigDecimal(taxStr);
                    BigDecimal inspSaleMoney = BigDecimal.ZERO;
                    BigDecimal serPriceMoney = BigDecimal.ZERO;
                    BigDecimal untaxAmt = BigDecimal.ZERO;
                    for (FscServiceFeeItemPdfBO item : tempList) {
                        inspSaleMoney = inspSaleMoney.add(item.getPurPrice().multiply(new BigDecimal(item.getItemCount())));
                        serPriceMoney = serPriceMoney.add(item.getSerPriceMoney());
                    }
                    serviceFeeItemTable.addCell(this.createCell(String.valueOf(sort), contentFont, true));
                    serviceFeeItemTable.addCell(this.createCell("\u5e73\u53f0\u670d\u52a1\u8d39", contentFont, false));
                    serviceFeeItemTable.addCell(this.createCell(inspSaleMoney.setScale(2, 4).toString(), contentFont, false));
                    serviceFeeItemTable.addCell(this.createCell(tempList.get(0).getServiceFeeRate() + "%", contentFont, false));
                    serviceFeeItemTable.addCell(this.createCell(serPriceMoney.setScale(2, 4).toString(), contentFont, false));
                    serviceFeeItemTable.addCell(this.createCell(tax + "%", contentFont, false));
                    if (tax.compareTo(BigDecimal.ZERO) <= 0) {
                        serviceFeeItemTable.addCell(this.createCell("0", contentFont, false));
                        serviceFeeItemTable.addCell(this.createCell("0", contentFont, false));
                        serviceFeeItemTable.addCell(this.createCell("", contentFont, false));
                    } else {
                        BigDecimal taxAmt = serPriceMoney.divide(BigDecimal.ONE.add(tax.divide(new BigDecimal(100))), 6, 4).multiply(tax.divide(new BigDecimal(100))).setScale(2, 4);
                        untaxAmt = serPriceMoney.subtract(taxAmt);
                        serviceFeeItemTable.addCell(this.createCell(taxAmt.setScale(2, 4).toString(), contentFont, false));
                        serviceFeeItemTable.addCell(this.createCell(untaxAmt.setScale(2, 4).toString(), contentFont, false));
                        serviceFeeItemTable.addCell(this.createCell("", contentFont, false));
                        totalTaxAmount = totalTaxAmount.add(taxAmt);
                        totalUnTaxAmount = totalUnTaxAmount.add(untaxAmt);
                    }
                    totalCharge = totalCharge.add(inspSaleMoney);
                    totalSerPriceMoney = totalSerPriceMoney.add(serPriceMoney);
                    ++sort;
                }
                serviceFeeItemTable.addCell(this.createCell("\u5408\u8ba1", contentFont, 2, true));
                serviceFeeItemTable.addCell(this.createCell(totalCharge.setScale(2, 4).toString(), contentFont, false));
                serviceFeeItemTable.addCell(this.createCell("", contentFont, false));
                serviceFeeItemTable.addCell(this.createCell(totalSerPriceMoney.setScale(2, 4).toString(), contentFont, false));
                serviceFeeItemTable.addCell(this.createCell("", contentFont, false));
                serviceFeeItemTable.addCell(this.createCell(totalTaxAmount.setScale(2, 4).toString(), contentFont, false));
                serviceFeeItemTable.addCell(this.createCell(totalUnTaxAmount.setScale(2, 4).toString(), contentFont, false));
                serviceFeeItemTable.addCell(this.createCell("\u51cf\u514d\u91d1\u989d\uff1a" + fscOrderPO.getCreditAmount().setScale(2, 4), contentFont, false));
                try {
                    document.add((Element)serviceFeeItemTable);
                }
                catch (DocumentException e) {
                    log.info("pdf\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355e\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u65b0\u589e\u9519\u8bef");
                }
            }
            Map<BigDecimal, List<FscOrderItemPO>> inspectionItemListMap = fscOrderItemPOList.stream().collect(Collectors.groupingBy(o -> o.getServiceFeeRate()));
            if (!ObjectUtil.isEmpty(fscOrderItemPOList)) {
                BigDecimal totalCharge = BigDecimal.ZERO;
                BigDecimal totalSerPriceMoney = BigDecimal.ZERO;
                BigDecimal totalTaxAmount = BigDecimal.ZERO;
                BigDecimal totalUnTaxAmount = BigDecimal.ZERO;
                for (Map.Entry<BigDecimal, List<FscOrderItemPO>> entry : inspectionItemListMap.entrySet()) {
                    List<FscOrderItemPO> tempList = entry.getValue();
                    String taxStr = "6";
                    BigDecimal tax = new BigDecimal(taxStr);
                    BigDecimal inspSaleMoney = BigDecimal.ZERO;
                    BigDecimal serPriceMoney = BigDecimal.ZERO;
                    BigDecimal untaxAmt = BigDecimal.ZERO;
                    for (FscOrderItemPO item : tempList) {
                        inspSaleMoney = inspSaleMoney.add(item.getInspPurchaseMoney());
                        serPriceMoney = serPriceMoney.add(item.getSerPriceMoney());
                    }
                    serviceFeeItemTable.addCell(this.createCell(String.valueOf(sort), contentFont, true));
                    serviceFeeItemTable.addCell(this.createCell("\u5e73\u53f0\u670d\u52a1\u8d39", contentFont, false));
                    serviceFeeItemTable.addCell(this.createCell(inspSaleMoney.setScale(2, 4).toString(), contentFont, false));
                    serviceFeeItemTable.addCell(this.createCell(entry.getKey().setScale(2, 4) + "%", contentFont, false));
                    serviceFeeItemTable.addCell(this.createCell(serPriceMoney.setScale(2, 4).toString(), contentFont, false));
                    serviceFeeItemTable.addCell(this.createCell(taxStr + "%", contentFont, false));
                    if (tax.compareTo(BigDecimal.ZERO) <= 0) {
                        serviceFeeItemTable.addCell(this.createCell("0", contentFont, false));
                        serviceFeeItemTable.addCell(this.createCell("0", contentFont, false));
                        serviceFeeItemTable.addCell(this.createCell("", contentFont, false));
                    } else {
                        BigDecimal taxAmt = serPriceMoney.divide(BigDecimal.ONE.add(tax.divide(new BigDecimal(100))), 6, 4).multiply(tax.divide(new BigDecimal(100))).setScale(2, 4);
                        untaxAmt = serPriceMoney.subtract(taxAmt.setScale(2, 4));
                        serviceFeeItemTable.addCell(this.createCell(taxAmt.setScale(2, 4).toString(), contentFont, false));
                        serviceFeeItemTable.addCell(this.createCell(untaxAmt.setScale(2, 4).toString(), contentFont, false));
                        serviceFeeItemTable.addCell(this.createCell("", contentFont, false));
                        totalTaxAmount = totalTaxAmount.add(taxAmt);
                        totalUnTaxAmount = totalUnTaxAmount.add(untaxAmt);
                    }
                    totalCharge = totalCharge.add(inspSaleMoney);
                    totalSerPriceMoney = totalSerPriceMoney.add(serPriceMoney);
                    ++sort;
                }
                serviceFeeItemTable.addCell(this.createCell("\u5408\u8ba1", contentFont, 2, true));
                serviceFeeItemTable.addCell(this.createCell(totalCharge.setScale(2, 4).toString(), contentFont, false));
                serviceFeeItemTable.addCell(this.createCell("", contentFont, false));
                serviceFeeItemTable.addCell(this.createCell(totalSerPriceMoney.setScale(2, 4).toString(), contentFont, false));
                serviceFeeItemTable.addCell(this.createCell("", contentFont, false));
                serviceFeeItemTable.addCell(this.createCell(totalTaxAmount.setScale(2, 4).toString(), contentFont, false));
                serviceFeeItemTable.addCell(this.createCell(totalUnTaxAmount.setScale(2, 4).toString(), contentFont, false));
                serviceFeeItemTable.addCell(this.createCell("\u51cf\u514d\u91d1\u989d\uff1a" + fscOrderPO.getCreditAmount().setScale(2, 4), contentFont, false));
                try {
                    document.add((Element)serviceFeeItemTable);
                }
                catch (DocumentException e) {
                    log.info("pdf\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355e\u65b0\u589e\u9519\u8bef");
                    throw new ZTBusinessException("pdf\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u5355\u65b0\u589e\u9519\u8bef");
                }
            }
        }
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
            innerFileUrl = this.accessUrl + path;
            fileUrl = this.ossFileUrl + path;
        } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        log.info("innerFileUrl:{}", (Object)innerFileUrl);
        log.info("fileUrl:{}", (Object)fileUrl);
        fscAttachmentPO.setObjId(reqBO.getFscOrderId());
        fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
        fscAttachmentPO.setObjType(0);
        fscAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
        fscAttachmentPO.setAttachmentName("\u9500\u552e\u6536\u5165\u7ed3\u7b97\u5355\uff08\u7535\u5546\u64ae\u5408\uff09.pdf");
        fscAttachmentPO.setAttachmentUrl(fileUrl);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.FSC_SERVICE_FEE_ORDER_PDF);
        fscAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
        fscAttachmentPO.setSysTenantName(reqBO.getSysTenantName());
        log.info("\u9644\u4ef6\u4fdd\u5b58\u5165\u53c2:{}", (Object)fscAttachmentPO);
        this.fscAttachmentMapper.insert(fscAttachmentPO);
        FscServiceFeeCreatePdfBusiRspBO rspBO = new FscServiceFeeCreatePdfBusiRspBO();
        rspBO.setUrl(fscAttachmentPO.getAttachmentUrl());
        return rspBO;
    }

    private Font getFont(String type) {
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            log.info("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5b57\u4f53\u9519\u8bef");
        }
        Font titleFont = new Font(baseFont, 8.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        switch (type) {
            case "titleFont": {
                return titleFont;
            }
            case "contentFont": {
                return contentFont;
            }
        }
        return null;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
            cell.setColspan(colspan);
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCellRight(String title, Font font, int colspan, boolean isColor) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(2);
        cell.setVerticalAlignment(5);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
            cell.setColspan(colspan);
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
        }
        return cell;
    }

    public PdfPCell createCell(String title, Font font, int colspan, boolean isColor, int rowspan) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(4);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(242, 242, 242, 1));
            cell.setColspan(colspan);
            cell.setRowspan(rowspan);
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
            cell.setRowspan(rowspan);
        }
        return cell;
    }

    public PdfPCell createCellGray(String title, Font font, int colspan, boolean isColor, int rowspan) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setFixedHeight(30.0f);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(4);
        if (isColor) {
            cell.setBackgroundColor(new BaseColor(128, 128, 128, 1));
            cell.setColspan(colspan);
            cell.setRowspan(rowspan);
            cell.setBorder(0);
        } else {
            cell.setColspan(colspan);
            cell.setBorder(0);
            cell.setRowspan(rowspan);
        }
        return cell;
    }

    public PdfPCell createCell(String title, Font font, boolean isFirst) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        if (isFirst) {
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(5);
        }
        return cell;
    }

    public void getServiceFeeAdjustInfo(FscServiceFeeCreatePdfBusiReqBO reqBO, FscServicePayAdjustRecodeBusiBaseBO proAdjustInfo, FscServicePayAdjustRecodeBusiBaseBO supplierAdjustInfo) {
        FscOrderAdjustProcessPO fscOrderAdjustProcessPo = new FscOrderAdjustProcessPO();
        fscOrderAdjustProcessPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderAdjustProcessPo.setOrderBy(" create_time desc");
        fscOrderAdjustProcessPo.setSysTenantId(reqBO.getSysTenantId());
        List<FscOrderAdjustProcessPO> adjustProcessPOList = this.fscOrderAdjustProcessMapper.getList(fscOrderAdjustProcessPo);
        if (ObjectUtil.isNotEmpty(adjustProcessPOList)) {
            Boolean supplierFlag = false;
            Boolean proFlag = false;
            for (FscOrderAdjustProcessPO fscOrderAdjustProcessPO : adjustProcessPOList) {
                List<FscAttachmentPO> attachmentPOList;
                if (!supplierFlag.booleanValue() && FscConstants.AdjustType.SUPPLIER.equals(fscOrderAdjustProcessPO.getAdjustType())) {
                    BeanUtils.copyProperties((Object)fscOrderAdjustProcessPO, (Object)supplierAdjustInfo);
                    attachmentPOList = this.getAttachmentInfo(reqBO.getFscOrderId(), fscOrderAdjustProcessPO.getAdjustProcessId(), FscConstants.AttachmentObjType.SERVICE_FEE, FscConstants.AttachmentType.SERVICE_FEE_ADJUST, reqBO.getSysTenantId());
                    supplierAdjustInfo.setAttachmentBOList(ObjectUtil.isNotEmpty(attachmentPOList) ? JSONObject.parseArray((String)JSONObject.toJSONString(attachmentPOList), AttachmentBO.class) : null);
                    supplierFlag = true;
                }
                if (!proFlag.booleanValue() && FscConstants.AdjustType.PRO.equals(fscOrderAdjustProcessPO.getAdjustType())) {
                    BeanUtils.copyProperties((Object)fscOrderAdjustProcessPO, (Object)proAdjustInfo);
                    attachmentPOList = this.getAttachmentInfo(reqBO.getFscOrderId(), fscOrderAdjustProcessPO.getAdjustProcessId(), FscConstants.AttachmentObjType.SERVICE_FEE, FscConstants.AttachmentType.SERVICE_FEE_ADJUST, reqBO.getSysTenantId());
                    proAdjustInfo.setAttachmentBOList(ObjectUtil.isNotEmpty(attachmentPOList) ? JSONObject.parseArray((String)JSONObject.toJSONString(attachmentPOList), AttachmentBO.class) : null);
                    proFlag = true;
                }
                if (!proFlag.booleanValue() || !supplierFlag.booleanValue()) continue;
                break;
            }
        }
        if (null == supplierAdjustInfo.getAdjustAmount()) {
            supplierAdjustInfo.setAdjustAmount(BigDecimal.ZERO);
        }
        if (null == proAdjustInfo.getAdjustAmount()) {
            proAdjustInfo.setAdjustAmount(BigDecimal.ZERO);
        }
    }

    public List<FscAttachmentPO> getAttachmentInfo(Long fscOrderId, Long objId, Integer objType, Integer attachmentType, Long sysTenantId) {
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(fscOrderId);
        fscAttachmentPo.setObjId(objId);
        fscAttachmentPo.setObjType(objType);
        fscAttachmentPo.setAttachmentType(attachmentType);
        fscAttachmentPo.setSysTenantId(sysTenantId);
        List<FscAttachmentPO> attachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPo);
        return attachmentPOList;
    }

    private Map<String, String> getUmcDic(String pCode, Long sysTenantId) {
        Map<String, String> umcDicMap = new HashMap<String, String>();
        QueryDictionaryAbilityReqBO reqBO = new QueryDictionaryAbilityReqBO();
        reqBO.setPcode(pCode);
        reqBO.setSysTenantId(sysTenantId);
        UmcRspListBO qryRspBO = this.umcDictionaryAbilityService.queryBypCodeBackPo(reqBO);
        if ("0000".equals(qryRspBO.getRespCode()) && null != qryRspBO && !CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
            umcDicMap = qryRspBO.getRows().stream().collect(Collectors.toMap(DicDictionaryBO::getCode, DicDictionaryBO::getTitle));
        }
        return umcDicMap;
    }
}

