/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.busibase.comb.api.FscUocOrderRelUpdateCombService;
import com.tydic.fsc.busibase.comb.bo.FscUocOrderRelUpdateCombReqBO;
import com.tydic.fsc.busibase.comb.bo.FscUocOrderRelUpdateCombRspBO;
import com.tydic.fsc.constants.FscConstants;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscUocOrderRelUpdateCombServiceImpl
implements FscUocOrderRelUpdateCombService {
    @Value(value="${FSC_ORDER_STATUS_SYNC_ORDER_TOPIC:FSC_ORDER_STATUS_SYNC_ORDER_TOPIC}")
    private String fscOrderStatusSyncOrderTopic;
    @Value(value="${FSC_ORDER_STATUS_SYNC_ORDER_TAG:FSC_ORDER_STATUS_SYNC_ORDER_TAG}")
    private String fscOrderStatusSyncOrderTag;
    @Resource(name="fscOrderStatusSyncServiceProvider")
    private ProxyMessageProducer fscOrderStatusSyncServiceProvider;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    @Override
    public FscUocOrderRelUpdateCombRspBO dealRelUpdate(FscUocOrderRelUpdateCombReqBO reqBO) {
        ProxySendResult proxySendResult = this.fscOrderStatusSyncServiceProvider.send(new ProxyMessage(this.fscOrderStatusSyncOrderTopic, this.fscOrderStatusSyncOrderTag, JSON.toJSONString((Object)reqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO);
        }
        return new FscUocOrderRelUpdateCombRspBO();
    }

    private void writeFailLog(FscUocOrderRelUpdateCombReqBO reqBO) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ORD);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailReq(JSON.toJSONString((Object)reqBO));
        fscOrderFailLogUpdateBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderFailLogUpdateBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

