/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.busi.bo.FscBillMailListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComInvoiceListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscSearchEsSQLRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FscBuildEsQrySqlConditionUtil {
    private static Integer maxPageSize;

    @Value(value="${es.max.page.size:10000}")
    public void setMaxPageSize(Integer maxPageSize) {
        FscBuildEsQrySqlConditionUtil.maxPageSize = maxPageSize;
    }

    public String buildComOrderEsSql(FscComOrderListPageQueryBusiReqBO reqBO) {
        RangeQueryBuilder rangeQueryBuilder;
        Number invoiceNoEnd;
        Number invoiceNoBegin;
        RangeQueryBuilder rangeQueryBuilder2;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getSupplierId() != null && reqBO.getSupplierId() != 0L) {
            if (ObjectUtil.isNotEmpty(reqBO.getSupplierIdList())) {
                List<Long> supplierIdList = reqBO.getSupplierIdList();
                supplierIdList.add(reqBO.getSupplierId());
                reqBO.setSupplierIdList(supplierIdList);
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplierId", (Object)reqBO.getSupplierId()));
            }
        }
        if (ObjectUtil.isNotEmpty(reqBO.getSupplierIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplierId", reqBO.getSupplierIdList()));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getIsCreatePayOrder())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isCreatePayOrder", (Object)reqBO.getIsCreatePayOrder()));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getPayeeAccountNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payeeAccountNo", (String)reqBO.getPayeeAccountNo()));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getAgreementVariety())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreementVariety", (String)reqBO.getAgreementVariety()));
        }
        if (ObjectUtil.isNotEmpty(reqBO.getQryPayerIds()) || ObjectUtil.isNotEmpty(reqBO.getQryPayerNames())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            if (ObjectUtil.isNotEmpty(reqBO.getQryPayerIds())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"payerId", reqBO.getQryPayerIds()));
            }
            if (ObjectUtil.isNotEmpty(reqBO.getQryPayerNames())) {
                Iterator<Object> qryPayerNames = new ArrayList<String>();
                reqBO.getQryPayerNames().forEach(bo -> {
                    if (bo.contains("(")) {
                        qryPayerNames.add(bo.replace("(", "\uff08").replace(")", "\uff09"));
                    }
                    if (bo.contains("\uff08")) {
                        qryPayerNames.add(bo.replace("\uff08", "(").replace("\uff09", ")"));
                    }
                });
                qryPayerNames.addAll(reqBO.getQryPayerNames());
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"payerName.keyword", qryPayerNames));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (reqBO.getQueryId() != null && reqBO.getQueryId() != 0L) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"payerId", (Object)reqBO.getQueryId()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"payeeId", (Object)reqBO.getQueryId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getFailReason())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"invoiceSyncFailReason.keyword", (String)("*" + reqBO.getFailReason() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"syncFailReason.keyword", (String)("*" + reqBO.getFailReason() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getAutoCreateState())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"autoCreateState", (Object)reqBO.getAutoCreateState()));
        }
        if (reqBO.getCreateOperId() != null && reqBO.getCreateOperId() != 0L || reqBO.getCreateOperId() == null && reqBO.getCreateOrgId() != null && reqBO.getCreateOrgId() != 0L) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            if (!(ObjectUtil.isEmpty(reqBO.getPurOrgIdList()) && ObjectUtil.isEmpty(reqBO.getPurOrgPathList()) || ObjectUtil.isEmpty(reqBO.getPurOrgIdList()))) {
                for (Long id : reqBO.getPurOrgIdList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"swapOrgId", (Object)id));
                }
            }
            if (!ObjectUtil.isEmpty(reqBO.getToPayerIds())) {
                for (Long toPayId : reqBO.getToPayerIds()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"payerId", (Object)toPayId));
                }
            }
            if (!ObjectUtil.isEmpty(reqBO.getToPayerNames())) {
                for (String toPayName : reqBO.getToPayerNames()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"payerName", (String)toPayName));
                }
            }
            if (!ObjectUtil.isEmpty(reqBO.getPurOrgPathList())) {
                for (String path : reqBO.getPurOrgPathList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"swapOrgPath.keyword", (String)("*" + path + "*")));
                }
            }
            if (reqBO.getCreateOperId() != null && reqBO.getCreateOperId() != 0L) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"swapUserId", (Object)reqBO.getCreateOperId()));
            }
            if (reqBO.getCreateOperId() == null && reqBO.getCreateOrgId() != null && reqBO.getCreateOrgId() != 0L) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"swapOrgId", (Object)reqBO.getCreateOrgId()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (reqBO.getSysTenantId() != null && reqBO.getSysTenantId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sysTenantId", (Object)reqBO.getSysTenantId()));
        }
        if (reqBO.getOrderSysTenantId() != null && reqBO.getOrderSysTenantId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSysTenantId", (Object)reqBO.getOrderSysTenantId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateSourceType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderCreateSourceType.keyword", (String)("*" + reqBO.getOrderCreateSourceType() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceReceiverName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"invoiceReceiverName.keyword", (String)("*" + reqBO.getInvoiceReceiverName() + "*")));
        }
        if (reqBO.getPurchaserId() != null && reqBO.getPurchaserId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaserId", (Object)reqBO.getPurchaserId()));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getRollBackBankFileItem())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"rollBackBankFileItem", (Object)reqBO.getRollBackBankFileItem()));
        }
        if (reqBO.getSecondOrgId() != null && reqBO.getSecondOrgId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"secondOrgId", (Object)reqBO.getSecondOrgId()));
        }
        if (!ObjectUtil.isEmpty(reqBO.getPurchaserIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserId", reqBO.getPurchaserIds()));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getCurrency())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"currency", (Object)reqBO.getCurrency()));
        }
        if (!ObjectUtil.isEmpty(reqBO.getPorNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserId", reqBO.getPorNoList()));
        }
        if (reqBO.getProOrgId() != null && reqBO.getProOrgId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"proOrgId", (Object)reqBO.getProOrgId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderNo.keyword", (String)("*" + reqBO.getOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShorName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"shorName.keyword", (String)("*" + reqBO.getShorName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getJsdOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"busiObjectNo.keyword", (String)("*" + reqBO.getJsdOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderOrderNoList.keyword", (String)("*" + reqBO.getOrderOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBusiObjectNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"busiObjectNo.keyword", (String)("*" + reqBO.getBusiObjectNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderNo.keyword", (String)("*" + reqBO.getSaleOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupplierName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"supplierName.keyword", (String)("*" + reqBO.getSupplierName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaserName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaserName.keyword", (String)("*" + reqBO.getPurchaserName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderConfirmName.keyword", (String)("*" + reqBO.getOrderConfirmName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExtOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"extOrderNo.keyword", (String)("*" + reqBO.getExtOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getFscOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"fscOrderNo.keyword", (String)("*" + reqBO.getFscOrderNo() + "*")));
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscOrderNos())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"fscOrderNo.keyword", reqBO.getFscOrderNos()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getFscApprovalOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"fscApprovalOrderNo.keyword", (String)("*" + reqBO.getFscApprovalOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreditNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"creditNo.keyword", (String)("*" + reqBO.getCreditNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"payOperName.keyword", (String)("*" + reqBO.getPayOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"payConfirmName.keyword", (String)("*" + reqBO.getPayConfirmName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"acceptOrderNo.keyword", (String)("*" + reqBO.getAcceptOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"discountOperName.keyword", (String)("*" + reqBO.getDiscountOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPreviousHandler())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"previousHandler.keyword", (String)("*" + reqBO.getPreviousHandler() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"auditOperName.keyword", (String)("*" + reqBO.getAuditOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeBegin())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getCreateTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getCreateTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldCreateTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getShouldCreateTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"shouldCreateTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldCreateTimeBegin())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getShouldCreateTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldCreateTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getShouldCreateTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getArrivalTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getArrivalTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"arrivalTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getArrivalTimeStart())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getArrivalTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getArrivalTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getArrivalTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getAuditTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"auditTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditTimeStart())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getAuditTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getAuditTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"payConfirmTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmTimeStart())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getPayConfirmTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getPayConfirmTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBillTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getBillTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"billDate");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getBillTimeBegin())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getBillTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getBillTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getBillTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBillDateStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getBillDateEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"billDate");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getBillDateStart())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getBillDateStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getBillDateEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getBillDateEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"orderConfirmTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmTimeStart())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getOrderConfirmTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getOrderConfirmTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSignTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getSignTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"signTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSignTimeBegin())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getSignTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSignTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getSignTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"invoiceType", (Object)reqBO.getInvoiceType()));
        }
        if (reqBO.getBillCycle() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"billCycle", (Object)reqBO.getBillCycle()));
        }
        if (reqBO.getCreditAmount() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"creditAmountStr.keyword", (String)("*" + reqBO.getCreditAmount().stripTrailingZeros().toPlainString() + "*")));
        }
        if (reqBO.getInvoiceAmount() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"invoiceAmountList", (Object[])new Object[]{reqBO.getInvoiceAmount().setScale(2, 1)}));
        }
        if (reqBO.getInvoiceState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"invoiceStateList", (Object)reqBO.getInvoiceState()));
        }
        if (reqBO.getInvStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"invStatus", (Object)reqBO.getInvStatus()));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getRedInvoiceApplyId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"redInvoiceApplyId", (String)reqBO.getRedInvoiceApplyId()));
        }
        if (reqBO.getAuditType() != null && (long)reqBO.getAuditType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"auditType", (Object)reqBO.getAuditType()));
        }
        if (null != reqBO.getInvoiceCategory()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"invoiceCategory", (Object)reqBO.getInvoiceCategory()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNoBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNoEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"invoiceNo");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNoBegin())) {
                invoiceNoBegin = Long.parseLong(reqBO.getInvoiceNoBegin());
                rangeQueryBuilder2.gte((Object)invoiceNoBegin);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNoEnd())) {
                invoiceNoEnd = Long.parseLong(reqBO.getInvoiceNoEnd());
                rangeQueryBuilder2.lte((Object)invoiceNoEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"discountOperTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperTimeStart())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getDiscountOperTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getDiscountOperTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBuyName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"buyName", (Object)reqBO.getBuyName()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getTaskOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskOperIdList", reqBO.getTaskOperIdList()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAuditDealResultQryKeys())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"fscEsAuditTaskInfoBO.auditDealResultQryKey.keyword", reqBO.getAuditDealResultQryKeys()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAuditStatuss())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"auditStatus", reqBO.getAuditStatuss()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAuditedTaskOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"auditedTaskOperIdList", reqBO.getAuditedTaskOperIdList()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAuditedPostIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"auditedPostIdList", reqBO.getAuditedPostIdList()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getConsignee())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"receiverName.keyword", (String)("*" + reqBO.getConsignee() + "*")));
        }
        if (!CollectionUtils.isEmpty(reqBO.getInspectionOper())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"inspectionOper", reqBO.getInspectionOper()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBuyer())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purPlaceOrderName.keyword", (String)("*" + reqBO.getBuyer() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getAccountNoType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"accountNoType.keyword", (String)reqBO.getAccountNoType()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getAccountNoTypeNot())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)"accountNoType.keyword", (String)reqBO.getAccountNoTypeNot()));
        }
        if (reqBO.getAccountSetId() != null && reqBO.getAccountSetId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"accountSetId", (Object)reqBO.getAccountSetId()));
        }
        if (null != reqBO.getOrderSource() && reqBO.getOrderSource() != 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", (Object)reqBO.getOrderSource()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderFlows())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderFlow", reqBO.getOrderFlows()));
        }
        if (reqBO.getBuildAction() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"buildAction", (Object)reqBO.getBuildAction()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayerIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"payerId", reqBO.getPayerIds()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayeeIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"payeeId", reqBO.getPayeeIds()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderStates())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderState", reqBO.getOrderStates()));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getPayState())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"payState", Arrays.asList(reqBO.getPayState())));
        }
        if (!CollectionUtils.isEmpty(reqBO.getServiceFreeOrderStates())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"serviceFreeState", reqBO.getServiceFreeOrderStates()));
        }
        if (null != reqBO.getBusiCategory()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"busiCategory", (Object)reqBO.getBusiCategory()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayChannel())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payChannel", (String)reqBO.getPayChannel()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTransactionId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"transactionId.keyword", (String)("*" + reqBO.getTransactionId() + "*")));
        }
        if (null != reqBO.getTotalChargeStart() || null != reqBO.getTotalChargeEnd()) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"totalCharge");
            if (null != reqBO.getTotalChargeStart()) {
                invoiceNoBegin = reqBO.getTotalChargeStart().doubleValue();
                rangeQueryBuilder2.gte((Object)invoiceNoBegin);
            }
            if (null != reqBO.getTotalChargeEnd()) {
                invoiceNoEnd = reqBO.getTotalChargeEnd().doubleValue();
                rangeQueryBuilder2.lte((Object)invoiceNoEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldPayDateStart())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"shouldPayDateStart");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldPayDateStart())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getShouldPayDateStart()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldPayDateEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"shouldPayDateEnd");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldPayDateEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getShouldPayDateEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getPayTimeEnd())) {
            rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"payTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPayTimeStart())) {
                rangeQueryBuilder2.gte((Object)this.getTime(reqBO.getPayTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPayTimeEnd())) {
                rangeQueryBuilder2.lte((Object)this.getTime(reqBO.getPayTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (!CollectionUtils.isEmpty(reqBO.getShouldPayTypes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"shouldPayType", reqBO.getShouldPayTypes()));
        }
        if (reqBO.getMakeType() != null && (long)reqBO.getMakeType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"makeType", (Object)reqBO.getMakeType()));
        }
        if (reqBO.getReceiveType() != null && (long)reqBO.getReceiveType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"receiveType", (Object)reqBO.getReceiveType()));
        }
        SortOrder order = SortOrder.DESC;
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        FieldSortBuilder sortQueryFirst = null;
        if (!ObjectUtil.isEmpty((Object)reqBO.getOrderBy())) {
            order = SortOrder.DESC;
            String[] sortItem = reqBO.getOrderBy().split(",");
            for (int i = 0; i < sortItem.length; ++i) {
                order = "syncState".equals(sortItem[i]) || "createTime".equals(sortItem[i]) ? SortOrder.ASC : SortOrder.DESC;
                fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)sortItem[i]).order(order));
            }
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscOrderIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"fscOrderId", reqBO.getFscOrderIds()));
        }
        if (reqBO.getFscOrderId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"fscOrderId", (Object)reqBO.getFscOrderId()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getFscBusiType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"fscBusiType", (Object)reqBO.getFscBusiType()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getFscBusiTypeName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"fscBusiTypeName.keyword", (String)("*" + reqBO.getFscBusiTypeName() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getFscBusiTypeItem())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"fscBusiTypeItem", (Object)reqBO.getFscBusiTypeItem()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getFscBusiTypeItemName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"fscBusiTypeItemName.keyword", (String)("*" + reqBO.getFscBusiTypeItemName() + "*")));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getSyncState())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"syncState", (Object)reqBO.getSyncState()));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getPayOrderSyncState())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payOrderSyncState", (Object)reqBO.getPayOrderSyncState()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getSyncStates())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"syncState", reqBO.getSyncStates()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getPurchaserIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaserId", reqBO.getPurchaserIds()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSyncTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getSyncTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"syncTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSyncTimeBegin())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getSyncTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSyncTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getSyncTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPayeeName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"payeeName.keyword", (String)("*" + reqBO.getPayeeName() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPayerName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"payerName.keyword", (String)("*" + reqBO.getPayerName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getLastPayDateStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getLastPayDateEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"lastPayDate");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getLastPayDateStart())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getLastPayDateStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getLastPayDateEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getLastPayDateEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBO.getShouldTotalChargeS())) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"totalCharge", reqBO.getShouldTotalChargeS()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getShouldFscOrderNoS())) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"fscOrderNo.keyword", reqBO.getShouldFscOrderNoS()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPayOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"payOrderNo.keyword", (String)("*" + reqBO.getPayOrderNo() + "*")));
        }
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        if (reqBO.getIsOrderBy().booleanValue() && !ObjectUtil.isEmpty((Object)sortQueryFirst)) {
            fieldSortBuilders.add(sortQueryFirst);
        }
        if ("YES".equalsIgnoreCase(reqBO.getIsMallWelfare())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"isWelfare.keyword", (String)"YES"));
        } else if ("NO".equalsIgnoreCase(reqBO.getIsMallWelfare())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)"isWelfare.keyword", (String)"YES"));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getActivityName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"activityName.keyword", (String)("*" + reqBO.getActivityName() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getActivityId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"activityId", (String)reqBO.getActivityId()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getBusiObjectNoS())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"busiObjectNo.keyword", reqBO.getBusiObjectNoS()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getMakeTypeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"makeType", reqBO.getMakeTypeList()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getWriteOffStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"writeOffStatus", (Object)reqBO.getWriteOffStatus()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getWriteOffSecondOrgIdList())) {
            BoolQueryBuilder writeOffShouldQueryBuilder = QueryBuilders.boolQuery();
            if (!CollectionUtils.isEmpty(reqBO.getOrderStateList())) {
                writeOffShouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"orderState", reqBO.getOrderStateList()));
            }
            BoolQueryBuilder writeOffBoolQueryBuilder = QueryBuilders.boolQuery();
            writeOffBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderState", (int)1008));
            writeOffShouldQueryBuilder.should((QueryBuilder)writeOffBoolQueryBuilder);
            boolQueryBuilder.must((QueryBuilder)writeOffShouldQueryBuilder);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getEntAcctWOffRemark())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"entAcctWOffRemark.keyword", (String)("*" + reqBO.getEntAcctWOffRemark() + "*")));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getEntAcctWOffApplyStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entAcctWOffApplyStatus", (Object)reqBO.getEntAcctWOffApplyStatus()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getEntAcctWOffCreateUserName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"entAcctWOffCreateUserName.keyword", (String)("*" + reqBO.getEntAcctWOffCreateUserName() + "*")));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getEntAcctWOffApplyNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"entAcctWOffApplyNo.keyword", (String)("*" + reqBO.getEntAcctWOffApplyNo() + "*")));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getEntAcctWOffFlag())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entAcctWOffFlag", (Object)reqBO.getEntAcctWOffFlag()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getEntAcctWOffFlag())) {
            fieldSortBuilders = new ArrayList(2);
            fieldSortBuilders.add(((FieldSortBuilder)SortBuilders.fieldSort((String)"entAcctWOffApplyStatus").order(SortOrder.DESC)).unmappedType("integer"));
            fieldSortBuilders.add(((FieldSortBuilder)SortBuilders.fieldSort((String)"entAcctWOffCreateTime").order(SortOrder.ASC)).unmappedType("date"));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getEntAcctWOffCreateUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entAcctWOffCreateUserId", (Object)reqBO.getEntAcctWOffCreateUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTradeDateStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getTradeDateEnd())) {
            RangeQueryBuilder rangeQueryBuilder3 = QueryBuilders.rangeQuery((String)"writeOffItemList.tradeDateTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTradeDateStart())) {
                rangeQueryBuilder3.gte((Object)this.getTime(reqBO.getTradeDateStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTradeDateEnd())) {
                rangeQueryBuilder3.lte((Object)this.getTime(reqBO.getTradeDateEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder3);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getBankWitnessSeq())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"writeOffItemList.bankWitnessSeq.keyword", (String)("*" + reqBO.getBankWitnessSeq() + "*")));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getWriteOffFlag())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"writeOffItemList.writeOffFlag.keyword", (String)("*" + reqBO.getWriteOffFlag() + "*")));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getShouldPayNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"writeOffItemList.shouldPayNo.keyword", (String)("*" + reqBO.getShouldPayNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptCreateTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getAcceptCreateTimeEnd())) {
            RangeQueryBuilder rangeQueryBuilder4 = QueryBuilders.rangeQuery((String)"acceptCreateTimeList");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptCreateTimeBegin())) {
                rangeQueryBuilder4.gte((Object)this.getTime(reqBO.getAcceptCreateTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptCreateTimeEnd())) {
                rangeQueryBuilder4.lte((Object)this.getTime(reqBO.getAcceptCreateTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder4);
        }
        if (reqBO.getOrderCreateOperId() != null && reqBO.getOrderCreateOperId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderCreateOperId", (Object)reqBO.getOrderCreateOperId()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"agreementCode.keyword", (String)("*" + reqBO.getAgreementCode() + "*")));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getDocId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"contractRelNo.keyword", (String)("*" + reqBO.getDocId() + "*")));
        }
        if (null != reqBO.getPayOrderState()) {
            if (1008 == reqBO.getPayOrderState()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payOrderState", (Object)reqBO.getPayOrderState()));
            } else {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"payOrderState", (int)1008));
            }
        }
        if (reqBO.getOperateId() != null && reqBO.getOperateId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"fscOrderProOperId", (Object)reqBO.getOperateId()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getReApplyInvoiceFlag())) {
            if ("1".equals(reqBO.getReApplyInvoiceFlag())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"reApplyInvoiceFlag", (String)reqBO.getReApplyInvoiceFlag()));
            } else {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"reApplyInvoiceFlag", (int)1));
            }
        }
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    public String buildComInvoiceEsSql(FscComInvoiceListPageQueryBusiReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getMakeType() != null && (long)reqBO.getMakeType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"makeType", (Object)reqBO.getMakeType()));
        }
        if (reqBO.getReceiveType() != null && (long)reqBO.getReceiveType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"receiveType", (Object)reqBO.getReceiveType()));
        }
        if (reqBO.getInvoiceId() != null && reqBO.getInvoiceId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"invoiceId", (Object)reqBO.getInvoiceId()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getInvoiceIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"invoiceId", reqBO.getInvoiceIds()));
        }
        if (reqBO.getFscOrderId() != null && reqBO.getFscOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"fscOrderId", (Object)reqBO.getFscOrderId()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscOrderIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"fscOrderId", reqBO.getFscOrderIds()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"invoiceCode.keyword", (String)("*" + reqBO.getInvoiceCode() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"invoiceNo.keyword", (String)("*" + reqBO.getInvoiceNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getFscOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"fscOrderNo.keyword", (String)("*" + reqBO.getFscOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderNoList.keyword", (String)("*" + reqBO.getOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaserId.keyword", (String)("*" + reqBO.getPurchaserId() + "*")));
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getBlueInv()) && reqBO.getBlueInv().equals(0)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"invType", (Object)reqBO.getInvType()));
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"redInvoiceStatus", (int)0));
        }
        if (reqBO.getBillDateStart() != null || reqBO.getBillDateEnd() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billDate");
            if (reqBO.getBillDateStart() != null) {
                long billDateStart = reqBO.getBillDateStart().getTime();
                rangeQueryBuilder.gte((Object)billDateStart);
            }
            if (reqBO.getBillDateEnd() != null) {
                Long billDateEnd = reqBO.getBillDateEnd().getTime();
                rangeQueryBuilder.lte((Object)billDateEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getInvoiceAmtStart()) || !ObjectUtil.isEmpty((Object)reqBO.getInvoiceAmtEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"amt");
            if (!ObjectUtil.isEmpty((Object)reqBO.getInvoiceAmtStart())) {
                rangeQueryBuilder.gte((Object)reqBO.getInvoiceAmtStart());
            }
            if (!ObjectUtil.isEmpty((Object)reqBO.getInvoiceAmtEnd())) {
                rangeQueryBuilder.lte((Object)reqBO.getInvoiceAmtEnd());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getCreateTimeStart() != null || reqBO.getCreateTimeEnd() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (reqBO.getCreateTimeStart() != null) {
                long createTimeStart = reqBO.getCreateTimeStart().getTime();
                rangeQueryBuilder.gte((Object)createTimeStart);
            }
            if (reqBO.getCreateTimeEnd() != null) {
                Long createTimeEnd = reqBO.getCreateTimeEnd().getTime();
                rangeQueryBuilder.lte((Object)createTimeEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getBillTimeStart() != null || reqBO.getBillTimeEnd() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billTime");
            if (reqBO.getBillTimeStart() != null) {
                long billTimeStart = reqBO.getBillTimeStart().getTime();
                rangeQueryBuilder.gte((Object)billTimeStart);
            }
            if (reqBO.getBillTimeEnd() != null) {
                Long billTimeEnd = reqBO.getBillTimeEnd().getTime();
                rangeQueryBuilder.lte((Object)billTimeEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getSignTimeStart() != null || reqBO.getSignTimeEnd() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"signTime");
            if (reqBO.getSignTimeStart() != null) {
                long signTimeStart = reqBO.getSignTimeStart().getTime();
                rangeQueryBuilder.gte((Object)signTimeStart);
            }
            if (reqBO.getSignTimeEnd() != null) {
                Long signTimeEnd = reqBO.getSignTimeEnd().getTime();
                rangeQueryBuilder.lte((Object)signTimeEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"invoiceType", (Object)reqBO.getInvoiceType()));
        }
        if (null != reqBO.getInvoiceCategory()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"invoiceCategory", (Object)reqBO.getInvoiceCategory()));
        }
        SortOrder order = SortOrder.DESC;
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    private String getQueryString(FscSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (maxPageSize < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)maxPageSize);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = uocSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = uocSearchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSON.parseArray((String)sortString));
        return queryJson.toJSONString();
    }

    public String buildBillMailEsSql(FscBillMailListPageQueryBusiReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getMakeId() != null && reqBO.getMakeId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"makeId", (Object)reqBO.getMakeId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMakeName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"makeName", (String)reqBO.getMakeName()));
        }
        if (reqBO.getReceiveId() != null && reqBO.getReceiveId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"receiveId", (Object)reqBO.getReceiveId()));
        }
        if (reqBO.getSysTenantId() != null && reqBO.getSysTenantId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sysTenantId", (Object)reqBO.getSysTenantId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getReceiveName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"receiveName.keyword", (String)("*" + reqBO.getReceiveName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBuyName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"buyName", (Object)reqBO.getBuyName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMailStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"mailStatus", (String)reqBO.getMailStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderNo.keyword", (String)("*" + reqBO.getOrderNo() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getInvoiceNoEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"invoiceNoMax");
            if (reqBO.getInvoiceNoEnd() != null) {
                String invoiceNoEnd = reqBO.getInvoiceNoEnd();
                rangeQueryBuilder.lte((Object)invoiceNoEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getInvoiceNoStart())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"invoiceNoMin");
            if (reqBO.getInvoiceNoStart() != null) {
                String invoiceNoStart = reqBO.getInvoiceNoStart();
                rangeQueryBuilder.gte((Object)invoiceNoStart);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBillDateStart())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billDateMax");
            if (reqBO.getBillDateStart() != null) {
                String billDateStart = reqBO.getBillDateStart();
                billDateStart = billDateStart.substring(0, 10);
                rangeQueryBuilder.lt((Object)billDateStart);
            }
            boolQueryBuilder.mustNot((QueryBuilder)rangeQueryBuilder);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBillDateEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billDateMin");
            if (reqBO.getBillDateEnd() != null) {
                String billDateEnd = reqBO.getBillDateEnd();
                billDateEnd = billDateEnd.substring(0, 10);
                rangeQueryBuilder.gt((Object)billDateEnd);
            }
            boolQueryBuilder.mustNot((QueryBuilder)rangeQueryBuilder);
        }
        if (!ObjectUtil.isNull((Object)reqBO.getSendDateStart())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"sendTimeMin");
            if (reqBO.getSendDateStart() != null) {
                Long sendDateStart = reqBO.getSendDateStart().getTime();
                rangeQueryBuilder.gte((Object)sendDateStart);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!ObjectUtil.isNull((Object)reqBO.getSendDateEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"sendTimeMax");
            if (reqBO.getBillDateEnd() != null) {
                Long sendDateEnd = reqBO.getSendDateEnd().getTime();
                rangeQueryBuilder.lte((Object)sendDateEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        SortOrder order = SortOrder.DESC;
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    private long getTime(String time) {
        long timeStamp;
        try {
            timeStamp = DateUtil.parse((CharSequence)time).getTime();
        }
        catch (Exception e) {
            timeStamp = Long.parseLong(time);
        }
        return timeStamp;
    }
}

