/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcUniteParamQryListDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityRspBO;
import com.tydic.dyc.fsc.api.DycFscBillOrderFeedbackTaskService;
import com.tydic.dyc.fsc.bo.DycFscBillOrderFeedbackTaskReqBO;
import com.tydic.dyc.fsc.bo.DycFscBillOrderFeedbackTaskRspBO;
import com.tydic.dyc.fsc.bo.DycFscCfcUniteParamQryListDetailRspBO;
import com.tydic.fsc.bill.ability.api.FscBillOrderFeedbackAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderFeedbackAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderFeedbackAbilityRspBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycFscBillOrderFeedbackTaskServiceImpl
implements DycFscBillOrderFeedbackTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycFscBillOrderFeedbackTaskServiceImpl.class);
    private static final String HAND_FEED_BACK = "1";
    @Autowired
    private FscBillOrderFeedbackAbilityService fscBillOrderFeedbackAbilityService;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Autowired
    private CfcUniteParamQryListDetailAbilityService cfcUniteParamQryListDetailAbilityService;

    public DycFscBillOrderFeedbackTaskRspBO dealOrderFeedbackTask(DycFscBillOrderFeedbackTaskReqBO reqBO) {
        DycFscCfcUniteParamQryListDetailRspBO config = this.queryConfig("feedback_rule");
        if (StringUtils.isBlank((CharSequence)config.getFeedbackMethod())) {
            throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u3010feedback_rule\u3011 feedbackMethod \u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!HAND_FEED_BACK.equals(config.getFeedbackMethod())) {
            FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
            fscComOrderListQueryAbilityReqBO.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
            fscComOrderListQueryAbilityReqBO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
            ArrayList<Integer> orderStates = new ArrayList<Integer>();
            orderStates.add(FscBillStatus.PENDING_FEEDBACK.getCode());
            fscComOrderListQueryAbilityReqBO.setOrderStates(orderStates);
            ArrayList<Integer> orderFlows = new ArrayList<Integer>();
            orderFlows.add(FscConstants.OrderFlow.INVOICE);
            fscComOrderListQueryAbilityReqBO.setOrderFlows(orderFlows);
            FscComOrderListQueryAbilityRspBO comOrderListPageQuery = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
            if (!"0000".equals(comOrderListPageQuery.getRespCode())) {
                throw new ZTBusinessException(comOrderListPageQuery.getRespDesc());
            }
            if (StringUtils.isBlank((CharSequence)config.getFeedbackTimeLimit())) {
                throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u3010feedback_rule\u3011 feedbackTimeLimit \u8fd4\u56de\u4e3a\u7a7a");
            }
            String feedbackTimeLimit = config.getFeedbackTimeLimit();
            long feedBackMills = Long.parseLong(feedbackTimeLimit) * 24L * 60L * 60L * 1000L;
            if (!CollectionUtils.isEmpty((Collection)comOrderListPageQuery.getRows())) {
                List needFeedBackList = comOrderListPageQuery.getRows().stream().filter(fscComOrderListBO -> System.currentTimeMillis() - fscComOrderListBO.getCreateTime().getTime() > feedBackMills).collect(Collectors.toList());
                for (FscComOrderListBO fscComOrderListBO2 : needFeedBackList) {
                    FscBillOrderFeedbackAbilityReqBO fscBillOrderFeedbackAbilityReqBO = new FscBillOrderFeedbackAbilityReqBO();
                    fscBillOrderFeedbackAbilityReqBO.setOrderId(fscComOrderListBO2.getFscOrderId());
                    FscBillOrderFeedbackAbilityRspBO fscBillOrderFeedbackAbilityRspBO = this.fscBillOrderFeedbackAbilityService.dealOrderFeedback(fscBillOrderFeedbackAbilityReqBO);
                    if ("0000".equals(fscBillOrderFeedbackAbilityRspBO.getRespCode())) continue;
                    log.error("\u5f00\u7968\u4e3b\u5355\u81ea\u52a8\u7ed3\u7b97\u5355\u3010{}\u3011\u53cd\u9988\u5931\u8d25, \u9519\u8bef\u63cf\u8ff0\u3010{}\u3011", (Object)fscBillOrderFeedbackAbilityReqBO.getOrderId(), (Object)fscBillOrderFeedbackAbilityRspBO.getRespDesc());
                }
            } else {
                log.error("\u672a\u67e5\u67e5\u8be2\u5230\u4e3b\u5355\u6570\u636e");
            }
        }
        return new DycFscBillOrderFeedbackTaskRspBO();
    }

    private DycFscCfcUniteParamQryListDetailRspBO queryConfig(String cfcParamCodes) {
        CfcUniteParamQryListDetailAbilityReqBO cfcUniteParamQryListDetailAbilityReqBO = new CfcUniteParamQryListDetailAbilityReqBO();
        cfcUniteParamQryListDetailAbilityReqBO.setParamCode(cfcParamCodes);
        cfcUniteParamQryListDetailAbilityReqBO.setCenter("FSC");
        CfcUniteParamQryListDetailAbilityRspBO cfcUniteParamQryListDetailAbilityRspBO = this.cfcUniteParamQryListDetailAbilityService.qryListDetail(cfcUniteParamQryListDetailAbilityReqBO);
        if (null == cfcUniteParamQryListDetailAbilityRspBO || null == cfcUniteParamQryListDetailAbilityRspBO.getJsonObject() || cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().isEmpty()) {
            throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return (DycFscCfcUniteParamQryListDetailRspBO)JSON.parseObject((String)cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().toJSONString(), DycFscCfcUniteParamQryListDetailRspBO.class);
    }
}

