/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscPayServiceBreakContractQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPayServiceBreakContractQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayServiceBreakContractQryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPayServiceBreakContractQryAbilityService"})
public class FscPayServiceBreakContractQryAbilityServiceImpl
implements FscPayServiceBreakContractQryAbilityService {
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;

    @PostMapping(value={"qryPayServiceBreak"})
    public FscPayServiceBreakContractQryAbilityRspBO qryPayServiceBreak(@RequestBody FscPayServiceBreakContractQryAbilityReqBO reqBO) {
        this.val(reqBO);
        Boolean dealBreachCheck = true;
        Boolean platformUsageCheck = true;
        if (FscConstants.BreakContract.DEAL_BREACH.equals(reqBO.getQryType()) || FscConstants.BreakContract.ALL.equals(reqBO.getQryType())) {
            dealBreachCheck = this.checkDealBreach(reqBO);
        }
        if (FscConstants.BreakContract.PLATFORM_USAGE.equals(reqBO.getQryType()) || FscConstants.BreakContract.ALL.equals(reqBO.getQryType())) {
            platformUsageCheck = this.checkPlatFormUsage(reqBO);
        }
        FscPayServiceBreakContractQryAbilityRspBO rspBO = new FscPayServiceBreakContractQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (dealBreachCheck.booleanValue() && platformUsageCheck.booleanValue()) {
            rspBO.setPlaceOrderEnable(FscConstants.PlaceOrderEnable.YES);
        } else {
            rspBO.setPlaceOrderEnable(FscConstants.PlaceOrderEnable.NO);
            rspBO.setBreakConditionDesc(dealBreachCheck != false ? "\u8d85\u8fc7\u5e73\u53f0\u670d\u52a1\u8d39\u8ba1\u8d39\u5468\u671f" : "\u672a\u7f34\u7eb3\u6210\u4ea4\u670d\u52a1\u8d39\u91d1\u989d\u8fbe\u5230\u9650\u989d");
        }
        return rspBO;
    }

    private Boolean checkPlatFormUsage(FscPayServiceBreakContractQryAbilityReqBO reqBO) {
        List<FscComOrderListBO> fscComOrderListBOS = this.queryComOrderByCondition(reqBO, FscConstants.OrderFlow.PL_SERVICE_FEE);
        if (CollectionUtils.isEmpty(fscComOrderListBOS)) {
            return true;
        }
        Integer orderState = (Integer)fscComOrderListBOS.stream().sorted(Comparator.comparing(FscComOrderListBO::getCreateTime).reversed()).limit(1L).map(FscComOrderListBO::getOrderState).collect(Collectors.toList()).get(0);
        List<Integer> unSupportStates = Arrays.asList(FscConstants.FscServiceOrderState.TO_PAY, FscConstants.FscServiceOrderState.PAY_TO_CONFIRM);
        return unSupportStates.contains(orderState);
    }

    private Boolean checkDealBreach(FscPayServiceBreakContractQryAbilityReqBO reqBO) {
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO;
        BigDecimal breachQuota;
        List<FscComOrderListBO> fscComOrderListBOS = this.queryComOrderByCondition(reqBO, FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        if (CollectionUtils.isEmpty(fscComOrderListBOS)) {
            return true;
        }
        BigDecimal totalActualAmount = fscComOrderListBOS.stream().map(FscComOrderListBO::getActualAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalActualAmount.compareTo(breachQuota = new BigDecimal((fscCfcUniteParamQryListDetailExternalRspBO = this.queryRule(FscConstants.OrderFlow.MONTH_SERVICE_FEE)).getBreachQuota())) <= 0;
    }

    private List<FscComOrderListBO> queryComOrderByCondition(FscPayServiceBreakContractQryAbilityReqBO reqBO, Integer orderFlow) {
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
        fscComOrderListQueryAbilityReqBO.setPageSize(Integer.valueOf(-1));
        fscComOrderListQueryAbilityReqBO.setOrderFlows(Collections.singletonList(orderFlow));
        fscComOrderListQueryAbilityReqBO.setOrderStates(Arrays.asList(FscConstants.FscServiceOrderState.TO_PAY, FscConstants.FscServiceOrderState.PAY_TO_CONFIRM));
        fscComOrderListQueryAbilityReqBO.setSupplierId(reqBO.getSupplierId());
        FscComOrderListQueryAbilityRspBO comOrderListPageQuery = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        return comOrderListPageQuery.getRows();
    }

    private FscCfcUniteParamQryListDetailExternalRspBO queryRule(Integer olderFlow) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(olderFlow)) {
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("deal_breach");
        } else if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(olderFlow)) {
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("platform_usage");
        }
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191135", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        return fscCfcUniteParamQryListDetailExternalRspBO;
    }

    private void val(FscPayServiceBreakContractQryAbilityReqBO reqBO) {
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
    }
}

