/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.busi.api.FscQueryCollectionFuncListBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountAttachmentBO;
import com.tydic.fsc.common.busi.bo.FscQueryCollectionFuncListBO;
import com.tydic.fsc.common.busi.bo.FscQueryCollectionFuncListBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscQueryCollectionFuncListBusiRspBO;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscQueryCollectionFuncListBusiServiceImpl
implements FscQueryCollectionFuncListBusiService {
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    private static final String IS_OPERATION = "0";
    private static final String IS_PURCHASE = "1";
    private static final String IS_SUPPLIER = "2";

    @Override
    public FscQueryCollectionFuncListBusiRspBO queryCollectionFuncList(FscQueryCollectionFuncListBusiReqBO reqBO) {
        String isprofess = reqBO.getIsprofess();
        FscQueryCollectionFuncListBusiRspBO rspBO = new FscQueryCollectionFuncListBusiRspBO();
        if (IS_OPERATION.equals(isprofess)) {
            List<FscQueryCollectionFuncListBO> detailsList = this.getDetailsList(null);
            rspBO.setAccountList(detailsList);
        } else if (IS_PURCHASE.equals(isprofess) || IS_SUPPLIER.equals(isprofess)) {
            Long userId = reqBO.getUserId();
            UmcQryMemLegalOrgInfoAbilityServiceReqBO memLegalOrgInfo = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
            memLegalOrgInfo.setMemId(userId);
            UmcQryMemLegalOrgInfoAbilityServiceRspBO memLegalOrgInfoRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(new UmcQryMemLegalOrgInfoAbilityServiceReqBO());
            Long orgId = memLegalOrgInfoRspBO.getLegalOrgInfo().getOrgId();
            FscAccountPO fscAccountPO = new FscAccountPO();
            fscAccountPO.setOrgId(orgId);
            List<FscQueryCollectionFuncListBO> detailsList = this.getDetailsList(fscAccountPO);
            rspBO.setAccountList(detailsList);
        }
        return rspBO;
    }

    private List<FscQueryCollectionFuncListBO> getDetailsList(FscAccountPO fscAccountPO) {
        ArrayList<FscQueryCollectionFuncListBO> accountList = new ArrayList<FscQueryCollectionFuncListBO>();
        List result = this.fscAccountMapper.getDetailsList(fscAccountPO);
        result.forEach(fscAccountDetailsPO -> {
            FscQueryCollectionFuncListBO fscQueryCollectionFuncListBO = new FscQueryCollectionFuncListBO();
            BeanUtils.copyProperties((Object)fscAccountDetailsPO, (Object)((Object)fscQueryCollectionFuncListBO));
            fscQueryCollectionFuncListBO.setAccountBtobStatus(fscAccountDetailsPO.getAccountBtobStatus() + "");
            ArrayList attachmentList = new ArrayList();
            List attachmentResultList = fscAccountDetailsPO.getAttachmentList();
            if (null != attachmentResultList) {
                attachmentResultList.forEach(fscMemberAttachmentPO -> {
                    FscAccountAttachmentBO fscAccountAttachmentBO = new FscAccountAttachmentBO();
                    fscAccountAttachmentBO.setAttachmentId(fscMemberAttachmentPO.getAttachmentId() + "");
                    BeanUtils.copyProperties((Object)fscMemberAttachmentPO, (Object)((Object)fscAccountAttachmentBO));
                    attachmentList.add(fscAccountAttachmentBO);
                    fscQueryCollectionFuncListBO.setAttachmentList(attachmentList);
                });
            }
            accountList.add(fscQueryCollectionFuncListBO);
        });
        return accountList;
    }
}

