/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankPayService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankBindBankAccountReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankBindBankAccountRspBO;
import com.tydic.fsc.common.busi.api.FscBindBankAccountBusiService;
import com.tydic.fsc.common.busi.bo.FscBindBankAccountBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBindBankAccountBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBindBankAccountBusiServiceImpl
implements FscBindBankAccountBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBindBankAccountBusiServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscBToBPingAnBankPayService fscBToBPingAnBankPayService;

    @Override
    public FscBindBankAccountBusiRspBO bindBankAccount(FscBindBankAccountBusiReqBO reqBO) {
        String accountNo = reqBO.getAccountNo();
        FscAccountPO accountPO = new FscAccountPO();
        accountPO.setAccountNo(accountNo);
        FscAccountPO returnAccountPO = this.fscAccountMapper.getModelBy(accountPO);
        if (returnAccountPO != null) {
            throw new FscBusinessException("198888", "\u8d26\u6237\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u65b0\u7ed1\u5b9a");
        }
        FscBToBPingAnBankBindBankAccountReqBO fscBToBPingAnBankBindBankAccountReqBO = (FscBToBPingAnBankBindBankAccountReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), FscBToBPingAnBankBindBankAccountReqBO.class);
        fscBToBPingAnBankBindBankAccountReqBO.setSubAcctNo(reqBO.getSubAccountNo());
        fscBToBPingAnBankBindBankAccountReqBO.setTranNetMemberCode(reqBO.getLegalOrgId());
        fscBToBPingAnBankBindBankAccountReqBO.setMemberName(reqBO.getLegalOrgName());
        fscBToBPingAnBankBindBankAccountReqBO.setMemberGlobalType("73");
        fscBToBPingAnBankBindBankAccountReqBO.setMemberGlobalId(reqBO.getLegalCertNumber());
        fscBToBPingAnBankBindBankAccountReqBO.setMemberAcctNo(reqBO.getAccountNo());
        fscBToBPingAnBankBindBankAccountReqBO.setBankType("1");
        fscBToBPingAnBankBindBankAccountReqBO.setAcctOpenBranchName(reqBO.getDepositBankName());
        fscBToBPingAnBankBindBankAccountReqBO.setCnapsBranchId(reqBO.getSizeLineNumber());
        fscBToBPingAnBankBindBankAccountReqBO.setEiconBankBranchId(reqBO.getSuperLineNumber());
        fscBToBPingAnBankBindBankAccountReqBO.setMobile(reqBO.getPhone());
        fscBToBPingAnBankBindBankAccountReqBO.setIndivBusinessFlag("2");
        if (reqBO.getOrgId() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setShopId(reqBO.getOrgId().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setShopName(reqBO.getOrgName());
        if (reqBO.getIsTransactor() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientFlag(reqBO.getIsTransactor().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientName(reqBO.getTransactorName());
        fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientGlobalType("1");
        fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientGlobalId(reqBO.getTransactorCertNo());
        fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientMobile(reqBO.getTransactorPhone());
        if (reqBO.getIsLegalPerson() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setRepFlag(reqBO.getIsLegalPerson().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setReprName(reqBO.getLegalPersonName());
        if (reqBO.getLegalPersonCertType() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setReprGlobalType(reqBO.getLegalPersonCertType().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setReprGlobalId(reqBO.getLegalPersonCertNo());
        FscBToBPingAnBankBindBankAccountRspBO fscBToBPingAnBankBindBankAccountRspBO = this.fscBToBPingAnBankPayService.bindAccount(fscBToBPingAnBankBindBankAccountReqBO);
        if (!"0000".equals(fscBToBPingAnBankBindBankAccountRspBO.getRespCode())) {
            log.error("\u94f6\u884c\u63a5\u53e3\u8c03\u7528\u5f02\u5e38!");
            throw new FscBusinessException("198888", fscBToBPingAnBankBindBankAccountRspBO.getRespDesc());
        }
        FscAccountPO insertAccountPO = (FscAccountPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), FscAccountPO.class);
        if (fscBToBPingAnBankBindBankAccountRspBO.getFrontSeqNo() != null) {
            insertAccountPO.setFrontSeqNo(fscBToBPingAnBankBindBankAccountRspBO.getFrontSeqNo());
        }
        log.info("\u83b7\u53d6\u94f6\u884c\u524d\u7f6e\u6d41\u6c34\u53f7:{}", (Object)fscBToBPingAnBankBindBankAccountRspBO.getFrontSeqNo());
        insertAccountPO.setLegalCertNo(reqBO.getLegalPersonCertNo());
        insertAccountPO.setLegalCertType(reqBO.getLegalPersonCertType());
        insertAccountPO.setLegalName(reqBO.getLegalPersonName());
        insertAccountPO.setStatus(FscConstants.AccountStatus.AUTHING);
        insertAccountPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        int rows = this.fscAccountMapper.insert(insertAccountPO);
        Long orgId = reqBO.getOrgId();
        FscLegalCompanyPO existPO = this.fscLegalCompanyMapper.getById(orgId);
        if (existPO == null) {
            FscLegalCompanyPO fscLegalCompanyPO = new FscLegalCompanyPO();
            fscLegalCompanyPO.setOrgId(reqBO.getOrgId()).setOrgCertificateCode(reqBO.getLegalCertNumber()).setSubAccountNo(reqBO.getSubAccountNo()).setOrgName(reqBO.getOrgName());
            int insertRows = this.fscLegalCompanyMapper.insert(fscLegalCompanyPO);
            if (insertRows != 1) {
                log.warn("\u6cd5\u4eba\u516c\u53f8\u4fe1\u606f\u6dfb\u52a0\u5931\u8d25!");
            }
        }
        FscBindBankAccountBusiRspBO rspBO = new FscBindBankAccountBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7ed1\u5b9a\u6210\u529f!");
        return rspBO;
    }
}

