/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscComBalanceWithdrawalBusiService;
import com.tydic.fsc.common.busi.bo.FscComBalanceWithdrawalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComBalanceWithdrawalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscWithdrawalLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscWithdrawalLogPO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscComBalanceWithdrawalBusiServiceImpl
implements FscComBalanceWithdrawalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComBalanceWithdrawalBusiServiceImpl.class);
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscWithdrawalLogMapper fscWithdrawalLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @Override
    public FscComBalanceWithdrawalBusiRspBO balanceWithdrawal(FscComBalanceWithdrawalBusiReqBO reqBO) {
        Long orgId = reqBO.getOrgId();
        log.debug("\u67e5\u8be2\u8d26\u6237\u673a\u6784id\u4e3a:{}", (Object)orgId);
        FscBalancePO fscBalancePO = this.fscBalanceMapper.getByOrgId(orgId);
        log.debug("\u67e5\u8be2\u5230\u7684\u4f59\u989d\u4fe1\u606f\u4e3a:{}", (Object)fscBalancePO);
        if (fscBalancePO == null) {
            throw new FscBusinessException("198888", "\u8be5\u8d26\u6237\u6570\u636e\u4f59\u989d\u4e3anull");
        }
        FscAccountPO queryAccount = new FscAccountPO();
        queryAccount.setOrgId(orgId);
        FscAccountPO fscAccountPO = this.fscAccountMapper.getModelBy(queryAccount);
        log.debug("\u67e5\u8be2\u7684\u8d26\u6237\u4fe1\u606f\u4e3a:{}", (Object)fscAccountPO);
        if (fscAccountPO == null) {
            throw new FscBusinessException("191103", "\u63d0\u73b0\u8d26\u6237\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        if (!FscConstants.AccountStatus.VALID.equals(fscAccountPO.getStatus())) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u8d26\u6237\u72b6\u6001\u5f02\u5e38");
        }
        FscLegalCompanyPO fscLegalCompanyPO = this.fscLegalCompanyMapper.getById(orgId);
        log.debug("\u5b50\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\u4e3a:{}", (Object)fscLegalCompanyPO);
        if (fscLegalCompanyPO == null) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u5b50\u8d26\u6237\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        Integer status = fscLegalCompanyPO.getStatus();
        if (!FscConstants.MerchantStatus.VALID.equals(status)) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u5b50\u8d26\u6237\u8d26\u53f7\u72b6\u6001\u5f02\u5e38");
        }
        BigDecimal usableAmount = fscBalancePO.getUsableAmount();
        if (reqBO.getUseAmount().compareTo(usableAmount) == 1) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u91d1\u989d\u8d85\u51fa\u9650\u5236,\u6700\u5927\u53ef\u91d1\u989d\u4e3a:" + usableAmount + "\u5143");
        }
        LocalDateTime dateTime = LocalDateTime.now();
        log.debug("\u5f53\u524d\u65f6\u95f4\u4e3a:{}", (Object)dateTime);
        BigDecimal updateUsableAmount = usableAmount.subtract(reqBO.getUseAmount());
        BigDecimal usedAmount = fscBalancePO.getUsedAmount();
        if (usedAmount == null) {
            usedAmount = new BigDecimal("0");
        }
        BigDecimal updateUseAmount = usedAmount.add(reqBO.getUseAmount());
        FscBalancePO set = new FscBalancePO();
        set.setUsableAmount(updateUsableAmount);
        set.setUsedAmount(updateUseAmount);
        set.setOperId(reqBO.getUserId());
        set.setOperName(reqBO.getName());
        set.setWithdrawalTime(dateTime);
        log.debug("\u4fee\u6539\u4f59\u989d\u6570\u636e\u4f20\u5165:{}", (Object)set);
        int updateRows = this.fscBalanceMapper.updateBy(set, fscBalancePO);
        log.debug("\u4fee\u6539\u7684\u6570\u636e\u884c\u6570\u4e3a:{}", (Object)updateRows);
        if (updateRows != 1) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38,\u4f59\u989d\u7ba1\u7406\u6570\u636e\u4fee\u6539\u5f02\u5e38!");
        }
        FscWithdrawalLogPO fscWithdrawalLogPO = new FscWithdrawalLogPO();
        Long id = Sequence.getInstance().nextId();
        fscWithdrawalLogPO.setId(id).setOrgId(reqBO.getOrgId()).setOrgName(reqBO.getOrgName()).setAccountId(fscAccountPO.getId()).setAccountNo(fscAccountPO.getAccountNo()).setAccountName(fscAccountPO.getAccountName()).setSubAccountNo(fscLegalCompanyPO.getSubAccountNo()).setDepositBankName(fscAccountPO.getDepositBankName()).setUsedAmount(reqBO.getUseAmount()).setCreateTime(dateTime).setTransferFee(new BigDecimal("0")).setOperId(reqBO.getUserId()).setOperName(reqBO.getName());
        log.debug("\u5373\u5c06\u6dfb\u52a0\u63d0\u73b0\u8bb0\u5f55:{}", (Object)fscWithdrawalLogPO);
        int insertRows = this.fscWithdrawalLogMapper.insert(fscWithdrawalLogPO);
        if (insertRows != 1) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38,\u63d0\u73b0\u8bb0\u5f55\u6570\u636e\u6dfb\u52a0\u5f02\u5e38!");
        }
        FscComBalanceWithdrawalBusiRspBO rspBO = new FscComBalanceWithdrawalBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63d0\u73b0\u64cd\u4f5c\u6210\u529f!");
        return rspBO;
    }
}

