/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderCancelAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscComOrderCancelBusiServiceImpl
implements FscComOrderCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelBusiServiceImpl.class);
    @Autowired
    private FscOrderCancelAtomService fscOrderCancelAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;

    @Override
    public FscComOrderCancelBusiRspBO dealOrderCancel(FscComOrderCancelBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)((Object)reqBO));
        FscOrderCancelAtomReqBO fscOrderCancelAtomReqBO = (FscOrderCancelAtomReqBO)JSON.parseObject((String)jsonString, FscOrderCancelAtomReqBO.class);
        FscOrderCancelAtomRspBO fscOrderCancelAtomRspBO = this.fscOrderCancelAtomService.dealCancelStatus(fscOrderCancelAtomReqBO);
        if (!"0000".equals(fscOrderCancelAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193124", fscOrderCancelAtomRspBO.getRespDesc());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO.setCancelOperId(reqBO.getUserId().toString());
        fscOrderPO.setCancelTime(new Date());
        fscOrderPO.setCancelOperName(reqBO.getName());
        this.fscOrderMapper.updateById(fscOrderPO);
        this.syncOrderStatus(reqBO.getOrderId());
        return new FscComOrderCancelBusiRspBO();
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }
}

