/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscPayBillWriteOffBusiService;
import com.tydic.fsc.common.busi.bo.FscPayBillWriteOffBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPayBillWriteOffBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayBillWriteOffBusiServiceImpl
implements FscPayBillWriteOffBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillWriteOffBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;

    @Override
    public FscPayBillWriteOffBusiRspBO payBillWriteOff(FscPayBillWriteOffBusiReqBO reqBO) {
        FscPayBillWriteOffBusiRspBO retBo = new FscPayBillWriteOffBusiRspBO();
        FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
        fscWriteOffItemPO.setMemo(reqBO.getMemo());
        List<Long> orderIds = reqBO.getFscOrderId();
        int index = 0;
        for (Long orderId : orderIds) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(orderId);
            fscOrderPO.setPayState(FscConstants.PayOrderPayStatus.PAIED);
            int row = this.fscOrderMapper.updateByFscOrderId(fscOrderPO);
            if (row < 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            List<Long> bankCheckIds = reqBO.getBankCheckIds();
            FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPO.setWriteOffFlag(FscConstants.WRITE_OFF_FLAG.MANUAL + "");
            fscBankCheckFileItemPO.setBankCheckId(bankCheckIds.get(index));
            int rows = this.fscBankCheckFileItemMapper.updateByBankCheckId(fscBankCheckFileItemPO);
            if (rows < 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            fscWriteOffItemPO.setFscOrderId(orderId);
            fscWriteOffItemPO.setBankCheckId(bankCheckIds.get(index));
            fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
            int insert = this.fscWriteOffItemMapper.insertAll(fscWriteOffItemPO);
            if (insert < 1) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u6838\u9500\u6570\u636e\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            ++index;
        }
        return retBo;
    }
}

