/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.ability.bo.FscAccountAttachmentBO;
import com.tydic.fsc.common.busi.api.FscQueryAccountFuncDetailBusiService;
import com.tydic.fsc.common.busi.bo.FscQueryAccountFuncDetailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscQueryAccountFuncDetailBusiRspBO;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMemberAttachmentMapper;
import com.tydic.fsc.po.FscAccountDetailsPO;
import com.tydic.fsc.po.FscAccountPO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscQueryAccountFuncDetailBusiServiceImpl
implements FscQueryAccountFuncDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscQueryAccountFuncDetailBusiServiceImpl.class);
    private static final String TO_BE_OPENED = "\u5f85\u5f00\u901a";
    private static final String OPENING = "\u5f00\u901a\u4e2d";
    private static final String OPENED_FAIL = "\u5f00\u901a\u5931\u8d25";
    private static final String ALREADY_OPENED = "\u5df2\u5f00\u901a";
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMemberAttachmentMapper fscMemberAttachmentMapper;

    @Override
    public FscQueryAccountFuncDetailBusiRspBO queryAccountFuncDetail(FscQueryAccountFuncDetailBusiReqBO reqBO) {
        Long id = reqBO.getId();
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setId(id);
        FscQueryAccountFuncDetailBusiRspBO busiRspBO = new FscQueryAccountFuncDetailBusiRspBO();
        FscAccountDetailsPO fscAccountDetailsPO = this.fscAccountMapper.geDetailsById(fscAccountPO);
        if (fscAccountDetailsPO == null) {
            busiRspBO.setRespCode("0100");
            busiRspBO.setRespDesc("\u672a\u627e\u5230\u8be5\u8d26\u6237\u4fe1\u606f");
            log.info("\u672a\u67e5\u8be2\u5230\u8d26\u6237id\u4e3a{}\u7684\u4fe1\u606f", (Object)id);
            return busiRspBO;
        }
        BeanUtils.copyProperties((Object)fscAccountDetailsPO, (Object)((Object)busiRspBO));
        List<FscAccountAttachmentBO> attachmentBOS = this.queryAttachmentInfo(id);
        busiRspBO.setAttachmentList(attachmentBOS);
        if (fscAccountDetailsPO.getAccountBtobStatus() != null) {
            if (fscAccountDetailsPO.getAccountBtobStatus() == 1) {
                busiRspBO.setRespDesc(TO_BE_OPENED);
            }
            if (fscAccountDetailsPO.getAccountBtobStatus() == 2) {
                busiRspBO.setRespDesc(OPENING);
            }
            if (fscAccountDetailsPO.getAccountBtobStatus() == 3) {
                busiRspBO.setRespDesc(OPENED_FAIL);
            }
            if (fscAccountDetailsPO.getAccountBtobStatus() == 4) {
                busiRspBO.setRespDesc(ALREADY_OPENED);
            }
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u67e5\u8be2\u5230\u8d26\u6237id\u4e3a[" + id + "]\u7684\u4fe1\u606f");
        log.debug("\u67e5\u8be2\u5230\u8d26\u6237id\u4e3a{}\u7684\u4fe1\u606f", (Object)id);
        return busiRspBO;
    }

    private List<FscAccountAttachmentBO> queryAttachmentInfo(Long accountId) {
        List attachmentPOS = this.fscMemberAttachmentMapper.getList(accountId);
        List<FscAccountAttachmentBO> attachmentBOS = attachmentPOS.stream().map(fscMemberAttachmentPO -> {
            FscAccountAttachmentBO attachmentBO = new FscAccountAttachmentBO();
            attachmentBO.setAttachmentId(fscMemberAttachmentPO.getAttachmentId() + "");
            BeanUtils.copyProperties((Object)fscMemberAttachmentPO, (Object)attachmentBO);
            return attachmentBO;
        }).collect(Collectors.toList());
        return attachmentBOS;
    }
}

