/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.ContractAbatchQryCodeAbilityService;
import com.tydic.contract.ability.bo.ContractAbatchQryCodeAbilityReqBO;
import com.tydic.contract.ability.bo.ContractAbatchQryCodeAbilityRspBO;
import com.tydic.contract.ability.bo.ContractAbatchQryCodeBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscPebExtOrdStatisticReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPebExtOrdStatisticRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProTransactionServiceListQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProTransactionServiceListQueryRspBO;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.busibase.external.api.uoc.FscPebExtOrdStatisticAbilityService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProTransactionServiceListQueryAbilityService;
import com.tydic.fsc.common.busi.api.FscComOrderDetailQueryBusiService;
import com.tydic.fsc.common.busi.bo.FscBusiObjectBO;
import com.tydic.fsc.common.busi.bo.FscComOrderListDetailRspBO;
import com.tydic.fsc.common.busi.bo.FscComOrderListQueryBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePostPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscComOrderDetailQueryBusiServiceImpl
implements FscComOrderDetailQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderDetailQueryBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscUocProTransactionServiceListQueryAbilityService fscUocProTransactionServiceListQueryAbilityService;
    @Autowired
    private FscPebExtOrdStatisticAbilityService fscPebExtOrdStatisticAbilityService;
    @Autowired
    private ContractAbatchQryCodeAbilityService contractAbatchQryCodeAbilityService;

    @Override
    public FscComOrderListDetailRspBO qryOrderDetailBusi(FscComOrderListQueryBusiReqBO reqBO) {
        List shouldPayList;
        this.validateParams(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (StringUtils.isEmpty((Object)fscOrderPO)) {
            throw new FscBusinessException("193111", "\u8be5\u7ed3\u7b97\u5355id" + reqBO.getFscOrderId() + "\u65e0\u6cd5\u67e5\u8be2\u5230\u7ed3\u7b97\u5355");
        }
        FscComOrderListDetailRspBO fscComOrderListBO = (FscComOrderListDetailRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPO), FscComOrderListDetailRspBO.class));
        fscComOrderListBO.setFscOrderNo(fscOrderPO.getOrderNo());
        if (FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
            fscComOrderListBO.setAuditType(0);
        } else if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            fscComOrderListBO.setAuditType(1);
        }
        Long contractId = fscOrderPO.getContractId();
        if (ObjectUtil.isNotNull((Object)contractId)) {
            ContractAbatchQryCodeAbilityReqBO contractAbatchQryCodeAbilityReqBO = new ContractAbatchQryCodeAbilityReqBO();
            List<Long> contractIdList = Collections.singletonList(contractId);
            contractAbatchQryCodeAbilityReqBO.setContractId(contractIdList);
            ContractAbatchQryCodeAbilityRspBO contractAbatchQryCodeAbilityRspBO = this.contractAbatchQryCodeAbilityService.qryContractCodeList(contractAbatchQryCodeAbilityReqBO);
            if (!"0000".equals(contractAbatchQryCodeAbilityRspBO.getRespCode())) {
                log.error("\u67e5\u8be2\u5408\u540c\u7f16\u53f7\u51fa\u9519\uff1a{}", (Object)contractAbatchQryCodeAbilityRspBO.getRespDesc());
            }
            if (ObjectUtil.isNotNull((Object)contractAbatchQryCodeAbilityRspBO) && !CollectionUtils.isEmpty((Collection)contractAbatchQryCodeAbilityRspBO.getRows())) {
                Map<Long, String> contractMap = contractAbatchQryCodeAbilityRspBO.getRows().stream().collect(Collectors.toMap(ContractAbatchQryCodeBO::getContractId, ContractAbatchQryCodeBO::getContractCode));
                fscComOrderListBO.setContractNo((String)contractMap.get(contractId));
            }
        }
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(reqBO.getFscOrderId());
        List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        ArrayList<String> attUrls = null;
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            attUrls = new ArrayList<String>(fscAttachmentPOS.size());
            for (FscAttachmentPO fscAttachmentPO : fscAttachmentPOS) {
                attUrls.add(fscAttachmentPO.getAttachmentUrl());
            }
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderRelationCounts = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        ArrayList<Long> orderIdList = null;
        ArrayList<Long> acceptOrderIdList = null;
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationCounts)) {
            if (!FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
                fscComOrderListBO.setOrderNum(fscOrderRelationCounts.size());
            }
            ArrayList<String> acceptOrderNoList = new ArrayList<String>(fscOrderRelationCounts.size());
            orderIdList = new ArrayList<Long>(fscOrderRelationCounts.size());
            ArrayList<String> extOrderNoList = new ArrayList<String>(fscOrderRelationCounts.size());
            ArrayList<String> orderNoList = new ArrayList<String>(fscOrderRelationCounts.size());
            acceptOrderIdList = new ArrayList<Long>(fscOrderRelationCounts.size());
            for (FscOrderRelationPO fscOrderRelationCount : fscOrderRelationCounts) {
                acceptOrderNoList.add(fscOrderRelationCount.getAcceptOrderNo());
                orderIdList.add(fscOrderRelationCount.getOrderId());
                extOrderNoList.add(fscOrderRelationCount.getExtOrderNo());
                orderNoList.add(fscOrderRelationCount.getOrderNo());
                if (!ObjectUtil.isNotNull((Object)fscOrderRelationCount.getAcceptOrderId())) continue;
                acceptOrderIdList.add(fscOrderRelationCount.getAcceptOrderId());
            }
            fscComOrderListBO.setAcceptOrderNoList(acceptOrderNoList);
            fscComOrderListBO.setExtOrderNoList(extOrderNoList);
            fscComOrderListBO.setOrderIdList(orderIdList);
            fscComOrderListBO.setOrderNo(orderNoList);
        } else if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            String serviceFeeCycle = fscOrderPO.getServiceFeeCycle();
            String[] cycles = serviceFeeCycle.split(",");
            Integer year = LocalDate.now().getYear();
            String firstCycleMonth = cycles[0].length() < 10 ? "0" + cycles[0] : cycles[0];
            String firstCycleDay = cycles[1].length() < 10 ? "0" + cycles[1] : cycles[1];
            String lastCycleMonth = cycles[2].length() < 10 ? "0" + cycles[2] : cycles[2];
            String lastCycleDay = cycles[3].length() < 10 ? "0" + cycles[3] : cycles[3];
            String firstDayStr = year + "-" + firstCycleMonth + "-" + firstCycleDay;
            String lastDayStr = year + "-" + lastCycleMonth + "-" + lastCycleDay;
            Integer searchType = FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) ? FscConstants.SearchType.ACCEPT : FscConstants.SearchType.ORDER;
            FscPebExtOrdStatisticRspBO fscPebExtOrdStatisticRspBO = this.qryYearOrdInfo(fscOrderPO.getSupplierId(), searchType, firstDayStr, lastDayStr);
            fscComOrderListBO.setOrderNum(fscPebExtOrdStatisticRspBO.getTotalCount());
        } else {
            fscComOrderListBO.setOrderNum(0);
        }
        if (FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
            List fscOrderPayItemList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemList)) {
                fscComOrderListBO.setOrderNum(fscOrderPayItemList.size());
            }
        }
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        List fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePo);
        Map buildActionMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUILD_ACTION");
        Map orderSourceMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SOURCE");
        Map shouldPayTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("SHOULD_PAY_TYPE");
        Map payTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CFC_PAY_TYPE_ALLOW");
        Map busiCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("BUSI_CATEGORY");
        Map orderStateMap = 0 == fscOrderPO.getOrderFlow() && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_PUR_MATCH_ECOM_SETTLE_ORDER_STATE") : (0 == fscOrderPO.getOrderFlow() && !FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE") : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE"));
        if (null != fscComOrderListBO.getPayChannel()) {
            FscPayTransPayInsReqBo fscPayTransPayInsReqBo = new FscPayTransPayInsReqBo();
            fscPayTransPayInsReqBo.setPaymentInsId(Collections.singletonList(Long.parseLong(fscComOrderListBO.getPayChannel())));
            FscPayTransPayInsRspBo fscPayTransPayInsRspBo = this.fscPayTransPayInsService.tranPayIns(fscPayTransPayInsReqBo);
            if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo)) {
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayInsMap())) {
                    fscComOrderListBO.setPayChannelStr((String)fscPayTransPayInsRspBo.getPayInsMap().get(fscComOrderListBO.getPayChannel()));
                }
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayMethodMap())) {
                    fscComOrderListBO.setPayMethodStr((String)fscPayTransPayInsRspBo.getPayMethodMap().get(fscComOrderListBO.getPayMethod()));
                }
            }
        }
        BigDecimal totalChargeBill = new BigDecimal("0");
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            ArrayList<Long> mailIdList = new ArrayList<Long>(fscInvoicePOS.size());
            ArrayList<String> invoiceNoList = new ArrayList<String>(fscInvoicePOS.size());
            ArrayList<String> invoiceCodeList = new ArrayList<String>(fscInvoicePOS.size());
            ArrayList<String> billDate = new ArrayList<String>(fscInvoicePOS.size());
            for (Object fscInvoicePO : fscInvoicePOS) {
                totalChargeBill = totalChargeBill.add(fscInvoicePO.getAmt());
                mailIdList.add(fscInvoicePO.getMailId());
                invoiceNoList.add(fscInvoicePO.getInvoiceNo());
                invoiceCodeList.add(fscInvoicePO.getInvoiceCode());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fscInvoicePO.getBillDate())) continue;
                billDate.add(fscInvoicePO.getBillDate());
            }
            fscComOrderListBO.setTotalChargeBill(totalChargeBill);
            fscComOrderListBO.setInvoiceNo((String)invoiceNoList.get(0));
            fscComOrderListBO.setInvoiceCode((String)invoiceCodeList.get(0));
            fscComOrderListBO.setBillDate((String)billDate.get(0));
            List InvoicePostPOList = this.fscInvoicePostMapper.getListByIds(mailIdList);
            if (!CollectionUtils.isEmpty((Collection)InvoicePostPOList)) {
                ArrayList<String> sendInfoStr = new ArrayList<String>(InvoicePostPOList.size());
                for (FscInvoicePostPO fscInvoicePostPO : InvoicePostPOList) {
                    String sendCompany = fscInvoicePostPO.getSendCompany();
                    String sendOrder = fscInvoicePostPO.getSendOrder();
                    if (StringUtils.isEmpty((Object)sendCompany) || StringUtils.isEmpty((Object)sendOrder)) continue;
                    sendInfoStr.add(sendCompany + "," + sendOrder);
                }
                fscComOrderListBO.setSendInfoStr(sendInfoStr);
            }
        }
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        if (!StringUtils.isEmpty((Object)fscOrderInvoicePO)) {
            fscComOrderListBO.setAccountSetId(fscOrderInvoicePO.getAccountSetId());
            fscComOrderListBO.setBuyName(fscOrderInvoicePO.getBuyName());
            fscComOrderListBO.setSignTime(fscOrderInvoicePO.getSignTime());
            fscComOrderListBO.setBillTime(fscOrderInvoicePO.getBillTime());
            fscComOrderListBO.setSignOperName(fscOrderInvoicePO.getSignOperName());
            fscComOrderListBO.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
            fscComOrderListBO.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
            fscComOrderListBO.setAccountSetName(fscOrderInvoicePO.getAccountSetName());
            Map InvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
            Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
            if (!StringUtils.isEmpty((Object)fscComOrderListBO.getInvoiceCategory())) {
                fscComOrderListBO.setInvoiceCategoryStr((String)InvoiceCategoryMap.get(String.valueOf(fscComOrderListBO.getInvoiceCategory())));
            }
            if (!StringUtils.isEmpty((Object)fscComOrderListBO.getInvoiceType())) {
                fscComOrderListBO.setInvoiceTypeStr((String)invoiceTypeMap.get(fscComOrderListBO.getInvoiceType()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(shouldPayList = this.fscShouldPayMapper.getByFscOrderId(reqBO.getFscOrderId())))) {
            List dateList = shouldPayList.stream().map(FscShouldPayPO::getShouldPayDate).collect(Collectors.toList());
            dateList = dateList.stream().filter(Objects::nonNull).collect(Collectors.toList());
            List<String> objectNos = shouldPayList.stream().map(FscShouldPayPO::getObjectNo).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dateList)) {
                dateList.sort(Date::compareTo);
                fscComOrderListBO.setShouldPayDateStart((Date)dateList.get(0));
                fscComOrderListBO.setShouldPayDateEnd((Date)dateList.get(dateList.size() - 1));
            }
            if (!CollectionUtils.isEmpty(objectNos)) {
                fscComOrderListBO.setBusiObjectNos(objectNos);
            }
            List<FscBusiObjectBO> fscBusiObjectBOS = shouldPayList.stream().map(fscShouldPayPO -> {
                FscBusiObjectBO fscBusiObjectBO = new FscBusiObjectBO();
                fscBusiObjectBO.setBusiObjectId(fscShouldPayPO.getObjectId());
                fscBusiObjectBO.setBusiObjectNo(fscShouldPayPO.getObjectNo());
                fscBusiObjectBO.setBusiObjectType(fscShouldPayPO.getObjectType());
                return fscBusiObjectBO;
            }).collect(Collectors.toList());
            fscComOrderListBO.setBusiObjectBOS(fscBusiObjectBOS);
        }
        ArrayList<String> inspectionOper = new ArrayList<String>();
        ArrayList<String> receiverName = new ArrayList<String>();
        ArrayList<String> purPlaceOrderName = new ArrayList<String>();
        ArrayList<String> orderNos = new ArrayList<String>();
        if ((FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) && !CollectionUtils.isEmpty(orderIdList)) {
            FscUocProTransactionServiceListQueryReqBO fscUocProTransactionServiceListQueryReqBO = new FscUocProTransactionServiceListQueryReqBO();
            fscUocProTransactionServiceListQueryReqBO.setSaleOrderIdList(orderIdList);
            fscUocProTransactionServiceListQueryReqBO.setInspOrderIdList(acceptOrderIdList);
            fscUocProTransactionServiceListQueryReqBO.setPageSize(Integer.valueOf(20000));
            FscUocProTransactionServiceListQueryRspBO fscUocProTransactionServiceListQueryRspBO = this.fscUocProTransactionServiceListQueryAbilityService.queryTransactionServiceList(fscUocProTransactionServiceListQueryReqBO);
            if (!CollectionUtils.isEmpty((Collection)fscUocProTransactionServiceListQueryRspBO.getRows())) {
                fscUocProTransactionServiceListQueryRspBO.getRows().forEach(fscUocInspectionDetailsListBO -> {
                    if (!StringUtils.isEmpty((Object)fscUocInspectionDetailsListBO.getInspOper())) {
                        inspectionOper.add(fscUocInspectionDetailsListBO.getInspOper());
                    }
                    if (!StringUtils.isEmpty((Object)fscUocInspectionDetailsListBO.getReceiverUser())) {
                        receiverName.add(fscUocInspectionDetailsListBO.getReceiverUser());
                    }
                    if (!StringUtils.isEmpty((Object)fscUocInspectionDetailsListBO.getPurName())) {
                        purPlaceOrderName.add(fscUocInspectionDetailsListBO.getPurName());
                    }
                    if (!StringUtils.isEmpty((Object)fscUocInspectionDetailsListBO.getSaleOrderNo())) {
                        orderNos.add(fscUocInspectionDetailsListBO.getSaleOrderNo());
                    }
                });
                fscComOrderListBO.setInspectionOper(inspectionOper);
                fscComOrderListBO.setReceiverName(receiverName);
                fscComOrderListBO.setPurPlaceOrderName(purPlaceOrderName);
                fscComOrderListBO.setOrderNo(orderNos);
                fscComOrderListBO.setPurchaserId(Convert.toLong((Object)((FscUocProInspectionDetailsListBO)fscUocProTransactionServiceListQueryRspBO.getRows().get(0)).getPurOrgId()));
            }
        } else if (!CollectionUtils.isEmpty(acceptOrderIdList)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setInspOrderIdList(acceptOrderIdList);
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!StringUtils.isEmpty((Object)fscOrderInvoicePO) && !StringUtils.isEmpty((Object)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                Map fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
                if (!CollectionUtils.isEmpty((Map)fscOrderInfoBoMap)) {
                    acceptOrderIdList.forEach(acceptOrderId -> {
                        FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)fscOrderInfoBoMap.get(acceptOrderId);
                        if (!StringUtils.isEmpty((Object)fscOrderInfoBO.getInspectionOper())) {
                            inspectionOper.add(fscOrderInfoBO.getInspectionOper());
                        }
                        if (!StringUtils.isEmpty((Object)fscOrderInfoBO.getReceiverName())) {
                            receiverName.add(fscOrderInfoBO.getReceiverName());
                        }
                        if (!StringUtils.isEmpty((Object)fscOrderInfoBO.getPurPlaceOrderName())) {
                            purPlaceOrderName.add(fscOrderInfoBO.getPurPlaceOrderName());
                        }
                        if (!StringUtils.isEmpty((Object)fscOrderInfoBO.getSaleOrderNo())) {
                            orderNos.add(fscOrderInfoBO.getSaleOrderNo());
                        }
                        if (!StringUtils.isEmpty((Object)fscOrderInfoBO.getPurchaseOrderNo())) {
                            orderNos.add(fscOrderInfoBO.getPurchaseOrderNo());
                        }
                    });
                }
                fscComOrderListBO.setInspectionOper(inspectionOper);
                fscComOrderListBO.setReceiverName(receiverName);
                fscComOrderListBO.setPurPlaceOrderName(purPlaceOrderName);
                fscComOrderListBO.setOrderNo(orderNos);
            }
        }
        if (fscComOrderListBO.getBillCycle() != null) {
            fscComOrderListBO.setBillCycleStr(fscComOrderListBO.getBillCycle() + "\u4e2a\u81ea\u7136\u65e5");
        }
        fscComOrderListBO.setOrderFlowStr(Objects.requireNonNull(FscOrderFlowEnum.getInstance((Integer)fscComOrderListBO.getOrderFlow())).getDescr());
        fscComOrderListBO.setBusiCategoryStr((String)busiCategoryMap.get(fscComOrderListBO.getBusiCategory() + ""));
        fscComOrderListBO.setBuildActionStr((String)buildActionMap.get(fscComOrderListBO.getBuildAction() + ""));
        fscComOrderListBO.setOrderStateStr((String)orderStateMap.get(fscComOrderListBO.getOrderState() + ""));
        fscComOrderListBO.setShouldPayTypeStr((String)shouldPayTypeMap.get(fscComOrderListBO.getShouldPayType() + ""));
        fscComOrderListBO.setOrderSourceStr((String)orderSourceMap.get(fscComOrderListBO.getOrderSource() + ""));
        fscComOrderListBO.setPayTypeStr((String)payTypeMap.get(fscComOrderListBO.getPayType() + ""));
        fscComOrderListBO.setAttachmentList(attUrls);
        fscComOrderListBO.setPayEvidenceUrls(attUrls);
        fscComOrderListBO.setRespCode("0000");
        fscComOrderListBO.setRespDesc("\u6210\u529f");
        return fscComOrderListBO;
    }

    private FscPebExtOrdStatisticRspBO qryYearOrdInfo(Long supId, Integer searchType, String effTime, String expTime) {
        FscPebExtOrdStatisticReqBO fscPebExtOrdStatisticReqBO = new FscPebExtOrdStatisticReqBO();
        fscPebExtOrdStatisticReqBO.setSupNo(supId.toString());
        fscPebExtOrdStatisticReqBO.setSearchType(searchType);
        fscPebExtOrdStatisticReqBO.setCreateTimeEff(effTime);
        fscPebExtOrdStatisticReqBO.setCreateTimeExp(expTime);
        FscPebExtOrdStatisticRspBO fscPebExtOrdStatisticRspBO = this.fscPebExtOrdStatisticAbilityService.queryOrdStatisticInfo(fscPebExtOrdStatisticReqBO);
        if (!"0000".equals(fscPebExtOrdStatisticRspBO.getRespCode())) {
            throw new FscBusinessException("193111", fscPebExtOrdStatisticRspBO.getRespDesc());
        }
        return fscPebExtOrdStatisticRspBO;
    }

    private void validateParams(FscComOrderListQueryBusiReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u3010fscOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u3010fscOrderId\u3011\u4e0d\u80fd\u4e3a0");
        }
    }
}

