/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService"})
public class FscComOrderCancelAbilityServiceImpl
implements FscComOrderCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscComOrderCancelBusiService fscComOrderCancelBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;

    @PostMapping(value={"dealOrderCancel"})
    public FscComOrderCancelAbilityRspBO dealOrderCancel(@RequestBody FscComOrderCancelAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if ("2".equals(reqBO.getIsprofess())) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u7528\u6237\u4e0d\u80fd\u53d6\u6d88\u7ed3\u7b97\u5355");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191125", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e3a\u7a7a");
        }
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) && !FscBillStatus.TO_BE_INVOICED.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001");
        }
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && !FscBillStatus.INVOICING_SUBMISSION.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u8d38\u6613\u6a21\u5f0f\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001");
        }
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && !FscBillStatus.INVOICING_SUBMISSION.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u7535\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\uff0c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\uff0c\u540e\u7eed\u72b6\u6001\u5f85\u4e0e\u7535\u5546\u5bf9\u63a5\u53d6\u6d88\u53d1\u7968\u63a5\u53e3\u540e\u542f\u7528");
        }
        reqBO.setOrderState(fscOrderPO.getOrderState());
        String jsonString = JSON.toJSONString((Object)reqBO);
        FscComOrderCancelBusiReqBO busiReqBO = (FscComOrderCancelBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderCancelBusiReqBO.class));
        busiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
        FscComOrderCancelBusiRspBO fscComOrderCancelBusiRspBO = this.fscComOrderCancelBusiService.dealOrderCancel(busiReqBO);
        if (!"0000".equals(fscComOrderCancelBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191125", fscComOrderCancelBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        this.syncOrderCheckStatus(fscOrderPO);
        return new FscComOrderCancelAbilityRspBO();
    }

    private void sendMq(FscComOrderCancelAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void syncOrderCheckStatus(FscOrderPO fscOrderPO) {
        log.info("\u53d6\u6d88\u53d1\u7968\u5165\u53c2\uff1a{}", (Object)fscOrderPO);
        if ("3".equals(fscOrderPO.getOrderSource().toString()) && (FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType()) || FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()))) {
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setFscOrderId(fscOrderPO.getFscOrderId());
            List fscOrderRelationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            FscOrderRelationPO fscOrderRelationPoAll = new FscOrderRelationPO();
            fscOrderRelationPoAll.setAcceptOrderId(((FscOrderRelationPO)fscOrderRelationPOList.get(0)).getAcceptOrderId());
            List fscOrderRelationPOAllList = this.fscOrderRelationMapper.getList(fscOrderRelationPoAll);
            FscOrderPO fscOrderPOAll = new FscOrderPO();
            fscOrderPOAll.setOrderFlow(FscConstants.OrderFlow.INVOICE);
            fscOrderPOAll.setFscOrderIds(fscOrderRelationPOAllList.stream().map(FscOrderRelationPO::getFscOrderId).collect(Collectors.toList()));
            List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPOAll);
            log.info("fscOrderPOList:{}", (Object)fscOrderPOList);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPOList) && fscOrderPOList.size() > 1) {
                return;
            }
            for (FscOrderRelationPO po : fscOrderRelationPOList) {
                FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
                uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.NOT_CHECK);
                uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(po.getAcceptOrderId());
                uocOrderSyncCheckStatusReqBO.setOrderId(po.getOrderId());
                log.info("\u53d6\u6d88\u7ed3\u7b97\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)uocOrderSyncCheckStatusReqBO);
                FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
                if ("0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) continue;
                this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, po);
            }
        }
    }

    private void writeFailLog(FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO, FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO, FscOrderRelationPO fscOrderRelationPO) {
        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
        long id = Sequence.getInstance().nextId();
        fscOrderFailLogUpdateAtomReqBO.setId(Long.valueOf(id));
        fscOrderFailLogUpdateAtomReqBO.setObjId(uocOrderSyncCheckStatusReqBO.getOrderId());
        fscOrderFailLogUpdateAtomReqBO.setObjNo(fscOrderRelationPO.getOrderNo());
        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC);
        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(uocOrderSyncCheckStatusRspBO.getRespDesc());
        FscOrderFailLogUpdateAtomRspBO fscOrderFailLogUpdateAtomRspBO = this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
        if (!"0000".equals(fscOrderFailLogUpdateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193002", fscOrderFailLogUpdateAtomRspBO.getRespDesc());
        }
    }
}

