/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.common.busi.api.FscComOrderConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderConfirmBusiServiceImpl
implements FscComOrderConfirmBusiService {
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    public static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    public static final String BUSI_CODE = "1005";

    @Override
    public FscComOrderConfirmBusiRspBO dealOrderConfirm(FscComOrderConfirmBusiReqBO reqBO) {
        FscOrderPO set = new FscOrderPO();
        set.setOrderConfirmId(reqBO.getUserName());
        set.setOrderConfirmName(reqBO.getName());
        set.setOrderConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(reqBO.getOrderId());
        this.fscOrderMapper.updateBy(set, where);
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            this.createShouldPay(reqBO.getFscShouldPayBOS(), reqBO);
        }
        if (!FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            this.updateOrderInvoice(reqBO);
        }
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(FscBillStatus.TO_BE_CONFIRM.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193110", flowAtomRspBO.getRespDesc());
        }
        return new FscComOrderConfirmBusiRspBO();
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscComOrderConfirmBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193110", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void updateOrderInvoice(FscComOrderConfirmBusiReqBO busiReqBO) {
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderInvoicePO.class);
        fscOrderInvoicePO.setFscOrderId(busiReqBO.getOrderId());
        if (null != busiReqBO.getUserId()) {
            fscOrderInvoicePO.setBillOperId(busiReqBO.getUserId().toString());
        }
        fscOrderInvoicePO.setBillOperName(busiReqBO.getUserName());
        fscOrderInvoicePO.setBillTime(new Date());
        FscOrderInvoicePO wherePO = new FscOrderInvoicePO();
        wherePO.setFscOrderId(busiReqBO.getOrderId());
        int insert = this.fscOrderInvoiceMapper.updateBy(fscOrderInvoicePO, wherePO);
    }
}

