/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscBalanceReqBO;
import com.tydic.fsc.common.ability.api.FscComBalanceListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComBalanceBO;
import com.tydic.fsc.common.ability.bo.FscComBalanceListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComBalanceListQueryAbilityRspBO;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComBalanceListQueryAbilityService"})
public class FscComBalanceListQueryAbilityServiceImpl
implements FscComBalanceListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComBalanceListQueryAbilityServiceImpl.class);
    @Autowired
    private FscBalanceMapper fscBalanceMapper;

    @PostMapping(value={"qryBalanceList"})
    public FscComBalanceListQueryAbilityRspBO qryBalanceList(@RequestBody FscComBalanceListQueryAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscBalanceReqBO fscBalanceReqBO = new FscBalanceReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)fscBalanceReqBO);
        String isprofess = reqBO.getIsprofess();
        log.debug("\u5f53\u524d\u67e5\u8be2\u7528\u6237\u6240\u5c5e\u5355\u4f4d\u4e3a:{}", (Object)isprofess);
        if ("0".equals(isprofess) && !reqBO.getIsSelfOrg().booleanValue()) {
            fscBalanceReqBO.setOrgId(null);
        }
        log.debug("\u67e5\u8be2\u4f59\u989d\u5217\u8868\u5165\u53c2\u6570:{}", (Object)fscBalanceReqBO);
        List fscBalanceMapperList = this.fscBalanceMapper.getListPage(fscBalanceReqBO, page);
        log.debug("\u4f59\u989d\u7edf\u8ba1\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u96c6\u5408\u4e3a:{}", (Object)fscBalanceMapperList);
        ArrayList<FscComBalanceBO> rows = new ArrayList<FscComBalanceBO>();
        BigDecimal frozenAmountTotal = BigDecimal.ZERO;
        BigDecimal usableAmountTotal = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)fscBalanceMapperList)) {
            for (FscBalancePO fscBalancePO : fscBalanceMapperList) {
                fscBalancePO.setUsableAmount(fscBalancePO.getUsableAmount().setScale(2, RoundingMode.HALF_UP));
                fscBalancePO.setFrozenAmount(fscBalancePO.getFrozenAmount().setScale(2, RoundingMode.HALF_UP));
                FscComBalanceBO bo = new FscComBalanceBO();
                BeanUtils.copyProperties((Object)fscBalancePO, (Object)bo);
                rows.add(bo);
                frozenAmountTotal = frozenAmountTotal.add(fscBalancePO.getFrozenAmount());
                usableAmountTotal = usableAmountTotal.add(fscBalancePO.getUsableAmount());
            }
        }
        frozenAmountTotal.setScale(2, RoundingMode.HALF_UP);
        usableAmountTotal.setScale(2, RoundingMode.HALF_UP);
        log.debug("\u4f59\u989d\u7edf\u8ba1\u67e5\u8be2\u51bb\u7ed3\u91d1\u989d\u4e0e\u53ef\u63d0\u73b0\u91d1\u989d\u603b\u91cf\u4e3a:{},{}", (Object)frozenAmountTotal, (Object)usableAmountTotal);
        log.debug("\u4f59\u989d\u67e5\u8be2\u6570\u636e\u51fa\u53c2rows:{}", rows);
        FscComBalanceListQueryAbilityRspBO rspBO = new FscComBalanceListQueryAbilityRspBO();
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setFrozenAmountTotal(frozenAmountTotal);
        rspBO.setUsableAmountTotal(usableAmountTotal);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f!");
        return rspBO;
    }
}

