/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.fsc.bo.FscMerchantConfDataBO;
import com.tydic.fsc.common.ability.bo.FscMerchantConfBatchQueryReqDataBO;
import com.tydic.fsc.common.busi.api.FscMerchantConfBatchQueryBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantConfBatchQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantConfBatchQueryBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscSkuCategoryMapper;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscSkuCategoryPO;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgClassMapAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgClassMapAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgClassMapAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantConfBatchQueryBusiService")
public class FscMerchantConfBatchQueryBusiServiceImpl
implements FscMerchantConfBatchQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantConfBatchQueryBusiServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscSkuCategoryMapper fscSkuCategoryMapper;
    @Autowired
    private UmcEnterpriseOrgClassMapAbilityService umcEnterpriseOrgClassMapAbilityService;

    @Override
    public FscMerchantConfBatchQueryBusiRspBO queryConfBatch(FscMerchantConfBatchQueryBusiReqBO reqBO) {
        FscMerchantConfBatchQueryBusiRspBO retBo = (FscMerchantConfBatchQueryBusiRspBO)FscRspUtil.getSuccessRspBo(FscMerchantConfBatchQueryBusiRspBO.class);
        ArrayList<FscMerchantConfDataBO> config = new ArrayList<FscMerchantConfDataBO>();
        retBo.setConfig(config);
        List<FscMerchantConfBatchQueryReqDataBO> queryParams = reqBO.getQueryParams();
        ArrayList<FscMerchantPO> queryPos = new ArrayList<FscMerchantPO>();
        for (FscMerchantConfBatchQueryReqDataBO param : queryParams) {
            FscMerchantPO queryPo = new FscMerchantPO();
            queryPo.setOrgId(param.getSupOrgId());
            queryPo.setStatus(FscConstants.MerchantStatus.VALID);
            queryPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            queryPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
            queryPos.add(queryPo);
        }
        List resultPos = this.fscMerchantMapper.selectModelSettleBatch(queryPos);
        if (CollectionUtils.isEmpty((Collection)resultPos)) {
            log.info("\u6279\u91cf\u67e5\u8be2\u4e3b\u5546\u6237\u7ed3\u679c\u4e3a\u7a7a");
            retBo.setRespDesc("\u6279\u91cf\u67e5\u8be2\u4e3b\u5546\u6237\u7ed3\u679c\u4e3a\u7a7a");
            return retBo;
        }
        Map<Long, FscMerchantPO> mainMerchantMap = resultPos.stream().collect(Collectors.toMap(FscMerchantPO::getOrgId, item -> item));
        List purOrgIds = queryParams.stream().map(FscMerchantConfBatchQueryReqDataBO::getPurOrgId).collect(Collectors.toList());
        purOrgIds.removeIf(Objects::isNull);
        UmcEnterpriseOrgClassMapAbilityReqBO umcEnterpriseOrgClassMapAbilityReqBO = new UmcEnterpriseOrgClassMapAbilityReqBO();
        umcEnterpriseOrgClassMapAbilityReqBO.setOrgIds(purOrgIds);
        log.info("\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u5355\u4f4d\u7684\u7c7b\u578b\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcEnterpriseOrgClassMapAbilityReqBO));
        UmcEnterpriseOrgClassMapAbilityRspBO umcEnterpriseOrgClassMapAbilityRspBO = this.umcEnterpriseOrgClassMapAbilityService.queryEnterpriseOrgClassMap(umcEnterpriseOrgClassMapAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u91c7\u8d2d\u5355\u4f4d\u7684\u7c7b\u578b\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcEnterpriseOrgClassMapAbilityRspBO));
        for (FscMerchantConfBatchQueryReqDataBO param : queryParams) {
            FscMerchantConfDataBO configData = new FscMerchantConfDataBO();
            BeanUtils.copyProperties((Object)param, (Object)configData);
            FscMerchantPO mainMerchant = mainMerchantMap.get(param.getSupOrgId());
            if (null == mainMerchant) {
                configData.setFailReason("\u672a\u67e5\u8be2\u5230\u673a\u6784[" + param.getSupOrgId() + "]\u7684\u5546\u6237\u4fe1\u606f");
                continue;
            }
            if (mainMerchant.getModelAllowExceptionFlag() == 0) {
                configData.setModelSettle(mainMerchant.getModelSettle());
                config.add(configData);
                continue;
            }
            configData.setModelSettle(mainMerchant.getModelSettle());
            FscMerchantPO exceptionPo = new FscMerchantPO();
            exceptionPo.setParentId(mainMerchant.getMerchantId());
            if (param.getPurOrgId() != null) {
                String s = (String)umcEnterpriseOrgClassMapAbilityRspBO.getOrgClassMap().get(param.getPurOrgId());
                if (!StringUtils.isEmpty((Object)s) && s.equals("1")) {
                    exceptionPo.setModelUserIdentity(Integer.valueOf(3));
                } else if (!StringUtils.isEmpty((Object)s) && s.equals("2")) {
                    exceptionPo.setModelUserIdentity(Integer.valueOf(2));
                } else if (!StringUtils.isEmpty((Object)s) && s.equals("4")) {
                    exceptionPo.setModelUserIdentity(Integer.valueOf(0));
                } else if (!StringUtils.isEmpty((Object)s) && s.equals("3")) {
                    exceptionPo.setModelUserIdentity(Integer.valueOf(1));
                } else {
                    throw new BusinessException("8888", "\u4f1a\u5458\u4e2d\u5fc3\u91c7\u8d2d\u5355\u4f4d\u7c7b\u578b\u5b57\u5178\u503c\u4e0d\u6b63\u786e");
                }
            }
            if (null != param.getModelContractId()) {
                exceptionPo.setModelContractId(param.getModelContractId());
            }
            exceptionPo.setExceptionUserLatitude(Integer.valueOf(1));
            exceptionPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            exceptionPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            exceptionPo.setExceptionCategory(FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL);
            exceptionPo.setCategoryTreePath(param.getCommodityTypeId());
            exceptionPo = this.fscMerchantMapper.getModelByLeftJoinFscSkuCategory(exceptionPo);
            if (null == exceptionPo) {
                exceptionPo = new FscMerchantPO();
                exceptionPo.setParentId(mainMerchant.getMerchantId());
                if (null != param.getModelContractId()) {
                    exceptionPo.setModelContractId(param.getModelContractId());
                }
                exceptionPo.setExceptionUserLatitude(Integer.valueOf(2));
                exceptionPo.setModelObjId(param.getPurOrgId());
                exceptionPo.setModelUserIdentity(null);
                exceptionPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
                exceptionPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
                exceptionPo.setExceptionCategory(FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL);
                exceptionPo.setCategoryTreePath(param.getCommodityTypeId());
                exceptionPo = this.fscMerchantMapper.getModelByLeftJoinFscSkuCategory(exceptionPo);
            }
            if (null == exceptionPo) {
                configData.setModelSettle(mainMerchant.getModelSettle());
                config.add(configData);
                continue;
            }
            if (!StringUtils.isEmpty((Object)param.getCommodityTypeId())) {
                FscSkuCategoryPO commodityTypePo = new FscSkuCategoryPO();
                commodityTypePo.setMerchantId(exceptionPo.getMerchantId());
                commodityTypePo.setCategoryTreePath(param.getCommodityTypeId());
                commodityTypePo = this.fscSkuCategoryMapper.getModelBy(commodityTypePo);
                if (null == commodityTypePo) {
                    configData.setModelSettle(mainMerchant.getModelSettle());
                    config.add(configData);
                    continue;
                }
            }
            configData.setModelSettle(exceptionPo.getModelSettle());
            config.add(configData);
        }
        return retBo;
    }
}

