/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.busi.api.FscPayBillWriteOffBusiService;
import com.tydic.fsc.common.busi.bo.FscPayBillWriteOffBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPayBillWriteOffBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillWriteOffBusiServiceImpl
implements FscPayBillWriteOffBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillWriteOffBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private UmcDycEnterpriseOrgQryDetailAbilityService umcDycEnterpriseOrgQryDetailAbilityService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FscPayBillWriteOffBusiRspBO payBillWriteOff(FscPayBillWriteOffBusiReqBO reqBO) {
        FscPayBillWriteOffBusiRspBO retBo = new FscPayBillWriteOffBusiRspBO();
        FscBankCheckFileItemPO fscBankCheckFileItemPOQry = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPOQry.setWriteOffFlag("0".toString());
        fscBankCheckFileItemPOQry.setBankCheckIdS(reqBO.getBankCheckIds());
        List FscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPOQry);
        if (CollectionUtils.isEmpty((Collection)FscBankCheckFileItemPOList) || reqBO.getBankCheckIds().size() != FscBankCheckFileItemPOList.size()) {
            throw new FscBusinessException("198888", "\u672a\u6838\u9500\u72b6\u6001\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u8bd5");
        }
        FscOrderPO fscOrderPOQry = new FscOrderPO();
        fscOrderPOQry.setFscOrderIds(reqBO.getFscOrderId());
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPOQry);
        String payeeBankAccount = ((FscOrderPO)fscOrderPOList.get(0)).getPayeeBankAccount();
        for (Object fscOrderPOFor : fscOrderPOList) {
            if (!StringUtils.isEmpty((Object)payeeBankAccount) && !payeeBankAccount.equals(fscOrderPOFor.getPayeeBankAccount())) {
                throw new FscBusinessException("198888", "\u6536\u6b3e\u5355\u4f4d\u5fc5\u987b\u76f8\u540c");
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(fscOrderPOFor.getFscOrderId());
            if (null != reqBO.getUserId()) {
                fscOrderPO.setPayOperId(reqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(reqBO.getName());
            fscOrderPO.setPayTime(new Date());
            fscOrderPO.setPayState(FscConstants.PayOrderPayStatus.PAIED);
            fscOrderPO.setActualAmount(fscOrderPOFor.getTotalCharge());
            int row = this.fscOrderMapper.updateById(fscOrderPO);
            if (row < 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
            for (FscBankCheckFileItemPO fscBankCheckFileItemPOFor : FscBankCheckFileItemPOList) {
                FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
                fscBankCheckFileItemPO.setWriteOffFlag("2".toString());
                fscBankCheckFileItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
                int rows = this.fscBankCheckFileItemMapper.updateByBankCheckId(fscBankCheckFileItemPO);
                if (rows < 1) {
                    throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                }
                FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                fscWriteOffItemPO.setMemo(reqBO.getMemo());
                fscWriteOffItemPO.setFscOrderId(fscOrderPOFor.getFscOrderId());
                fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
                fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                fscWriteOffItemPOList.add(fscWriteOffItemPO);
            }
            if (CollectionUtils.isEmpty(fscWriteOffItemPOList)) continue;
            this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
        }
        ArrayList<FscBalancePO> fscBalancePOList = new ArrayList<FscBalancePO>();
        for (FscBankCheckFileItemPO fscBankCheckFileItemPOFor : FscBankCheckFileItemPOList) {
            UmcDycEnterpriseOrgQryDetailAbilityReqBO umcDycEnterpriseOrgQryDetailAbilityReqBO = new UmcDycEnterpriseOrgQryDetailAbilityReqBO();
            umcDycEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscBankCheckFileItemPOFor.getPayeeId());
            log.info("\u67e5\u8be2\u6536\u6b3e\u5355\u4f4d\u662f\u5426\u662f\u8fd0\u8425\u5165\u53c2:{}", (Object)umcDycEnterpriseOrgQryDetailAbilityReqBO);
            UmcDycEnterpriseOrgQryDetailAbilityRspBO rspBO = this.umcDycEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcDycEnterpriseOrgQryDetailAbilityReqBO);
            log.info("\u67e5\u8be2\u6536\u6b3e\u5355\u4f4d\u662f\u5426\u662f\u4e91\u5929\u51fa\u53c2:{}", (Object)rspBO);
            if (!ObjectUtils.isEmpty((Object)rspBO.getEnterpriseOrgBO()) && rspBO.getEnterpriseOrgBO().getIsProfessionalOrg().equals("0")) continue;
            FscBalancePO fscBalancePO = new FscBalancePO();
            fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscBalancePO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
            fscBalancePO.setOrgId(((FscOrderPO)fscOrderPOList.get(0)).getPayeeId());
            fscBalancePO.setOrgCode("");
            fscBalancePO.setOrgName(((FscOrderPO)fscOrderPOList.get(0)).getPayeeName());
            fscBalancePO.setSubAccountNo(((FscOrderPO)fscOrderPOList.get(0)).getPayeeBankAccount());
            fscBalancePO.setPayerOrgId(((FscOrderPO)fscOrderPOList.get(0)).getPayerId());
            fscBalancePO.setPayerOrgName(((FscOrderPO)fscOrderPOList.get(0)).getPayerName());
            fscBalancePO.setPayerOrgCode(null);
            fscBalancePO.setPayerSubAccountNo(null);
            fscBalancePO.setFrozenEndTime(this.getConfiguration(((FscOrderPO)fscOrderPOList.get(0)).getPayeeId().toString()));
            fscBalancePO.setPayAmount(fscBankCheckFileItemPOFor.getTradeAmt());
            if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                fscBalancePO.setFrozenAmount(new BigDecimal(0));
                fscBalancePO.setUsableAmount(fscBankCheckFileItemPOFor.getTradeAmt());
                fscBalancePO.setThawOperTime(new Date());
            } else {
                fscBalancePO.setFrozenAmount(fscBankCheckFileItemPOFor.getTradeAmt());
                fscBalancePO.setUsableAmount(new BigDecimal(0));
            }
            fscBalancePO.setUsedAmount(new BigDecimal(0));
            fscBalancePO.setCreateTime(new Date());
            fscBalancePOList.add(fscBalancePO);
        }
        if (!CollectionUtils.isEmpty(fscBalancePOList)) {
            this.fscBalanceMapper.insertBatch(fscBalancePOList);
        }
        if (null != reqBO.getFscOrderId()) {
            FscOrderStatusFlowBusiReqBO fscOrderStatusFlowBusiReqBO = new FscOrderStatusFlowBusiReqBO();
            fscOrderStatusFlowBusiReqBO.setOrderIds(reqBO.getFscOrderId());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("confirmFlag", 0);
            fscOrderStatusFlowBusiReqBO.setParamMap(paramMap);
            fscOrderStatusFlowBusiReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            FscOrderStatusFlowBusiRspBO busiflowRspBO = this.fscOrderStatusFlowBusiService.dealStatusFlow(fscOrderStatusFlowBusiReqBO);
            if (!"0000".equals(busiflowRspBO.getRespCode())) {
                throw new FscBusinessException(busiflowRspBO.getRespCode(), busiflowRspBO.getRespDesc());
            }
        }
        return retBo;
    }

    private Date getConfiguration(String relId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }
}

