/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscBillMailBO;
import com.tydic.fsc.busibase.busi.bo.FscBillMailListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.config.FscEsConfig;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.busi.api.FscEsQryBillMailListBusiService;
import com.tydic.fsc.common.busi.bo.FscBillMailPageQueryBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.fsc.utils.FscBuildEsQrySqlConditionUtil;
import com.tydic.fsc.utils.FscElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscEsQryBillMailListBusiServiceImpl
implements FscEsQryBillMailListBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEsQryBillMailListBusiServiceImpl.class);
    private final FscEsConfig fscEsConfig;
    private final FscElasticsearchUtil fscElasticsearchUtil;
    private final FscBuildEsQrySqlConditionUtil buildEsQrySqlConditionUtil;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;

    @Autowired
    public FscEsQryBillMailListBusiServiceImpl(FscEsConfig fscEsConfig, FscElasticsearchUtil fscElasticsearchUtil, FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService) {
        this.fscEsConfig = fscEsConfig;
        this.fscElasticsearchUtil = fscElasticsearchUtil;
        this.buildEsQrySqlConditionUtil = new FscBuildEsQrySqlConditionUtil();
    }

    @Override
    @BigDecimalConvert(value=2)
    public FscBillMailPageQueryBusiRspBO esQryBillMailList(FscBillMailListPageQueryBusiReqBO reqBO) {
        String rule = this.queryRule();
        FscBillMailPageQueryBusiRspBO rspBO = new FscBillMailPageQueryBusiRspBO();
        String qryString = this.buildEsQrySqlConditionUtil.buildBillMailEsSql(reqBO);
        log.debug("ES\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f\u6761\u4ef6---->" + qryString);
        String endPoint = null;
        if ("1".equals(rule)) {
            endPoint = "/" + this.fscEsConfig.getMailByNameIndexName() + "/_search";
        } else if ("2".equals(rule)) {
            endPoint = "/" + this.fscEsConfig.getMailByNoIndexName() + "/_search";
        }
        String result = null;
        Request request = new Request("POST", endPoint);
        request.setJsonEntity(qryString);
        try {
            Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest(request);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.fscElasticsearchUtil.createIndex(this.fscEsConfig.getMailByNameIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("191001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest(request);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("\u5931\u8d25");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f\u5931\u8d25!");
                    return rspBO;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f\u5931\u8d25!");
            return rspBO;
        }
        System.out.println("ES\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u4fe1\u606fresult---->" + result);
        this.resolveReturnData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        return rspBO;
    }

    private String queryRule() {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("bundling_rules");
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("193114", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        return fscCfcUniteParamQryListDetailExternalRspBO.getBalingRules();
    }

    private void resolveReturnData(String result, FscBillMailPageQueryBusiRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
        Integer total = totalObj.getInteger("value");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f!");
            return;
        }
        ArrayList<FscBillMailBO> rows = new ArrayList<FscBillMailBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            FscBillMailBO fscBillMailBO = (FscBillMailBO)JSON.toJavaObject((JSON)objJson, FscBillMailBO.class);
            rows.add(fscBillMailBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u53d1\u7968\u90ae\u5bc4\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
    }
}

