/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscCashierPayMethodEditAbilityService;
import com.tydic.fsc.common.ability.bo.FscCashierPayMethodEditAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCashierPayMethodEditAbilityRspBO;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.payment.pay.atom.CashierPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.dao.po.CashierPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCashierPayMethodEditAbilityService"})
public class FscCashierPayMethodEditAbilityServiceImpl
implements FscCashierPayMethodEditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCashierPayMethodEditAbilityServiceImpl.class);
    private static final int OPERATE_TYPE_ADD = 1;
    private static final int OPERATE_TYPE_DELETE = 2;
    @Autowired
    private CashierPayMethodRelAtomService cashierPayMethodRelAtomService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    @PostMapping(value={"editCashierPayMethod"})
    public FscCashierPayMethodEditAbilityRspBO editCashierPayMethod(@RequestBody FscCashierPayMethodEditAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("=========\u6536\u94f6\u53f0\u652f\u4ed8\u65b9\u5f0f\u7f16\u8f91API\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscCashierPayMethodEditAbilityRspBO retBo = (FscCashierPayMethodEditAbilityRspBO)FscRspUtil.getSuccessRspBo(FscCashierPayMethodEditAbilityRspBO.class);
        this.validateArgs(reqBO);
        String relId = null;
        switch (reqBO.getOperateType()) {
            case 1: {
                this.addRel(reqBO);
                break;
            }
            case 2: {
                relId = this.removeRel(reqBO);
                break;
            }
        }
        retBo.setRelId(relId);
        if (log.isDebugEnabled()) {
            log.debug("=========\u6536\u94f6\u53f0\u652f\u4ed8\u65b9\u5f0f\u7f16\u8f91API\u7ed3\u675f\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private void addRel(FscCashierPayMethodEditAbilityReqBO reqBO) {
        this.deleteOldData(reqBO);
        Date nowTime = this.fscMerchantMapper.getDBDate();
        CashierPayMethodRelPo relPo = new CashierPayMethodRelPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)relPo);
        relPo.setCreateOperId(reqBO.getName());
        relPo.setCreateTime(nowTime);
        List<String> payMethods = Arrays.asList(reqBO.getPayMethod().split(","));
        for (String payMethod : payMethods) {
            relPo.setPayMethod(Long.valueOf(payMethod));
            this.cashierPayMethodRelAtomService.createCashierPayMethodRel(relPo);
        }
    }

    private void deleteOldData(FscCashierPayMethodEditAbilityReqBO reqBO) {
        CashierPayMethodRelPo validatePo = new CashierPayMethodRelPo();
        validatePo.setCashierTemplate(reqBO.getCashierTemplate());
        List relPos = this.cashierPayMethodRelAtomService.queryCashierPayMethodRelByCondition(validatePo);
        if (CollectionUtils.isEmpty((Collection)relPos)) {
            return;
        }
        List<String> payMethods = Arrays.asList(reqBO.getPayMethod().split(","));
        PayMethodPo payMethodPo = this.payMethodAtomService.queryPayMethodById(Long.valueOf(payMethods.get(0)));
        if (null == payMethodPo) {
            throw new FscBusinessException("191114", "\u652f\u4ed8\u65b9\u5f0f\u7f16\u7801\u975e\u6cd5");
        }
        PayMethodPo queryMethodPo = new PayMethodPo();
        queryMethodPo.setPaymentInsId(payMethodPo.getPaymentInsId());
        List payMethodPoList = this.payMethodAtomService.queryPayMethod(queryMethodPo);
        List innerPayMethodList = payMethodPoList.stream().map(item -> item.getPayMethod()).collect(Collectors.toList());
        List<Long> relIds = relPos.stream().filter(item -> innerPayMethodList.contains(item.getPayMethod())).map(item -> item.getId()).collect(Collectors.toList());
        CashierPayMethodRelPo deletePo = new CashierPayMethodRelPo();
        relIds.forEach(item -> {
            deletePo.setId(item);
            int result = this.cashierPayMethodRelAtomService.deleteCashierPayMethodRel(deletePo);
            if (result < 1) {
                throw new FscBusinessException("191114", "\u6267\u884c\u65b0\u589e\u65f6\u5f02\u5e38");
            }
        });
    }

    private String removeRel(FscCashierPayMethodEditAbilityReqBO reqBO) {
        CashierPayMethodRelPo relPo = new CashierPayMethodRelPo();
        relPo.setId(Long.valueOf(reqBO.getRelId()));
        int result = this.cashierPayMethodRelAtomService.deleteCashierPayMethodRel(relPo);
        if (result < 1) {
            throw new FscBusinessException("191114", "\u5220\u9664\u5931\u8d25");
        }
        return reqBO.getRelId();
    }

    private void validateArgs(FscCashierPayMethodEditAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperateType()) {
            throw new FscBusinessException("191000", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (reqBO.getOperateType()) {
            case 1: {
                if (null == reqBO.getCashierTemplate()) {
                    throw new FscBusinessException("191000", "\u6536\u94f6\u53f0ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null != reqBO.getPayMethod()) break;
                throw new FscBusinessException("191000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case 2: {
                if (null != reqBO.getRelId()) break;
                throw new FscBusinessException("191000", "\u5173\u7cfbID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            default: {
                throw new FscBusinessException("191000", "\u64cd\u4f5c\u7c7b\u578b\u975e\u6cd5");
            }
        }
    }
}

