/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscStockBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscStockListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscStockListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscStockListQryAbilityRspBO;
import com.tydic.fsc.dao.FscStockMapper;
import com.tydic.fsc.po.FscStockPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscStockListQryAbilityService"})
public class FscStockListQryAbilityServiceImpl
implements FscStockListQryAbilityService {
    @Autowired
    private FscStockMapper fscStockMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryStockList"})
    public FscStockListQryAbilityRspBO qryStockList(@RequestBody FscStockListQryAbilityReqBO reqBO) {
        FscStockPO fscStockPO = (FscStockPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscStockPO.class);
        fscStockPO.setOrderNo(reqBO.getFscOrderNo());
        fscStockPO.setSyncState(reqBO.getSyncState());
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        fscStockPO.setOrderBy("s.create_time");
        List fscStockPageList = this.fscStockMapper.getListPage(fscStockPO, page);
        if (CollectionUtils.isEmpty((Collection)fscStockPageList)) {
            return new FscStockListQryAbilityRspBO();
        }
        List fscStockBOList = JSON.parseArray((String)JSON.toJSONString((Object)fscStockPageList), FscStockBO.class);
        Map<Long, FscStockPO> fscStockMap = fscStockPageList.stream().collect(Collectors.toMap(FscStockPO::getId, m -> m));
        for (FscStockBO fscStockBO : fscStockBOList) {
            fscStockBO.setFscOrderNo(fscStockMap.get(fscStockBO.getId()).getOrderNo());
            Map financialSyncState = this.fscDictionaryBusiService.queryBypCodeBackMap("FINANCIAL_SYNC_STATE");
            fscStockBO.setSyncStateStr(ObjectUtil.isEmpty((Object)fscStockBO.getSyncState()) ? "\u672a\u540c\u6b65" : (String)financialSyncState.get(fscStockBO.getSyncState().toString()));
        }
        FscStockListQryAbilityRspBO rspBO = new FscStockListQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(fscStockBOList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }
}

