/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcQryOverduePaymentRuleAbilityService;
import com.tydic.cfc.ability.bo.CfcQryOverduePaymentRuleAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryOverduePaymentRuleAbilityRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.busi.api.FscAuditInvoiceWriteOffBankFileBusiService;
import com.tydic.fsc.common.busi.bo.FscAuditInvoiceWriteOffBankFileBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAuditInvoiceWriteOffBankFileBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOutPayRecordMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOutPayRecordPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAuditInvoiceWriteOffBankFileBusiServiceImpl
implements FscAuditInvoiceWriteOffBankFileBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAuditInvoiceWriteOffBankFileBusiServiceImpl.class);
    @Autowired
    private FscOutPayRecordMapper fscOutPayRecordMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private CfcQryOverduePaymentRuleAbilityService cfcQryOverduePaymentRuleAbilityService;

    @Override
    public FscAuditInvoiceWriteOffBankFileBusiRspBO auditInvoiceWriteOffBankFile(FscAuditInvoiceWriteOffBankFileBusiReqBO reqBO) {
        FscAuditInvoiceWriteOffBankFileBusiRspBO rspBO = new FscAuditInvoiceWriteOffBankFileBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOutPayRecordPO fscOutPayRecordPO = new FscOutPayRecordPO();
        fscOutPayRecordPO.setPayerSecondOrgId(reqBO.getSecondOrgId());
        fscOutPayRecordPO.setWriteOffFlag(Integer.valueOf(Integer.parseInt("0")));
        List fscOutPayRecordPOList = this.fscOutPayRecordMapper.getList(fscOutPayRecordPO);
        if (ObjectUtil.isEmpty((Object)fscOutPayRecordPOList)) {
            log.info("\u4ed8\u6b3e\u5355\u4f4dsbu:{},\u672a\u67e5\u8be2\u5230\u5f85\u6838\u9500\u4ed8\u6b3e\u8bb0\u5f55", (Object)reqBO.getSecondOrgId());
            return rspBO;
        }
        ArrayList<Long> bankCheckItemIds = new ArrayList<Long>();
        ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
        ArrayList<FscBalancePO> fscBalancePOList = new ArrayList<FscBalancePO>();
        ArrayList<Long> outPayRecordIds = new ArrayList<Long>();
        for (FscOutPayRecordPO item : fscOutPayRecordPOList) {
            if (!this.checkOverDay(item).booleanValue()) continue;
            FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPO.setTradeAmt(item.getPayAmount());
            fscBankCheckFileItemPO.setPayerBankAccount(item.getPayerAccount());
            fscBankCheckFileItemPO.setPayeeId(item.getPayeeId());
            fscBankCheckFileItemPO.setPayeeAccountNo(item.getPayeeAccount());
            fscBankCheckFileItemPO.setTradeDateStart(DateUtil.dateToStr((Date)item.getPayTime(), (String)"yyyy-MM-dd"));
            fscBankCheckFileItemPO.setWriteOffFlag("0");
            FscBankCheckFileItemPO fileItemPO = this.fscBankCheckFileItemMapper.getModelBy(fscBankCheckFileItemPO);
            if (ObjectUtil.isEmpty((Object)fileItemPO)) {
                log.info("\u4ed8\u6b3e\u5355\u4f4dsbu:{},\u672a\u67e5\u8be2\u5230\u5f85\u6838\u9500\u94f6\u884c\u6d41\u6c34\u8bb0\u5f55", (Object)reqBO.getSecondOrgId());
                continue;
            }
            outPayRecordIds.add(item.getOutPayRecordId());
            bankCheckItemIds.add(fileItemPO.getBankCheckId());
            FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
            fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
            fscWriteOffItemPO.setFscOrderId(item.getOutPayRecordId());
            fscWriteOffItemPO.setBankCheckId(fileItemPO.getBankCheckId());
            fscWriteOffItemPO.setWriteOffType(FscConstants.FSC_WRITE_OFF_TYPE.OUT_PAY_RECORD);
            fscWriteOffItemPOList.add(fscWriteOffItemPO);
            FscBalancePO fscBalancePO = new FscBalancePO();
            fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscBalancePO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
            fscBalancePO.setOrgId(item.getPayeeId());
            fscBalancePO.setOrgCode("");
            fscBalancePO.setOrgName(item.getPayeeName());
            fscBalancePO.setSubAccountNo(item.getPayeeAccount());
            fscBalancePO.setPayerOrgId(item.getPayerId());
            fscBalancePO.setPayerOrgName(item.getPayerName());
            fscBalancePO.setPayerOrgCode(null);
            fscBalancePO.setPayerSubAccountNo(null);
            fscBalancePO.setFrozenEndTime(this.getConfiguration(item.getPayeeId().toString()));
            fscBalancePO.setPayAmount(item.getPayAmount());
            if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                fscBalancePO.setFrozenAmount(new BigDecimal(0));
                fscBalancePO.setUsableAmount(item.getPayAmount());
                fscBalancePO.setThawOperTime(new Date());
            } else {
                fscBalancePO.setFrozenAmount(item.getPayAmount());
                fscBalancePO.setUsableAmount(new BigDecimal(0));
            }
            fscBalancePO.setUsedAmount(new BigDecimal(0));
            fscBalancePOList.add(fscBalancePO);
        }
        if (!CollectionUtils.isEmpty(bankCheckItemIds)) {
            FscBankCheckFileItemPO updateBankCheckItemPO = new FscBankCheckFileItemPO();
            updateBankCheckItemPO.setWriteOffFlag("1");
            updateBankCheckItemPO.setUpdateTime(new Date());
            updateBankCheckItemPO.setBankCheckIdS(bankCheckItemIds);
            this.fscBankCheckFileItemMapper.updateWriteOffFlagByBankCheckIds(updateBankCheckItemPO);
        }
        if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
            this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
        }
        if (!CollectionUtils.isEmpty(fscBalancePOList)) {
            this.fscBalanceMapper.insertBatch(fscBalancePOList);
        }
        if (!CollectionUtils.isEmpty(outPayRecordIds)) {
            FscOutPayRecordPO updateFscOutPayRecordPO = new FscOutPayRecordPO();
            updateFscOutPayRecordPO.setUpdateTime(new Date());
            updateFscOutPayRecordPO.setOutPayRecordIds(outPayRecordIds);
            updateFscOutPayRecordPO.setWriteOffFlag(Integer.valueOf(Integer.parseInt("1")));
            this.fscOutPayRecordMapper.updateByRecordIds(updateFscOutPayRecordPO);
        }
        return rspBO;
    }

    private Date getConfiguration(String relId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }

    private Boolean checkOverDay(FscOutPayRecordPO fscOutPayRecordPO) {
        CfcQryOverduePaymentRuleAbilityReqBO cfcQryOverduePaymentRuleAbilityReqBO = new CfcQryOverduePaymentRuleAbilityReqBO();
        cfcQryOverduePaymentRuleAbilityReqBO.setOrgIdWeb(fscOutPayRecordPO.getPayerSecondOrgId());
        cfcQryOverduePaymentRuleAbilityReqBO.setCorporationId(fscOutPayRecordPO.getPayerId());
        log.info("\u83b7\u53d6\u8d85\u671f\u81ea\u52a8\u6838\u9500\u5929\u6570\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)cfcQryOverduePaymentRuleAbilityReqBO));
        CfcQryOverduePaymentRuleAbilityRspBO cfcQryEnableOverduePaymentRuleListAbilityRspBO = this.cfcQryOverduePaymentRuleAbilityService.qryOverduePaymentRule(cfcQryOverduePaymentRuleAbilityReqBO);
        log.info("\u83b7\u53d6\u8d85\u671f\u81ea\u52a8\u6838\u9500\u5929\u6570\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)cfcQryEnableOverduePaymentRuleListAbilityRspBO));
        if (!"0000".equals(cfcQryEnableOverduePaymentRuleListAbilityRspBO.getRespCode())) {
            log.info("\u83b7\u53d6\u8d85\u671f\u81ea\u52a8\u6838\u9500\u5929\u6570\u9519\u8bef");
            return false;
        }
        Calendar now = Calendar.getInstance();
        if (ObjectUtil.isEmpty((Object)cfcQryEnableOverduePaymentRuleListAbilityRspBO.getOverdueDays())) {
            now.add(5, Math.negateExact(0));
        } else {
            now.add(5, Math.negateExact(Integer.parseInt(cfcQryEnableOverduePaymentRuleListAbilityRspBO.getOverdueDays())));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date configDate = DateUtil.strToDate((String)sdf.format(now.getTime()), (String)"yyyy-MM-dd");
        Date payOrderDate = DateUtil.strToDate((String)sdf.format(fscOutPayRecordPO.getPayTime()), (String)"yyyy-MM-dd");
        log.info("\u914d\u7f6e\u65f6\u95f4\uff1a{}", (Object)DateUtil.dateToStr((Date)configDate, (String)"yyyy-MM-dd"));
        log.info("\u4ed8\u6b3e\u65f6\u95f4\uff1a{}", (Object)DateUtil.dateToStr((Date)payOrderDate, (String)"yyyy-MM-dd"));
        if (payOrderDate.after(configDate)) {
            log.info("\u4ed8\u6b3e\u8ba1\u5212\u884c\u7684\u4ed8\u6b3e\u65f6\u95f4\u4e0d\u6ee1\u8db3\u6ee1\u8db3\u2264\uff08\u5f53\u524d\u670d\u52a1\u5668\u65f6\u95f4-7\u5929\uff09");
            return false;
        }
        return true;
    }
}

