/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.cfc.ability.api.CfcQryOverduePaymentRuleAbilityService;
import com.tydic.cfc.ability.bo.CfcQryOverduePaymentRuleAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryOverduePaymentRuleAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiRspBO;
import com.tydic.fsc.common.busi.api.FscAuditInvoiceWriteOffPayOrderBusiService;
import com.tydic.fsc.common.busi.bo.FscAuditInvoiceWriteOffPayOrderBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAuditInvoiceWriteOffPayOrderBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOutPayRecordMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOutPayRecordPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscAuditInvoiceWriteOffPayOrderBusiServiceImpl
implements FscAuditInvoiceWriteOffPayOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAuditInvoiceWriteOffPayOrderBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOutPayRecordMapper fscOutPayRecordMapper;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private CfcQryOverduePaymentRuleAbilityService cfcQryOverduePaymentRuleAbilityService;

    @Override
    public FscAuditInvoiceWriteOffPayOrderBusiRspBO auditInvoiceWriteOffPayOrder(FscAuditInvoiceWriteOffPayOrderBusiReqBO reqBO) {
        FscAuditInvoiceWriteOffPayOrderBusiRspBO rspBO = new FscAuditInvoiceWriteOffPayOrderBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List payOrderIds = reqBO.getFscOrderPOList().stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        List fscOrderPOList = this.fscOrderMapper.getJSDbyFKDids(payOrderIds);
        ArrayList<Long> updatePayOrderIds = new ArrayList<Long>();
        if (!ObjectUtil.isEmpty((Object)fscOrderPOList)) {
            for (FscOrderPO item : fscOrderPOList) {
                CfcQryOverduePaymentRuleAbilityReqBO cfcQryOverduePaymentRuleAbilityReqBO = new CfcQryOverduePaymentRuleAbilityReqBO();
                cfcQryOverduePaymentRuleAbilityReqBO.setOrgIdWeb(item.getSecondOrgId());
                cfcQryOverduePaymentRuleAbilityReqBO.setCorporationId(item.getPayerId());
                log.info("\u83b7\u53d6\u8d85\u671f\u81ea\u52a8\u6838\u9500\u5929\u6570\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)cfcQryOverduePaymentRuleAbilityReqBO));
                CfcQryOverduePaymentRuleAbilityRspBO cfcQryEnableOverduePaymentRuleListAbilityRspBO = this.cfcQryOverduePaymentRuleAbilityService.qryOverduePaymentRule(cfcQryOverduePaymentRuleAbilityReqBO);
                log.info("\u83b7\u53d6\u8d85\u671f\u81ea\u52a8\u6838\u9500\u5929\u6570\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)cfcQryEnableOverduePaymentRuleListAbilityRspBO));
                if (!"0000".equals(cfcQryEnableOverduePaymentRuleListAbilityRspBO.getRespCode())) {
                    log.info("\u83b7\u53d6\u8d85\u671f\u81ea\u52a8\u6838\u9500\u5929\u6570\u9519\u8bef");
                    continue;
                }
                if (ObjectUtil.isEmpty((Object)cfcQryEnableOverduePaymentRuleListAbilityRspBO.getOverdueDays())) {
                    reqBO.setOverDay(0);
                } else {
                    reqBO.setOverDay(Integer.parseInt(cfcQryEnableOverduePaymentRuleListAbilityRspBO.getOverdueDays()));
                }
                FscInvoicePO fscInvoicePO = new FscInvoicePO();
                fscInvoicePO.setFscOrderId(item.getFscOrderId());
                List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
                if (ObjectUtil.isEmpty((Object)fscInvoicePOList)) {
                    log.info("\u53d1\u7968\u6838\u9500\u4ed8\u6b3e\u5355\uff1a\u7ed3\u7b97\u5355:{},\u672a\u67e5\u8be2\u5230\u53d1\u7968", (Object)item.getFscOrderId());
                    continue;
                }
                List fscInvoicePOS = fscInvoicePOList.stream().filter(o -> ObjectUtil.isEmpty((Object)o.getPayStatus()) && "1".equals(o.getPayStatus())).collect(Collectors.toList());
                if (fscInvoicePOS.size() != fscInvoicePOList.size()) {
                    log.info("\u53d1\u7968\u6838\u9500\u4ed8\u6b3e\u5355\uff1a\u7ed3\u7b97\u5355:{},\u53d1\u7968\u672a\u5168\u90e8\u4ed8\u6b3e", (Object)item.getFscOrderId());
                    continue;
                }
                FscOutPayRecordPO fscOutPayRecordPO = new FscOutPayRecordPO();
                fscOutPayRecordPO.setPayerId(item.getPayerId());
                fscOutPayRecordPO.setFscOrderId(item.getFscOrderId());
                Calendar now = Calendar.getInstance();
                now.add(5, Math.negateExact(reqBO.getOverDay()));
                fscOutPayRecordPO.setPayTimeEnd(now.getTime());
                List fscOutPayRecordPOList = this.fscOutPayRecordMapper.getListByFscOrderId(fscOutPayRecordPO);
                if (ObjectUtil.isEmpty((Object)fscOutPayRecordPOList)) {
                    log.info("\u53d1\u7968\u6838\u9500\u4ed8\u6b3e\u5355\uff1a\u7ed3\u7b97\u5355:{},\u53d1\u7968\u95f4\u9694\u5929\u6570\u8fc7\u77ed", (Object)item.getFscOrderId());
                    continue;
                }
                FscOrderPO payOrderInfo = this.fscOrderMapper.getPayOrderByFscOrderId(item);
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(payOrderInfo.getFscOrderId());
                if (null != reqBO.getUserId()) {
                    fscOrderPO.setPayOperId(reqBO.getUserId().toString());
                }
                fscOrderPO.setPayOperName(reqBO.getName());
                fscOrderPO.setPayTime(new Date());
                fscOrderPO.setPayState(FscConstants.PayOrderPayStatus.PAIED);
                fscOrderPO.setActualAmount(payOrderInfo.getTotalCharge());
                int row = this.fscOrderMapper.updateById(fscOrderPO);
                if (row < 1) {
                    throw new FscBusinessException("198888", "\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                }
                updatePayOrderIds.add(payOrderInfo.getFscOrderId());
            }
        }
        try {
            FscOrderStatusFlowBusiReqBO fscOrderStatusFlowBusiReqBO = new FscOrderStatusFlowBusiReqBO();
            fscOrderStatusFlowBusiReqBO.setOrderIds(updatePayOrderIds);
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("confirmFlag", 0);
            fscOrderStatusFlowBusiReqBO.setParamMap(paramMap);
            fscOrderStatusFlowBusiReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            FscOrderStatusFlowBusiRspBO busiflowRspBO = this.fscOrderStatusFlowBusiService.dealStatusFlow(fscOrderStatusFlowBusiReqBO);
            if (!"0000".equals(busiflowRspBO.getRespCode())) {
                throw new FscBusinessException(busiflowRspBO.getRespCode(), busiflowRspBO.getRespDesc());
            }
        }
        catch (FscBusinessException e) {
            log.info("\u6d41\u7a0b\u6d41\u8f6c\u9519\u8bef");
            e.printStackTrace();
        }
        return rspBO;
    }
}

